/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class SaveProjectsDialog
extends JCenterDialog {
    private DefaultListModel mModel = new DefaultListModel();
    private boolean mIsCanceled = true;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton mCancelBtn;
    private JButton mDiscardAllBtn;
    private JList mProjectsList;
    private JButton mSaveAllBtn;
    private JButton mSaveBtn;

    public SaveProjectsDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.mProjectsList.setCellRenderer(new UMLProjectRender());
        this.mProjectsList.setModel(this.mModel);
    }

    protected void initDirtyProjectList() {
        Project[] projectArray;
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            IProject iProject;
            UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)project.getLookup().lookup(UMLProjectHelper.class);
            if (uMLProjectHelper == null || (iProject = uMLProjectHelper.getProject()) == null || !iProject.isDirty()) continue;
            this.mModel.addElement(project);
        }
    }

    public void addProject(Project project) {
        this.mModel.addElement(project);
    }

    public void showDialog() {
        this.mProjectsList.setSelectedIndex(0);
        this.setVisible(true);
    }

    public static boolean saveProjects() {
        Project[] projectArray;
        boolean bl = true;
        Frame frame = WindowManager.getDefault().getMainWindow();
        SaveProjectsDialog saveProjectsDialog = new SaveProjectsDialog(frame, true);
        saveProjectsDialog.getRootPane().setDefaultButton(saveProjectsDialog.mSaveBtn);
        saveProjectsDialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSN_SaveProjectsDialog"));
        saveProjectsDialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSD_SaveProjectsDialog"));
        boolean bl2 = false;
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            IProject iProject;
            UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)project.getLookup().lookup(UMLProjectHelper.class);
            if (uMLProjectHelper == null || (iProject = uMLProjectHelper.getProject()) == null || !iProject.isDirty()) continue;
            saveProjectsDialog.addProject(project);
            bl2 = true;
        }
        if (bl2) {
            saveProjectsDialog.showDialog();
            if (saveProjectsDialog.isCanceled()) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean isCanceled() {
        return this.mIsCanceled;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mProjectsList = new JList();
        this.mSaveAllBtn = new JButton();
        this.mSaveBtn = new JButton();
        this.mDiscardAllBtn = new JButton();
        this.mCancelBtn = new JButton();
        this.jPanel1 = new JPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/uml/project/Bundle");
        this.setTitle(resourceBundle.getString("SAVE_DIALOG_TITLE"));
        this.getAccessibleContext().setAccessibleName("");
        this.getAccessibleContext().setAccessibleDescription("");
        this.jScrollPane1.setViewportView(this.mProjectsList);
        this.mProjectsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSN_ProjectsList"));
        this.mProjectsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSD_ProjectsList"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.mSaveAllBtn, (String)resourceBundle.getString("SAVE_ALL_BTN"));
        this.mSaveAllBtn.setActionCommand("Save_All");
        this.mSaveAllBtn.setDefaultCapable(false);
        this.mSaveAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveProjectsDialog.this.mSaveAllBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(7, 0, 0, 10);
        this.getContentPane().add((Component)this.mSaveAllBtn, gridBagConstraints);
        this.mSaveAllBtn.getAccessibleContext().setAccessibleName("");
        this.mSaveAllBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSD_SaveAllButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.mSaveBtn, (String)resourceBundle.getString("SAVE_BTN"));
        this.mSaveBtn.setActionCommand("Save");
        this.mSaveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveProjectsDialog.this.mSaveBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.getContentPane().add((Component)this.mSaveBtn, gridBagConstraints);
        this.mSaveBtn.getAccessibleContext().setAccessibleName("");
        this.mSaveBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSD_SaveButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.mDiscardAllBtn, (String)resourceBundle.getString("DISCARD_ALL_BTN"));
        this.mDiscardAllBtn.setActionCommand("Discard_All");
        this.mDiscardAllBtn.setDefaultCapable(false);
        this.mDiscardAllBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveProjectsDialog.this.mDiscardAllBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(6, 0, 0, 10);
        this.getContentPane().add((Component)this.mDiscardAllBtn, gridBagConstraints);
        this.mDiscardAllBtn.getAccessibleContext().setAccessibleName("");
        this.mDiscardAllBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSD_DiscardAllButton"));
        this.mCancelBtn.setText(resourceBundle.getString("CANCEL_BTN"));
        this.mCancelBtn.setDefaultCapable(false);
        this.mCancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SaveProjectsDialog.this.mCancelBtnActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        this.getContentPane().add((Component)this.mCancelBtn, gridBagConstraints);
        this.mCancelBtn.getAccessibleContext().setAccessibleName("");
        this.mCancelBtn.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SaveProjectsDialog.class, (String)"ACSD_CancelButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void mCancelBtnActionPerformed(ActionEvent actionEvent) {
        this.closeWindow(true);
    }

    private void mDiscardAllBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.mModel.getSize();
        UMLProject[] uMLProjectArray = new UMLProject[n];
        for (int i = 0; i < n; ++i) {
            uMLProjectArray[i] = (UMLProject)this.mModel.getElementAt(i);
            UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)uMLProjectArray[i].getLookup().lookup(UMLProjectHelper.class);
            uMLProjectHelper.getProject().setDirty(false);
            uMLProjectHelper.getProject().setChildrenDirty(false);
        }
        this.closeWindow(false);
    }

    private void mSaveAllBtnActionPerformed(ActionEvent actionEvent) {
        int n = this.mModel.getSize();
        UMLProject[] uMLProjectArray = new UMLProject[n];
        for (int i = 0; i < n; ++i) {
            uMLProjectArray[i] = (UMLProject)this.mModel.getElementAt(i);
        }
        this.saveProjects(uMLProjectArray);
        this.closeWindow(false);
    }

    private void mSaveBtnActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.mProjectsList.getSelectedIndices();
        UMLProject[] uMLProjectArray = new UMLProject[nArray.length];
        int n = this.mModel.size();
        for (int i = 0; i < nArray.length; ++i) {
            uMLProjectArray[i] = (UMLProject)this.mModel.getElementAt(nArray[i]);
            this.mModel.removeElementAt(nArray[i]);
        }
        this.saveProjects(uMLProjectArray);
        if (nArray.length == n) {
            this.closeWindow(false);
        } else {
            this.mProjectsList.setSelectedIndex(0);
        }
    }

    protected void closeWindow(boolean bl) {
        this.mIsCanceled = bl;
        this.setVisible(false);
    }

    protected void saveProjects(UMLProject[] uMLProjectArray) {
        for (UMLProject uMLProject : uMLProjectArray) {
            uMLProject.saveProject();
        }
    }

    public class UMLProjectRender
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Project project = (Project)object;
            ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
            super.getListCellRendererComponent((JList<?>)jList, projectInformation.getDisplayName(), n, bl, bl2);
            this.setIcon(projectInformation.getIcon());
            return this;
        }
    }
}

