/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project;

import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.core.IApplication;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.nodes.UMLModelRootNode;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogDiagramDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogProjectDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.INewDialogTabDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialog;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogDiagramDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogProjectDetails;
import org.netbeans.modules.uml.ui.controls.newdialog.NewDialogResultProcessor;
import org.netbeans.modules.uml.ui.controls.newdialog.ProjectLocationPanel;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductProjectManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLProductProjectManager
implements IProductProjectManager {
    private static String previousDirectory = "";

    public void displayInsertProjectDialog(IWorkspace iWorkspace) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(previousDirectory);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".etd");
            }

            public String getDescription() {
                return NbBundle.getMessage(UMLProductProjectManager.class, (String)"Dialog.InsertProject.FileFilter.Description");
            }
        });
        jFileChooser.setDialogTitle(NbBundle.getMessage(UMLProductProjectManager.class, (String)"Dialog.InsertProject.Title"));
        if (jFileChooser.showOpenDialog(jFileChooser) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            IProject iProject;
            IApplication iApplication = ProductHelper.getApplication();
            if (iApplication != null && (iProject = iApplication.openProject(file.getAbsolutePath())) != null) {
                this.insertProjectIntoWorkspace(iWorkspace, iProject);
            }
            previousDirectory = file.getPath();
        }
    }

    private boolean insertProjectIntoWorkspace(IWorkspace iWorkspace, IProject iProject) {
        boolean bl = false;
        IApplication iApplication = ProductHelper.getApplication();
        if (iApplication != null) {
            IWSProject iWSProject = iApplication.importProject(iWorkspace, iProject);
            bl = true;
        }
        return bl;
    }

    public void displayNewProjectDialog() {
        NewDialogProjectDetails newDialogProjectDetails = new NewDialogProjectDetails();
        newDialogProjectDetails.setAllowFromRESelection(false);
        newDialogProjectDetails.setMode("Analysis");
        this.displayNewProjectDialog((INewDialogProjectDetails)newDialogProjectDetails);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayNewProjectDialog(INewDialogProjectDetails iNewDialogProjectDetails) {
        NewDialogProjectDetails newDialogProjectDetails;
        NewDialogResultProcessor newDialogResultProcessor;
        NewDialogProjectDetails newDialogProjectDetails2 = null;
        ProjectLocationPanel projectLocationPanel = new ProjectLocationPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)projectLocationPanel, NbBundle.getMessage(ProjectLocationPanel.class, (String)"TITLE_CreateDesignCenterProject"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationPanel.class, (String)"TITLE_CreateDesignCenterProject"));
        try {
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                newDialogProjectDetails2 = projectLocationPanel.getProjectDetails();
                newDialogResultProcessor = new NewDialogResultProcessor();
                newDialogResultProcessor.handleResult((INewDialogTabDetails)newDialogProjectDetails2);
            }
        }
        finally {
            dialog.dispose();
        }
        newDialogResultProcessor = null;
        if (newDialogProjectDetails2 != null && newDialogProjectDetails2 instanceof INewDialogProjectDetails && (newDialogResultProcessor = this.newProject((INewDialogProjectDetails)(newDialogProjectDetails = newDialogProjectDetails2))) != null) {
            this.doPostNewProject((IProject)newDialogResultProcessor, iNewDialogProjectDetails);
        }
    }

    public IProject newProject(INewDialogProjectDetails iNewDialogProjectDetails) {
        IProject iProject = null;
        if (iNewDialogProjectDetails != null) {
            String string = iNewDialogProjectDetails.getLocation();
            String string2 = iNewDialogProjectDetails.getName();
            String string3 = string + File.separatorChar + string2 + ".etd";
            IApplication iApplication = ProductHelper.getApplication();
            if (iApplication != null) {
                iProject = iApplication.getProjectByFileName(string3);
            }
        }
        return iProject;
    }

    public void doPostNewProject(IProject iProject, INewDialogProjectDetails iNewDialogProjectDetails) {
        if (iProject != null) {
            boolean bl = true;
            if (iNewDialogProjectDetails != null) {
                bl = iNewDialogProjectDetails.getPromptToCreateDiagram();
            }
            if (bl) {
                IProject iProject2 = null;
                if (iProject instanceof INamespace) {
                    iProject2 = iProject;
                }
                this.queryUserForNewDiagram((INamespace)iProject2, 0, 65535);
            }
        }
    }

    public IDiagram queryUserForNewDiagram(INamespace iNamespace, int n, int n2) {
        INewDialogDiagramDetails iNewDialogDiagramDetails;
        IDiagram iDiagram = null;
        NewDialog newDialog = new NewDialog();
        newDialog.addTab(4);
        NewDialogDiagramDetails newDialogDiagramDetails = new NewDialogDiagramDetails();
        newDialogDiagramDetails.setNamespace(iNamespace);
        newDialogDiagramDetails.setDiagramKind(n);
        newDialogDiagramDetails.setAvailableDiagramKinds(n2);
        newDialog.specifyDefaults((INewDialogTabDetails)newDialogDiagramDetails);
        INewDialogTabDetails iNewDialogTabDetails = newDialog.display(null);
        if (iNewDialogTabDetails != null && iNewDialogTabDetails instanceof INewDialogDiagramDetails && (iNewDialogDiagramDetails = (INewDialogDiagramDetails)iNewDialogTabDetails) != null) {
            INamespace iNamespace2 = iNewDialogDiagramDetails.getNamespace();
            String string = iNewDialogDiagramDetails.getName();
            int n3 = iNewDialogDiagramDetails.getDiagramKind();
            if (string != null && string.length() > 0) {
                iDiagram = this.newDiagram(iNamespace2, n3, string);
            }
        }
        return iDiagram;
    }

    public IDiagram newDiagram(INamespace iNamespace, int n, String string) {
        IDiagram iDiagram = null;
        IProductDiagramManager iProductDiagramManager = ProductHelper.getProductDiagramManager();
        if (iProductDiagramManager != null && iDiagram == null) {
            if (iNamespace != null) {
                iDiagram = iProductDiagramManager.createDiagram(n, iNamespace, string, null);
            } else {
                IProject iProject;
                IProductProjectManager iProductProjectManager = ProductHelper.getProductProjectManager();
                if (iProductProjectManager != null && (iProject = iProductProjectManager.getCurrentProject()) != null) {
                    iDiagram = iProductDiagramManager.createDiagram(n, (INamespace)iProject, string, null);
                }
            }
        }
        return iDiagram;
    }

    public IProject getCurrentProject() {
        Node[] nodeArray;
        IProject iProject = null;
        for (Node node : nodeArray = TopComponent.getRegistry().getActivatedNodes()) {
            IElement iElement = (IElement)node.getCookie(IElement.class);
            if (iElement == null && node.getCookie(UMLModelRootNode.class) != null) {
                iElement = (IElement)node.getParentNode().getLookup().lookup(UMLProject.class);
            }
            if (iElement == null) continue;
            iProject = iElement.getProject();
            break;
        }
        return iProject;
    }

    public ArrayList<IProject> getOpenProjects() {
        Project[] projectArray;
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)project.getLookup().lookup(UMLProjectHelper.class);
            if (uMLProjectHelper == null) continue;
            arrayList.add(uMLProjectHelper.getProject());
        }
        return arrayList;
    }
}

