/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.common;

import java.io.File;
import org.netbeans.api.project.Project;

public class ReferencedJavaProjectModel {
    private static final String BROKEN = "BrokenProperty";
    private Project project;
    private String property;
    private File projFile;
    private String expectedLocation = "";
    private ReferenceStatus refStatus = ReferenceStatus.REF_STATUS_UNSET;

    public ReferencedJavaProjectModel() {
    }

    private ReferencedJavaProjectModel(String string, String string2, File file, Project project, ReferenceStatus referenceStatus) {
        this.project = project;
        this.property = string;
        this.projFile = file;
        this.expectedLocation = string2;
        this.refStatus = referenceStatus;
    }

    public static ReferencedJavaProjectModel createMounted(String string, Project project) {
        if (string == null || project == null) {
            throw new IllegalArgumentException("property and project must not be null");
        }
        return new ReferencedJavaProjectModel(string, null, null, project, ReferenceStatus.REF_STATUS_MOUNTED);
    }

    public static ReferencedJavaProjectModel createUnset(String string) {
        if (string == null) {
            throw new IllegalArgumentException("property must not be null");
        }
        return new ReferencedJavaProjectModel(string, null, null, null, ReferenceStatus.REF_STATUS_UNSET);
    }

    public static ReferencedJavaProjectModel createMounted(String string, String string2, File file, Project project) {
        if (string == null) {
            throw new IllegalArgumentException("property must not be null");
        }
        return new ReferencedJavaProjectModel(string, string2, file, project, ReferenceStatus.REF_STATUS_MOUNTED);
    }

    public static ReferencedJavaProjectModel createUnmounted(String string, String string2, File file) {
        if (string == null) {
            throw new IllegalArgumentException("property must not be null");
        }
        return new ReferencedJavaProjectModel(string, string2, file, null, ReferenceStatus.REF_STATUS_UNMOUNTED);
    }

    public static ReferencedJavaProjectModel createBroken(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("property must not be null in broken items");
        }
        return new ReferencedJavaProjectModel(string, string2, null, null, ReferenceStatus.REF_STATUS_BROKEN);
    }

    public ReferenceStatus getRefStatus() {
        return this.refStatus;
    }

    public Project getProject() {
        return this.project;
    }

    public String getProperty() {
        return this.property;
    }

    public String getExpectedLocation() {
        return this.expectedLocation;
    }

    public File getProjectFile() {
        return this.projFile;
    }

    public boolean isBroken() {
        return this.refStatus == ReferenceStatus.REF_STATUS_BROKEN;
    }

    public int hashCode() {
        int n = 0;
        if (this.isBroken()) {
            return BROKEN.hashCode();
        }
        if (this.project != null) {
            n += this.project.hashCode();
        }
        return n += this.property.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReferencedJavaProjectModel)) {
            return false;
        }
        ReferencedJavaProjectModel referencedJavaProjectModel = (ReferencedJavaProjectModel)object;
        if (this.isBroken() != referencedJavaProjectModel.isBroken()) {
            return false;
        }
        if (this.isBroken()) {
            return this.getProperty().equals(referencedJavaProjectModel.getProperty());
        }
        if (!this.getProperty().equals(referencedJavaProjectModel.getProperty())) {
            return false;
        }
        return this.getProject() == referencedJavaProjectModel.getProject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceStatus {
        REF_STATUS_BROKEN,
        REF_STATUS_MOUNTED,
        REF_STATUS_UNMOUNTED,
        REF_STATUS_UNSET;

    }
}

