/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectModel;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.netbeans.modules.uml.project.ui.wizards.PanelConfigureProject;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ReferencedJavaProjectPanel
extends JPanel
implements PropertyChangeListener,
TableModelListener {
    private JLabel javaProjectLabel;
    private ButtonGroup modelTypeButtonGroup;
    private JComboBox projectsComboBox;
    private JTable sourceRoots;
    private JLabel sourceRootsLabel;
    private JPanel sourceRootsPanel;
    private JScrollPane sourceRootsScrollPane;
    private Project javaSrcProj;
    private String javaSrcProjName;
    private boolean valid;
    private boolean isWizard = false;
    private final UMLProjectProperties uiProperties;
    private ReferencedJavaProjectModel javaRefModel;
    private JavaSourceRootsUI.JavaSourceRootsModel javaRefSrcsModel;
    private PanelConfigureProject panel;
    public static boolean mIsImplementationMode = true;
    private ResourceBundle bundle = NbBundle.getBundle(ReferencedJavaProjectPanel.class);
    public static final String ASSOCIATED_JAVA_PROJ_PROP = "ReferencedProjectProperty";
    public static final String SOURCE_GROUP_CHANGED_PROP = "SOURCE_GROUP_CHANGED";
    public static final String JAVA_PROJECT_CHANGED_PROP = "JAVA_PROJ_CHANGED";

    public ReferencedJavaProjectPanel(PanelConfigureProject panelConfigureProject) {
        this(panelConfigureProject, 0, null, null);
    }

    public ReferencedJavaProjectPanel(PanelConfigureProject panelConfigureProject, int n) {
        this(panelConfigureProject, n, null, null);
    }

    public ReferencedJavaProjectPanel(PanelConfigureProject panelConfigureProject, int n, Project project, JavaSourceRootsUI.JavaSourceRootsModel javaSourceRootsModel) {
        this.panel = panelConfigureProject;
        this.isWizard = true;
        this.uiProperties = null;
        this.initComponents();
        if (javaSourceRootsModel == null) {
            this.sourceRoots.setModel(JavaSourceRootsUI.createEmptyModel());
        } else {
            this.sourceRoots.setModel(javaSourceRootsModel);
        }
        this.sourceRootsScrollPane.getViewport().setBackground(this.sourceRoots.getBackground());
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        this.sourceRoots.setAutoResizeMode(3);
        this.initValues(project);
    }

    public ReferencedJavaProjectPanel(UMLProjectProperties uMLProjectProperties) {
        this.uiProperties = uMLProjectProperties;
        this.initComponents();
        if (uMLProjectProperties == null) {
            this.isWizard = true;
            this.sourceRoots.setModel(JavaSourceRootsUI.createEmptyModel());
        } else {
            this.isWizard = false;
            this.javaRefModel = uMLProjectProperties.referencedJavaProjectModel;
            this.javaRefSrcsModel = uMLProjectProperties.referencedJavaSourceRootsModel;
            this.setSelectedProject(this.javaRefModel.getProject());
            this.sourceRoots.setModel(this.javaRefSrcsModel);
        }
        this.sourceRoots.getModel().addTableModelListener(this);
        this.sourceRootsScrollPane.getViewport().setBackground(this.sourceRoots.getBackground());
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        ProjectCellRenderer projectCellRenderer = new ProjectCellRenderer();
        this.projectsComboBox.setRenderer(projectCellRenderer);
        DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(new Project[]{this.javaRefModel.getProject()});
        this.projectsComboBox.setModel(defaultComboBoxModel);
        this.projectsComboBox.setEnabled(false);
    }

    private void initValues(Project project) {
        ProjectCellRenderer projectCellRenderer = new ProjectCellRenderer();
        this.projectsComboBox.setRenderer(projectCellRenderer);
        Project[] projectArray = ProjectUtil.getOpenJavaProjects();
        Project[] projectArray2 = ProjectUtil.getSelectedProjects(Project.class);
        DefaultComboBoxModel<Project> defaultComboBoxModel = new DefaultComboBoxModel<Project>(projectArray);
        this.projectsComboBox.setModel(defaultComboBoxModel);
        Project project2 = null;
        if (project != null) {
            project2 = project;
        } else if (projectArray.length > 0 && projectArray2.length > 0) {
            project2 = projectArray2[0];
        }
        this.selectProject(project2);
    }

    private void selectProject(Project project) {
        if (project != null) {
            this.projectsComboBox.setSelectedItem(project);
        } else if (ProjectUtil.getOpenJavaProjects().length > 0) {
            this.projectsComboBox.setSelectedIndex(0);
        }
        this.updateState();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl = this.isAtLeastOneSrcFolderSelected();
        this.firePropertyChange(SOURCE_GROUP_CHANGED_PROP, "dontCareOldValue", (Object)bl);
    }

    private boolean isAtLeastOneSrcFolderSelected() {
        boolean bl = false;
        TableModel tableModel = this.sourceRoots.getModel();
        if (tableModel != null) {
            int n = tableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                boolean bl2 = bl = bl || (Boolean)tableModel.getValueAt(i, 0) != false;
                if (bl) break;
            }
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("MODE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue().equals("Implementation")) {
                if (ProjectUtil.getOpenJavaProjects().length > 0) {
                    this.initValues(null);
                    this.projectsComboBox.setEnabled(this.isWizard);
                }
            } else if (propertyChangeEvent.getNewValue().equals("Design")) {
                this.projectsComboBox.setSelectedItem(null);
                this.projectsComboBox.setEnabled(false);
            }
        } else if (ASSOCIATED_JAVA_PROJ_PROP.equals(propertyChangeEvent.getPropertyName())) {
            this.updateSourceRootsTable();
        }
    }

    private void initComponents() {
        this.modelTypeButtonGroup = new ButtonGroup();
        this.sourceRootsPanel = new JPanel();
        this.sourceRootsLabel = new JLabel();
        this.sourceRootsScrollPane = new JScrollPane();
        this.sourceRoots = new JTable();
        this.projectsComboBox = new JComboBox();
        this.javaProjectLabel = new JLabel();
        this.sourceRootsLabel.setLabelFor(this.sourceRoots);
        Mnemonics.setLocalizedText((JLabel)this.sourceRootsLabel, (String)this.bundle.getString("LBL_SourceGroupsLabel"));
        this.sourceRootsLabel.getAccessibleContext().setAccessibleName("");
        this.sourceRootsLabel.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_SourceGroupsLabel"));
        this.sourceRootsScrollPane.setBorder(null);
        this.sourceRootsScrollPane.setHorizontalScrollBarPolicy(32);
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{new Boolean(true), null, null}, {new Boolean(true), null, null}}, new String[]{"Reverse Engineer", "Package Folder", "Package Folder Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Boolean.class, Object.class, String.class};
                this.canEdit = new boolean[]{true, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.sourceRootsScrollPane.setViewportView(this.sourceRoots);
        this.sourceRoots.getAccessibleContext().setAccessibleName("");
        this.sourceRoots.getAccessibleContext().setAccessibleDescription("");
        this.sourceRootsScrollPane.getAccessibleContext().setAccessibleName("");
        this.sourceRootsScrollPane.getAccessibleContext().setAccessibleDescription("");
        this.projectsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ReferencedJavaProjectPanel.this.projectsComboBoxItemStateChanged(itemEvent);
            }
        });
        this.projectsComboBox.getAccessibleContext().setAccessibleName("");
        this.projectsComboBox.getAccessibleContext().setAccessibleDescription("");
        this.javaProjectLabel.setLabelFor(this.projectsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.javaProjectLabel, (String)this.bundle.getString("LBL_ReferencedJavaProjectLabel"));
        this.javaProjectLabel.getAccessibleContext().setAccessibleName("");
        this.javaProjectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencedJavaProjectPanel.class, (String)"ACSD_ReferencedJavaProjectLabel"));
        GroupLayout groupLayout = new GroupLayout((Container)this.sourceRootsPanel);
        this.sourceRootsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.sourceRootsScrollPane, -1, 512, Short.MAX_VALUE).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.javaProjectLabel).addPreferredGap(0).add((Component)this.projectsComboBox, 0, 444, Short.MAX_VALUE)).add((Component)this.sourceRootsLabel, -1, 512, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectsComboBox, -2, -1, -2).add((Component)this.javaProjectLabel)).addPreferredGap(0).add((Component)this.sourceRootsLabel).addPreferredGap(0).add((Component)this.sourceRootsScrollPane, -1, 180, Short.MAX_VALUE).addContainerGap()));
        this.sourceRootsPanel.getAccessibleContext().setAccessibleName("");
        this.sourceRootsPanel.getAccessibleContext().setAccessibleDescription("");
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.sourceRootsPanel, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.sourceRootsPanel, -1, -1, Short.MAX_VALUE));
    }

    private void projectsComboBoxItemStateChanged(ItemEvent itemEvent) {
        this.setSelectedProject((Project)this.projectsComboBox.getSelectedItem());
        this.updateSourceRootsTable();
    }

    public Project getSelectedProject() {
        return this.javaSrcProj;
    }

    public void setSelectedProject(Project project) {
        Project project2 = this.javaSrcProj;
        mIsImplementationMode = false;
        this.javaSrcProj = project;
        this.firePropertyChange(ASSOCIATED_JAVA_PROJ_PROP, project2, this.javaSrcProj);
    }

    private void updateState() {
        if (this.projectsComboBox.getSelectedItem() == null) {
            this.sourceRoots.setModel(JavaSourceRootsUI.createEmptyModel());
            this.setSelectedProject(null);
            return;
        }
        this.setSelectedProject((Project)this.projectsComboBox.getSelectedItem());
        this.updateSourceRootsTable();
    }

    private void updateSourceRootsTable() {
        if (this.uiProperties == null) {
            this.sourceRoots.setModel(JavaSourceRootsUI.createModel(this.getSelectedProject()));
            this.sourceRoots.getModel().addTableModelListener(this);
        } else {
            this.uiProperties.referencedJavaProjectModel = ReferencedJavaProjectModel.createMounted("uml.javaproject", this.getSelectedProject());
            this.uiProperties.referencedJavaSourceRootsModel = this.javaRefSrcsModel = JavaSourceRootsUI.createModel(this.getSelectedProject());
            this.sourceRoots.setModel(this.uiProperties.referencedJavaSourceRootsModel);
            this.sourceRoots.getModel().addTableModelListener(this);
        }
    }

    public JavaSourceRootsUI.JavaSourceRootsModel getJavaSourceRootsModel() {
        return (JavaSourceRootsUI.JavaSourceRootsModel)this.sourceRoots.getModel();
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        if (this.uiProperties == null) {
            if (this.getSelectedProject() == null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ReferencedJavaProjectPanel.class, (String)"ReverseEngineer_Warning"));
                return false;
            }
            if (this.sourceRoots.getModel() == null || !this.isAtLeastOneSrcFolderSelected()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ReferencedJavaProjectPanel.class, (String)"SourceGroup_Warning"));
                return false;
            }
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
            return true;
        }
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    private static class ProjectCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ProjectCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Project) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)object));
                this.setText(projectInformation.getDisplayName());
                this.setIcon(projectInformation.getIcon());
            } else {
                this.setText(object == null ? " " : object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

