/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectModel;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectPanel;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerModeling
extends JPanel
implements HelpCtx.Provider {
    UMLProjectProperties mUIProperties = null;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanelCentral;
    private JTextField projectLocation;
    private ReferencedJavaProjectPanel javaProjectPanel;
    private JLabel messageLabel = null;
    private ModeChangeListener mChangeListener = new ModeChangeListener();

    public CustomizerModeling(UMLProjectProperties uMLProjectProperties) {
        this.mUIProperties = uMLProjectProperties;
        this.initComponents();
        this.addJavaProjectPanel(uMLProjectProperties);
        this.addMessageLabel(uMLProjectProperties);
        FileObject fileObject = uMLProjectProperties.getProject().getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        this.projectLocation.setText(file == null ? "" : file.getPath());
        String string = uMLProjectProperties.getCurrentProjectMode();
        if (string.equals("Analysis")) {
            this.disableAllComponents();
        }
        this.testBroken();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerModeling.class);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectLocation = new JTextField();
        this.jPanelCentral = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName("");
        this.getAccessibleContext().setAccessibleDescription("");
        this.jLabel1.setLabelFor(this.projectLocation);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/uml/project/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("LBL_ProjectFolderLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName("");
        this.jLabel1.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ProjectFolderLabel"));
        this.projectLocation.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.projectLocation, gridBagConstraints);
        this.projectLocation.getAccessibleContext().setAccessibleName("");
        this.projectLocation.getAccessibleContext().setAccessibleDescription("");
        this.jPanelCentral.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.45;
        this.add((Component)this.jPanelCentral, gridBagConstraints);
        this.jPanelCentral.getAccessibleContext().setAccessibleName("");
        this.jPanelCentral.getAccessibleContext().setAccessibleDescription("");
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void addJavaProjectPanel(UMLProjectProperties uMLProjectProperties) {
        this.javaProjectPanel = new ReferencedJavaProjectPanel(uMLProjectProperties);
        this.jPanelCentral.add((Component)this.javaProjectPanel, "Center");
        this.javaProjectPanel.addPropertyChangeListener(this.mChangeListener);
        this.javaProjectPanel.addPropertyChangeListener("JAVA_PROJ_CHANGED", this.mChangeListener);
        this.javaProjectPanel.addPropertyChangeListener("SOURCE_GROUP_CHANGED", this.mChangeListener);
    }

    private void addMessageLabel(UMLProjectProperties uMLProjectProperties) {
        this.messageLabel = new JLabel();
        this.messageLabel.setOpaque(false);
        this.jPanelCentral.add((Component)this.messageLabel, "South");
    }

    private void disablePanel(JPanel jPanel) {
        Component[] componentArray;
        for (Component component : componentArray = jPanel.getComponents()) {
            if (component instanceof JLabel || !component.isEnabled()) continue;
            component.setEnabled(false);
        }
    }

    private void disableAllComponents() {
        this.disablePanel(this.javaProjectPanel);
    }

    private void testBroken() {
        boolean bl = false;
        if (this.mUIProperties.referencedJavaProjectModel.getRefStatus() == ReferencedJavaProjectModel.ReferenceStatus.REF_STATUS_BROKEN) {
            bl = true;
        }
        if (bl) {
            this.messageLabel.setText(NbBundle.getMessage(CustomizerModeling.class, (String)"LBL_CustomizeModeling_Reference_Error"));
        } else {
            this.messageLabel.setText(" ");
        }
    }

    public class ModeChangeListener
    implements PropertyChangeListener {
        private boolean mIsEnabled = true;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ReferencedProjectProperty".equals(propertyChangeEvent.getPropertyName())) {
                CustomizerModeling.this.testBroken();
                CustomizerModeling.this.firePropertyChange("okEnableProperty", this.mIsEnabled, true);
                this.mIsEnabled = true;
            } else if ("SOURCE_GROUP_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                String string = "";
                Object object = propertyChangeEvent.getNewValue();
                boolean bl = true;
                if (object instanceof Boolean) {
                    bl = (Boolean)object;
                }
                if (!bl) {
                    string = NbBundle.getMessage(CustomizerModeling.class, (String)"SourceGroup_Warning");
                }
                CustomizerModeling.this.messageLabel.setText(string);
                CustomizerModeling.this.firePropertyChange("okEnableProperty", this.mIsEnabled, bl);
                this.mIsEnabled = bl;
            }
        }
    }
}

