/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.customizer;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.modules.uml.core.eventframework.EventDispatchNameKeeper;
import org.netbeans.modules.uml.core.eventframework.EventDispatchRetriever;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementChangeEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementImport;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementLifeTimeEventDispatcher;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementLifeTimeEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IImportEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackageImport;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.profiles.IProfile;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.customizer.AntArtifactChooser;
import org.netbeans.modules.uml.project.ui.customizer.ImportElementListener;
import org.netbeans.modules.uml.project.ui.customizer.UMLImportsSupport;
import org.netbeans.modules.uml.project.ui.customizer.UMLProjectProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class UMLImportsUiSupport {
    private UMLImportsSupport importSupport;
    private ImportListener impListener;
    public static final int COL_UML_PROJECT_NAME = 0;
    public static final int COL_UML_PROJECT_FOLDER = 1;
    private UMLProject mProject = null;
    private ArrayList<ImportElementListener> mImportListeners = new ArrayList();
    private HashMap importedElements = null;

    public UMLImportsUiSupport(UMLProject uMLProject) {
        this.mProject = uMLProject;
    }

    public void initializeProject() {
        this.impListener = new ImportListener();
        IElementChangeEventDispatcher iElementChangeEventDispatcher = null;
        IElementLifeTimeEventDispatcher iElementLifeTimeEventDispatcher = null;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        iElementChangeEventDispatcher = (IElementChangeEventDispatcher)eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.modifiedName());
        iElementLifeTimeEventDispatcher = (IElementLifeTimeEventDispatcher)eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.lifeTime());
        iElementChangeEventDispatcher.registerForImportEventsSink((IImportEventsSink)this.impListener);
        iElementLifeTimeEventDispatcher.registerForLifeTimeEvents((IElementLifeTimeEventsSink)this.impListener);
    }

    public void unInitializeProject() {
        IElementChangeEventDispatcher iElementChangeEventDispatcher = null;
        IElementLifeTimeEventDispatcher iElementLifeTimeEventDispatcher = null;
        EventDispatchRetriever eventDispatchRetriever = EventDispatchRetriever.instance();
        iElementChangeEventDispatcher = (IElementChangeEventDispatcher)eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.modifiedName());
        iElementLifeTimeEventDispatcher = (IElementLifeTimeEventDispatcher)eventDispatchRetriever.getDispatcher(EventDispatchNameKeeper.lifeTime());
        iElementChangeEventDispatcher.revokeImportEventsSink((IImportEventsSink)this.impListener);
        iElementLifeTimeEventDispatcher.revokeLifeTimeSink((IElementLifeTimeEventsSink)this.impListener);
    }

    public void addImportElementListener(ImportElementListener importElementListener) {
        this.mImportListeners.add(importElementListener);
    }

    public void removeImportElementListener(ImportElementListener importElementListener) {
        this.mImportListeners.remove(importElementListener);
    }

    public void fireElementImported(IProject iProject, IElement iElement, IElementImport iElementImport) {
        for (ImportElementListener importElementListener : this.mImportListeners) {
            importElementListener.elementImported(iProject, iElement, iElementImport);
        }
    }

    public void firePackageImported(IProject iProject, IElement iElement, IPackageImport iPackageImport) {
        for (ImportElementListener importElementListener : this.mImportListeners) {
            importElementListener.packageImported(iProject, iElement, iPackageImport);
        }
    }

    public void fireElementDeleted(IProject iProject, IElement iElement) {
        for (ImportElementListener importElementListener : this.mImportListeners) {
            importElementListener.elementDeleted(iProject, iElement);
        }
    }

    public static DefaultTableModel createTableModel(Iterator iterator) {
        UMLImportsModel uMLImportsModel = new UMLImportsModel(new Object[0][0]);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object[] objectArray = new Object[2];
            objectArray[0] = e;
            if (e instanceof UMLImportsSupport.Item) {
                UMLImportsSupport.Item item = (UMLImportsSupport.Item)e;
                objectArray[1] = item.getDirectoryLocation();
            } else {
                objectArray[1] = "";
            }
            uMLImportsModel.addRow(objectArray);
        }
        return uMLImportsModel;
    }

    public static Iterator getIterator(DefaultTableModel defaultTableModel) {
        return UMLImportsUiSupport.getList(defaultTableModel).iterator();
    }

    public static List getList(DefaultTableModel defaultTableModel) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            arrayList.add(defaultTableModel.getValueAt(i, 0));
        }
        return arrayList;
    }

    public static int[] addArtifacts(DefaultTableModel defaultTableModel, AntArtifactChooser.ArtifactItem[] artifactItemArray) {
        int[] nArray = new int[artifactItemArray.length];
        for (int i = 0; i < artifactItemArray.length; ++i) {
            UMLImportsSupport.Item item = UMLImportsSupport.Item.create(artifactItemArray[i].getArtifact(), artifactItemArray[i].getArtifactURI(), null);
            boolean bl = false;
            for (int j = 0; j < defaultTableModel.getRowCount(); ++j) {
                if (defaultTableModel.getValueAt(j, 0) != item) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            defaultTableModel.addRow(new Object[]{item, "TODO"});
        }
        return nArray;
    }

    protected boolean inSameProject(IElement iElement) {
        UMLProjectHelper uMLProjectHelper;
        boolean bl = false;
        if (iElement != null && this.mProject != null && (uMLProjectHelper = (UMLProjectHelper)this.mProject.getLookup().lookup(UMLProjectHelper.class)) != null) {
            IProject iProject = uMLProjectHelper.getProject();
            bl = iElement.inSameProject((IElement)iProject);
        }
        return bl;
    }

    protected void modelElementImported(IPackage iPackage, IElement iElement, IElementImport iElementImport) {
        IProject iProject = ProjectUtil.getOwningProjectOfImportedElement(iElement);
        Project project = ProjectUtil.findElementOwner((IElement)iProject);
        Project project2 = ProjectUtil.findReferencingProject((IElement)iElementImport);
        if (project instanceof UMLProject && project2 instanceof UMLProject && project != project2) {
            boolean bl;
            UMLProject uMLProject = (UMLProject)project;
            UMLProject uMLProject2 = (UMLProject)project2;
            this.fireElementImported(((UMLProjectHelper)uMLProject.getLookup().lookup(UMLProjectHelper.class)).getProject(), iElement, iElementImport);
            if (!this.doesReferenceExist(uMLProject2, uMLProject) && !(bl = this.doesReferenceExist(uMLProject, uMLProject2))) {
                AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)uMLProject, (String)"umlproj");
                AntArtifactChooser.ArtifactItem[] artifactItemArray = new AntArtifactChooser.ArtifactItem[antArtifactArray.length];
                for (int i = 0; i < antArtifactArray.length; ++i) {
                    URI[] uRIArray = antArtifactArray[i].getArtifactLocations();
                    for (int j = 0; j < uRIArray.length; ++j) {
                        artifactItemArray[i] = new AntArtifactChooser.ArtifactItem(antArtifactArray[i], uRIArray[j]);
                    }
                }
                UMLProjectProperties uMLProjectProperties = uMLProject2.getUMLProjectProperties();
                UMLImportsUiSupport.addArtifacts(uMLProjectProperties.umlProjectImportsModel, artifactItemArray);
                uMLProjectProperties.save();
            }
        }
    }

    protected void modelPackageImported(IPackage iPackage, IElement iElement, IPackageImport iPackageImport) {
        if (iElement != null && this.inSameProject((IElement)iPackage)) {
            Project project = ProjectUtil.findElementOwner(iElement);
            Project project2 = ProjectUtil.findReferencingProject(iElement);
            if (project instanceof UMLProject && project2 instanceof UMLProject && project != project2) {
                boolean bl;
                UMLProject uMLProject = (UMLProject)project;
                UMLProject uMLProject2 = (UMLProject)project2;
                this.firePackageImported(((UMLProjectHelper)uMLProject.getLookup().lookup(UMLProjectHelper.class)).getProject(), iElement, iPackageImport);
                if (!this.doesReferenceExist(uMLProject2, uMLProject) && !(bl = this.doesReferenceExist(uMLProject, uMLProject2))) {
                    AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)uMLProject, (String)"umlproj");
                    AntArtifactChooser.ArtifactItem[] artifactItemArray = new AntArtifactChooser.ArtifactItem[antArtifactArray.length];
                    for (int i = 0; i < antArtifactArray.length; ++i) {
                        URI[] uRIArray = antArtifactArray[i].getArtifactLocations();
                        for (int j = 0; j < uRIArray.length; ++j) {
                            artifactItemArray[i] = new AntArtifactChooser.ArtifactItem(antArtifactArray[i], uRIArray[j]);
                        }
                    }
                    UMLProjectProperties uMLProjectProperties = uMLProject2.getUMLProjectProperties();
                    UMLImportsUiSupport.addArtifacts(uMLProjectProperties.umlProjectImportsModel, artifactItemArray);
                    uMLProjectProperties.save();
                }
            }
        }
    }

    protected boolean doesReferenceExist(UMLProject uMLProject, UMLProject uMLProject2) {
        boolean bl = false;
        UMLProjectProperties uMLProjectProperties = uMLProject.getUMLProjectProperties();
        DefaultTableModel defaultTableModel = uMLProjectProperties.umlProjectImportsModel;
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            Project project;
            UMLImportsSupport.Item item = (UMLImportsSupport.Item)defaultTableModel.getValueAt(i, 0);
            AntArtifact antArtifact = item.getArtifact();
            if (antArtifact == null || !(project = antArtifact.getProject()).getProjectDirectory().equals(uMLProject2.getProjectDirectory())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void modelElementDeleted(IElement iElement) {
        if (iElement == null) {
            return;
        }
        this.fireElementDeleted(iElement.getProject(), iElement);
    }

    protected synchronized Map getImportedElements() {
        if (this.importedElements == null) {
            Iterator iterator;
            Iterator iterator2;
            this.importedElements = new HashMap();
            UMLProjectHelper uMLProjectHelper = (UMLProjectHelper)this.mProject.getLookup().lookup(UMLProjectHelper.class);
            IProject iProject = uMLProjectHelper.getProject();
            ETList eTList = iProject.getImportedPackages();
            if (eTList != null) {
                iterator2 = eTList.iterator();
                while (iterator2.hasNext()) {
                    iterator = (INamespace)iterator2.next();
                    this.importedElements.put(new ElementWrapper((IElement)iterator), iterator);
                }
            }
            if ((iterator2 = iProject.getImportedElements()) != null) {
                iterator = iterator2.iterator();
                while (iterator.hasNext()) {
                    IElement iElement = (IElement)iterator.next();
                    this.importedElements.put(new ElementWrapper(iElement), iElement);
                }
            }
        }
        return this.importedElements;
    }

    private static class ElementWrapper {
        IElement element;

        ElementWrapper(IElement iElement) {
            this.element = iElement;
        }

        public boolean equals(Object object) {
            if (object instanceof ElementWrapper) {
                return this.element.isSame((IVersionableElement)((ElementWrapper)object).element);
            }
            return false;
        }

        public int hashCode() {
            return this.element.getXMIID().hashCode();
        }
    }

    public class ImportListener
    implements IImportEventsSink,
    IElementLifeTimeEventsSink {
        public void onElementImported(IElementImport iElementImport, IResultCell iResultCell) {
            if (UMLImportsUiSupport.this.inSameProject((IElement)iElementImport)) {
                UMLImportsUiSupport.this.modelElementImported(iElementImport.getImportingPackage(), (IElement)iElementImport.getImportedElement(), iElementImport);
            }
        }

        public void onPackageImported(IPackageImport iPackageImport, IResultCell iResultCell) {
            if (!(iPackageImport instanceof IProfile)) {
                UMLImportsUiSupport.this.modelPackageImported(iPackageImport.getImportingPackage(), (IElement)iPackageImport.getImportedPackage(), iPackageImport);
            }
        }

        public void onPreElementImport(IPackage iPackage, IElement iElement, INamespace iNamespace, IResultCell iResultCell) {
            Project project;
            Project project2 = ProjectUtil.findNetBeansProjectForModel(iNamespace.getProject());
            if (!project2.equals(project = ProjectUtil.findNetBeansProjectForModel(iPackage.getProject())) && UMLImportsUiSupport.this.mProject.equals(project) && ProjectUtils.hasSubprojectCycles((Project)UMLImportsUiSupport.this.mProject, (Project)project2)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_Cycles"), 1));
                iResultCell.setContinue(false);
            }
        }

        public void onPrePackageImport(IPackage iPackage, IPackage iPackage2, INamespace iNamespace, IResultCell iResultCell) {
            Project project;
            Project project2 = ProjectUtil.findNetBeansProjectForModel(iNamespace.getProject());
            if (!project2.equals(project = ProjectUtil.findNetBeansProjectForModel(iPackage.getProject())) && UMLImportsUiSupport.this.mProject.equals(project) && ProjectUtils.hasSubprojectCycles((Project)UMLImportsUiSupport.this.mProject, (Project)project2)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AntArtifactChooser.class, (String)"MSG_AACH_Cycles"), 1));
                iResultCell.setContinue(false);
            }
        }

        public void onElementDeleted(IVersionableElement iVersionableElement, IResultCell iResultCell) {
            if (iVersionableElement instanceof IElement) {
                UMLImportsUiSupport.this.modelElementDeleted((IElement)iVersionableElement);
            }
        }

        public void onElementDuplicated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        }

        public void onElementPreCreate(String string, IResultCell iResultCell) {
        }

        public void onElementPreDuplicated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        }

        public void onElementCreated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        }

        public void onElementPreDelete(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        }
    }

    public static class UMLImportsModel
    extends DefaultTableModel {
        static String colProjLabel = NbBundle.getMessage(UMLImportsUiSupport.class, (String)"LBL_ImportedProjectsColProject");
        static String colProjFolder = NbBundle.getMessage(UMLImportsUiSupport.class, (String)"LBL_ImportedProjectsColFolder");

        public UMLImportsModel(Object[][] objectArray) {
            super(objectArray, new Object[]{colProjLabel, colProjFolder});
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(n);
        }
    }
}

