/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.uml.project.UMLProject;
import org.netbeans.modules.uml.project.UMLProjectGenerator;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.common.CommonUiSupport;
import org.netbeans.modules.uml.project.ui.common.JavaSourceRootsUI;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectModel;
import org.netbeans.modules.uml.project.ui.common.ReferencedJavaProjectSupport;
import org.netbeans.modules.uml.project.ui.customizer.UMLImportsSupport;
import org.netbeans.modules.uml.project.ui.customizer.UMLImportsUiSupport;
import org.netbeans.modules.uml.util.StringTokenizer2;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLProjectProperties {
    public static final String MODELING_MODE = "uml.modeling.mode";
    public static final String UML_PROJECT_ANT_ARTIFACT = "uml.umlproject";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";
    public static final String REFERENCED_JAVA_PROJECT = "uml.javaproject";
    public static final String REFERENCED_JAVA_PROJECT_ARTIFACTS = "uml.javaproject.artifacts";
    public static final String REFERENCED_JAVA_PROJECT_SRC = "uml.javaproject.src";
    public static final String UML_PROJECT_IMPORTS = "uml.imports";
    public static final String UML_ARTIFACT_PREFIX = "${uml.reference.";
    public static final String CODE_GEN_FOLDER_LOCATION = "code.gen.folder.location";
    public static final String CODE_GEN_TEMPLATES = "code.gen.templates";
    public static final String CODE_GEN_BACKUP_SOURCES = "code.gen.backup.sources";
    public static final String CODE_GEN_USE_MARKERS = "code.gen.use.markers";
    public static final String CODE_GEN_ADD_MARKERS = "code.gen.add.markers";
    public static final String CODE_GEN_SHOW_DIALOG = "code.gen.show.dialog";
    public static final String DEFAULT_JAVA_TEMPLATES = "Java:Basic Class|Java:Basic Interface|Java:Basic Enumeration";
    public ComboBoxModel modelingModeModel;
    public String modelingModeValue;
    public ReferencedJavaProjectModel referencedJavaProjectModel;
    public JavaSourceRootsUI.JavaSourceRootsModel referencedJavaSourceRootsModel;
    public DefaultTableModel umlProjectImportsModel;
    public String codeGenTemplates;
    public String codeGenFolderLocation;
    public String codeGenBackupSources;
    public String codeGenUseMarkers;
    public String codeGenAddMarkers;
    public String codeGenShowDialog;
    UMLImportsSupport importsSupport;
    private UMLProject project;
    private UMLProjectHelper updateHelper;
    private PropertyEvaluator evaluator;
    private ReferenceHelper refHelper;
    private ReferencedJavaProjectSupport javaRefSupport;
    private StoreGroup privateGroup;
    private StoreGroup projectGroup;
    public static final String TEMPLATE_DELIMITER = "|";

    public UMLProject getProject() {
        return this.project;
    }

    public UMLProjectProperties(UMLProject uMLProject, UMLProjectHelper uMLProjectHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = uMLProject;
        this.updateHelper = uMLProjectHelper;
        this.evaluator = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.javaRefSupport = new ReferencedJavaProjectSupport(propertyEvaluator, referenceHelper, uMLProjectHelper.getAntProjectHelper(), null, ANT_ARTIFACT_PREFIX);
        this.importsSupport = new UMLImportsSupport(propertyEvaluator, referenceHelper, uMLProjectHelper.getAntProjectHelper(), UML_ARTIFACT_PREFIX);
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.init();
    }

    public void init() {
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        this.modelingModeModel = CommonUiSupport.createModelingModeComboBoxModel(this.evaluator.getProperty(MODELING_MODE));
        this.referencedJavaProjectModel = this.javaRefSupport.createReferencedJavaProjectModel(REFERENCED_JAVA_PROJECT, this.evaluator.getProperty(REFERENCED_JAVA_PROJECT));
        this.referencedJavaSourceRootsModel = this.javaRefSupport.createReferencedJavaSourceRootsModel(this.referencedJavaProjectModel, (String)editableProperties.get((Object)REFERENCED_JAVA_PROJECT_SRC));
        this.umlProjectImportsModel = UMLImportsUiSupport.createTableModel(this.importsSupport.itemsIterator((String)editableProperties.get((Object)UML_PROJECT_IMPORTS)));
        this.codeGenFolderLocation = (String)editableProperties.get((Object)CODE_GEN_FOLDER_LOCATION);
        this.codeGenTemplates = (String)editableProperties.get((Object)CODE_GEN_TEMPLATES);
        this.codeGenBackupSources = (String)editableProperties.get((Object)CODE_GEN_BACKUP_SOURCES);
        this.codeGenUseMarkers = (String)editableProperties.get((Object)CODE_GEN_USE_MARKERS);
        this.codeGenAddMarkers = (String)editableProperties.get((Object)CODE_GEN_ADD_MARKERS);
        this.codeGenShowDialog = (String)editableProperties.get((Object)CODE_GEN_SHOW_DIALOG);
    }

    public void save() {
        try {
            ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    UMLProjectProperties.this.storeProperties();
                    return null;
                }
            });
            ProjectManager.getDefault().saveProject((Project)this.project);
            this.project.setUMLProjectProperties(this);
        }
        catch (MutexException mutexException) {
            ErrorManager.getDefault().notify((Throwable)((IOException)mutexException.getException()));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void storeProperties() throws IOException {
        this.resolveProjectDependencies();
        String[] stringArray = this.importsSupport.encodeToStrings(UMLImportsUiSupport.getIterator(this.umlProjectImportsModel));
        String[] stringArray2 = this.javaRefSupport.encodeSrcGroupsToStrings(this.referencedJavaSourceRootsModel);
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        EditableProperties editableProperties2 = this.updateHelper.getProperties("nbproject/private/private.properties");
        this.projectGroup.store(editableProperties);
        this.privateGroup.store(editableProperties2);
        editableProperties.setProperty(MODELING_MODE, this.getProjectMode());
        editableProperties.setProperty(REFERENCED_JAVA_PROJECT_SRC, stringArray2);
        if (this.codeGenFolderLocation != null) {
            editableProperties.setProperty(CODE_GEN_FOLDER_LOCATION, this.codeGenFolderLocation);
        }
        if (this.codeGenTemplates != null) {
            editableProperties.setProperty(CODE_GEN_TEMPLATES, this.codeGenTemplates);
        }
        if (this.codeGenBackupSources != null) {
            editableProperties.setProperty(CODE_GEN_BACKUP_SOURCES, this.codeGenBackupSources);
        }
        if (this.codeGenUseMarkers != null) {
            editableProperties.setProperty(CODE_GEN_USE_MARKERS, this.codeGenUseMarkers);
        }
        if (this.codeGenAddMarkers != null) {
            editableProperties.setProperty(CODE_GEN_ADD_MARKERS, this.codeGenAddMarkers);
        }
        if (this.codeGenShowDialog != null) {
            editableProperties.setProperty(CODE_GEN_SHOW_DIALOG, this.codeGenShowDialog);
        }
        editableProperties.setProperty(UML_PROJECT_IMPORTS, stringArray);
        this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
        this.updateHelper.putProperties("nbproject/private/private.properties", editableProperties2);
        UMLProjectGenerator.fixJavaProjectReferences(this.updateHelper.getAntProjectHelper(), this.referencedJavaProjectModel.getProject());
    }

    private void resolveProjectDependencies() {
        String[] stringArray;
        AntProjectHelper antProjectHelper = this.updateHelper.getAntProjectHelper();
        EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        String string = (String)editableProperties.get((Object)REFERENCED_JAVA_PROJECT_ARTIFACTS);
        if (string != null && string.length() > 0) {
            stringArray = new String[]{string};
            for (int i = 0; i < stringArray.length; ++i) {
                this.refHelper.destroyReference(stringArray[i]);
            }
        }
        editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        stringArray = this.referencedJavaProjectModel.getProject();
        if (stringArray != null) {
            String[] stringArray2 = UMLProjectGenerator.addJavaSrcProjRef(antProjectHelper, this.refHelper, (Project)stringArray);
            editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
            editableProperties.setProperty(REFERENCED_JAVA_PROJECT_ARTIFACTS, stringArray2);
            antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
        }
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        HashSet hashSet3 = new HashSet(hashSet);
        hashSet3.removeAll(hashSet2);
        HashSet hashSet4 = new HashSet(hashSet2);
        hashSet4.removeAll(hashSet);
        editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
        boolean bl = false;
        String string2 = "";
        if (stringArray != null) {
            string2 = UMLProjectGenerator.getJavaSrcProjRefVal(antProjectHelper, (Project)stringArray);
            bl = true;
        }
        editableProperties.setProperty(REFERENCED_JAVA_PROJECT, string2);
        if (bl) {
            this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
        }
    }

    private String relativizeLibraryClasspath(String string, File file) {
        String string2 = PropertyUtils.getGlobalProperties().getProperty(string);
        if (string2 == null) {
            return null;
        }
        String[] stringArray = PropertyUtils.tokenizePath((String)string2);
        StringBuffer stringBuffer = new StringBuffer();
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String getAntPropertyName(String string) {
        if (string != null && string.startsWith("${") && string.endsWith("}")) {
            return string.substring(2, string.length() - 1);
        }
        return string;
    }

    public String getProjectMode() {
        return this.evaluator.getProperty(MODELING_MODE);
    }

    public String getCurrentProjectMode() {
        return this.evaluator.getProperty(MODELING_MODE);
    }

    public String getCodeGenTemplates() {
        String string = this.evaluator.getProperty(CODE_GEN_TEMPLATES);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void setCodeGenFolderLocation(String string) {
        this.codeGenFolderLocation = string;
    }

    public String getCodeGenFolderLocation() {
        String string = this.evaluator.getProperty(CODE_GEN_FOLDER_LOCATION);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public List<String> getCodeGenTemplatesArray() {
        return new ArrayList<String>(Arrays.asList(StringTokenizer2.toArray((String)this.getCodeGenTemplates(), (String)TEMPLATE_DELIMITER)));
    }

    public void setCodeGenTemplates(List<String> list) {
        this.codeGenTemplates = StringTokenizer2.delimitedString((Object[])list.toArray(), (String)TEMPLATE_DELIMITER);
    }

    public boolean isCodeGenBackupSources() {
        String string = this.evaluator.getProperty(CODE_GEN_BACKUP_SOURCES);
        if (string == null) {
            string = "true";
        }
        return Boolean.valueOf(string);
    }

    public void setCodeGenBackupSources(boolean bl) {
        this.codeGenBackupSources = String.valueOf(bl);
    }

    public boolean isCodeGenUseMarkers() {
        String string = this.evaluator.getProperty(CODE_GEN_USE_MARKERS);
        if (string == null) {
            string = "true";
        }
        return Boolean.valueOf(string);
    }

    public void setCodeGenUseMarkers(boolean bl) {
        this.codeGenUseMarkers = String.valueOf(bl);
    }

    public boolean isCodeGenAddMarkers() {
        String string = this.evaluator.getProperty(CODE_GEN_ADD_MARKERS);
        if (string == null) {
            string = "false";
        }
        return Boolean.valueOf(string);
    }

    public void setCodeGenAddMarkers(boolean bl) {
        this.codeGenAddMarkers = String.valueOf(bl);
    }

    public boolean isCodeGenShowDialog() {
        String string = this.evaluator.getProperty(CODE_GEN_SHOW_DIALOG);
        if (string == null) {
            string = "true";
        }
        return Boolean.valueOf(string);
    }

    public void setCodeGenShowDialog(boolean bl) {
        this.codeGenShowDialog = String.valueOf(bl);
    }

    public File getJavaSourceRootFolder() {
        return this.referencedJavaSourceRootsModel == null || this.referencedJavaSourceRootsModel.getSourceGroups().length == 0 || this.referencedJavaSourceRootsModel.getSourceGroup(0) == null ? null : FileUtil.toFile((FileObject)this.referencedJavaSourceRootsModel.getSourceGroup(0).getRootFolder());
    }
}

