/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.nodes;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.uml.core.metamodel.core.foundation.ExternalFileManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IAutonomousElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IDirectedRelationship;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementImport;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackageImport;
import org.netbeans.modules.uml.core.metamodel.core.foundation.UMLXMLManip;
import org.netbeans.modules.uml.core.metamodel.profiles.IProfile;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.XMLManip;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.UMLProjectHelper;
import org.netbeans.modules.uml.project.ui.cookies.ImportedElementCookie;
import org.netbeans.modules.uml.project.ui.nodes.ImportedElementNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ImportedProjectChildren
extends Children.Keys {
    private UMLProjectHelper mHelper = null;
    private HashMap<Object, AbstractNode> mNodeMap = new HashMap();
    private HashMap<String, IProject> ownerMap = new HashMap();

    public ImportedProjectChildren(UMLProjectHelper uMLProjectHelper) {
        this.mHelper = uMLProjectHelper;
    }

    public void addNewImportedElement(final IProject iProject, final IElement iElement, final IDirectedRelationship iDirectedRelationship, final boolean bl) {
        if (!(iDirectedRelationship instanceof IElementImport) && !(iDirectedRelationship instanceof IPackageImport)) {
            return;
        }
        Project project = ProjectUtil.findNetBeansProjectForModel(iProject);
        if (SwingUtilities.isEventDispatchThread()) {
            this.addImportNode(iProject, bl, iElement, (IElement)iDirectedRelationship);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportedProjectChildren.this.addImportNode(iProject, bl, iElement, (IElement)iDirectedRelationship);
                    }
                });
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void addImportNode(IProject iProject, boolean bl, IElement iElement, IElement iElement2) {
        Node node = this.getOwningProject(iProject);
        boolean bl2 = false;
        Children children = node.getChildren();
        for (Node[] nodeArray : children.getNodes()) {
            if (!((ImportedElementNode)nodeArray).getElementXMIID().equals(iElement.getXMIID())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            Node[] nodeArray;
            Project project = ProjectUtil.findNetBeansProjectForModel(iProject);
            Node node2 = ProjectUtil.findNodeInProjectTree(project, iElement);
            if (node2 == null) {
                Logger.getLogger(ImportedProjectChildren.class.getName()).log(Level.WARNING, NbBundle.getMessage(ImportedProjectChildren.class, (String)"MSG_InvalidImportedElement", (Object)iElement.getElementType(), (Object)iElement.toString()));
                return;
            }
            ImportedElementNode importedElementNode = null;
            if (iElement2 instanceof IElementImport) {
                importedElementNode = new ImportedElementNode(this.mHelper.getProject(), node2, (IElementImport)iElement2);
            } else if (iElement2 instanceof IPackageImport) {
                importedElementNode = new ImportedElementNode(this.mHelper.getProject(), node2, (IPackageImport)iElement2);
            }
            nodeArray = new Node[]{importedElementNode};
            if (children != null) {
                children.add(nodeArray);
                this.refreshKeys();
            }
        }
    }

    public void removeImportElement(IProject iProject, IElement iElement) {
        IElementImport iElementImport;
        IElement iElement2 = iElement;
        if (iElement instanceof IElementImport) {
            iElementImport = (IElementImport)iElement;
            iElement2 = iElementImport.getImportedElement();
        } else if (iElement instanceof IPackageImport) {
            iElementImport = (IPackageImport)iElement;
            iElement2 = iElementImport.getImportedPackage();
        }
        iElementImport = (Node)this.mNodeMap.get(iProject);
        if (iElementImport == null) {
            return;
        }
        this.removeNode((Node)iElementImport, iElement2);
    }

    private void removeNode(Node node, IElement iElement) {
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            ImportedElementCookie importedElementCookie = (ImportedElementCookie)nodeArray[i].getCookie(ImportedElementCookie.class);
            if (importedElementCookie == null || !importedElementCookie.getElementXMIID().equals(iElement.getXMIID())) continue;
            try {
                ((ImportedElementNode)nodeArray[i]).destroy(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    protected void addNotify() {
        IAutonomousElement iAutonomousElement;
        IPackage iPackage;
        Iterator iterator2;
        IProject iProject = this.mHelper.getProject();
        HashSet<String> hashSet = new HashSet<String>();
        ETList eTList = iProject.getPackageImports();
        if (eTList != null) {
            for (Iterator iterator2 : eTList) {
                iPackage = iterator2.getImportedPackage();
                if (iPackage instanceof IProfile || hashSet.contains(iPackage.getXMIID())) continue;
                hashSet.add(iPackage.getXMIID());
                iAutonomousElement = this.getOwningProjectOfImportedElement((IElement)iPackage);
                if (iAutonomousElement == null) {
                    Logger.getLogger(ImportedProjectChildren.class.getName()).log(Level.WARNING, NbBundle.getMessage(ImportedProjectChildren.class, (String)"MSG_InvalidOwner", (Object)iPackage.getElementType(), (Object)iPackage.toString()));
                    continue;
                }
                this.addNewImportedElement((IProject)iAutonomousElement, (IElement)iPackage, (IDirectedRelationship)iterator2, false);
            }
        }
        Iterator iterator3 = iProject.getElementImports();
        iterator2 = iterator3.iterator();
        while (iterator2.hasNext()) {
            iPackage = (IElementImport)iterator2.next();
            iAutonomousElement = iPackage.getImportedElement();
            if (hashSet.contains(iAutonomousElement.getXMIID())) continue;
            hashSet.add(iAutonomousElement.getXMIID());
            IProject iProject2 = this.getOwningProjectOfImportedElement((IElement)iAutonomousElement);
            if (iProject2 == null) {
                Logger.getLogger(ImportedProjectChildren.class.getName()).log(Level.WARNING, NbBundle.getMessage(ImportedProjectChildren.class, (String)"MSG_InvalidOwner", (Object)iAutonomousElement.getElementType(), (Object)iAutonomousElement.toString()));
                continue;
            }
            this.addNewImportedElement(iProject2, (IElement)iAutonomousElement, (IDirectedRelationship)iPackage, false);
        }
    }

    protected IProject getOwningProjectOfImportedElement(IElement iElement) {
        org.dom4j.Node node = null;
        IProject iProject = null;
        String string = XMLManip.getAttributeValue((org.dom4j.Node)iElement.getNode(), (String)"owner");
        if (this.ownerMap.containsKey(string)) {
            return this.ownerMap.get(string);
        }
        node = ExternalFileManager.getExternalNode((org.dom4j.Node)iElement.getNode());
        INamespace iNamespace = UMLXMLManip.getProject((org.dom4j.Node)node);
        if (iNamespace != null) {
            iProject = iNamespace.getProject();
        }
        this.ownerMap.put(string, iProject);
        return iProject;
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object object) {
        Node[] nodeArray = new Node[]{(Node)this.mNodeMap.get(object)};
        return nodeArray;
    }

    protected Node getOwningProject(IProject iProject) {
        AbstractNode abstractNode = null;
        if (iProject != null && (abstractNode = this.mNodeMap.get(iProject)) == null) {
            abstractNode = new AbstractNode((Children)new Children.SortedArray());
            abstractNode.setName(iProject.getNameWithAlias());
            abstractNode.setIconBaseWithExtension("org/netbeans/modules/uml/resources/images/uml-project.png");
            this.mNodeMap.put(iProject, abstractNode);
        }
        return abstractNode;
    }

    protected void refreshKeys() {
        this.setKeys(this.mNodeMap.keySet());
    }
}

