/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.nodes;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.modules.uml.common.Util;
import org.netbeans.modules.uml.common.ui.SaveNotifierOkCancel;
import org.netbeans.modules.uml.core.eventframework.IEventPayload;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.project.ui.nodes.UMLElementNode;
import org.netbeans.modules.uml.project.ui.nodes.actions.CopyDiagramAction;
import org.netbeans.modules.uml.propertysupport.DefinitionPropertyBuilder;
import org.netbeans.modules.uml.ui.controls.newdialog.AddPackageVisualPanel1;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeDragVerify;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeEventDispatcher;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeDragVerifyImpl;
import org.netbeans.modules.uml.ui.support.ADTransferable;
import org.netbeans.modules.uml.ui.support.DispatchHelper;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.diagramsupport.ProxyDiagramManager;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeDiagram;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IToolTipData;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaDropContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaEventsSink;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.RenameAction;
import org.openide.cookies.PrintCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class UMLDiagramNode
extends UMLElementNode
implements ITreeDiagram,
IDrawingAreaEventsSink {
    private IProxyDiagram mDiagram = null;
    private String mDiagramType = "Diagram";
    private DiagramPrintCookie mPrintCookie = null;
    private DispatchHelper dispatchHelper = null;
    private boolean bCancelSaveDialog = false;
    private boolean listenersRegistered = false;
    private static boolean alwaysSaveProject = false;

    public UMLDiagramNode(IProxyDiagram iProxyDiagram) {
        this.initializeNode(iProxyDiagram);
    }

    public UMLDiagramNode(Lookup lookup, IProxyDiagram iProxyDiagram) {
        super(lookup);
        this.initializeNode(iProxyDiagram);
    }

    private void initializeNode(IProxyDiagram iProxyDiagram) {
        this.setDiagram(iProxyDiagram);
        this.setFilename(iProxyDiagram.getFilename());
        this.setDiagramType(iProxyDiagram.getDiagramKindName());
        this.registerListeners();
        this.getCookieSet().add((Node.Cookie)this);
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        IProject iProject = this.getDiagram().getProject();
        String string = this.getDiagram().getQualifiedName();
        stringBuffer.append(iProject + "::" + string);
        return stringBuffer.toString();
    }

    public void registerListeners() {
        if (this.isListenersRegistered()) {
            return;
        }
        this.getDispatchHelper().registerDrawingAreaEvents((IDrawingAreaEventsSink)this);
        this.setListenersRegistered(true);
    }

    public void unregisterListeners() {
        this.getDispatchHelper().revokeDrawingAreaSink((IDrawingAreaEventsSink)this);
        this.setListenersRegistered(false);
    }

    public boolean canRename() {
        return true;
    }

    public void destroy() throws IOException {
        ProxyDiagramManager proxyDiagramManager = ProxyDiagramManager.instance();
        proxyDiagramManager.removeDiagram(this.getDiagram().getFilename());
        super.destroy();
    }

    public IProxyDiagram getDiagram() {
        return this.mDiagram;
    }

    public void setDiagram(IProxyDiagram iProxyDiagram) {
        this.mDiagram = iProxyDiagram;
    }

    public void setDiagramType(String string) {
        this.mDiagramType = string;
        this.fireIconChange();
    }

    public DiagramPrintCookie getPrintCookie() {
        if (this.mPrintCookie == null) {
            this.mPrintCookie = new DiagramPrintCookie();
        }
        return this.mPrintCookie;
    }

    public String getDiagramType() {
        return this.mDiagramType;
    }

    public Transferable clipboardCopy() throws IOException {
        ADTransferable aDTransferable = new ADTransferable("DRAGGEDITEMS");
        aDTransferable.addDiagramLocation(this.getDiagram().getFilename());
        DispatchHelper dispatchHelper = new DispatchHelper();
        IProjectTreeEventDispatcher iProjectTreeEventDispatcher = dispatchHelper.getProjectTreeDispatcher();
        if (iProjectTreeEventDispatcher != null) {
            IEventPayload iEventPayload = iProjectTreeEventDispatcher.createPayload("ProjectTreeBeginDrag");
            ProjectTreeDragVerifyImpl projectTreeDragVerifyImpl = new ProjectTreeDragVerifyImpl();
            if (this instanceof ITreeItem) {
                IProjectTreeItem[] iProjectTreeItemArray = new IProjectTreeItem[]{this.getData()};
                iProjectTreeEventDispatcher.fireBeginDrag(null, iProjectTreeItemArray, (IProjectTreeDragVerify)projectTreeDragVerifyImpl, iEventPayload);
            }
        }
        return aDTransferable;
    }

    public Action[] getActions(boolean bl) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add((Action)SystemAction.get(OpenAction.class));
        arrayList.add(null);
        int n = this.getDiagram().getDiagramKind();
        if (n != 64 && n != 8) {
            arrayList.add((Action)SystemAction.get(CopyDiagramAction.class));
        }
        arrayList.add((Action)SystemAction.get(RenameAction.class));
        arrayList.add((Action)SystemAction.get(DeleteAction.class));
        arrayList.add(null);
        this.addContextMenus(arrayList);
        arrayList.add(null);
        arrayList.add((Action)SystemAction.get(PropertiesAction.class));
        Action[] actionArray = new Action[arrayList.size()];
        arrayList.toArray(actionArray);
        return actionArray;
    }

    protected void setFilename(String string) {
        String string2;
        IProjectTreeItem iProjectTreeItem = this.getData();
        if (iProjectTreeItem != null && (string2 = StringUtilities.ensureExtension((String)string, (String)".etld")).length() > 0) {
            iProjectTreeItem.setDescription(string2);
        }
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && this.hashCode() == object.hashCode()) {
            return true;
        }
        if (object instanceof ITreeDiagram) {
            ITreeDiagram iTreeDiagram = (ITreeDiagram)object;
            String string = iTreeDiagram.getData().getDescription();
            String string2 = this.getData().getDescription();
            bl = string2.equals(string);
        } else if (object instanceof String) {
            String string = this.getData().getDescription();
            bl = string.equals((String)object);
        } else if (object instanceof IDrawingAreaControl) {
            IDrawingAreaControl iDrawingAreaControl = (IDrawingAreaControl)object;
            String string = iDrawingAreaControl.getFilename();
            String string3 = this.getData().getDescription();
            bl = string3.equals(string);
        } else if (object instanceof IProxyDiagram) {
            IProxyDiagram iProxyDiagram = (IProxyDiagram)object;
            String string = iProxyDiagram.getFilename();
            String string4 = this.getData().getDescription();
            bl = string4.equals(string);
        } else if (object instanceof IDiagram) {
            IDiagram iDiagram = (IDiagram)object;
            String string = iDiagram.getFilename();
            String string5 = this.getData().getDescription();
            bl = string5.equals(string);
        } else {
            bl = super.equals(object);
        }
        return bl;
    }

    public String getType() {
        return this.mDiagramType;
    }

    public void setName(String string) throws IllegalArgumentException {
        String string2;
        if (!Util.isDiagramNameValid((String)string)) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddPackageVisualPanel1.class, (String)"MSG_Invalid_Diagram_Name", (Object)string));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        String string3 = this.getName();
        IProxyDiagram iProxyDiagram = this.getDiagram();
        IDiagram iDiagram = null;
        boolean bl = false;
        if (iProxyDiagram != null && iProxyDiagram.getDiagram() != null) {
            bl = true;
            iDiagram = iProxyDiagram.getDiagram();
        }
        if (bl && iProxyDiagram.isOpen() && iDiagram.getIsDirty() && !iProxyDiagram.getName().equals(string) && !string3.equals("") && !string3.equals(string) && !this.save(iDiagram, true, string2 = NbBundle.getMessage(UMLDiagramNode.class, (String)"LBL_DIALOG_MSG_RenamePreSaveDiagram", (Object)iDiagram.getName()))) {
            iDiagram.setIsDirty(true);
            return;
        }
        this.setDiagramName(string);
        super.setName(string);
        this.firePropertySetsChange(null, this.retreiveProperties());
    }

    private void setDiagramName(String string) {
        String string2;
        IProxyDiagram iProxyDiagram;
        IProjectTreeItem iProjectTreeItem = this.getData();
        if (iProjectTreeItem != null && (iProxyDiagram = iProjectTreeItem.getDiagram()) != null && !(string2 = iProxyDiagram.getName()).equals(string)) {
            iProxyDiagram.setName(string);
            if (ProductHelper.getShowAliasedNames()) {
                iProxyDiagram.setAlias(string);
            }
            iProjectTreeItem.setItemText(string);
            this.fireNameChange(string2, string);
            this.fireDisplayNameChange(string2, string);
            if (this.getDiagram() != null && this.getDiagram().getDiagram() != null && this.getDiagram().getDiagram().getIsDirty()) {
                this.getDiagram().getDiagram().save();
            }
        }
    }

    public String getElementType() {
        IProxyDiagram iProxyDiagram;
        String string = "";
        IProjectTreeItem iProjectTreeItem = this.getData();
        if (iProjectTreeItem != null && (iProxyDiagram = iProjectTreeItem.getDiagram()) != null) {
            IDiagram iDiagram = iProxyDiagram.getDiagram();
            string = iDiagram != null ? "Diagram" : "ProxyDiagram";
        }
        return string;
    }

    public IElement getModelElement() {
        IProxyDiagram iProxyDiagram;
        IDiagram iDiagram = null;
        IProjectTreeItem iProjectTreeItem = this.getData();
        if (iProjectTreeItem != null && (iProxyDiagram = iProjectTreeItem.getDiagram()) != null) {
            iDiagram = iProxyDiagram.getDiagram();
        }
        return iDiagram;
    }

    protected Node.PropertySet[] buildProperties() {
        Node.PropertySet[] propertySetArray = null;
        IElement iElement = this.getModelElement();
        DefinitionPropertyBuilder definitionPropertyBuilder = DefinitionPropertyBuilder.instance();
        if (iElement != null) {
            propertySetArray = definitionPropertyBuilder.retreiveProperties(iElement.getElementType(), (Object)iElement);
        } else {
            IProjectTreeItem iProjectTreeItem = this.getData();
            if (iProjectTreeItem != null) {
                IProxyDiagram iProxyDiagram = iProjectTreeItem.getDiagram();
                propertySetArray = definitionPropertyBuilder.retreiveProperties(this.getElementType(), (Object)iProxyDiagram);
            }
        }
        return propertySetArray;
    }

    public void onDrawingAreaTooltipPreDisplay(IDiagram iDiagram, IPresentationElement iPresentationElement, IToolTipData iToolTipData, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreSave(IProxyDiagram iProxyDiagram, IResultCell iResultCell) {
    }

    public void onDrawingAreaPrePropertyChange(IProxyDiagram iProxyDiagram, int n, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreFileRemoved(String string, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreDrop(IDiagram iDiagram, IDrawingAreaDropContext iDrawingAreaDropContext, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreCreated(IDrawingAreaControl iDrawingAreaControl, IResultCell iResultCell) {
    }

    public void onDrawingAreaPostSave(IProxyDiagram iProxyDiagram, IResultCell iResultCell) {
    }

    public void onDrawingAreaPostPropertyChange(IProxyDiagram iProxyDiagram, int n, IResultCell iResultCell) {
        if (n == 1 && iProxyDiagram.getXMIID().equals(this.getDiagram().getXMIID())) {
            String string = iProxyDiagram.getNameWithAlias();
            this.fireNameChange("", string);
            this.fireDisplayNameChange("", string);
        }
    }

    public void onDrawingAreaPostDrop(IDiagram iDiagram, IDrawingAreaDropContext iDrawingAreaDropContext, IResultCell iResultCell) {
    }

    public void onDrawingAreaPostCreated(IDrawingAreaControl iDrawingAreaControl, IResultCell iResultCell) {
        this.registerListeners();
    }

    public void onDrawingAreaOpened(IDiagram iDiagram, IResultCell iResultCell) {
        this.registerListeners();
        if (this.getCookieSet().getCookie(DiagramPrintCookie.class) == null) {
            this.getCookieSet().add((Node.Cookie)this.getPrintCookie());
        }
    }

    public void onDrawingAreaKeyDown(IDiagram iDiagram, int n, boolean bl, boolean bl2, boolean bl3, IResultCell iResultCell) {
    }

    public void onDrawingAreaFileRemoved(String string, IResultCell iResultCell) {
    }

    public void onDrawingAreaClosed(IDiagram iDiagram, boolean bl, IResultCell iResultCell) {
        if (iDiagram.getFilename().equals(this.mDiagram.getDiagram().getFilename())) {
            this.getCookieSet().remove((Node.Cookie)this.getPrintCookie());
            this.unregisterListeners();
        }
    }

    public void onDrawingAreaActivated(IDiagram iDiagram, IResultCell iResultCell) {
    }

    protected boolean save(IDiagram iDiagram, boolean bl) {
        return this.save(iDiagram, bl, null);
    }

    protected boolean save(IDiagram iDiagram, boolean bl, String string) {
        String string2 = this.getDiagram().getName();
        boolean bl2 = this.userConfirmedSave(string2, string);
        if (this.getDiagram() != null && this.getDiagram().getDiagram().getIsDirty() && (!bl || bl2)) {
            iDiagram.save();
            return true;
        }
        if (!bl2 && !this.bCancelSaveDialog) {
            this.getDiagram().getDiagram().setIsDirty(false);
            return false;
        }
        return false;
    }

    private boolean userConfirmedSave(String string, String string2) {
        String string3 = NbBundle.getMessage(UMLDiagramNode.class, (String)"LBL_DIALOG_TITLE_SaveDiagram");
        if (string2 == null || string2.equals("")) {
            string2 = NbBundle.getMessage(UMLDiagramNode.class, (String)"LBL_DIALOG_MSG_RenamePreSaveDiagram", (Object)this.getDiagram().getDiagram().getName());
        }
        boolean bl = false;
        Object object = SaveNotifierOkCancel.getDefault().displayNotifier(string3, string2);
        if (object == NotifyDescriptor.OK_OPTION) {
            bl = true;
        } else {
            bl = false;
            this.bCancelSaveDialog = true;
        }
        return bl;
    }

    public boolean isListenersRegistered() {
        return this.listenersRegistered;
    }

    public void setListenersRegistered(boolean bl) {
        this.listenersRegistered = bl;
    }

    public DispatchHelper getDispatchHelper() {
        if (this.dispatchHelper == null) {
            this.dispatchHelper = new DispatchHelper();
        }
        return this.dispatchHelper;
    }

    public class DiagramPrintCookie
    implements PrintCookie {
        public void print() {
            IDiagram iDiagram;
            IProxyDiagram iProxyDiagram;
            IProjectTreeItem iProjectTreeItem = UMLDiagramNode.this.getData();
            IProductDiagramManager iProductDiagramManager = ProductHelper.getProductDiagramManager();
            if (iProjectTreeItem != null && iProductDiagramManager != null && (iProxyDiagram = iProjectTreeItem.getDiagram()) != null && (iDiagram = iProxyDiagram.getDiagram()) != null) {
                iDiagram.printGraph(true);
            }
        }
    }

    public class DiagramCookie
    implements Node.Cookie {
        public IProxyDiagram getDiagram() {
            return UMLDiagramNode.this.getDiagram();
        }
    }
}

