/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.nodes.actions;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.project.ui.cookies.ImportedElementCookie;
import org.netbeans.modules.uml.project.ui.nodes.actions.ImportedElementDeletePanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.ExtendedDelete;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class UMLDeleteImportedElementAction
extends CookieAction
implements ExtendedDelete {
    public boolean delete(final Node[] nodeArray) throws IOException {
        if (this.enable(nodeArray)) {
            if (EventQueue.isDispatchThread()) {
                this.performAction(nodeArray);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        UMLDeleteImportedElementAction.this.performAction(nodeArray);
                    }
                });
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return;
        }
        ImportedElementDeletePanel importedElementDeletePanel = new ImportedElementDeletePanel(nodeArray);
        String string = NbBundle.getMessage(UMLDeleteImportedElementAction.class, (String)"TITLE_ConfirmDeleteImportedElement");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)importedElementDeletePanel, string, true, 0, NotifyDescriptor.YES_OPTION, null);
        dialogDescriptor.setMessageType(3);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(string);
        try {
            dialog.setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.YES_OPTION) {
                boolean bl = importedElementDeletePanel.getDeleteFromOriginal();
                for (Node node : nodeArray) {
                    if (bl) {
                        node.destroy();
                        continue;
                    }
                    ImportedElementCookie importedElementCookie = (ImportedElementCookie)node.getLookup().lookup(ImportedElementCookie.class);
                    importedElementCookie.removeImportedElement();
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(UMLDeleteImportedElementAction.class.getName()).log(Level.SEVERE, exception.getLocalizedMessage());
        }
        finally {
            dialog.dispose();
        }
    }

    protected int mode() {
        return 4;
    }

    public String getName() {
        return NbBundle.getMessage(UMLDeleteImportedElementAction.class, (String)"CTL_RemoveFromImport");
    }

    protected Class[] cookieClasses() {
        return new Class[]{ImportedElementCookie.class};
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

