/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.project.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.project.ProjectUtil;
import org.netbeans.modules.uml.project.ui.UMLProjectSettings;
import org.netbeans.modules.uml.project.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.uml.project.ui.wizards.SettingsPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ProjectLocationVisualPanel
extends SettingsPanel
implements DocumentListener {
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private ButtonGroup modelTypeButtonGroup;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private ResourceBundle bundle = NbBundle.getBundle(ProjectLocationVisualPanel.class);
    private PanelConfigureProject panel;
    private int type;

    public ProjectLocationVisualPanel(PanelConfigureProject panelConfigureProject, int n) {
        this.initComponents();
        this.panel = panelConfigureProject;
        this.type = n;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    private void initComponents() {
        this.modelTypeButtonGroup = new ButtonGroup();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)this.bundle.getString("LBL_NWP1_ProjectName_Label"));
        this.projectNameLabel.getAccessibleContext().setAccessibleName("");
        this.projectNameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationVisualPanel.class, (String)"ACSD_NWP1_ProjectName"));
        this.projectNameTextField.getAccessibleContext().setAccessibleName("");
        this.projectNameTextField.getAccessibleContext().setAccessibleDescription("");
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)this.bundle.getString("LBL_NWP1_ProjectLocation_Label"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName("");
        this.projectLocationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationVisualPanel.class, (String)"ACSD_NWP1_ProjectLocation"));
        this.projectLocationTextField.getAccessibleContext().setAccessibleName("");
        this.projectLocationTextField.getAccessibleContext().setAccessibleDescription("");
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)this.bundle.getString("LBL_NWP1_BrowseLocation_Button"));
        this.browseButton.setActionCommand("BROWSE");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectLocationVisualPanel.this.browseLocationAction(actionEvent);
            }
        });
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_browseButton"));
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)this.bundle.getString("LBL_NWP1_CreatedProjectFolder_Lablel"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleName("");
        this.createdFolderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProjectLocationVisualPanel.class, (String)"ACSD_NWP1_CreatedProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        this.createdFolderTextField.getAccessibleContext().setAccessibleName("");
        this.createdFolderTextField.getAccessibleContext().setAccessibleDescription("");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.projectNameLabel, -1, -1, Short.MAX_VALUE).add((Component)this.createdFolderLabel, -1, -1, Short.MAX_VALUE).add((Component)this.projectLocationLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.createdFolderTextField, -1, 340, Short.MAX_VALUE).add(1, (Component)this.projectNameTextField, -1, 340, Short.MAX_VALUE).add(1, (Component)this.projectLocationTextField, -1, 340, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectNameTextField, -2, -1, -2).add((Component)this.projectNameLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.projectLocationTextField, -2, -1, -2).add((Component)this.projectLocationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createdFolderTextField, -2, -1, -2).add((Component)this.createdFolderLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseLocationAction(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("BROWSE".equals(string)) {
            File file;
            JFileChooser jFileChooser = new JFileChooser();
            FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
            jFileChooser.setDialogTitle(this.bundle.getString("LBL_NWP1_SelectProjectLocation"));
            jFileChooser.setFileSelectionMode(1);
            String string2 = this.projectLocationTextField.getText();
            if (string2.length() > 0 && (file = new File(string2)).exists()) {
                jFileChooser.setSelectedFile(file);
            }
            if (0 == jFileChooser.showOpenDialog(this)) {
                file = jFileChooser.getSelectedFile();
                this.projectLocationTextField.setText(file.getAbsolutePath());
            }
            this.panel.fireChangeEvent();
        }
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        Object object;
        File file;
        String string = this.projectNameTextField.getText();
        String string2 = string.trim();
        int n = string2.length();
        if (n == 0 || n < string.length()) {
            String string3 = n == 0 ? this.bundle.getString("MSG_IllegalProjectName") : this.bundle.getString("MSG_SpacesInProjectName");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string3);
            return false;
        }
        File file2 = new File(this.projectLocationTextField.getText()).getAbsoluteFile();
        if (ProjectLocationVisualPanel.getCanonicalFile(file2) == null) {
            String string4 = this.bundle.getString("MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string4);
            return false;
        }
        File file3 = ProjectLocationVisualPanel.getCanonicalFile(new File(this.createdFolderTextField.getText()).getAbsoluteFile());
        if (file3 == null) {
            String string5 = this.bundle.getString("MSG_IllegalProjectName");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string5);
            return false;
        }
        boolean bl = true;
        for (file = file3; file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file != null) {
            try {
                object = File.createTempFile("temp", "", file);
                if (((File)object).exists()) {
                    bl = false;
                    ((File)object).delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.bundle.getString("MSG_ProjectFolderReadOnly"));
            return false;
        }
        if (FileUtil.toFileObject((File)file) == null) {
            object = this.bundle.getString("MSG_IllegalProjectLocation");
            wizardDescriptor.putProperty("WizardPanel_errorMessage", object);
            return false;
        }
        object = file3.listFiles();
        if (file3.exists() && object != null && ((Object)object).length > 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.bundle.getString("MSG_ProjectFolderExists"));
            return false;
        }
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("name", (Object)this.projectNameTextField.getText().trim());
        wizardDescriptor.putProperty("projdir", (Object)new File(this.createdFolderTextField.getText().trim()));
        wizardDescriptor.putProperty("uml-wizard-type", (Object)this.type);
    }

    void read(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        file = file == null || file.getParentFile() == null || !file.getParentFile().isDirectory() ? ProjectChooser.getProjectsFolder() : file.getParentFile();
        this.projectLocationTextField.setText(file.getAbsolutePath());
        String string = (String)wizardDescriptor.getProperty("name");
        if (string == null) {
            String string2 = this.bundle.getString("TXT_UMLProject");
            string = ProjectUtil.createUniqueProjectName(file, string2, false);
            wizardDescriptor.putProperty("nameIndex", (Object)new Integer(UMLProjectSettings.getDefault().getNewProjectCount()));
        }
        this.projectNameTextField.setText(string);
        this.projectNameTextField.selectAll();
        this.firePropertyChange("MODE_CHANGED", null, wizardDescriptor.getProperty("uml-wizard-type"));
    }

    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
    }

    private static JFileChooser createChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setName(NbBundle.getMessage(ProjectLocationVisualPanel.class, (String)"LBL_NWP1_SelectProjectLocation"));
        return jFileChooser;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTexts(documentEvent);
        if (this.projectNameTextField.getDocument() == documentEvent.getDocument()) {
            this.firePropertyChange("name", null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.projectNameTextField.getDocument() || document == this.projectLocationTextField.getDocument()) {
            String string = this.projectNameTextField.getText();
            String string2 = this.projectLocationTextField.getText();
            this.createdFolderTextField.setText(string2 + File.separatorChar + string);
        }
        this.panel.fireChangeEvent();
    }

    static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

