/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Report {
    File antScript;
    File resultsDir;
    String suiteClassName;
    String classpath;
    ClassPath platformSources;
    Collection<FileObject> classpathSourceRoots;
    String[] outputStd;
    String[] outputErr;
    int totalTests;
    int failures;
    int errors;
    int elapsedTimeMillis;
    int detectedPassedTests;
    private Collection<Testcase> tests;
    private boolean closed = false;

    Report(String string) {
        this.suiteClassName = string;
        this.antScript = this.antScript;
        this.tests = new ArrayList<Testcase>(10);
    }

    void reportTest(Testcase testcase) {
        this.tests.add(testcase);
        if (testcase.trouble == null) {
            ++this.detectedPassedTests;
        }
    }

    void update(Report report) {
        this.resultsDir = report.resultsDir;
        this.suiteClassName = report.suiteClassName;
        this.outputStd = report.outputStd;
        this.outputErr = report.outputErr;
        this.totalTests = report.totalTests;
        this.failures = report.failures;
        this.errors = report.errors;
        this.elapsedTimeMillis = report.elapsedTimeMillis;
        this.detectedPassedTests = report.detectedPassedTests;
        this.tests = report.tests;
    }

    Collection<Testcase> getTests() {
        if (this.tests.isEmpty()) {
            List<Testcase> list = Collections.emptyList();
            return list;
        }
        return new ArrayList<Testcase>(this.tests);
    }

    boolean containsFailed() {
        assert (EventQueue.isDispatchThread());
        return this.failures + this.errors != 0;
    }

    static final class Trouble {
        static final String COMPARISON_FAILURE_JUNIT3 = "junit.framework.ComparisonFailure";
        static final String COMPARISON_FAILURE_JUNIT4 = "org.junit.ComparisonFailure";
        boolean error;
        String message;
        String exceptionClsName;
        String[] stackTrace;
        Trouble nestedTrouble;

        Trouble(boolean bl) {
            this.error = bl;
        }

        boolean isError() {
            return this.error;
        }

        boolean isComparisonFailure() {
            return this.exceptionClsName != null && (this.exceptionClsName.equals(COMPARISON_FAILURE_JUNIT3) || this.exceptionClsName.equals(COMPARISON_FAILURE_JUNIT4));
        }

        boolean isFakeError() {
            return this.error && this.isComparisonFailure();
        }
    }

    static final class Testcase {
        String className;
        String name;
        int timeMillis;
        Trouble trouble;

        Testcase() {
        }
    }
}

