/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import javax.swing.Action;
import org.netbeans.modules.junit.output.JumpAction;
import org.netbeans.modules.junit.output.Report;
import org.netbeans.modules.junit.output.TestMethodNodeChildren;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

final class TestMethodNode
extends AbstractNode {
    private final Report.Testcase testcase;

    TestMethodNode(Report.Testcase testcase) {
        super((Children)(testcase.trouble != null ? new TestMethodNodeChildren(testcase) : Children.LEAF));
        this.testcase = testcase;
        this.setDisplayName();
        this.setIconBaseWithExtension("org/netbeans/modules/junit/output/res/method.gif");
    }

    private void setDisplayName() {
        int n;
        int n2 = this.testcase.trouble == null ? 0 : (n = this.testcase.trouble.isError() ? 1 : 2);
        if (n == 0 && this.testcase.timeMillis < 0) {
            this.setDisplayName(this.testcase.name);
            return;
        }
        String[] stringArray = new String[]{null, "MSG_TestMethodError", "MSG_TestMethodFailed"};
        String[] stringArray2 = new String[]{"MSG_TestMethodPassed_time", "MSG_TestMethodError_time", "MSG_TestMethodFailed_time"};
        this.setDisplayName(this.testcase.timeMillis < 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)stringArray[n], (Object)this.testcase.name) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)stringArray2[n], (Object)this.testcase.name, (Object)new Float((float)this.testcase.timeMillis / 1000.0f)));
    }

    public String getHtmlDisplayName() {
        int n = this.testcase.trouble == null ? 0 : (this.testcase.trouble.isError() ? 1 : 2);
        String[] stringArray = new String[]{"MSG_TestMethodPassed_HTML", "MSG_TestMethodError_HTML", "MSG_TestMethodFailed_HTML"};
        String[] stringArray2 = new String[]{"MSG_TestMethodPassed_HTML_time", "MSG_TestMethodError_HTML_time", "MSG_TestMethodFailed_HTML_time"};
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(this.testcase.name);
        stringBuffer.append("&nbsp;&nbsp;");
        stringBuffer.append("<font color='#");
        stringBuffer.append(this.testcase.trouble != null ? "FF0000'>" : "00CC00'>");
        stringBuffer.append(this.testcase.timeMillis < 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)stringArray[n]) : NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)stringArray2[n], (Object)new Float((float)this.testcase.timeMillis / 1000.0f)));
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    public Action getPreferredAction() {
        Report.Trouble trouble = this.testcase.trouble;
        String string = trouble != null && trouble.stackTrace != null && trouble.stackTrace.length != 0 ? trouble.stackTrace[0] : null;
        return new JumpAction((Node)this, string);
    }

    public SystemAction[] getActions(boolean bl) {
        return new SystemAction[0];
    }
}

