/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.nodes.Document;

class XDMModelUndoableEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -4513245871320808368L;
    private Document oldDocument;
    private Document newDocument;
    private XDMModel model;

    public XDMModelUndoableEdit(Document document, Document document2, XDMModel xDMModel) {
        this.oldDocument = document;
        this.newDocument = document2;
        this.model = xDMModel;
    }

    public void redo() throws CannotRedoException {
        super.redo();
        try {
            this.model.resetDocument(this.newDocument);
        }
        catch (RuntimeException runtimeException) {
            if (this.newDocument != this.model.getCurrentDocument()) {
                CannotRedoException cannotRedoException = new CannotRedoException();
                cannotRedoException.initCause(runtimeException);
                throw cannotRedoException;
            }
            throw runtimeException;
        }
    }

    public void undo() throws CannotUndoException {
        super.undo();
        try {
            this.model.resetDocument(this.oldDocument);
        }
        catch (RuntimeException runtimeException) {
            if (this.oldDocument != this.model.getCurrentDocument()) {
                CannotUndoException cannotUndoException = new CannotUndoException();
                cannotUndoException.initCause(runtimeException);
                throw cannotUndoException;
            }
            throw runtimeException;
        }
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof XDMModelUndoableEdit) {
            XDMModelUndoableEdit xDMModelUndoableEdit = (XDMModelUndoableEdit)undoableEdit;
            if (this.newDocument == xDMModelUndoableEdit.oldDocument) {
                this.newDocument = xDMModelUndoableEdit.newDocument;
                return true;
            }
        }
        return false;
    }
}

