/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.drawingarea;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.common.ui.SaveNotifierYesNo;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.drawingarea.dataobject.DiagramDataNode;
import org.netbeans.modules.uml.drawingarea.dataobject.DiagramDataObject;
import org.netbeans.modules.uml.palette.PaletteSupport;
import org.netbeans.modules.uml.project.ui.nodes.AbstractModelElementNode;
import org.netbeans.modules.uml.project.ui.nodes.UMLModelElementNode;
import org.netbeans.modules.uml.resources.images.ImageUtil;
import org.netbeans.modules.uml.ui.controls.drawingarea.IUIDiagram;
import org.netbeans.modules.uml.ui.support.DispatchHelper;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProductDiagramManager;
import org.netbeans.modules.uml.ui.support.commonresources.CommonResourceManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IToolTipData;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.ICreateNodeContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDraggingNodeContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaAddNodeEventsSink;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaDropContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaEventsSink;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaSelectionEventsSink;
import org.netbeans.spi.palette.PaletteController;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramTopComponent
extends CloneableTopComponent
implements IDrawingAreaSelectionEventsSink,
IDrawingAreaEventsSink,
IDrawingAreaAddNodeEventsSink {
    private transient ADDrawingAreaControl mControl = null;
    private transient String m_PreferredID = "";
    private transient LocalUMLModelElementNode node = null;
    private transient DiagramDataObject diagramDO;
    private boolean bCancelSaveDialog = false;
    private boolean projectClosing = false;
    private static transient boolean overviewOpen = false;
    private transient boolean listenersRegistered = false;
    private transient boolean isHidden = true;
    private static final String SPACE_STAR = " *";
    DispatchHelper helper = new DispatchHelper();
    private DiagramChangeListener listener = new DiagramChangeListener();
    private PaletteController paletteContrl;
    private PaletteSupport paletteSupport;
    private static final int RESULT_CANCEL = 0;
    private static final int RESULT_NO = 1;
    private static final int RESULT_YES = 2;
    private boolean processingProperties = false;

    public DiagramTopComponent(String string, boolean bl) {
        this.initializeUI();
        this.loadDrawingArea(string, bl);
        this.initialize();
    }

    public DiagramTopComponent(INamespace iNamespace, String string, int n) {
        this.initializeUI();
        this.loadDrawingArea(iNamespace, string, n);
        this.initialize();
    }

    private void initialize() {
        this.paletteContrl = this.getAssociatedPalette();
        Runnable runnable = new Runnable(){

            public void run() {
                DiagramTopComponent.this.setToolTipText(DiagramTopComponent.this.getFullNamespace());
            }
        };
        SwingUtilities.invokeLater(runnable);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("shift F10"), "SHOW_CONTEXT_MENU");
        this.getActionMap().put("SHOW_CONTEXT_MENU", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramTopComponent.this.mControl.showAccessiblePopupMenu();
            }
        });
    }

    private DiagramDataObject getDiagramDO() {
        IDrawingAreaControl iDrawingAreaControl;
        if (this.diagramDO == null && (iDrawingAreaControl = this.getDrawingAreaControl()) != null) {
            String string;
            String string2 = string = iDrawingAreaControl.getFilename();
            String string3 = string;
            try {
                if (string != null && !string.equals("")) {
                    int n = string.lastIndexOf(".");
                    if (n > -1) {
                        string3 = string.substring(0, n) + ".etlp";
                        string2 = string.substring(0, n) + ".etld";
                    }
                    File file = new File(string3);
                    File file2 = new File(string2);
                    FileObject fileObject = FileUtil.createData((File)file);
                    FileUtil.createData((File)file2);
                    if (fileObject != null) {
                        this.diagramDO = (DiagramDataObject)DataObject.find((FileObject)fileObject);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this.diagramDO;
    }

    private String getFullNamespace() {
        if (this.mControl == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        IProject iProject = this.mControl.getNamespace().getProject();
        stringBuffer.append(this.mControl.getProxyDiagram().toString());
        for (IElement iElement = this.mControl.getDiagram().getOwner(); iElement != null && !iElement.toString().equals(iProject.toString()); iElement = iElement.getOwner()) {
            stringBuffer.insert(0, iElement + "::");
        }
        stringBuffer.insert(0, iProject + "::");
        return stringBuffer.toString();
    }

    public void loadDrawingArea(INamespace iNamespace, String string, int n) {
        Object var4_4 = null;
        try {
            this.mControl = new ADDrawingAreaControl();
            this.addControl();
            this.mControl.addPropertyChangeListener((PropertyChangeListener)this.listener);
            this.mControl.initializeNewDiagram(iNamespace, string, n);
            this.setDiagramProperties((IDrawingAreaControl)this.mControl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void loadDrawingArea(String string, boolean bl) {
        if (string != null) {
            ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
            IDiagram iDiagram = null;
            IProduct iProduct = null;
            if (iCoreProduct instanceof IProduct) {
                iProduct = (IProduct)iCoreProduct;
                iDiagram = iProduct.getDiagram(string);
            }
            if (iDiagram != null) {
                if (iDiagram instanceof IUIDiagram) {
                    IUIDiagram iUIDiagram = (IUIDiagram)iDiagram;
                    ADDrawingAreaControl aDDrawingAreaControl = (ADDrawingAreaControl)iUIDiagram.getDrawingArea();
                    if (aDDrawingAreaControl != null) {
                        this.setDiagramProperties((IDrawingAreaControl)aDDrawingAreaControl);
                        this.mControl = aDDrawingAreaControl;
                    } else {
                        if (iProduct != null) {
                            iProduct.removeDiagram(iDiagram);
                        }
                        this.mControl = this.createNewDiagram(string, bl);
                        this.setDiagramProperties((IDrawingAreaControl)this.mControl);
                    }
                }
            } else {
                this.mControl = this.createNewDiagram(string, bl);
                this.setDiagramProperties((IDrawingAreaControl)this.mControl);
            }
        } else {
            this.mControl = this.createNewDiagram(null, false);
        }
        this.addControl();
    }

    private void addControl() {
        if (this.mControl != null) {
            this.add((Component)this.mControl, "Center");
            if (this.getDiagramDO() != null) {
                this.getDiagramDO().addPropertyChangeListener(this.listener);
            }
        }
    }

    private void addSaveCookie() {
        Node[] nodeArray = this.getActivatedNodes();
        if (nodeArray != null && nodeArray.length > 0 && nodeArray[0] instanceof LocalUMLModelElementNode) {
            ((LocalUMLModelElementNode)nodeArray[0]).addSaveCookie();
        }
        if (this.node != null) {
            this.node.addSaveCookie();
        }
    }

    private void removeSaveCookie() {
        Node[] nodeArray = this.getActivatedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!(nodeArray[i] instanceof LocalUMLModelElementNode)) continue;
            ((LocalUMLModelElementNode)nodeArray[i]).removeSaveCookie();
        }
        if (this.node != null) {
            this.node.removeSaveCookie();
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public IDiagram getAssociatedDiagram() {
        IDiagram iDiagram = null;
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingAreaControl();
        if (iDrawingAreaControl != null) {
            iDiagram = iDrawingAreaControl.getDiagram();
        }
        return iDiagram;
    }

    protected void registerListeners() {
        if (this.isListenersRegistered()) {
            return;
        }
        this.helper.registerDrawingAreaSelectionEvents((IDrawingAreaSelectionEventsSink)this);
        this.helper.registerDrawingAreaEvents((IDrawingAreaEventsSink)this);
        this.helper.registerDrawingAreaAddNodeEvents((IDrawingAreaAddNodeEventsSink)this);
        this.setListenersRegistered(true);
    }

    protected void unregisterListeners() {
        this.helper.revokeDrawingAreaSelectionSink((IDrawingAreaSelectionEventsSink)this);
        this.helper.revokeDrawingAreaSink((IDrawingAreaEventsSink)this);
        this.helper.revokeDrawingAreaAddNodeSink((IDrawingAreaAddNodeEventsSink)this);
        this.setListenersRegistered(false);
    }

    protected ADDrawingAreaControl createNewDiagram(INamespace iNamespace, String string, int n) {
        ADDrawingAreaControl aDDrawingAreaControl = null;
        try {
            aDDrawingAreaControl = new ADDrawingAreaControl();
            aDDrawingAreaControl.addPropertyChangeListener((PropertyChangeListener)this.listener);
            aDDrawingAreaControl.initializeNewDiagram(iNamespace, string, n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return aDDrawingAreaControl;
    }

    private ADDrawingAreaControl createNewDiagram(String string, boolean bl) {
        ADDrawingAreaControl aDDrawingAreaControl = null;
        try {
            aDDrawingAreaControl = new ADDrawingAreaControl();
            aDDrawingAreaControl.addPropertyChangeListener((PropertyChangeListener)this.listener);
            this.mControl = aDDrawingAreaControl;
            aDDrawingAreaControl.load(string, bl);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return aDDrawingAreaControl;
    }

    protected void setDiagramProperties(final IDrawingAreaControl iDrawingAreaControl) {
        if (iDrawingAreaControl != null) {
            CommonResourceManager commonResourceManager = CommonResourceManager.instance();
            final String string = commonResourceManager.getIconDetailsForElementType(iDrawingAreaControl.getDiagramKind2());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiagramTopComponent.this.setDisplayName(iDrawingAreaControl.getNameWithAlias());
                    DiagramTopComponent.this.setName(iDrawingAreaControl.getName());
                    DiagramTopComponent.this.setIcon(Utilities.loadImage((String)string, (boolean)true));
                }
            });
        }
    }

    protected void initializeUI() {
        this.setLayout(new BorderLayout());
    }

    public boolean canClose() {
        if (!this.getDrawingAreaControl().getIsDirty() || this.getDrawingAreaControl().getGraphWindow() == null) {
            return true;
        }
        DiagramDataObject diagramDataObject = this.getDiagramDO();
        if (diagramDataObject != null && diagramDataObject.getCookie(SaveCookie.class) == null) {
            return true;
        }
        IDiagram iDiagram = this.getDrawingAreaControl().getDiagram();
        return this.save(iDiagram, false, null);
    }

    protected void componentClosed() {
        IProductDiagramManager iProductDiagramManager = ProductHelper.getProductDiagramManager();
        if (iProductDiagramManager != null) {
            iProductDiagramManager.closeDiagram(this.getDrawingAreaControl().getDiagram().getFilename());
        }
        super.componentClosed();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiagramTopComponent.this.selectedElements(null, null, null);
                DiagramTopComponent.this.remove((Component)DiagramTopComponent.this.mControl);
                DiagramTopComponent.this.mControl = null;
                if (DiagramTopComponent.this.getDiagramDO() != null) {
                    DiagramTopComponent.this.getDiagramDO().removePropertyChangeListener(DiagramTopComponent.this.listener);
                }
            }
        });
        this.removeBasicActionCallbacks();
        this.isHidden = true;
        this.unregisterListeners();
        this.detachAssociatedPalette();
    }

    protected boolean save(IDiagram iDiagram, boolean bl, String string) {
        boolean bl2 = true;
        if (iDiagram == null || !iDiagram.getIsDirty()) {
            return bl2;
        }
        String string2 = iDiagram.getFilename();
        int n = 0;
        n = bl ? 2 : this.saveDiagram();
        switch (n) {
            case 2: {
                SaveCookie saveCookie = this.getDiagramDO().getCookie(SaveCookie.class);
                try {
                    if (saveCookie == null) break;
                    saveCookie.save();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                break;
            }
            case 1: {
                DiagramDataObject diagramDataObject = this.getDiagramDO();
                if (diagramDataObject != null) {
                    diagramDataObject.removeSaveCookie();
                    diagramDataObject.setModified(false);
                }
                this.removeSaveCookie();
                break;
            }
            case 0: {
                bl2 = false;
            }
        }
        return bl2;
    }

    private int saveDiagram() {
        String string = "PSK_YES";
        String string2 = NbBundle.getMessage(DiagramTopComponent.class, (String)"LBL_DIALOG_TITLE_SaveDiagram");
        String string3 = NbBundle.getMessage(DiagramTopComponent.class, (String)"LBL_DIALOG_MSG_Diagram", (Object)this.getName());
        int n = 0;
        Object object = SaveNotifierYesNo.getDefault().displayNotifier(string2, string3, this.getFullNamespace());
        if (object == SaveNotifierYesNo.SAVE_ALWAYS_OPTION) {
            n = 2;
        } else if (object == NotifyDescriptor.YES_OPTION) {
            n = 2;
        } else if (object == NotifyDescriptor.NO_OPTION) {
            n = 1;
        } else {
            n = 0;
            this.bCancelSaveDialog = true;
        }
        return n;
    }

    protected void componentActivated() {
        super.componentActivated();
        this.isHidden = false;
        this.registerListeners();
        this.getDrawingAreaControl().setFocus();
        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("modeling-diagrams");
        if (topComponentGroup != null) {
            topComponentGroup.open();
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("documentation");
            if (!Boolean.TRUE.equals(topComponent.getClientProperty((Object)"isSliding"))) {
                topComponent.requestVisible();
            }
            if (overviewOpen) {
                if (this.mControl != null) {
                    this.mControl.overviewWindow(true);
                }
            } else if (this.mControl != null) {
                this.mControl.overviewWindow(false);
                overviewOpen = false;
            }
        } else {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("documentation");
            if (topComponent != null && !topComponent.isOpened()) {
                topComponent.open();
            }
        }
        this.selectedElements(this.getDrawingAreaControl().getDiagram(), (ETList<IPresentationElement>)this.getDrawingAreaControl().getSelected(), null);
        this.addBasicActionCallbacks();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.isHidden = true;
        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("modeling-diagrams");
        if (topComponentGroup != null) {
            topComponentGroup.close();
            if (this.mControl != null && this.mControl.getIsOverviewWindowOpen()) {
                this.mControl.overviewWindow(false);
                overviewOpen = true;
            } else {
                overviewOpen = false;
            }
        } else {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent("documentation");
            if (topComponent != null && topComponent.isOpened()) {
                topComponent.close();
            }
        }
        this.mControl.selectAll(false);
        this.removeBasicActionCallbacks();
        this.removeSelectedActionCallbacks();
    }

    public String preferredID() {
        String string = this.m_PreferredID;
        if (string.length() <= 0) {
            if (this.getDrawingAreaControl() != null) {
                IDiagram iDiagram = this.getDrawingAreaControl().getDiagram();
                if (iDiagram != null) {
                    this.m_PreferredID = DiagramTopComponent.preferredIDForDiagram(iDiagram);
                }
            } else {
                this.m_PreferredID = super.preferredID();
            }
            string = this.m_PreferredID;
        }
        return string;
    }

    public static String preferredIDForDiagram(IDiagram iDiagram) {
        String string = "";
        if (iDiagram != null) {
            String string2 = iDiagram.getFilename();
            File file = new File(string2);
            String string3 = file.getName();
            int n = string3.lastIndexOf(46);
            if (n > 0) {
                string3 = string3.substring(0, n);
            }
            string = string3.toUpperCase();
        }
        return string;
    }

    public void onSelect(IDiagram iDiagram, ETList<IPresentationElement> eTList, ICompartment iCompartment, IResultCell iResultCell) {
        IDiagram iDiagram2 = this.getDrawingAreaControl().getDiagram();
        if (iDiagram.isSame(iDiagram2)) {
            this.selectedElements(iDiagram, eTList, iCompartment);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiagramTopComponent.this.refreshPropertySet();
            }
        });
    }

    private void refreshPropertySet() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null) {
            return;
        }
        for (Node node : nodeArray) {
            if (!(node instanceof AbstractModelElementNode)) continue;
            AbstractModelElementNode abstractModelElementNode = (AbstractModelElementNode)node;
            abstractModelElementNode.notifyPropertySetsChange();
        }
    }

    public void onUnselect(IDiagram iDiagram, IPresentationElement[] iPresentationElementArray, IResultCell iResultCell) {
        IDiagram iDiagram2 = this.getDrawingAreaControl().getDiagram();
        if (iDiagram.isSame(iDiagram2)) {
            ETList eTList = iDiagram.getSelected();
            this.selectedElements(iDiagram, (ETList<IPresentationElement>)eTList, null);
        }
    }

    protected void selectedElements(IDiagram iDiagram, ETList<IPresentationElement> eTList, ICompartment iCompartment) {
        Object object;
        IElement iElement = null;
        if (iCompartment != null) {
            iElement = iCompartment.getModelElement();
            this.addSelectedActionCallbacks();
        } else if (eTList != null && eTList.size() > 0) {
            object = (IPresentationElement)eTList.get(0);
            if (object != null) {
                iElement = object.getFirstSubject();
            }
            this.addSelectedActionCallbacks();
        } else if (iDiagram != null) {
            iElement = iDiagram;
        }
        if (iElement != null) {
            this.node = new LocalUMLModelElementNode();
            this.node.setElement(iElement);
            this.node.setName(iElement.getElementType());
            if (iElement instanceof INamedElement) {
                String string;
                object = ((INamedElement)iElement).getName();
                if (object != null && !object.trim().equals("")) {
                    this.node.setName((String)object);
                } else if (iElement instanceof IAssociation && (string = iElement.getExpandedElementType()) != null && string.trim().length() > 0) {
                    this.node.setName(string.replace('_', ' '));
                }
            } else if (iElement instanceof IDiagram) {
                this.node.setName(((IDiagram)iElement).getName());
            }
            object = new Node[]{this.node};
            this.setActivatedNodes((Node[])object);
        } else {
            object = new IPresentationElement[]{};
            this.setActivatedNodes((Node[])object);
            this.removeSelectedActionCallbacks();
        }
    }

    private void configureLocalNode(IElement iElement) {
        if (iElement != null) {
            Node[] nodeArray;
            this.node = new LocalUMLModelElementNode();
            this.node.setElement(iElement);
            this.node.setName(iElement.getElementType());
            if (iElement instanceof INamedElement) {
                nodeArray = ((INamedElement)iElement).getName();
                if (!nodeArray.trim().equals("")) {
                    this.node.setName(((INamedElement)iElement).getName());
                }
            } else if (iElement instanceof IDiagram) {
                this.node.setName(((IDiagram)iElement).getName());
            }
            nodeArray = new Node[]{this.node};
            this.setActivatedNodes(nodeArray);
        } else {
            Node[] nodeArray = new Node[]{};
            this.setActivatedNodes(nodeArray);
            this.removeSelectedActionCallbacks();
        }
    }

    public IDrawingAreaControl getDrawingAreaControl() {
        return this.mControl;
    }

    private PaletteController getAssociatedPalette() {
        if (this.paletteSupport == null) {
            this.paletteSupport = new PaletteSupport();
        }
        if (this.getDrawingAreaControl() != null) {
            PaletteController paletteController = this.paletteSupport.getPalette(this.getDrawingAreaControl());
            return paletteController;
        }
        return null;
    }

    private void detachAssociatedPalette() {
        if (this.paletteSupport != null) {
            this.paletteSupport.unregisterListeners();
        }
    }

    public void onDrawingAreaTooltipPreDisplay(IDiagram iDiagram, IPresentationElement iPresentationElement, IToolTipData iToolTipData, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreSave(IProxyDiagram iProxyDiagram, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreFileRemoved(String string, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreDrop(IDiagram iDiagram, IDrawingAreaDropContext iDrawingAreaDropContext, IResultCell iResultCell) {
    }

    public void onDrawingAreaPreCreated(IDrawingAreaControl iDrawingAreaControl, IResultCell iResultCell) {
    }

    public void onDrawingAreaPostSave(IProxyDiagram iProxyDiagram, IResultCell iResultCell) {
    }

    public void onDrawingAreaPrePropertyChange(IProxyDiagram iProxyDiagram, int n, IResultCell iResultCell) {
        if (n == 1 && iProxyDiagram.getDiagram().isSame(this.getDrawingAreaControl().getDiagram()) && this.getDrawingAreaControl().getIsDirty()) {
            String string = NbBundle.getMessage(DiagramTopComponent.class, (String)"LBL_DIALOG_MSG_RenamePreSaveDiagram", (Object)this.getDrawingAreaControl().getDiagram().getName());
            switch (this.saveDiagram()) {
                case 2: {
                    return;
                }
                case 0: 
                case 1: {
                    this.getDrawingAreaControl().setIsDirty(true);
                    iResultCell.setContinue(false);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DiagramTopComponent.this.refreshPropertySet();
                        }
                    });
                }
            }
        }
    }

    public void onDrawingAreaPostPropertyChange(IProxyDiagram iProxyDiagram, int n, IResultCell iResultCell) {
        IDiagram iDiagram = this.getDrawingAreaControl().getDiagram();
        IDiagram iDiagram2 = iProxyDiagram.getDiagram();
        if (iDiagram2 != null && iDiagram2.isSame(iDiagram) && n == 1 && iProxyDiagram.getDiagram().isSame(this.getDrawingAreaControl().getDiagram())) {
            this.setName(iProxyDiagram.getName());
            this.setDisplayName(iProxyDiagram.getName());
        }
    }

    public void onDrawingAreaPostDrop(IDiagram iDiagram, IDrawingAreaDropContext iDrawingAreaDropContext, IResultCell iResultCell) {
    }

    public void onDrawingAreaPostCreated(IDrawingAreaControl iDrawingAreaControl, IResultCell iResultCell) {
    }

    public void onDrawingAreaOpened(IDiagram iDiagram, IResultCell iResultCell) {
    }

    public void onDrawingAreaKeyDown(IDiagram iDiagram, int n, boolean bl, boolean bl2, boolean bl3, IResultCell iResultCell) {
    }

    public void onDrawingAreaFileRemoved(String string, IResultCell iResultCell) {
    }

    public void onDrawingAreaClosed(IDiagram iDiagram, boolean bl, IResultCell iResultCell) {
    }

    public void onDrawingAreaActivated(IDiagram iDiagram, IResultCell iResultCell) {
    }

    public void onDrawingAreaCreateNode(IDiagram iDiagram, ICreateNodeContext iCreateNodeContext, IResultCell iResultCell) {
    }

    public void onDrawingAreaDraggingNode(IDiagram iDiagram, IDraggingNodeContext iDraggingNodeContext, IResultCell iResultCell) {
    }

    public void addSelectedActionCallbacks() {
        ((CallbackSystemAction)SystemAction.get(CopyAction.class)).setActionPerformer((ActionPerformer)new DiagramCopyCookie());
        ((CallbackSystemAction)SystemAction.get(CutAction.class)).setActionPerformer((ActionPerformer)new DiagramCutCookie());
        ((CallbackSystemAction)SystemAction.get(DeleteAction.class)).setActionPerformer((ActionPerformer)new DeletePerformer());
    }

    public void removeSelectedActionCallbacks() {
        ((CallbackSystemAction)SystemAction.get(CopyAction.class)).setActionPerformer(null);
        ((CallbackSystemAction)SystemAction.get(CutAction.class)).setActionPerformer(null);
        ((CallbackSystemAction)SystemAction.get(DeleteAction.class)).setActionPerformer(null);
    }

    public void addBasicActionCallbacks() {
        this.getActionMap().put("paste-from-clipboard", new DiagramPasteAction());
    }

    public void removeBasicActionCallbacks() {
        this.getActionMap().put("paste-from-clipboard", new DiagramPasteAction());
    }

    public Lookup getLookup() {
        Lookup lookup = super.getLookup();
        Lookup lookup2 = this.getThisLookup();
        return new ProxyLookup(new Lookup[]{lookup, lookup2});
    }

    public Lookup getThisLookup() {
        if (this.paletteContrl == null) {
            this.paletteContrl = this.getAssociatedPalette();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (this.mControl != null) {
            arrayList.add(this.mControl);
        }
        if (this.paletteContrl != null) {
            arrayList.add(this.paletteContrl);
        }
        if (this.getDiagramDO() != null) {
            arrayList.add((Object)this.getDiagramDO());
        }
        return Lookups.fixed((Object[])arrayList.toArray());
    }

    public boolean isListenersRegistered() {
        return this.listenersRegistered;
    }

    public void setListenersRegistered(boolean bl) {
        this.listenersRegistered = bl;
    }

    private SaveCookie getSaveCookie() {
        if (this.node == null) {
            return null;
        }
        Node.Cookie cookie = this.node.getCookie(SaveCookie.class);
        if (cookie != null) {
            return (SaveCookie)cookie;
        }
        return null;
    }

    private void setDiagramDisplayName(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiagramTopComponent.this.setDisplayName(string);
            }
        });
    }

    private class DiagramChangeListener
    implements PropertyChangeListener {
        private DiagramChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ADDrawingAreaControl.DIRTYSTATE)) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                DiagramDataObject diagramDataObject = DiagramTopComponent.this.getDiagramDO();
                if (!diagramDataObject.isValid()) {
                    return;
                }
                DiagramDataNode diagramDataNode = (DiagramDataNode)diagramDataObject.getNodeDelegate();
                if (bl) {
                    diagramDataObject.addSaveCookie();
                    diagramDataNode.setDisplayName(DiagramTopComponent.this.mControl.getNameWithAlias());
                    diagramDataNode.setValue("iconImage", DiagramTopComponent.this.mControl.getDiagramKind());
                    diagramDataNode.setIconBaseWithExtension(ImageUtil.instance().getDiagramTypeImageName(DiagramTopComponent.this.mControl.getDiagramKind()));
                    DiagramTopComponent.this.setDiagramDisplayName(DiagramTopComponent.this.mControl.getNameWithAlias() + DiagramTopComponent.SPACE_STAR);
                    DiagramTopComponent.this.addSaveCookie();
                    diagramDataObject.setModified(bl);
                } else {
                    diagramDataObject.removeSaveCookie();
                    diagramDataObject.setModified(bl);
                    diagramDataNode.setValue("iconImage", DiagramTopComponent.this.mControl.getDiagramKind());
                    diagramDataNode.setIconBaseWithExtension(ImageUtil.instance().getDiagramTypeImageName(DiagramTopComponent.this.mControl.getDiagramKind()));
                    diagramDataNode.setDisplayName(DiagramTopComponent.this.mControl.getNameWithAlias());
                    DiagramTopComponent.this.setDiagramDisplayName(DiagramTopComponent.this.mControl.getNameWithAlias());
                    DiagramTopComponent.this.removeSaveCookie();
                }
            } else if (propertyChangeEvent.getPropertyName().equals("modified") && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
                DiagramDataNode diagramDataNode = (DiagramDataNode)DiagramTopComponent.this.getDiagramDO().getNodeDelegate();
                diagramDataNode.setIconBaseWithExtension(ImageUtil.instance().getDiagramTypeImageName(DiagramTopComponent.this.mControl.getDiagramKind()));
                diagramDataNode.setDisplayName(DiagramTopComponent.this.mControl.getNameWithAlias());
                DiagramTopComponent.this.setDiagramDisplayName(DiagramTopComponent.this.mControl.getNameWithAlias());
                DiagramTopComponent.this.removeSaveCookie();
            }
        }
    }

    public class DiagramPasteAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DiagramTopComponent.this.mControl.paste();
        }
    }

    public class DeletePerformer
    implements ActionPerformer {
        public void performAction(SystemAction systemAction) {
            DiagramTopComponent.this.mControl.deleteSelected(true);
        }
    }

    public class DiagramCutCookie
    implements ActionPerformer {
        public void performAction(SystemAction systemAction) {
            DiagramTopComponent.this.mControl.cut();
        }
    }

    public class DiagramCopyCookie
    implements ActionPerformer {
        public void performAction(SystemAction systemAction) {
            DiagramTopComponent.this.mControl.copy();
        }
    }

    private class LocalUMLModelElementNode
    extends UMLModelElementNode {
        private DiagramPrintCookie printCookie;

        public LocalUMLModelElementNode() {
            this.addPrintCookie();
            if (DiagramTopComponent.this.mControl.getIsDirty()) {
                this.addSaveCookie();
            }
        }

        public void setName(String string) {
            this.setDisplayName(string);
            this.getData().setItemText(string);
        }

        public void addSaveCookie() {
            SaveCookie saveCookie = DiagramTopComponent.this.getDiagramDO().getCookie(SaveCookie.class);
            this.getCookieSet().add((Node.Cookie)saveCookie);
        }

        public void removeSaveCookie() {
            Node.Cookie cookie = this.getCookie(SaveCookie.class);
            if (cookie != null) {
                this.getCookieSet().remove(cookie);
            }
        }

        public DiagramPrintCookie getDiagramPrintCookie() {
            if (this.printCookie == null) {
                this.printCookie = new DiagramPrintCookie();
            }
            return this.printCookie;
        }

        public void addPrintCookie() {
            if (this.getCookieSet().getCookie(DiagramPrintCookie.class) == null) {
                this.getCookieSet().add((Node.Cookie)this.getDiagramPrintCookie());
            }
        }

        public void removePrintCookie() {
            this.getCookieSet().remove((Node.Cookie)this.getDiagramPrintCookie());
        }

        public boolean equals(Object object) {
            return ((Object)((Object)this)).hashCode() == object.hashCode();
        }
    }

    public class DiagramPrintCookie
    implements PrintCookie {
        public void print() {
            IProductDiagramManager iProductDiagramManager = ProductHelper.getProductDiagramManager();
            IDiagram iDiagram = DiagramTopComponent.this.getDrawingAreaControl().getDiagram();
            if (iDiagram != null) {
                iDiagram.printGraph(true);
            }
        }
    }
}

