/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.drawingarea.dataobject;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.drawingarea.dataobject.DiagramDataLoader;
import org.netbeans.modules.uml.drawingarea.dataobject.DiagramDataNode;
import org.netbeans.modules.uml.drawingarea.dataobject.DiagramEditorSupport;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.util.DummyCorePreference;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramDataObject
extends MultiDataObject {
    private transient DiagramEditorSupport diagramEditor;
    private transient OpenViewEdit openViewEdit;
    FileObject etldfo;
    FileObject etlpfo;
    static final long serialVersionUID = 1L;

    public DiagramDataObject(FileObject fileObject, FileObject fileObject2, DiagramDataLoader diagramDataLoader) throws DataObjectExistsException {
        super(fileObject2, (MultiFileLoader)diagramDataLoader);
        this.etlpfo = fileObject2;
        this.etldfo = fileObject;
        this.registerEntry(fileObject);
    }

    public void addSaveCookie() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)new Save());
    }

    public void removeSaveCookie() {
        SaveCookie saveCookie = this.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            CookieSet cookieSet = this.getCookieSet();
            cookieSet.remove((Node.Cookie)saveCookie);
        }
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        Object object;
        if (OpenCookie.class.equals(clazz) || ViewCookie.class.equals(clazz) || EditCookie.class.equals(clazz)) {
            if (this.openViewEdit == null) {
                this.openViewEdit = new OpenViewEdit();
            }
            object = (Node.Cookie)clazz.cast(this.openViewEdit);
        } else {
            object = clazz.isAssignableFrom(DiagramEditorSupport.class) ? this.getDiagramEditorSupport() : super.getCookie(clazz);
        }
        return (T)object;
    }

    public FileObject getDiagramFile() {
        return this.etldfo;
    }

    public boolean isReadOnly() {
        return !this.etlpfo.canWrite() || !this.etldfo.canWrite();
    }

    public synchronized DiagramEditorSupport getDiagramEditorSupport() {
        if (this.diagramEditor == null) {
            this.diagramEditor = new DiagramEditorSupport(this.getPrimaryEntry(), this, this.getCookieSet());
        }
        return this.diagramEditor;
    }

    public DiagramEditorSupport getDiagramEditor() {
        return this.getDiagramEditorSupport();
    }

    protected Node createNodeDelegate() {
        return new DiagramDataNode(this);
    }

    private class OpenViewEdit
    implements OpenCookie,
    ViewCookie,
    EditCookie {
        private OpenViewEdit() {
        }

        public void open() {
            DiagramDataObject.this.getDiagramEditorSupport().openDiagramEditor();
        }

        public void view() {
            DiagramDataObject.this.getDiagramEditorSupport().open();
        }

        public void edit() {
            if (NbPreferences.forModule(DummyCorePreference.class).getBoolean("UML_Open_Project_Diagrams", true)) {
                this.open();
            }
        }
    }

    private class Save
    implements SaveCookie {
        private Save() {
        }

        public void save() throws IOException {
            ICoreProduct iCoreProduct = ProductRetriever.retrieveProduct();
            Object var2_2 = null;
            IProduct iProduct = null;
            if (iCoreProduct instanceof IProduct) {
                iProduct = (IProduct)iCoreProduct;
                ETList eTList = iProduct.getDiagramManager().getOpenDiagrams();
                for (IProxyDiagram iProxyDiagram : eTList) {
                    File file = new File(iProxyDiagram.getFilename());
                    if ((DiagramDataObject.this.etldfo == null || !file.equals(FileUtil.toFile((FileObject)DiagramDataObject.this.etldfo))) && (DiagramDataObject.this.etlpfo == null || !file.equals(FileUtil.toFile((FileObject)DiagramDataObject.this.etlpfo)))) continue;
                    iProxyDiagram.getDiagram().save();
                }
            }
            DiagramDataObject.this.removeSaveCookie();
            DiagramDataObject.this.setModified(false);
        }
    }
}

