/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.compilers.DefaultCompilerProvider;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSet {
    public static final String None = "None";
    private CompilerFlavor flavor;
    private int id;
    private String name;
    private String displayName;
    private boolean autoGenerated;
    private boolean isDefault;
    private StringBuffer directory = new StringBuffer(256);
    private ArrayList<Tool> tools = new ArrayList();
    private String librarySearchOption;
    private String dynamicLibrarySearchOption;
    private String libraryOption;
    private CompilerProvider compilerProvider;
    private String driveLetterPrefix = "/";

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean bl) {
        this.autoGenerated = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setAsDefault(boolean bl) {
        this.isDefault = bl;
    }

    protected CompilerSet(CompilerFlavor compilerFlavor, String string, String string2) {
        this.addDirectory(string);
        this.compilerProvider = (CompilerProvider)Lookup.getDefault().lookup(CompilerProvider.class);
        if (this.compilerProvider == null) {
            this.compilerProvider = new DefaultCompilerProvider();
        }
        switch (compilerFlavor) {
            case Interix: {
                this.driveLetterPrefix = "/dev/fs/";
                break;
            }
            case Cygwin: {
                this.driveLetterPrefix = "/cygdrive/";
                break;
            }
            case MinGW: {
                this.driveLetterPrefix = "/";
                break;
            }
            case Sun: {
                compilerFlavor = CompilerSet.getBestSunStudioFlavor(compilerFlavor, string);
            }
        }
        if (string.length() > 0) {
            this.id = compilerFlavor.nextId();
        }
        this.name = string2 != null ? string2 : compilerFlavor.toString();
        this.displayName = this.mapNameToDisplayName(compilerFlavor, string.length() == 0);
        if (compilerFlavor.isSunCompiler()) {
            this.librarySearchOption = "-L";
            this.dynamicLibrarySearchOption = "-R";
            this.libraryOption = "-l";
        } else if (compilerFlavor.isGnuCompiler() && Utilities.getOperatingSystem() == 8) {
            this.librarySearchOption = "-L";
            this.dynamicLibrarySearchOption = "-R";
            this.libraryOption = "-l";
        } else if (compilerFlavor.isGnuCompiler()) {
            this.librarySearchOption = "-L";
            this.dynamicLibrarySearchOption = "-Wl,-rpath ";
            this.libraryOption = "-l";
        }
        this.flavor = compilerFlavor;
        this.setAutoGenerated(true);
        this.setAsDefault(false);
    }

    protected CompilerSet() {
        this.name = None;
        this.flavor = CompilerFlavor.Unknown;
        this.displayName = NbBundle.getMessage(CompilerSet.class, (String)"LBL_EmptyCompilerSetDisplayName");
        this.compilerProvider = (CompilerProvider)Lookup.getDefault().lookup(CompilerProvider.class);
        if (this.compilerProvider == null) {
            this.compilerProvider = new DefaultCompilerProvider();
        }
        this.setAutoGenerated(true);
        this.setAsDefault(false);
    }

    public CompilerSet createCopy() {
        CompilerSet compilerSet = new CompilerSet(this.flavor, this.getDirectory(), this.name);
        compilerSet.setAutoGenerated(this.isAutoGenerated());
        compilerSet.setAsDefault(this.isDefault());
        for (Tool tool : this.getTools()) {
            compilerSet.addTool(tool.createCopy());
        }
        return compilerSet;
    }

    public static CompilerSet getCompilerSet(String string) {
        CompilerSet compilerSet = CompilerSetManager.getDefault().getCompilerSet(CompilerFlavor.toFlavor(string));
        if (compilerSet == null) {
            CompilerFlavor compilerFlavor = CompilerFlavor.toFlavor(string);
            compilerFlavor = compilerFlavor == null ? CompilerFlavor.Unknown : compilerFlavor;
            compilerSet = new CompilerSet(compilerFlavor, "", null);
        }
        return compilerSet;
    }

    public static CompilerFlavor getCompilerSetFlavor(String string, String[] stringArray) {
        if (Utilities.isWindows()) {
            if (string.toLowerCase().indexOf("cygwin") != -1) {
                return CompilerFlavor.Cygwin;
            }
            if (string.toLowerCase().indexOf("mingw") != -1) {
                return CompilerFlavor.MinGW;
            }
            if (string.toLowerCase().indexOf("sfu") != -1 || string.toLowerCase().indexOf("sua") != -1) {
                return CompilerFlavor.Interix;
            }
        } else {
            if (CompilerSet.isSunCompilerDirectory(string)) {
                return CompilerSet.getBestSunStudioFlavor(CompilerFlavor.Sun, string);
            }
            if (CompilerSet.isSunUCBCompilerDirectory(string)) {
                return CompilerFlavor.SunUCB;
            }
            if (Utilities.getOperatingSystem() == 8 && (string.equals("/usr/bin") || string.equals("/bin"))) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals("cc") && !stringArray[i].equals("CC")) continue;
                    return CompilerSet.getBestSunStudioFlavor(CompilerFlavor.Sun, string);
                }
            }
        }
        for (String string2 : stringArray) {
            if (string2.indexOf("gcc") == -1 && string2.indexOf("g++") == -1) continue;
            return CompilerFlavor.GNU;
        }
        return CompilerFlavor.GNU;
    }

    public static CompilerSet getCustomCompilerSet(String string, CompilerFlavor compilerFlavor, String string2) {
        CompilerSet compilerSet = new CompilerSet(compilerFlavor, string, string2);
        compilerSet.setAutoGenerated(false);
        return compilerSet;
    }

    public static CompilerSet getCompilerSet(String string, String[] stringArray) {
        CompilerSet compilerSet = null;
        if (compilerSet != null) {
            return compilerSet;
        }
        String string2 = CompilerSet.getBase(string);
        if (string2.length() > 0 && compilerSet != null) {
            compilerSet.addDirectory(string);
            return compilerSet;
        }
        CompilerFlavor compilerFlavor = CompilerSet.getCompilerSetFlavor(string, stringArray);
        return new CompilerSet(compilerFlavor, string, null);
    }

    protected static CompilerSet createEmptyCompilerSet() {
        return new CompilerSet();
    }

    private String mapNameToDisplayName(CompilerFlavor compilerFlavor, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("LBL_");
        stringBuffer.append((Object)compilerFlavor);
        stringBuffer.append("CompilerSet_");
        stringBuffer.append("0");
        return NbBundle.getMessage(CompilerSet.class, (String)stringBuffer.toString(), (Object)this.id);
    }

    private static CompilerFlavor getBestSunStudioFlavor(CompilerFlavor compilerFlavor, String string) {
        String string2 = string.contains("/prod/bin") ? "/../../inventory" : "/../inventory";
        File file = new File(string + string2);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("v17")) {
                    return CompilerFlavor.Sun13;
                }
                if (stringArray[i].startsWith("v16")) {
                    return CompilerFlavor.Sun12;
                }
                if (stringArray[i].startsWith("v15")) {
                    return CompilerFlavor.Sun11;
                }
                if (stringArray[i].startsWith("v14")) {
                    return CompilerFlavor.Sun10;
                }
                if (stringArray[i].startsWith("v13")) {
                    return CompilerFlavor.Sun9;
                }
                if (!stringArray[i].startsWith("v12")) continue;
                return CompilerFlavor.Sun8;
            }
        }
        return compilerFlavor;
    }

    private static boolean isSunCompilerDirectory(String string) {
        if (string.indexOf("SUNWspro") != -1 || string.indexOf("/prod/bin") != -1) {
            return true;
        }
        File file = new File(string + "/../prod");
        return file.exists() && file.isDirectory();
    }

    private static boolean isSunUCBCompilerDirectory(String string) {
        return Utilities.getOperatingSystem() == 8 && string.equals("/usr/ucb");
    }

    protected int getID() {
        return this.id;
    }

    public boolean isGnuCompiler() {
        return this.flavor.isGnuCompiler();
    }

    public boolean isSunCompiler() {
        return this.flavor.isSunCompiler();
    }

    public boolean isSunUCBCompiler() {
        return this.flavor.isSunUCBCompiler();
    }

    private static String getBase(String string) {
        String string2 = "";
        if (string.toLowerCase().indexOf("sfu") != -1 || string.toLowerCase().indexOf("sua") != -1) {
            int n = string.indexOf("\\opt\\gcc");
            if (n != -1) {
                string2 = string.substring(0, n);
            } else if (string.endsWith("\\bin")) {
                string2 = string.substring(0, string.length() - 4);
            }
        }
        return string2;
    }

    public CompilerFlavor getCompilerFlavor() {
        return this.flavor;
    }

    public void setFlavor(CompilerFlavor compilerFlavor) {
        this.flavor = compilerFlavor;
    }

    public void addDirectory(String string) {
        if (this.directory.length() == 0) {
            this.directory.append(string);
        } else {
            this.directory.append(File.pathSeparator);
            this.directory.append(string);
        }
    }

    public String getDirectory() {
        return this.directory.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Tool addTool(String string, String string2, int n) {
        if (this.findTool(n) != null) {
            return null;
        }
        Tool tool = null;
        if (tool == null) {
            tool = this.compilerProvider.createCompiler(this.flavor, n, string, Tool.getToolDisplayName(n), string2);
        }
        if (!this.tools.contains(tool)) {
            this.tools.add(tool);
        }
        tool.setCompilerSet(this);
        return tool;
    }

    public void addTool(Tool tool) {
        this.tools.add(tool);
        tool.setCompilerSet(this);
    }

    public Tool addNewTool(String string, String string2, int n) {
        Tool tool = this.compilerProvider.createCompiler(this.flavor, n, string, Tool.getToolDisplayName(n), string2);
        this.tools.add(tool);
        tool.setCompilerSet(this);
        return tool;
    }

    public void removeTool(String string, String string2, int n) {
        for (Tool tool : this.tools) {
            if (!tool.getName().equals(string) || !tool.getPath().equals(string2) || tool.getKind() != n) continue;
            this.tools.remove(tool);
            tool.setCompilerSet(null);
            return;
        }
    }

    public void reparent(String string) {
        this.directory = new StringBuffer(256);
        this.addDirectory(string);
        this.tools.clear();
    }

    public Tool getTool(String string) {
        String string2 = null;
        if (Utilities.isWindows()) {
            string2 = string + ".exe";
        }
        for (Tool tool : this.tools) {
            if (!tool.getDisplayName().equals(string) && !tool.getName().equals(string) && (string2 == null || !tool.getName().equals(string2))) continue;
            return tool;
        }
        return null;
    }

    public Tool getTool(String string, int n) {
        String string2 = null;
        if (Utilities.isWindows()) {
            string2 = string + ".exe";
        }
        for (Tool tool : this.tools) {
            if (!tool.getDisplayName().equals(string) && !tool.getName().equals(string) && (string2 == null || !tool.getName().equals(string2)) || n != tool.getKind()) continue;
            return tool;
        }
        return this.compilerProvider.createCompiler(CompilerFlavor.Unknown, n, "", Tool.getToolDisplayName(n), "");
    }

    public Tool getTool(int n) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != n) continue;
            return tool;
        }
        Tool tool = this.compilerProvider.createCompiler(this.getCompilerFlavor(), n, "", Tool.getToolDisplayName(n), "");
        this.tools.add(tool);
        tool.setCompilerSet(this);
        return tool;
    }

    public Tool findTool(int n) {
        for (Tool tool : this.tools) {
            if (tool.getKind() != n) continue;
            return tool;
        }
        return null;
    }

    public boolean isValid() {
        Tool tool = this.getTool(Tool.CCompiler);
        Tool tool2 = this.getTool(Tool.CCCompiler);
        Tool tool3 = this.getTool(Tool.FortranCompiler);
        return tool != null && tool2 != null && (!CppSettings.getDefault().isFortranEnabled() || tool3 != null);
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public String getDynamicLibrarySearchOption() {
        return this.dynamicLibrarySearchOption;
    }

    public void setDynamicLibrarySearchOption(String string) {
        this.dynamicLibrarySearchOption = string;
    }

    public String getLibrarySearchOption() {
        return this.librarySearchOption;
    }

    public void setLibrarySearchOption(String string) {
        this.librarySearchOption = string;
    }

    public String getLibraryOption() {
        return this.libraryOption;
    }

    public void setLibraryOption(String string) {
        this.libraryOption = string;
    }

    public String getDriveLetterPrefix() {
        return this.driveLetterPrefix;
    }

    public String normalizeDriveLetter(String string) {
        if (string.length() > 1 && string.charAt(1) == ':') {
            return this.getDriveLetterPrefix() + string.charAt(0) + string.substring(2);
        }
        return string;
    }

    public String toString() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompilerFlavor {
        Sun13("SunStudio_13"),
        Sun12("SunStudio_12"),
        Sun11("SunStudio_11"),
        Sun10("SunStudio_10"),
        Sun9("SunStudio_9"),
        Sun8("SunStudio_8"),
        Sun("SunStudio"),
        SunUCB("SunUCB"),
        GNU("GNU"),
        Cygwin("Cygwin"),
        MinGW("MinGW"),
        DJGPP("DJGPP"),
        Interix("Interix"),
        Unknown("Unknown");

        private String sval;
        private int id;

        private CompilerFlavor(String string2) {
            this.sval = string2;
            this.id = 0;
        }

        protected int nextId() {
            return this.id++;
        }

        public boolean isGnuCompiler() {
            return this == GNU || this == Cygwin || this == MinGW || this == DJGPP || this == Interix;
        }

        public boolean isSunCompiler() {
            return this.isSunStudioCompiler() || this == SunUCB;
        }

        public boolean isSunStudioCompiler() {
            return this == Sun13 || this == Sun12 || this == Sun11 || this == Sun10 || this == Sun9 || this == Sun8 || this == Sun;
        }

        public boolean isSunUCBCompiler() {
            return this == SunUCB;
        }

        public static CompilerFlavor toFlavor(String string) {
            if (string != null) {
                if (string.equals("SunStudio")) {
                    return Sun;
                }
                if (string.equals("SunStudio_13")) {
                    return Sun13;
                }
                if (string.equals("SunStudio_12")) {
                    return Sun12;
                }
                if (string.equals("SunStudio_11")) {
                    return Sun11;
                }
                if (string.equals("SunStudio_10")) {
                    return Sun10;
                }
                if (string.equals("SunStudio_9")) {
                    return Sun9;
                }
                if (string.equals("SunStudio_8")) {
                    return Sun8;
                }
                if (string.equals("SunUCB")) {
                    return SunUCB;
                }
                if (string.equals("Cygwin")) {
                    return Cygwin;
                }
                if (string.equals("MinGW")) {
                    return MinGW;
                }
                if (string.equals("DJGPP")) {
                    return DJGPP;
                }
                if (string.equals("Interix")) {
                    return Interix;
                }
                if (string.equals("Unknown")) {
                    return GNU;
                }
            }
            return GNU;
        }

        public static String mapOldToNew(String string, int n) {
            if (n <= 43) {
                if (string.equals("Sun")) {
                    return "SunStudio";
                }
                if (string.equals("Sun12")) {
                    return "SunStudio_12";
                }
                if (string.equals("Sun11")) {
                    return "SunStudio_11";
                }
                if (string.equals("Sun10")) {
                    return "SunStudio_10";
                }
                if (string.equals("Sun9")) {
                    return "SunStudio_9";
                }
                if (string.equals("Sun8")) {
                    return "SunStudio_8";
                }
                if (string.equals("DJGPP")) {
                    return "GNU";
                }
                if (string.equals("Interix")) {
                    return "GNU";
                }
                if (string.equals("Unknown")) {
                    return "GNU";
                }
            }
            return string;
        }

        public static List getFlavors() {
            ArrayList<CompilerFlavor> arrayList = new ArrayList<CompilerFlavor>();
            arrayList.add(GNU);
            arrayList.add(Cygwin);
            arrayList.add(MinGW);
            arrayList.add(Sun13);
            arrayList.add(Sun12);
            arrayList.add(Sun11);
            arrayList.add(Sun10);
            arrayList.add(Sun9);
            arrayList.add(Sun8);
            arrayList.add(Sun);
            arrayList.add(SunUCB);
            return arrayList;
        }

        public String toString() {
            return this.sval;
        }
    }
}

