/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.NoCompilersPanel;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.compilers.DefaultCompilerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSetManager {
    private static final String gcc_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*gcc(([-.]\\d){2,4})?(\\.exe)?";
    private static final String gpp_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*g\\+\\+(([-.]\\d){2,4})?(\\.exe)?$";
    private static final String cc_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*cc(([-.]\\d){2,4})?(\\.exe)?$";
    private static final String CC_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*CC(([-.]\\d){2,4})?$";
    private static final String fortran_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*[fg](77|90|95|fortran)(([-.]\\d){2,4})?(\\.exe)?";
    private static final String make_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*([dg]make|make)(([-.]\\d){2,4})?(\\.exe)?$";
    private static final String debugger_pattern = "([a-zA-z][a-zA-Z0-9_]*-)*(gdb|dbx)(([-.]\\d){2,4})?(\\.exe)?$";
    public static final int SUN_COMPILER_SET = 0;
    public static final int GNU_COMPILER_SET = 1;
    public static final String Sun12 = "Sun12";
    public static final String Sun11 = "Sun11";
    public static final String Sun10 = "Sun10";
    public static final String Sun = "Sun";
    public static final String GNU = "GNU";
    private static CompilerFilenameFilter gcc_filter;
    private static CompilerFilenameFilter gpp_filter;
    private static CompilerFilenameFilter cc_filter;
    private static CompilerFilenameFilter CC_filter;
    private static CompilerFilenameFilter fortran_filter;
    private static CompilerFilenameFilter make_filter;
    private static CompilerFilenameFilter debugger_filter;
    private ArrayList<CompilerSet> sets = new ArrayList();
    private static CompilerSetManager instance;
    private static String NO_SETS;
    private static String SET_NAME;
    private static String SET_FLAVOR;
    private static String SET_DIRECTORY;
    private static String SET_AUTO;
    private static String NO_TOOLS;
    private static String TOOL_NAME;
    private static String TOOL_DISPLAYNAME;
    private static String TOOL_KIND;
    private static String TOOL_PATH;
    private static String TOOL_FLAVOR;
    private static CompilerProvider compilerProvider;

    public CompilerSetManager() {
        this.initCompilerFilters();
        this.initCompilerSets(Path.getPath());
    }

    public CompilerSetManager(ArrayList<CompilerSet> arrayList) {
        this.sets = arrayList;
    }

    public CompilerSetManager deepCopy() {
        CompilerSetManager compilerSetManager = new CompilerSetManager(new ArrayList<CompilerSet>());
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            compilerSetManager.add(compilerSet.createCopy());
        }
        return compilerSetManager;
    }

    public static CompilerSetManager getDefault() {
        return CompilerSetManager.getDefault(true);
    }

    public static synchronized CompilerSetManager getDefault(boolean bl) {
        if (instance == null && bl && (instance = CompilerSetManager.restoreFromDisk()) == null) {
            instance = new CompilerSetManager();
            if (instance.getCompilerSets().size() > 0 && instance.getCompilerSets().get(0).getName() != "None") {
                instance.saveToDisk();
            } else {
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new NoCompilersPanel(), CompilerSetManager.getString("NO_COMPILERS_FOUND_TITLE"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            }
        }
        if (instance != null && instance.getCompilerSets().size() == 0) {
            instance.add(CompilerSet.createEmptyCompilerSet());
        }
        return instance;
    }

    public static synchronized void setDefault(CompilerSetManager compilerSetManager) {
        if (compilerSetManager.getCompilerSets().size() == 0) {
            compilerSetManager.add(CompilerSet.createEmptyCompilerSet());
        }
        instance = compilerSetManager;
    }

    public String getUniqueCompilerSetName(String string) {
        int n = 0;
        String string2 = string;
        while (this.getCompilerSet(string2 = string + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        return string2;
    }

    public void initCompilerSets(ArrayList<String> arrayList) {
        HashSet<CompilerSet.CompilerFlavor> hashSet = new HashSet<CompilerSet.CompilerFlavor>();
        for (String string : arrayList) {
            CompilerSet.CompilerFlavor compilerFlavor;
            File file = new File(string);
            if (!file.isDirectory() || !this.isACompilerSetFolder(file)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (new File(file, "cc").exists()) {
                arrayList2.add("cc");
            }
            if (new File(file, "gcc").exists()) {
                arrayList2.add("gcc");
            }
            if (hashSet.contains((Object)(compilerFlavor = CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), arrayList2.toArray(new String[arrayList2.size()]))))) continue;
            hashSet.add(compilerFlavor);
            CompilerSet compilerSet = null;
            if (string.contains("msys") && (compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.MinGW)) != null) {
                this.initCompilerSet(string, compilerSet);
            }
            if (compilerSet != null) continue;
            compilerSet = CompilerSet.getCustomCompilerSet(file.getAbsolutePath(), compilerFlavor, compilerFlavor.toString());
            compilerSet.setAutoGenerated(true);
            this.initCompilerSet(string, compilerSet);
            this.add(compilerSet);
        }
        this.completeCompilerSets();
    }

    public void initCompilerSet(CompilerSet compilerSet) {
        this.initCompilerSet(compilerSet.getDirectory(), compilerSet);
        CompilerSetManager.completeCompilerSet(compilerSet);
    }

    public void reInitCompilerSet(CompilerSet compilerSet, String string) {
        compilerSet.reparent(string);
        this.initCompilerSet(compilerSet);
    }

    private void initCompilerSet(String string, CompilerSet compilerSet) {
        this.initCompiler(gcc_filter, "gcc", Tool.CCompiler, string, compilerSet);
        this.initCompiler(gpp_filter, "g++", Tool.CCCompiler, string, compilerSet);
        this.initCompiler(cc_filter, "cc", Tool.CCompiler, string, compilerSet);
        this.initFortranCompiler(fortran_filter, Tool.FortranCompiler, string, compilerSet);
        if (Utilities.isUnix()) {
            this.initCompiler(CC_filter, "CC", Tool.CCCompiler, string, compilerSet);
        }
        this.initMakeTool(make_filter, Tool.MakeTool, string, compilerSet);
        this.initDebuggerTool(debugger_filter, Tool.DebuggerTool, string, compilerSet);
    }

    private boolean isACompilerSetFolder(File file) {
        String[] stringArray = new String[]{"gcc", "g++", "cc", "CC"};
        if (file.getPath().contains("msys") && new File(file, "make.exe").exists()) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!new File(file, stringArray[i]).exists() && !new File(file, stringArray[i] + ".exe").exists()) continue;
            return true;
        }
        return false;
    }

    private void initCompiler(CompilerFilenameFilter compilerFilenameFilter, String string, int n, String string2, CompilerSet compilerSet) {
        File file = new File(string2);
        String[] stringArray = file.list(compilerFilenameFilter);
        if (stringArray != null && stringArray.length > 0) {
            if (compilerSet == null) {
                CompilerSet.CompilerFlavor object = CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), stringArray);
                compilerSet = this.getCompilerSet(object);
                if (compilerSet != null && !compilerSet.getDirectory().equals(string2)) {
                    return;
                }
                compilerSet = CompilerSet.getCompilerSet(file.getAbsolutePath(), stringArray);
                this.add(compilerSet);
                if (compilerSet.findTool(n) != null) {
                    return;
                }
            }
            for (String string3 : stringArray) {
                File file2 = new File(file, string3);
                if (!file2.exists() || file2.isDirectory() || !string3.equals(string) && !string3.equals(string + ".exe")) continue;
                compilerSet.addTool(string3, string2, n);
                break;
            }
        }
    }

    private void initFortranCompiler(CompilerFilenameFilter compilerFilenameFilter, int n, String string, CompilerSet compilerSet) {
        File file = new File(string);
        String[] stringArray = file.list(compilerFilenameFilter);
        String[] stringArray2 = new String[]{"gfortran", "g95", "g90", "g77", "ffortran", "f95", "f90", "f77"};
        if (stringArray != null && stringArray.length > 0) {
            if (compilerSet == null) {
                CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), stringArray);
                compilerSet = this.getCompilerSet(compilerFlavor);
                if (compilerSet != null && !compilerSet.getDirectory().equals(string)) {
                    return;
                }
                compilerSet = CompilerSet.getCompilerSet(file.getAbsolutePath(), stringArray);
                this.add(compilerSet);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                String string2 = stringArray2[i];
                if (Utilities.isWindows()) {
                    string2 = string2 + ".exe";
                }
                if (!new File(file, string2).exists() || new File(file, string2).isDirectory()) continue;
                compilerSet.addTool(string2, string, n);
                return;
            }
        }
    }

    private void initMakeTool(CompilerFilenameFilter compilerFilenameFilter, int n, String string, CompilerSet compilerSet) {
        File file = new File(string);
        String[] stringArray = file.list(compilerFilenameFilter);
        String[] stringArray2 = new String[]{"dmake", "gmake", "make"};
        if (stringArray != null && stringArray.length > 0) {
            if (compilerSet == null) {
                compilerSet = null;
                if (string.contains("msys")) {
                    compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.MinGW);
                }
                if (compilerSet == null) {
                    CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), stringArray);
                    compilerSet = this.getCompilerSet(compilerFlavor);
                    if (compilerSet != null && !compilerSet.getDirectory().equals(string)) {
                        return;
                    }
                    compilerSet = CompilerSet.getCompilerSet(file.getAbsolutePath(), stringArray);
                    this.add(compilerSet);
                }
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                String string2 = stringArray2[i];
                if (Utilities.isWindows()) {
                    string2 = string2 + ".exe";
                }
                if (!new File(file, string2).exists() || new File(file, string2).isDirectory()) continue;
                compilerSet.addTool(string2, string, n);
                return;
            }
        }
    }

    private void initDebuggerTool(CompilerFilenameFilter compilerFilenameFilter, int n, String string, CompilerSet compilerSet) {
        File file = new File(string);
        String[] stringArray = file.list(compilerFilenameFilter);
        String[] stringArray2 = IpeUtils.isGdbEnabled() ? new String[]{"gdb"} : new String[]{"dbx"};
        if (stringArray != null && stringArray.length > 0) {
            if (compilerSet == null) {
                CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), stringArray);
                compilerSet = this.getCompilerSet(compilerFlavor);
                if (compilerSet != null && !compilerSet.getDirectory().equals(string)) {
                    return;
                }
                compilerSet = CompilerSet.getCompilerSet(file.getAbsolutePath(), stringArray);
                this.add(compilerSet);
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                String string2 = stringArray2[i];
                if (Utilities.isWindows()) {
                    string2 = string2 + ".exe";
                }
                if (!new File(file, string2).exists() || new File(file, string2).isDirectory()) continue;
                compilerSet.addTool(string2, string, n);
                return;
            }
        }
    }

    private void completeCompilerSets() {
        CompilerSet compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.Sun);
        if (compilerSet == null) {
            compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.Sun12);
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.Sun11);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.Sun10);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.Sun9);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(CompilerSet.CompilerFlavor.Sun8);
            }
            if (compilerSet != null) {
                compilerSet = compilerSet.createCopy();
                compilerSet.setName(CompilerSet.CompilerFlavor.Sun.toString());
                compilerSet.setFlavor(CompilerSet.CompilerFlavor.Sun);
                compilerSet.setAsDefault(false);
                compilerSet.setAutoGenerated(true);
                this.add(compilerSet);
            }
        }
        for (CompilerSet compilerSet2 : this.sets) {
            CompilerSetManager.completeCompilerSet(compilerSet2);
        }
        if (this.sets.size() == 0) {
            this.add(CompilerSet.createEmptyCompilerSet());
        }
    }

    private static void completeCompilerSet(CompilerSet compilerSet) {
        String string;
        if (compilerSet.getTool(Tool.CCompiler) == null) {
            compilerSet.addTool("", "", Tool.CCompiler);
        }
        if (compilerSet.getTool(Tool.CCCompiler) == null) {
            compilerSet.addTool("", "", Tool.CCCompiler);
        }
        if (compilerSet.getTool(Tool.FortranCompiler) == null) {
            compilerSet.addTool("", "", Tool.FortranCompiler);
        }
        if (compilerSet.findTool(Tool.MakeTool) == null && (string = Path.findCommand("make")) != null) {
            compilerSet.addNewTool(IpeUtils.getBaseName(string), IpeUtils.getDirName(string), Tool.MakeTool);
        }
        if (compilerSet.getTool(Tool.MakeTool) == null) {
            compilerSet.addTool("", "", Tool.MakeTool);
        }
        if (compilerSet.findTool(Tool.DebuggerTool) == null && (string = IpeUtils.isGdbEnabled() ? Path.findCommand("gdb") : Path.findCommand("dbx")) != null) {
            compilerSet.addNewTool(IpeUtils.getBaseName(string), IpeUtils.getDirName(string), Tool.DebuggerTool);
        }
        if (compilerSet.getTool(Tool.DebuggerTool) == null) {
            compilerSet.addTool("", "", Tool.DebuggerTool);
        }
    }

    private void initCompilerFilters() {
        gcc_filter = new CompilerFilenameFilter(gcc_pattern);
        gpp_filter = new CompilerFilenameFilter(gpp_pattern);
        cc_filter = new CompilerFilenameFilter(cc_pattern);
        fortran_filter = new CompilerFilenameFilter(fortran_pattern);
        if (Utilities.isUnix()) {
            CC_filter = new CompilerFilenameFilter(CC_pattern);
        }
        make_filter = new CompilerFilenameFilter(make_pattern);
        debugger_filter = new CompilerFilenameFilter(debugger_pattern);
    }

    public void add(CompilerSet compilerSet) {
        if (this.sets.size() == 1 && this.sets.get(0).getName() == "None") {
            this.sets.remove(0);
        }
        this.sets.add(compilerSet);
        if (this.sets.size() == 1) {
            this.setDefault(compilerSet);
        }
    }

    public void remove(CompilerSet compilerSet) {
        if (this.sets.contains(compilerSet)) {
            this.sets.remove(compilerSet);
        }
    }

    public CompilerSet getCompilerSet(CompilerSet.CompilerFlavor compilerFlavor) {
        return this.getCompilerSet(compilerFlavor.toString());
    }

    public CompilerSet getCompilerSet(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByDisplayName(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDisplayName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByPath(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDirectory().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(String string, String string2) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string) || !compilerSet.getDisplayName().equals(string2)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(int n) {
        if (n >= 0 && n < this.sets.size()) {
            return this.sets.get(n);
        }
        return null;
    }

    public List<CompilerSet> getCompilerSets() {
        return this.sets;
    }

    public List<String> getCompilerSetDisplayNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getDisplayName());
        }
        return arrayList;
    }

    public List<String> getCompilerSetNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getName());
        }
        return arrayList;
    }

    public void setDefault(CompilerSet compilerSet) {
        boolean bl = false;
        for (CompilerSet compilerSet2 : this.getCompilerSets()) {
            compilerSet2.setAsDefault(false);
            if (compilerSet2 != compilerSet) continue;
            compilerSet.setAsDefault(true);
            bl = true;
        }
        if (!bl && this.sets.size() > 0) {
            this.getCompilerSet(0).setAsDefault(true);
        }
    }

    public CompilerSet getDefaultCompilerSet() {
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            if (!compilerSet.isDefault()) continue;
            return compilerSet;
        }
        return null;
    }

    protected boolean isGdbEnabled() {
        for (ModuleInfo moduleInfo : Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class)).allInstances()) {
            if (!moduleInfo.getCodeNameBase().equals("org.netbeans.modules.cnd.debugger.gdb") || !moduleInfo.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(CompilerSetManager.class);
    }

    public void saveToDisk() {
        CompilerSetManager.getPreferences().putInt(NO_SETS, this.sets.size());
        int n = 0;
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            CompilerSetManager.getPreferences().put(SET_NAME + '.' + n, compilerSet.getName());
            CompilerSetManager.getPreferences().put(SET_FLAVOR + '.' + n, compilerSet.getCompilerFlavor().toString());
            CompilerSetManager.getPreferences().put(SET_DIRECTORY + '.' + n, compilerSet.getDirectory());
            CompilerSetManager.getPreferences().putBoolean(SET_AUTO + '.' + n, compilerSet.isAutoGenerated());
            List<Tool> list = compilerSet.getTools();
            CompilerSetManager.getPreferences().putInt(NO_TOOLS + '.' + n, list.size());
            int n2 = 0;
            for (Tool tool : list) {
                CompilerSetManager.getPreferences().put(TOOL_NAME + '.' + n + '.' + n2, tool.getName());
                CompilerSetManager.getPreferences().put(TOOL_DISPLAYNAME + '-' + n + '.' + n2, tool.getDisplayName());
                CompilerSetManager.getPreferences().putInt(TOOL_KIND + '.' + n + '.' + n2, tool.getKind());
                CompilerSetManager.getPreferences().put(TOOL_PATH + '.' + n + '.' + n2, tool.getPath());
                CompilerSetManager.getPreferences().put(TOOL_FLAVOR + '.' + n + '.' + n2, tool.getFlavor().toString());
                ++n2;
            }
            ++n;
        }
    }

    private static CompilerProvider getCompilerProvider() {
        if (compilerProvider == null) {
            compilerProvider = (CompilerProvider)Lookup.getDefault().lookup(CompilerProvider.class);
        }
        if (compilerProvider == null) {
            compilerProvider = new DefaultCompilerProvider();
        }
        return compilerProvider;
    }

    public static CompilerSetManager restoreFromDisk() {
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        int n = CompilerSetManager.getPreferences().getInt(NO_SETS, -1);
        if (n < 0) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            String string = CompilerSetManager.getPreferences().get(SET_NAME + '.' + i, null);
            String string2 = CompilerSetManager.getPreferences().get(SET_FLAVOR + '.' + i, null);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string2 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string2);
            }
            String string3 = CompilerSetManager.getPreferences().get(SET_DIRECTORY + '.' + i, null);
            if (string == null || string2 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetManager.getPreferences().getBoolean(SET_AUTO + '.' + i, false);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string3, string);
            compilerSet.setAutoGenerated(bl);
            int n2 = CompilerSetManager.getPreferences().getInt(NO_TOOLS + '.' + i, -1);
            for (int j = 0; j < n2; ++j) {
                String string4 = CompilerSetManager.getPreferences().get(TOOL_NAME + '.' + i + '.' + j, null);
                String string5 = CompilerSetManager.getPreferences().get(TOOL_DISPLAYNAME + '-' + i + '.' + j, null);
                int n3 = CompilerSetManager.getPreferences().getInt(TOOL_KIND + '.' + i + '.' + j, -1);
                String string6 = CompilerSetManager.getPreferences().get(TOOL_PATH + '.' + i + '.' + j, null);
                String string7 = CompilerSetManager.getPreferences().get(TOOL_FLAVOR + '.' + i + '.' + j, null);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string7 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string7);
                }
                Tool tool = CompilerSetManager.getCompilerProvider().createCompiler(compilerFlavor2, n3, "", string5, string6);
                tool.setName(string4);
                compilerSet.addTool(tool);
            }
            CompilerSetManager.completeCompilerSet(compilerSet);
            arrayList.add(compilerSet);
        }
        return new CompilerSetManager(arrayList);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CompilerSetManager.class, (String)string);
    }

    static {
        instance = null;
        NO_SETS = "csm.noOfSets";
        SET_NAME = "csm.setName";
        SET_FLAVOR = "csm.setFlavor";
        SET_DIRECTORY = "csm.setDirectory";
        SET_AUTO = "csm.autoGenerated";
        NO_TOOLS = "csm.noOfTools";
        TOOL_NAME = "csm.toolName";
        TOOL_DISPLAYNAME = "csm.toolDisplayName";
        TOOL_KIND = "csm.toolKind";
        TOOL_PATH = "csm.toolPath";
        TOOL_FLAVOR = "csm.toolFlavor";
        compilerProvider = null;
    }

    private class CompilerFilenameFilter
    implements FilenameFilter {
        Pattern pc = null;

        public CompilerFilenameFilter(String string) {
            try {
                this.pc = Pattern.compile(string);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }

        public boolean accept(File file, String string) {
            return this.pc != null && this.pc.matcher(string).matches();
        }
    }
}

