/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.api.utils.IpeFileSystemView;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.UnixRE;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public abstract class EnterItemsPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = 5260017369797781413L;
    private JLabel entryLabel;
    private JTextField entryText;
    private JButton entryChooser;
    private JButton addBtn;
    private JButton changeBtn;
    private JButton removeBtn;
    private JButton upArrow;
    private JButton downArrow;
    private JList list;
    protected JFileChooser fc;
    private boolean expandDirs;
    private boolean dirChooser;
    private boolean mspFilter;
    private boolean dynamicNext;
    private boolean dynamicLast;
    private boolean itemsRequired;
    private boolean addBeginning;
    private HashSet filters;
    private File lastChooserDir = null;
    protected static final int EXPAND_DIRS = 1;
    protected static final int DIR_CHOOSER = 2;
    protected static final int MSP_FILTER = 4;
    protected static final int DYNAMIC_DEFAULT_BUTTONS = 8;
    protected static final int DYNAMIC_LAST_BUTTON = 16;
    protected static final int ITEMS_REQUIRED = 32;
    protected static final int ADD_BEGINNING = 64;
    private JButton nextButton = null;
    private static boolean lastEnabled;

    public EnterItemsPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        lastEnabled = false;
    }

    protected void create(String string, char c, int n) {
        boolean bl = false;
        this.expandDirs = (n & 1) == 1;
        this.dirChooser = (n & 2) == 2;
        this.mspFilter = (n & 4) == 4;
        this.dynamicNext = (n & 8) == 8;
        this.dynamicLast = (n & 0x10) == 16;
        this.itemsRequired = (n & 0x20) == 32;
        this.addBeginning = (n & 0x40) == 64;
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.dynamicNext) {
            this.nextButton = MakefileWizard.getMakefileWizard().getNextButton();
        }
        this.setLayout(new GridBagLayout());
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.createTextPanel(string, c), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.createButtonRow1(), gridBagConstraints);
        JLabel jLabel = new JLabel(this.getListLabel());
        jLabel.setDisplayedMnemonic(this.getListMnemonic());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.list = new JList(new DefaultListModel());
        jLabel.setLabelFor(this.list);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)this.createButtonRow2(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.setupListeners();
    }

    void addComponent(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        this.add((Component)jComponent, gridBagConstraints);
    }

    protected String getListLabel() {
        return this.getString("LBL_ListLabel");
    }

    protected char getListMnemonic() {
        return this.getString("MNEM_ListLabel").charAt(0);
    }

    private JPanel createTextPanel(String string, char c) {
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String string2 = stringTokenizer.nextToken();
        this.entryLabel = new JLabel(string2);
        this.entryLabel.setDisplayedMnemonic(c);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.entryLabel, gridBagConstraints);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            gridBagConstraints.gridy = n++;
            jPanel.add((Component)new JLabel(string2), gridBagConstraints);
        }
        this.entryText = new JTextField();
        this.entryLabel.setLabelFor(this.entryText);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.entryText, gridBagConstraints);
        this.entryChooser = new JButton(this.getString("BTN_Chooser"));
        this.entryChooser.setMnemonic(this.getString("MNEM_Chooser").charAt(0));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.entryChooser, gridBagConstraints);
        this.createChooser(this.entryChooser);
        return jPanel;
    }

    private JPanel createButtonRow1() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.addBtn = new JButton(this.getString("BTN_Add"));
        this.addBtn.setMnemonic(this.getString("MNEM_Add").charAt(0));
        this.addBtn.setEnabled(false);
        jPanel.add(this.addBtn);
        this.changeBtn = new JButton(this.getString("BTN_Change"));
        this.changeBtn.setMnemonic(this.getString("MNEM_Change").charAt(0));
        this.changeBtn.setEnabled(false);
        jPanel.add(this.changeBtn);
        return jPanel;
    }

    private JPanel createButtonRow2() {
        JPanel jPanel = new JPanel(new GridLayout(1, 3, 6, 0));
        this.removeBtn = new JButton(this.getString("BTN_Remove"));
        this.removeBtn.setMnemonic(this.getString("MNEM_Remove").charAt(0));
        this.removeBtn.setEnabled(false);
        jPanel.add(this.removeBtn);
        this.upArrow = new JButton(this.getString("BTN_Up"));
        this.upArrow.setMnemonic(this.getString("MNEM_Up").charAt(0));
        this.upArrow.setEnabled(false);
        jPanel.add(this.upArrow);
        this.downArrow = new JButton(this.getString("BTN_Down"));
        this.downArrow.setMnemonic(this.getString("MNEM_Down").charAt(0));
        this.downArrow.setEnabled(false);
        jPanel.add(this.downArrow);
        return jPanel;
    }

    public JList getList() {
        return this.list;
    }

    public String[] getListItems() {
        Object[] objectArray = ((DefaultListModel)this.list.getModel()).toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString().trim();
        }
        return stringArray;
    }

    private Object[] expandFileList(String string) {
        LinkedList linkedList;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        LinkedList<ListItem> linkedList2 = new LinkedList<ListItem>();
        TokType tokType = new TokType();
        boolean bl = false;
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            object = this.validateInput(stringTokenizer.nextToken());
            if (object == null) continue;
            if (((String)object).startsWith("$(")) {
                int n2 = 1;
                int n3 = 2;
                while (n2 > 0) {
                    for (int i = n3; i < ((String)object).length(); ++i) {
                        if (((String)object).charAt(i) == '(') {
                            ++n2;
                        }
                        if (((String)object).charAt(i) == ')') {
                            --n2;
                        }
                        if (n2 <= 0) break;
                    }
                    if (n2 <= 0) continue;
                    if (!stringTokenizer.hasMoreTokens()) break;
                    n3 = ((String)object).length() + 1;
                    object = (String)object + " " + stringTokenizer.nextToken();
                }
            }
            linkedList = this.expandToken((String)object, tokType);
            ++n;
            if (linkedList.size() == 0) {
                if (tokType.isRE()) continue;
                linkedList2.add(new ListItem((String)object, false));
                bl = true;
                continue;
            }
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                ListItem listItem = (ListItem)listIterator.next();
                File file = new File(listItem.getName());
                if (this.expandDirs && file.isDirectory()) {
                    LinkedList linkedList3 = this.processDirectory((String)object, file);
                    if (linkedList3 != null) {
                        linkedList2.addAll(linkedList3);
                        continue;
                    }
                    --n;
                    continue;
                }
                linkedList2.add(new ListItem(file.getAbsolutePath(), file.exists()));
            }
        }
        if (this.checkErrorConditions(n, linkedList2, bl)) {
            object = this.getErrorInfo();
            linkedList = new NotifyDescriptor((Object)((ErrorInfo)object).getMsg(), ((ErrorInfo)object).getTitle(), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)linkedList);
        }
        return linkedList2.toArray(new ListItem[linkedList2.size()]);
    }

    protected boolean checkErrorConditions(int n, LinkedList linkedList, boolean bl) {
        return n == 1 && (linkedList.size() == 0 || bl);
    }

    protected abstract ErrorInfo getErrorInfo();

    private LinkedList expandToken(String string, TokType tokType) {
        LinkedList<ListItem> linkedList = new LinkedList<ListItem>();
        REParser rEParser = new REParser(string);
        String string2 = rEParser.getFirstComponent();
        String string3 = rEParser.getRegularExpression();
        String string4 = rEParser.getRemainder();
        if (string3 == null) {
            File file = new File(string2);
            tokType.setRE(false);
            if (file.exists()) {
                linkedList.add(new ListItem(file.getAbsolutePath(), file.exists()));
            }
        } else {
            tokType.setRE(true);
            LinkedList linkedList2 = this.processDir(string2, string3);
            TokType tokType2 = new TokType();
            if (linkedList2 != null) {
                if (string4 == null) {
                    linkedList.addAll(linkedList2);
                } else {
                    ListIterator listIterator = linkedList2.listIterator();
                    while (listIterator.hasNext()) {
                        ListItem listItem = (ListItem)listIterator.next();
                        StringBuffer stringBuffer = new StringBuffer(256);
                        stringBuffer.append(listItem.getName());
                        stringBuffer.append(File.separator);
                        stringBuffer.append(string4);
                        linkedList.addAll(this.expandToken(stringBuffer.toString(), tokType2));
                    }
                }
            }
        }
        return linkedList;
    }

    private LinkedList processDir(String string, String string2) {
        UnixRE unixRE;
        LinkedList<ListItem> linkedList = new LinkedList<ListItem>();
        File[] fileArray = this.getFileArray(new File(string));
        if (fileArray == null) {
            return null;
        }
        try {
            unixRE = new UnixRE(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                patternSyntaxException.printStackTrace();
            }
            return null;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string3 = fileArray[i].toString();
            if (!unixRE.match(string3)) continue;
            File file = new File(string3);
            linkedList.add(new ListItem(file.getAbsolutePath(), file.exists()));
        }
        return linkedList;
    }

    private File[] getFileArray(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        File[] fileArray2 = new File[fileArray.length + 2];
        fileArray2[0] = new File(".");
        fileArray2[1] = new File("..");
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray2[i + 2] = fileArray[i];
        }
        return fileArray2;
    }

    private LinkedList processDirectory(String string, File file) {
        String string2 = MessageFormat.format(this.getString("MSG_CREATE_SOURCE_DIRECTORY"), string);
        JButton jButton = new JButton(this.getString("BTN_Subdirs"));
        jButton.setMnemonic(this.getString("MNEM_Subdirs").charAt(0));
        JButton jButton2 = new JButton(this.getString("BTN_Dirs"));
        jButton2.setMnemonic(this.getString("MNEM_Dirs").charAt(0));
        JButton jButton3 = new JButton(this.getString("BTN_Cancel"));
        String string3 = this.getString("LBL_QUESTION_WINDOW");
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string2, string3, -1, 3, (Object[])new JButton[]{jButton, jButton2, jButton3}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (object instanceof JButton) {
            if (object.equals(jButton)) {
                return this.addDirectoryFiles(string, file, true);
            }
            if (object.equals(jButton2)) {
                return this.addDirectoryFiles(string, file, false);
            }
        }
        return null;
    }

    private LinkedList addDirectoryFiles(String string, File file, boolean bl) {
        LinkedList<ListItem> linkedList = new LinkedList<ListItem>();
        File[] fileArray = file.listFiles(new SrcsFileFilter());
        for (int i = 0; i < fileArray.length; ++i) {
            linkedList.add(new ListItem(string + File.separator + fileArray[i].getName(), true));
        }
        if (bl) {
            File[] fileArray2 = file.listFiles(new DirFilter());
            for (int i = 0; i < fileArray2.length; ++i) {
                linkedList.addAll(this.addDirectoryFiles(string + File.separator + fileArray2[i].getName(), fileArray2[i], true));
            }
        }
        return linkedList;
    }

    protected void addMultipleFiles(Object[] objectArray) {
        if (objectArray != null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            String string = this.getMakefileData().getBaseDirectory(true);
            for (int i = 0; i < objectArray.length; ++i) {
                String string2 = IpeUtils.getRelativePath(string, ((ListItem)objectArray[i]).getName());
                if (defaultListModel.contains(string2)) continue;
                if (this.addBeginning) {
                    defaultListModel.add(0, string2);
                    continue;
                }
                defaultListModel.addElement(string2);
            }
        }
    }

    protected void addMultipleFiles(File[] fileArray) {
        if (fileArray != null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
            String string = this.getMakefileData().getBaseDirectory(true);
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = IpeUtils.getRelativePath(string, fileArray[i].getPath());
                if (defaultListModel.contains(string2)) continue;
                if (this.addBeginning) {
                    defaultListModel.add(0, string2);
                    continue;
                }
                defaultListModel.addElement(string2);
            }
        }
    }

    protected String validateInput(String string) {
        return string;
    }

    protected void createChooser(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (EnterItemsPanel.this.fc == null) {
                    EnterItemsPanel.this.fc = new JFileChooser();
                    EnterItemsPanel.this.fc.setApproveButtonText(EnterItemsPanel.this.getString("BTN_Approve"));
                    EnterItemsPanel.this.fc.setMultiSelectionEnabled(true);
                    EnterItemsPanel.this.fc.setFileSystemView(new IpeFileSystemView(EnterItemsPanel.this.fc.getFileSystemView()));
                    if (EnterItemsPanel.this.mspFilter) {
                        EnterItemsPanel.this.fc.setFileFilter(new MspFileFilter());
                    }
                    if (EnterItemsPanel.this.dirChooser) {
                        EnterItemsPanel.this.fc.setFileSelectionMode(1);
                        EnterItemsPanel.this.fc.setDialogTitle(EnterItemsPanel.this.getString("TITLE_DirChooser"));
                    } else {
                        EnterItemsPanel.this.fc.setDialogTitle(EnterItemsPanel.this.getString("DLG_FILE_CHOOSER_TITLE"));
                    }
                }
                File file = null;
                String string = IpeUtils.expandPath(EnterItemsPanel.this.getText());
                if (string.length() > 0) {
                    file = new File(string);
                }
                if (file != null && file.isDirectory()) {
                    EnterItemsPanel.this.fc.setCurrentDirectory(file);
                } else if (EnterItemsPanel.this.lastChooserDir != null) {
                    EnterItemsPanel.this.fc.setCurrentDirectory(EnterItemsPanel.this.lastChooserDir);
                } else {
                    EnterItemsPanel.this.fc.setCurrentDirectory(new File(EnterItemsPanel.this.getMakefileData().getBaseDirectory(true)));
                }
                int n = EnterItemsPanel.this.fc.showDialog(EnterItemsPanel.this, null);
                if (n == 0) {
                    EnterItemsPanel.this.addMultipleFiles(EnterItemsPanel.this.fc.getSelectedFiles());
                    EnterItemsPanel.this.lastChooserDir = EnterItemsPanel.this.fc.getCurrentDirectory();
                    EnterItemsPanel.this.entryText.setText(null);
                    EnterItemsPanel.this.addBtn.setEnabled(false);
                }
            }
        });
    }

    public JTextField getEntryText() {
        return this.entryText;
    }

    private String getText() {
        return IpeUtils.expandPath(this.entryText.getText());
    }

    public boolean isPanelValid() {
        return !this.itemsRequired || this.list.getModel().getSize() != 0;
    }

    public void addNotify() {
        super.addNotify();
        this.removeBtn.setEnabled(false);
        this.upArrow.setEnabled(false);
        this.downArrow.setEnabled(false);
        if (this.itemsRequired && this.list.getModel().getSize() == 0) {
            this.nextButton.setEnabled(false);
        }
        if (this.dynamicNext && this.entryText.getDocument().getLength() > 0) {
            this.addBtn.setEnabled(true);
            IpeUtils.setDefaultButton(this.getRootPane(), this.addBtn);
        }
        this.entryText.selectAll();
        IpeUtils.requestFocus(this.entryText);
    }

    public void removeNotify() {
        Container container;
        super.removeNotify();
        if (this.dynamicNext || this.itemsRequired) {
            this.nextButton.setEnabled(true);
            this.getRootPane().setDefaultButton(this.nextButton);
        }
        if (this.fc != null && this.fc.isShowing() && (container = this.fc.getTopLevelAncestor()) != null && container instanceof JDialog) {
            ((JDialog)container).dispose();
        }
    }

    private void setupListeners() {
        final DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        this.entryText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getDocument().getLength() >= 1) {
                    EnterItemsPanel.this.addBtn.setEnabled(true);
                    if (EnterItemsPanel.this.dynamicNext) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.addBtn);
                    }
                }
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getDocument().getLength() >= 1) {
                    EnterItemsPanel.this.addBtn.setEnabled(true);
                    if (EnterItemsPanel.this.dynamicNext && EnterItemsPanel.this.list.getModel().getSize() == 0) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.addBtn);
                    }
                    int n = EnterItemsPanel.this.list.getMinSelectionIndex();
                    int n2 = EnterItemsPanel.this.list.getMaxSelectionIndex();
                    if (n >= 0 && n2 >= 0 && n == n2) {
                        EnterItemsPanel.this.changeBtn.setEnabled(true);
                    }
                }
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getDocument().getLength() == 0) {
                    EnterItemsPanel.this.addBtn.setEnabled(false);
                    EnterItemsPanel.this.changeBtn.setEnabled(false);
                    if (EnterItemsPanel.this.dynamicNext) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.nextButton);
                    }
                }
            }
        });
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnterItemsPanel.this.addMultipleFiles(EnterItemsPanel.this.expandFileList(EnterItemsPanel.this.getText()));
                EnterItemsPanel.this.list.clearSelection();
                EnterItemsPanel.this.entryText.setText(null);
                EnterItemsPanel.this.addBtn.setEnabled(false);
                EnterItemsPanel.this.changeBtn.setEnabled(false);
                if (EnterItemsPanel.this.dynamicNext && !EnterItemsPanel.this.itemsRequired || EnterItemsPanel.this.itemsRequired && defaultListModel.getSize() > 0) {
                    EnterItemsPanel.this.nextButton.setEnabled(true);
                    EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.nextButton);
                }
            }
        });
        this.changeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                defaultListModel.set(EnterItemsPanel.this.list.getMinSelectionIndex(), EnterItemsPanel.this.getText());
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = EnterItemsPanel.this.list.getMinSelectionIndex();
                int[] nArray = EnterItemsPanel.this.list.getSelectedIndices();
                for (n = nArray.length; n > 0; --n) {
                    defaultListModel.remove(nArray[n - 1]);
                }
                int n3 = n = n2 >= EnterItemsPanel.this.list.getModel().getSize() ? n2 - 1 : n2;
                if (n >= 0) {
                    EnterItemsPanel.this.list.ensureIndexIsVisible(n);
                    EnterItemsPanel.this.list.setSelectedIndex(n);
                    EnterItemsPanel.this.removeBtn.setEnabled(true);
                    EnterItemsPanel.this.changeBtn.setEnabled(true);
                    EnterItemsPanel.this.upArrow.setEnabled(n > 0);
                    EnterItemsPanel.this.downArrow.setEnabled(n < EnterItemsPanel.this.list.getModel().getSize() - 1);
                } else {
                    EnterItemsPanel.this.removeBtn.setEnabled(false);
                    EnterItemsPanel.this.changeBtn.setEnabled(false);
                    EnterItemsPanel.this.upArrow.setEnabled(false);
                    EnterItemsPanel.this.downArrow.setEnabled(false);
                }
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = EnterItemsPanel.this.list.getMinSelectionIndex();
                    int n2 = EnterItemsPanel.this.list.getMaxSelectionIndex();
                    if (n >= 0 && n2 >= 0) {
                        if (n == n2) {
                            EnterItemsPanel.this.entryText.setText(defaultListModel.get(n).toString());
                            EnterItemsPanel.this.addBtn.setEnabled(true);
                            EnterItemsPanel.this.changeBtn.setEnabled(true);
                            EnterItemsPanel.this.upArrow.setEnabled(n != 0);
                            EnterItemsPanel.this.downArrow.setEnabled(n != defaultListModel.getSize() - 1);
                        } else {
                            EnterItemsPanel.this.entryText.setText(null);
                            EnterItemsPanel.this.changeBtn.setEnabled(false);
                            EnterItemsPanel.this.upArrow.setEnabled(false);
                            EnterItemsPanel.this.downArrow.setEnabled(false);
                        }
                    }
                    EnterItemsPanel.this.removeBtn.setEnabled(true);
                }
            }
        });
        defaultListModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                if (defaultListModel.getSize() > 0) {
                    if (EnterItemsPanel.this.dynamicLast && !lastEnabled && EnterItemsPanel.this.getMakefileData().isComplete(true)) {
                        lastEnabled = true;
                    }
                } else if (EnterItemsPanel.this.dynamicLast && lastEnabled) {
                    lastEnabled = false;
                }
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
                if (defaultListModel.getSize() == 0) {
                    if (EnterItemsPanel.this.dynamicNext && EnterItemsPanel.this.itemsRequired && EnterItemsPanel.this.list.getModel().getSize() == 0) {
                        EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.addBtn);
                        EnterItemsPanel.this.nextButton.setEnabled(false);
                    }
                    if (EnterItemsPanel.this.dynamicLast && lastEnabled) {
                        lastEnabled = false;
                    }
                }
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                if (EnterItemsPanel.this.dynamicNext && EnterItemsPanel.this.itemsRequired) {
                    EnterItemsPanel.this.nextButton.setEnabled(true);
                    EnterItemsPanel.this.getRootPane().setDefaultButton(EnterItemsPanel.this.nextButton);
                }
                if (EnterItemsPanel.this.dynamicLast && !lastEnabled && EnterItemsPanel.this.getMakefileData().isComplete(true)) {
                    lastEnabled = true;
                }
            }
        });
        this.upArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = EnterItemsPanel.this.list.getSelectedIndex();
                Object e = defaultListModel.remove(n);
                defaultListModel.add(n - 1, e);
                EnterItemsPanel.this.list.setSelectedIndex(n - 1);
                if (n == 1) {
                    EnterItemsPanel.this.upArrow.setEnabled(false);
                }
            }
        });
        this.downArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = EnterItemsPanel.this.list.getSelectedIndex();
                Object e = defaultListModel.remove(n);
                defaultListModel.add(n + 1, e);
                EnterItemsPanel.this.list.setSelectedIndex(n + 1);
                if (n == defaultListModel.getSize() - 1) {
                    EnterItemsPanel.this.downArrow.setEnabled(false);
                }
            }
        });
    }

    protected final class ErrorInfo {
        private String title;
        private String msg;

        protected ErrorInfo() {
            this(null, null);
        }

        protected ErrorInfo(String string, String string2) {
            this.title = string;
            this.msg = string2;
        }

        String getTitle() {
            return this.title;
        }

        void setTitle(String string) {
            this.title = string;
        }

        String getMsg() {
            return this.msg;
        }

        void setMsg(String string) {
            this.msg = string;
        }
    }

    private final class TokType {
        private boolean re;

        private TokType() {
        }

        void setRE(boolean bl) {
            this.re = bl;
        }

        boolean isRE() {
            return this.re;
        }
    }

    protected class ListItem {
        private String name;
        private boolean exists;

        public ListItem(String string, boolean bl) {
            this.name = string;
            this.exists = bl;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public boolean isExists() {
            return this.exists;
        }
    }

    private class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private class SrcsFileFilter
    implements FileFilter {
        private String filterString;

        public SrcsFileFilter() {
            this.filterString = EnterItemsPanel.this.getString("DFLT_SourceFilter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(File file) {
            Object object;
            if (file.isDirectory()) {
                return false;
            }
            if (EnterItemsPanel.this.filters == null) {
                object = new StringTokenizer(this.filterString);
                EnterItemsPanel.this.filters = new HashSet(15);
                HashSet hashSet = EnterItemsPanel.this.filters;
                synchronized (hashSet) {
                    try {
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            EnterItemsPanel.this.filters.add(new UnixRE(((StringTokenizer)object).nextToken()));
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        patternSyntaxException.printStackTrace();
                        return false;
                    }
                }
            }
            object = EnterItemsPanel.this.filters;
            synchronized (object) {
                for (UnixRE unixRE : EnterItemsPanel.this.filters) {
                    if (!unixRE.match(file.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class MspFileFilter
    extends javax.swing.filechooser.FileFilter {
        private String filterString;

        public MspFileFilter() {
            this.filterString = EnterItemsPanel.this.getString("DFLT_SourceFilter");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean accept(File file) {
            Object object;
            if (file.isDirectory()) {
                return true;
            }
            if (EnterItemsPanel.this.filters == null) {
                object = new StringTokenizer(this.filterString);
                EnterItemsPanel.this.filters = new HashSet(15);
                HashSet hashSet = EnterItemsPanel.this.filters;
                synchronized (hashSet) {
                    try {
                        while (((StringTokenizer)object).hasMoreTokens()) {
                            EnterItemsPanel.this.filters.add(new UnixRE(((StringTokenizer)object).nextToken()));
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        patternSyntaxException.printStackTrace();
                        return false;
                    }
                }
            }
            object = EnterItemsPanel.this.filters;
            synchronized (object) {
                for (UnixRE unixRE : EnterItemsPanel.this.filters) {
                    if (!unixRE.match(file.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return this.filterString;
        }
    }

    private class REParser {
        private String firstComponent;
        private String regularExpression;
        private String remainder;

        public REParser(String string) {
            int n = 0;
            if (string.charAt(0) != File.separatorChar) {
                string = EnterItemsPanel.this.getMakefileData().getBaseDirectory(true) + File.separator + string;
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '/') {
                    n = i;
                }
                if (c != '*' && c != '?' && c != '[') continue;
                this.firstComponent = new String(string.substring(0, n));
                int n2 = string.indexOf(47, i);
                if (n2 == -1) {
                    this.regularExpression = new String(string.substring(n + 1));
                    this.remainder = null;
                } else {
                    this.regularExpression = new String(string.substring(n + 1, n2));
                    this.remainder = new String(string.substring(n2 + 1));
                }
                return;
            }
            this.firstComponent = new String(string);
            this.regularExpression = null;
            this.remainder = null;
        }

        public String getFirstComponent() {
            return this.firstComponent;
        }

        public String getRegularExpression() {
            return this.regularExpression;
        }

        public String getRemainder() {
            return this.remainder;
        }
    }
}

