/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.ui.options.AddRemoveListModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanel;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AddRemoveToolPanel
extends JPanel
implements ActionListener {
    AddRemoveListModel model;
    CompilerSet cs;
    private JButton addButton;
    private JList compilerList;
    private JLabel compilerListLabel;
    private JScrollPane compilerListScrollPane;
    private JButton removeButton;

    public AddRemoveToolPanel(JComboBox jComboBox, CompilerSet compilerSet) {
        this.cs = compilerSet;
        this.model = new AddRemoveListModel();
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            Object e = jComboBox.getItemAt(i);
            if (!(e instanceof Tool)) continue;
            this.model.addElement(e);
        }
        this.initComponents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object = actionEvent.getSource();
        if (object == this.addButton) {
            String string = this.addUserTool();
            if (string != null && !this.model.contains(string)) {
                this.model.addAddElement(string);
                this.compilerList.setSelectedValue(string, true);
                this.removeButton.setEnabled(true);
            }
        } else if (object == this.removeButton && (n = this.compilerList.getSelectedIndex()) >= 0) {
            this.model.remove(n);
            if (this.model.getSize() > 0) {
                this.compilerList.setSelectedIndex(n < this.model.getSize() ? n : this.model.getSize() - 1);
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private String addUserTool() {
        FileOnlyChooser fileOnlyChooser = new FileOnlyChooser((FileSystemView)new CompilerSetView(this.cs.getDirectory()));
        fileOnlyChooser.setDialogType(0);
        fileOnlyChooser.setFileFilter(new FileOnlyFilter());
        int n = fileOnlyChooser.showDialog(this, NbBundle.getMessage(ToolsPanel.class, (String)"LBL_DialogAddButton"));
        if (n == 0) {
            String string;
            File file = fileOnlyChooser.getSelectedFile();
            String string2 = file.getAbsolutePath();
            int n2 = string2.lastIndexOf(File.separator);
            if (n2 >= 0) {
                string = string2.substring(n2 + 1);
                string2 = string2.substring(0, n2);
            } else {
                string = file.getName();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(this.cs.getDirectory());
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equals(string2) || (file = new File(string3, string)).isDirectory() || !file.exists()) continue;
                return string;
            }
        }
        return null;
    }

    protected AddRemoveListModel getModel() {
        return this.model;
    }

    private void initComponents() {
        this.compilerListLabel = new JLabel();
        this.compilerListScrollPane = new JScrollPane();
        this.compilerList = new JList();
        this.compilerList.setModel(this.model);
        this.addButton = new JButton();
        this.addButton.addActionListener(this);
        this.removeButton = new JButton();
        this.removeButton.addActionListener(this);
        if (this.model.getSize() > 0) {
            this.compilerList.setSelectedIndex(0);
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
        this.compilerListLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_CompilerList").charAt(0));
        this.compilerListLabel.setLabelFor(this.compilerList);
        this.compilerListLabel.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("LBL_CompilerList"));
        this.compilerListScrollPane.setViewportView(this.compilerList);
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_AddToolButton").charAt(0));
        this.addButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("LBL_AddToolButton"));
        this.addButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("ACSN_AddToolButton"));
        this.addButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("ACSD_AddToolButton"));
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("MNEM_RemoveToolButton").charAt(0));
        this.removeButton.setText(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("LBL_RemoveToolButton"));
        this.removeButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("ACSN_RemoveToolButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/cnd/ui/options/Bundle").getString("ACSD_RemoveToolButton"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.compilerListScrollPane, -1, 227, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addButton, -1, 83, Short.MAX_VALUE).add((Component)this.removeButton))).add((Component)this.compilerListLabel, -2, 259, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.compilerListLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton, -2, 29, -2).addPreferredGap(0).add((Component)this.removeButton, -2, 25, -2).addContainerGap(208, Short.MAX_VALUE)).add((Component)this.compilerListScrollPane, -1, 272, Short.MAX_VALUE))));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 2);
    }

    private class FileOnlyFilter
    extends FileFilter {
        private FileOnlyFilter() {
        }

        public boolean accept(File file) {
            String string;
            return !file.isDirectory() && ((string = FileUtil.toFileObject((File)file).getMIMEType()).startsWith("application/x-exe") || string.equals("text/sh"));
        }

        public String getDescription() {
            return NbBundle.getMessage(ToolsPanel.class, (String)"LBL_ExecutableFilesOnly");
        }
    }

    private class CompilerSetView
    extends FileSystemView {
        File[] roots;

        public CompilerSetView(String string) {
            int n = string.indexOf(File.pathSeparator);
            if (n >= 0) {
                this.roots = new File[2];
                this.roots[0] = new File(string.substring(0, n));
                this.roots[1] = new File(string.substring(n + 1));
            } else {
                this.roots = new File[1];
                this.roots[0] = new File(string);
            }
        }

        public String getSystemDisplayName(File file) {
            if (file.isDirectory()) {
                return file.getAbsolutePath();
            }
            return super.getSystemDisplayName(file);
        }

        public File[] getRoots() {
            return this.roots;
        }

        public File getDefaultDirectory() {
            return this.roots[0];
        }

        public File getParentDirectory() {
            return null;
        }

        public File getHomeDirectory() {
            return this.getDefaultDirectory();
        }

        public Boolean isTraversable(File file) {
            if (file.isDirectory()) {
                for (int i = 0; i < this.roots.length; ++i) {
                    if (!this.roots[i].equals(file)) continue;
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }

        public File createNewFolder(File file) throws IOException {
            return file;
        }
    }

    private class FileOnlyChooser
    extends JFileChooser {
        public FileOnlyChooser(FileSystemView fileSystemView) {
            super(fileSystemView);
        }

        public boolean isTraversible(File file) {
            return false;
        }

        public boolean isDirectorySelectionEnabled() {
            return false;
        }

        public boolean isAcceptAllFileFilterUsed() {
            return false;
        }
    }
}

