/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.impl;

import org.netbeans.modules.xslt.tmap.model.api.Invoke;
import org.netbeans.modules.xslt.tmap.model.api.Operation;
import org.netbeans.modules.xslt.tmap.model.api.Param;
import org.netbeans.modules.xslt.tmap.model.api.Service;
import org.netbeans.modules.xslt.tmap.model.api.TMapComponent;
import org.netbeans.modules.xslt.tmap.model.api.TMapVisitor;
import org.netbeans.modules.xslt.tmap.model.api.Transform;
import org.netbeans.modules.xslt.tmap.model.api.TransformMap;
import org.netbeans.modules.xslt.tmap.model.impl.InvokeImpl;
import org.netbeans.modules.xslt.tmap.model.impl.OperationImpl;
import org.netbeans.modules.xslt.tmap.model.impl.ParamImpl;
import org.netbeans.modules.xslt.tmap.model.impl.ServiceImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TMapComponentAbstract;
import org.netbeans.modules.xslt.tmap.model.impl.TMapComponents;
import org.netbeans.modules.xslt.tmap.model.impl.TMapModelImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TransformImpl;
import org.netbeans.modules.xslt.tmap.model.impl.TransformMapImpl;
import org.w3c.dom.Element;

public class TMapComponentBuildVisitor
implements TMapVisitor {
    private TMapModelImpl myModel;
    private Element myElement;
    private TMapComponent myResult;

    public TMapComponentBuildVisitor(TMapModelImpl tMapModelImpl) {
        assert (tMapModelImpl != null);
        this.myModel = tMapModelImpl;
    }

    public TMapComponent createSubComponent(TMapComponent tMapComponent, Element element) {
        this.myElement = element;
        String string = element.getNamespaceURI();
        if (string == null && tMapComponent instanceof TMapComponentAbstract) {
            string = ((TMapComponentAbstract)tMapComponent).lookupNamespaceURI(element.getPrefix());
        }
        if ("http://xml.netbeans.org/schema/transformmap".equals(string)) {
            if (tMapComponent == null) {
                if (TMapComponents.TRANSFORM_MAP.getTagName().equals(this.getElement().getLocalName())) {
                    this.setResult(new TransformMapImpl(this.getModel(), element));
                }
            } else {
                tMapComponent.accept(this);
            }
        }
        return this.myResult;
    }

    public void visit(TransformMap transformMap) {
        if (this.isAcceptable(TMapComponents.SERVICE)) {
            this.setResult(new ServiceImpl(this.getModel(), this.getElement()));
        }
    }

    public void visit(Service service) {
        if (this.isAcceptable(TMapComponents.OPERATION)) {
            this.setResult(new OperationImpl(this.getModel(), this.getElement()));
        }
    }

    public void visit(Operation operation) {
        if (this.isAcceptable(TMapComponents.INVOKE)) {
            this.setResult(new InvokeImpl(this.getModel(), this.getElement()));
        } else if (this.isAcceptable(TMapComponents.TRANSFORM)) {
            this.setResult(new TransformImpl(this.getModel(), this.getElement()));
        }
    }

    public void visit(Invoke invoke) {
    }

    public void visit(Transform transform) {
        if (this.isAcceptable(TMapComponents.PARAM)) {
            this.setResult(new ParamImpl(this.getModel(), this.getElement()));
        }
    }

    public void visit(Param param) {
    }

    void init() {
        this.myResult = null;
        this.myElement = null;
    }

    public Element getElement() {
        return this.myElement;
    }

    private boolean isAcceptable(TMapComponents tMapComponents) {
        return tMapComponents.getTagName().equals(this.getLocalName());
    }

    private String getLocalName() {
        return this.getElement().getLocalName();
    }

    private TMapModelImpl getModel() {
        return this.myModel;
    }

    private void setResult(TMapComponent tMapComponent) {
        this.myResult = tMapComponent;
    }
}

