/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.xsltmap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtil {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String UTF8 = "UTF-8";
    private static final String XSLT_MAP_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + LINE_SEPARATOR + "<xsltmap>" + LINE_SEPARATOR + "</xsltmap>" + LINE_SEPARATOR;

    private XmlUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createTemplateXsltMapFo(Project project) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException("project shouldn't be null");
        }
        FileObject fileObject = Util.getXsltMapFo(project);
        if (fileObject != null) {
            return fileObject;
        }
        FileObject fileObject2 = Util.getProjectSource(project);
        assert (fileObject2 != null);
        File file = new File(FileUtil.toFile((FileObject)fileObject2).getPath(), "xsltmap.xml");
        if (file != null) {
            file.createNewFile();
        }
        fileObject = FileUtil.toFileObject((File)file);
        Document document = XMLUtil.createDocument((String)"xsltmap", null, null, null);
        document.setXmlStandalone(true);
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)UTF8);
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createNewXmlFo(String string, String string2, String string3) throws IOException {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("path and fileName shouldn't be null");
        }
        File file = new File(string, string2 + ".xml");
        if (file != null) {
            file.createNewFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        Document document = XMLUtil.createDocument((String)"transformmap", (String)string3, null, null);
        document.setXmlStandalone(true);
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)FileEncodingQuery.getDefaultEncoding().name());
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return fileObject;
    }

    public static Document getDocument(File file) {
        return XmlUtil.getDocument(file, false);
    }

    public static Document getDocument(File file, boolean bl) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(bl);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        Document document = null;
        Object var5_6 = null;
        try {
            document = documentBuilder.parse(file);
            document.setXmlStandalone(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            document = null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            document = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            document = null;
        }
        return document;
    }

    public static Document getDocument(FileObject fileObject) {
        DocumentBuilder documentBuilder;
        if (fileObject == null || !fileObject.canRead()) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        Document document = null;
        Object var4_5 = null;
        try {
            document = documentBuilder.parse(fileObject.getInputStream());
            document.setXmlStandalone(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            document = null;
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            document = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            document = null;
        }
        return document;
    }

    public static Node getElementByTagName(NodeList nodeList, String string) {
        if (nodeList == null || string == null) {
            return null;
        }
        Node node = null;
        int n = nodeList.getLength();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            node = node2;
            break;
        }
        return node;
    }

    public static Node getElementByTagName(Document document, String string) {
        if (document == null || string == null) {
            return null;
        }
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        return nodeList.item(0);
    }

    public static String getAttrValue(NamedNodeMap namedNodeMap, String string) {
        if (namedNodeMap == null || string == null) {
            return null;
        }
        String string2 = null;
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null || 2 != node.getNodeType()) {
            return null;
        }
        string2 = node.getNodeValue();
        return string2;
    }

    public static Attr createAttr(String string, String string2, Document document) {
        if (string == null || string.length() == 0 || string2 == null || document == null) {
            return null;
        }
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        return attr;
    }
}

