/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.multiview.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.JTextComponent;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.netbeans.modules.xslt.tmap.TMapDataEditorSupport;
import org.netbeans.modules.xslt.tmap.TMapDataObject;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.multiview.tree.TreeMultiViewVisualPanel;
import org.netbeans.modules.xslt.tmap.navigator.TMapLogicalPanel;
import org.netbeans.modules.xslt.tmap.navigator.TMapNavigatorLookupHint;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class TreeMultiViewElement
extends TopComponent
implements MultiViewElement,
ExplorerManager.Provider,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ACTIVATED_NODES = "activatedNodes";
    private transient MultiViewElementCallback myMultiViewObserver;
    private transient TMapLogicalPanel myTreeView;
    private TMapDataObject myDataObject;
    private transient JComponent myToolBarPanel;
    private static Boolean groupVisible = null;
    private transient InstanceContent nodesHack;
    private ExplorerManager myExplorerManager;
    private ActivatedNodesMediator myNodesMediator;
    private CookieProxyLookup myCookieProxyLookup;

    private TreeMultiViewElement() {
    }

    public TreeMultiViewElement(TMapDataObject tMapDataObject) {
        this.myDataObject = tMapDataObject;
        this.initialize();
        this.initializeUI();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.myDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myDataObject = (TMapDataObject)((Object)objectInput.readObject());
        this.initialize();
        this.initializeUI();
    }

    private GridBagConstraints createGBConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        return gridBagConstraints;
    }

    public int getPersistenceType() {
        return 2;
    }

    public CloseOperationState canCloseElement() {
        boolean bl = this.isLastView();
        if (!bl) {
            return CloseOperationState.STATE_OK;
        }
        TMapDataEditorSupport tMapDataEditorSupport = this.myDataObject.getEditorSupport();
        boolean bl2 = tMapDataEditorSupport.isModified();
        if (!bl2) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"Data Object Modified", null, null);
    }

    public void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.myExplorerManager, (boolean)true);
        this.myTreeView.requestFocusInWindow();
    }

    public void componentClosed() {
        super.componentClosed();
        this.cleanup();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        ExplorerUtils.activateActions((ExplorerManager)this.myExplorerManager, (boolean)false);
    }

    public void componentHidden() {
        super.componentHidden();
        if (this.myTreeView != null) {
            this.myTreeView.setVisible(false);
        }
        TreeMultiViewElement.updateTMapTcGroupVisibility(false);
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.myTreeView != null) {
            this.myTreeView.setVisible(true);
        }
        TreeMultiViewElement.updateTMapTcGroupVisibility(true);
    }

    public JComponent getToolbarRepresentation() {
        if (this.myToolBarPanel == null) {
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            int n = 0;
            for (Component component : jToolBar.getComponents()) {
                if (!(component instanceof JButton) && !(component instanceof JToggleButton)) continue;
                n = Math.max(component.getPreferredSize().height, n);
            }
            for (Component component : jToolBar.getComponents()) {
                Dimension dimension;
                if (component instanceof JButton || component instanceof JToggleButton) {
                    dimension = component.getMaximumSize();
                    dimension.height = n;
                    component.setMaximumSize(dimension);
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                if (component instanceof JTextComponent) {
                    component.setMaximumSize(component.getPreferredSize());
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                if (component instanceof JSlider) {
                    dimension = component.getMaximumSize();
                    dimension.width = 160;
                    component.setMaximumSize(dimension);
                    dimension = component.getPreferredSize();
                    dimension.width = 160;
                    component.setPreferredSize(dimension);
                    continue;
                }
                component.setMinimumSize(component.getPreferredSize());
            }
            this.myToolBarPanel = jToolBar;
        }
        return this.myToolBarPanel;
    }

    public UndoRedo getUndoRedo() {
        return this.myDataObject.getEditorSupport().getUndoManager();
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.myMultiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.myMultiViewObserver != null) {
            this.myMultiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected boolean closeLast() {
        return true;
    }

    private TMapLogicalPanel createTreeView() {
        TreeMultiViewVisualPanel treeMultiViewVisualPanel = new TreeMultiViewVisualPanel();
        Lookup lookup = this.getLookup();
        TMapModel tMapModel = (TMapModel)lookup.lookup(TMapModel.class);
        treeMultiViewVisualPanel.navigate(lookup, tMapModel);
        return treeMultiViewVisualPanel;
    }

    private void initializeUI() {
        this.setLayout(new GridBagLayout());
        this.myTreeView = this.createTreeView();
        JScrollPane jScrollPane = new JScrollPane(this.myTreeView);
        jScrollPane.setBorder(null);
        GridBagConstraints gridBagConstraints = this.createGBConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        this.add(jScrollPane, gridBagConstraints);
        this.setVisible(true);
    }

    private static void updateTMapTcGroupVisibility(boolean bl) {
        WindowManager windowManager = WindowManager.getDefault();
        TopComponentGroup topComponentGroup = windowManager.findTopComponentGroup("tmap_designer");
        if (topComponentGroup == null) {
            return;
        }
        boolean bl2 = false;
        for (Mode mode : windowManager.getModes()) {
            String string;
            MultiViewPerspective multiViewPerspective;
            MultiViewHandler multiViewHandler;
            TopComponent topComponent = mode.getSelectedTopComponent();
            if (topComponent == null || (multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent)) == null || (multiViewPerspective = multiViewHandler.getSelectedPerspective()) == null || !"tmap-tree".equals(string = multiViewPerspective.preferredID())) continue;
            bl2 = true;
            break;
        }
        if (bl2 && !Boolean.TRUE.equals(groupVisible)) {
            topComponentGroup.open();
        } else if (!bl2 && !Boolean.FALSE.equals(groupVisible)) {
            topComponentGroup.close();
        }
        groupVisible = bl2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getMVEditorActivePanelPrefferedId() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return null;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        if (multiViewPerspective != null) {
            return multiViewPerspective.preferredID();
        }
        return null;
    }

    private boolean isLastView() {
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)this.myMultiViewObserver.getTopComponent()).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    private TMapDataObject getDataObject() {
        return this.myDataObject;
    }

    private void initialize() {
        this.myExplorerManager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.myExplorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.myExplorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.myExplorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.myExplorerManager, (boolean)false));
        Node node = this.myDataObject.getNodeDelegate();
        this.myNodesMediator = new ActivatedNodesMediator(node);
        this.myNodesMediator.setExplorerManager((ExplorerManager.Provider)this);
        ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{TMapNavigatorLookupHint.getInstance()}), Lookups.singleton((Object)((Object)this.myDataObject)), this.myDataObject.getLookup(), Lookups.singleton((Object)this), this.myNodesMediator.getLookup(), node.getLookup()});
        proxyLookup = Lookups.exclude((Lookup)proxyLookup, (Class[])new Class[]{ActionMap.class});
        this.myCookieProxyLookup = new CookieProxyLookup(new Lookup[]{proxyLookup}, node);
        this.associateLookup((Lookup)this.myCookieProxyLookup);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myNodesMediator);
        this.addPropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myCookieProxyLookup);
        this.setLayout(new BorderLayout());
    }

    private void cleanup() {
        try {
            this.myExplorerManager.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myNodesMediator);
        this.removePropertyChangeListener(ACTIVATED_NODES, (PropertyChangeListener)this.myCookieProxyLookup);
        this.myNodesMediator = null;
        this.myCookieProxyLookup = null;
        this.myTreeView = null;
        this.removeAll();
    }

    private Lookup createAssociateLookup() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", null);
        actionMap.put("cut-to-clipboard", null);
        actionMap.put("paste-from-clipboard", null);
        this.nodesHack = new InstanceContent();
        return new ProxyLookup(new Lookup[]{this.myDataObject.getLookup(), Lookups.fixed((Object[])new Object[]{actionMap}), new AbstractLookup((AbstractLookup.Content)this.nodesHack)});
    }

    public ExplorerManager getExplorerManager() {
        return this.myExplorerManager;
    }
}

