/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xslt.tmap.model.api.TMapModel;
import org.netbeans.modules.xslt.tmap.model.api.WSDLReference;
import org.netbeans.modules.xslt.tmap.model.spi.TMapModelFactory;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationDesc;
import org.netbeans.modules.xslt.tmap.nodes.TMapComponentNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class Util {
    public static final String FORWARD_SLASH = "/";
    public static final String UP_REL_FOLDER = "../";
    public static final String CUR_REL_FOLDER = "./";
    public static final String WSDL = "wsdl";
    public static final String SRC = "src";
    private static String GRAY_COLOR = "#999999";

    private Util() {
    }

    public static FileObject getRelativeFO(FileObject fileObject, String string) {
        if (fileObject == null || string == null) {
            return null;
        }
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        if (string.startsWith(UP_REL_FOLDER)) {
            int n = UP_REL_FOLDER.length();
            while (string.startsWith(UP_REL_FOLDER)) {
                fileObject = fileObject.getParent();
                string = string.substring(n);
            }
        } else if (string.startsWith(CUR_REL_FOLDER)) {
            string = string.substring(CUR_REL_FOLDER.length());
        }
        return fileObject.getFileObject(string);
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        if (string != null) {
            return string;
        }
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(fileObject.getPath(), FORWARD_SLASH);
        StringTokenizer stringTokenizer2 = new StringTokenizer(fileObject2.getPath(), FORWARD_SLASH);
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()).equals(string3 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null)) {
        }
        if (string3 == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(UP_REL_FOLDER);
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            stringBuffer.append(UP_REL_FOLDER);
        }
        StringBuffer stringBuffer2 = new StringBuffer(string3);
        while (stringTokenizer2.hasMoreTokens()) {
            stringBuffer2.append(FORWARD_SLASH).append(stringTokenizer2.nextToken());
        }
        return stringBuffer.append(stringBuffer2).toString();
    }

    public static Project getProject(FileObject fileObject) {
        Object var1_1 = null;
        return fileObject == null ? null : FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static FileObject getProjectRoot(FileObject fileObject) {
        FileObject fileObject2 = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            fileObject2 = project.getProjectDirectory();
        }
        return fileObject2;
    }

    public static WSDLModel[] getAllProjectWsdls(FileObject fileObject) {
        FileObject[] fileObjectArray;
        WSDLModel[] wSDLModelArray;
        assert (fileObject != null);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Enumeration enumeration = fileObject.getFolders(true);
        while (enumeration.hasMoreElements()) {
            wSDLModelArray = (WSDLModel[])enumeration.nextElement();
            for (FileObject fileObject2 : fileObjectArray = wSDLModelArray.getChildren()) {
                if (fileObject2.isFolder() || !WSDL.equals(fileObject2.getExt())) continue;
                arrayList.add(fileObject2);
            }
        }
        wSDLModelArray = null;
        if (arrayList != null && arrayList.size() > 0) {
            wSDLModelArray = new WSDLModel[arrayList.size()];
        }
        fileObjectArray = WSDLModelFactory.getDefault();
        for (int i = 0; i < wSDLModelArray.length; ++i) {
            ModelSource modelSource = Utilities.getModelSource((FileObject)((FileObject)arrayList.get(i)), (boolean)true);
            wSDLModelArray[i] = fileObjectArray.getModel(modelSource);
        }
        return wSDLModelArray;
    }

    public static FileObject[] getProjectSources(Project project) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("xml");
        if (sourceGroupArray != null) {
            for (SourceGroup sourceGroup : sourceGroupArray) {
                arrayList.add(sourceGroup.getRootFolder());
            }
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    public static FileObject getProjectSource(Project project) {
        FileObject fileObject = null;
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("xml");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            fileObject = sourceGroupArray[0].getRootFolder();
        }
        return fileObject;
    }

    public static FileObject getTMapFo(Project project) {
        return Util.getProjectSource(project).getFileObject("transformmap.xml");
    }

    public static File getTransformationDescriptor(Project project) {
        FileObject fileObject = Util.getProjectSource(project).getFileObject("transformmap.xml");
        if (fileObject == null) {
            fileObject = Util.getProjectSource(project).getFileObject("xsltmap.xml");
        }
        return fileObject == null ? null : FileUtil.toFile((FileObject)fileObject);
    }

    public static FileObject getXsltMapFo(Project project) {
        if (project == null) {
            throw new IllegalArgumentException("project shouldn't be null");
        }
        FileObject fileObject = null;
        FileObject fileObject2 = Util.getProjectSource(project);
        assert (fileObject2 != null);
        fileObject = fileObject2.getFileObject("xsltmap.xml");
        return fileObject;
    }

    public static FileObject getXsltMapFo(FileObject fileObject) {
        FileObject fileObject2 = null;
        if (fileObject == null) {
            return null;
        }
        fileObject2 = fileObject.getParent().getFileObject("xsltmap.xml");
        return fileObject2;
    }

    public static FileObject getXsltMapFo(File file) {
        if (file == null) {
            return null;
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        Project project = Util.getProject(fileObject);
        return project == null ? null : Util.getXsltMapFo(project);
    }

    public static TMapModel getTMapModel(FileObject fileObject) {
        TMapModel tMapModel = null;
        if (fileObject != null) {
            ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
            tMapModel = TMapModelFactory.TMapModelFactoryAccess.getFactory().getModel(modelSource);
        }
        return tMapModel;
    }

    public static FileObject createDefaultTransformmap(Project project) {
        assert (project != null);
        FileObject fileObject = null;
        FileObject fileObject2 = Util.getProjectSource(project);
        if (fileObject2 == null) {
            return null;
        }
        try {
            fileObject = FileUtil.copyFile((FileObject)Repository.getDefault().getDefaultFileSystem().findResource("org-netbeans-xsltpro/transformmap.xml"), (FileObject)fileObject2, (String)"transformmap");
            if (fileObject != null) {
                SoaUiUtil.fixEncoding((DataObject)DataObject.find((FileObject)fileObject), (FileObject)fileObject2);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
        return fileObject;
    }

    public static File getXsltMapFile(File file) {
        return FileUtil.toFile((FileObject)Util.getXsltMapFo(file));
    }

    public static PartnerLinkType findPartnerLinkType(FileObject fileObject, String string) {
        WSDLModel wSDLModel;
        WSDLModel[] wSDLModelArray;
        if (fileObject == null || string == null) {
            return null;
        }
        PartnerLinkType partnerLinkType = null;
        WSDLModel[] wSDLModelArray2 = wSDLModelArray = Util.getAllProjectWsdls(fileObject);
        int n = wSDLModelArray2.length;
        for (int i = 0; i < n && (partnerLinkType = Util.getPartnerLinkType(wSDLModel = wSDLModelArray2[i], string)) == null; ++i) {
        }
        return partnerLinkType;
    }

    public static Operation findWsdlOperation(FileObject fileObject, String string, String string2, String string3, String string4) {
        QName qName;
        Object object;
        Object object2;
        if (string == null || string2 == null || fileObject == null || string3 == null || string4 == null) {
            return null;
        }
        QName qName2 = null;
        PartnerLinkType partnerLinkType = Util.findPartnerLinkType(fileObject, string);
        Role role = null;
        if (partnerLinkType != null) {
            role = partnerLinkType.getRole1();
            Object object3 = role = role != null && !string2.equals(role.getName()) ? null : role;
            if (role == null) {
                role = partnerLinkType.getRole2();
                role = role != null && !string2.equals(role.getName()) ? null : role;
            }
        }
        PortType portType = null;
        if (role != null) {
            object2 = role.getPortType();
            portType = object2 == null ? null : (PortType)object2.get();
            object = object2 == null ? null : object2.getQName();
            qName = QName.valueOf(string3);
            if (portType != null && qName != null && !qName.equals(object)) {
                portType = null;
            }
        }
        if (portType != null && (object2 = portType.getOperations()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                qName = (Operation)object.next();
                if (!string4.equals(qName.getName())) continue;
                qName2 = qName;
                break;
            }
        }
        return qName2;
    }

    public static Operation findWsdlOperation(FileObject fileObject, TransformationDesc transformationDesc) {
        if (fileObject == null || transformationDesc == null) {
            return null;
        }
        return Util.findWsdlOperation(fileObject, transformationDesc.getPartnerLink(), transformationDesc.getRoleName(), transformationDesc.getPortType(), transformationDesc.getOperation());
    }

    public static PartnerLinkType getPartnerLinkType(WSDLModel wSDLModel, String string) {
        if (wSDLModel == null || string == null) {
            return null;
        }
        PartnerLinkType partnerLinkType = null;
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions == null) {
            return partnerLinkType;
        }
        List list = definitions.getExtensibilityElements(PartnerLinkType.class);
        for (PartnerLinkType partnerLinkType2 : list) {
            String string2 = partnerLinkType2.getName();
            String string3 = wSDLModel.getDefinitions().getTargetNamespace();
            if (!string.equals("{" + string3 + "}" + string2)) continue;
            partnerLinkType = partnerLinkType2;
            break;
        }
        return partnerLinkType;
    }

    public static Operation findWsdlOperation(File file, TransformationDesc transformationDesc) {
        return Util.findWsdlOperation(FileUtil.toFileObject((File)file), transformationDesc);
    }

    public static Operation getOperation(WSDLModel wSDLModel, String string, String string2) {
        NamedComponentReference namedComponentReference;
        if (wSDLModel == null || string == null || string2 == null) {
            return null;
        }
        NamedComponentReference namedComponentReference2 = null;
        Definitions definitions = wSDLModel.getDefinitions();
        if (definitions == null) {
            return namedComponentReference2;
        }
        Collection collection = definitions.getPortTypes();
        Object object = null;
        for (Object object2 : collection) {
            namedComponentReference = object2.createReferenceTo((ReferenceableWSDLComponent)object2, PortType.class);
            QName qName = namedComponentReference.getQName();
            String string3 = qName.getNamespaceURI();
            String string4 = qName.getLocalPart();
            if (!string.equals("{" + string3 + "}" + string4)) continue;
            object = object2;
            break;
        }
        if (object != null) {
            Object object2;
            Collection collection2 = object.getOperations();
            object2 = collection2.iterator();
            while (object2.hasNext()) {
                namedComponentReference = (Operation)object2.next();
                if (!string2.equals(namedComponentReference.getName())) continue;
                namedComponentReference2 = namedComponentReference;
                break;
            }
        }
        return namedComponentReference2;
    }

    private String getLocalPart(String string) {
        QName qName = QName.valueOf(string);
        return qName.getLocalPart();
    }

    public static String getNamespace(ReferenceableWSDLComponent referenceableWSDLComponent) {
        if (referenceableWSDLComponent == null) {
            return null;
        }
        String string = null;
        WSDLModel wSDLModel = referenceableWSDLComponent.getModel();
        Definitions definitions = null;
        if (wSDLModel != null) {
            definitions = wSDLModel.getDefinitions();
        }
        if (definitions != null) {
            string = definitions.getTargetNamespace();
        }
        return string;
    }

    public static String getMessageType(Operation operation, boolean bl) {
        Input input;
        if (operation == null) {
            return null;
        }
        String string = null;
        NamedComponentReference namedComponentReference = null;
        Object object = input = bl ? operation.getInput() : operation.getOutput();
        if (input != null) {
            namedComponentReference = input.getMessage();
        }
        Message message = null;
        if (namedComponentReference != null) {
            message = (Message)namedComponentReference.get();
        }
        if (message != null) {
            String string2 = Util.getNamespace((ReferenceableWSDLComponent)message);
            string2 = string2 != null ? "{" + string2 + "}" : "";
            string = string2 + message.getName();
        }
        return string;
    }

    public static String getGrayString(String string) {
        return Util.getGrayString("", string);
    }

    public static String getGrayString(String string, String string2) {
        return string2 == null ? string : "<html>" + Util.getCorrectedHtmlRenderedString(string) + "<font color='" + GRAY_COLOR + "'>" + Util.getCorrectedHtmlRenderedString(string2) + "</font></html>";
    }

    public static String getGrayString(String string, String string2, String string3) {
        return Util.getGrayString(string, string2, string3, true);
    }

    public static String getGrayString(String string, String string2, String string3, boolean bl) {
        String string4;
        String string5 = bl ? "<html>" : "";
        String string6 = string4 = bl ? "</html>" : "";
        return string2 == null ? string : string5 + Util.getCorrectedHtmlRenderedString(string) + "<font color='" + GRAY_COLOR + "'>" + Util.getCorrectedHtmlRenderedString(string2) + "</font>" + (string3 == null ? "" : Util.getCorrectedHtmlRenderedString(string3)) + string4;
    }

    public static final String getCorrectedHtmlRenderedString(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("&amp;", "&");
        string = string.replaceAll("&gt;", ">;");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        return string;
    }

    public static FileObject getSrcFolder(Project project) {
        return project.getProjectDirectory().getFileObject(SRC);
    }

    public static String getReferenceLocalName(WSDLReference wSDLReference) {
        if (wSDLReference == null) {
            return null;
        }
        QName qName = wSDLReference.getQName();
        return qName == null ? null : qName.getLocalPart();
    }

    public static String getReferenceLocalName(Reference reference) {
        if (reference == null) {
            return null;
        }
        return reference == null ? null : reference.getRefString();
    }

    public static String getLocalizedAttribute(Reference reference, String string) {
        if (reference == null) {
            return "";
        }
        string = string == null ? "" : string;
        return NbBundle.getMessage(TMapComponentNode.class, (String)"LBL_ATTRIBUTE_HTML_TEMPLATE", (Object)string, (Object)reference.getRefString());
    }

    public static String getLocalizedAttribute(String string, String string2) {
        if (string == null) {
            return "";
        }
        string2 = string2 == null ? "" : string2;
        string = string == null ? "" : string;
        return NbBundle.getMessage(TMapComponentNode.class, (String)"LBL_ATTRIBUTE_HTML_TEMPLATE", (Object)string2, (Object)string);
    }
}

