/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.ComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.actions.SelectAction;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGLocatableElement;

public final class SelectActionFactory
extends AbstractComposerActionFactory
implements SceneManager.SelectionListener {
    private final AbstractSVGAction m_navigateBackAction = new AbstractSVGAction("svg_prev_sel", false){

        public void actionPerformed(ActionEvent actionEvent) {
            if (SelectActionFactory.this.m_selectionHistoryIndex > 0) {
                String[] stringArray = (String[])SelectActionFactory.this.m_selectionHistory.get(--SelectActionFactory.this.m_selectionHistoryIndex);
                SelectActionFactory.this.m_sceneMgr.setSelection(stringArray[0], false);
                SelectActionFactory.this.updateSelectionHistoryButtons();
            }
        }
    };
    private final AbstractSVGAction m_navigateForwardAction = new AbstractSVGAction("svg_next_sel", false, 1){

        public void actionPerformed(ActionEvent actionEvent) {
            if (SelectActionFactory.this.m_selectionHistoryIndex < SelectActionFactory.this.m_selectionHistory.size() - 1) {
                String[] stringArray = (String[])SelectActionFactory.this.m_selectionHistory.get(++SelectActionFactory.this.m_selectionHistoryIndex);
                SelectActionFactory.this.m_sceneMgr.setSelection(stringArray[0], false);
                SelectActionFactory.this.updateSelectionHistoryButtons();
            }
        }
    };
    private final AbstractSVGAction m_navigateUpAction = new AbstractSVGAction("svg_parent_sel", false, 2){

        public void actionPerformed(ActionEvent actionEvent) {
            SVGObject[] sVGObjectArray = SelectActionFactory.this.m_sceneMgr.getSelected();
            if (sVGObjectArray != null && sVGObjectArray.length > 0) {
                Node node;
                assert (sVGObjectArray[0] != null);
                SVGLocatableElement sVGLocatableElement = sVGObjectArray[0].getSVGElement();
                assert (sVGLocatableElement != null);
                for (node = sVGLocatableElement.getParentNode(); node != null && !(node instanceof SVGLocatableElement); node = node.getParentNode()) {
                }
                if (node != null) {
                    String string = ((SVGLocatableElement)node).getId();
                    SelectActionFactory.this.m_sceneMgr.setSelection(string, false);
                    SelectActionFactory.this.updateSelectionHistory(string);
                }
            }
        }
    };
    private final List<String[]> m_selectionHistory = new ArrayList<String[]>();
    private int m_selectionHistoryIndex = -1;
    private SelectAction m_activeAction;

    public SelectActionFactory(SceneManager sceneManager) {
        super(sceneManager);
    }

    public static MouseEvent getSelectionEvent(AWTEvent aWTEvent) {
        MouseEvent mouseEvent;
        if (aWTEvent.getID() == 500 && (mouseEvent = (MouseEvent)aWTEvent).getButton() == 1 && mouseEvent.getClickCount() > 0) {
            return mouseEvent;
        }
        return null;
    }

    public synchronized ComposerAction startAction(SVGObject sVGObject) {
        return this.setActiveAction(new SelectAction(this, sVGObject));
    }

    public synchronized ComposerAction startAction(AWTEvent aWTEvent, boolean bl) {
        SVGObject[] sVGObjectArray;
        MouseEvent mouseEvent;
        if (!bl && (mouseEvent = SelectActionFactory.getSelectionEvent(aWTEvent)) != null && (sVGObjectArray = this.m_sceneMgr.getPerseusController().getObjectsAt(mouseEvent.getX(), mouseEvent.getY())) != null && sVGObjectArray.length > 0) {
            SVGDataObject sVGDataObject;
            DocumentElement documentElement;
            String string = sVGObjectArray[0].getElementId();
            if (mouseEvent.getClickCount() > 1 && (documentElement = (sVGDataObject = this.m_sceneMgr.getDataObject()).getModel().getElementById(string)) != null) {
                SVGSourceMultiViewElement.selectElement(sVGDataObject, documentElement.getStartOffset(), true);
            }
            this.updateSelectionHistory(string);
            return this.setActiveAction(new SelectAction(this, sVGObjectArray[0]));
        }
        return null;
    }

    public SelectAction getActiveAction() {
        if (this.m_activeAction != null && !this.m_activeAction.isCompleted()) {
            return this.m_activeAction;
        }
        return null;
    }

    public Action[] getMenuActions() {
        return new Action[]{this.m_navigateBackAction, this.m_navigateForwardAction, this.m_navigateUpAction};
    }

    public void selectionChanged(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2, boolean bl) {
        Node node;
        boolean bl2 = false;
        if (!this.m_sceneMgr.isReadOnly() && sVGObjectArray != null && sVGObjectArray.length > 0 && (node = sVGObjectArray[0].getSVGElement().getParentNode()) != null) {
            bl2 = true;
        }
        this.m_navigateUpAction.setEnabled(bl2);
        this.updateSelectionHistoryButtons();
    }

    private SelectAction setActiveAction(SelectAction selectAction) {
        if (this.m_activeAction != null) {
            this.m_activeAction.actionCompleted();
        }
        this.m_activeAction = selectAction;
        return selectAction;
    }

    private void updateSelectionHistory(String string) {
        String[] stringArray = new String[]{string};
        for (int i = this.m_selectionHistory.size() - 1; i > this.m_selectionHistoryIndex; --i) {
            this.m_selectionHistory.remove(i);
        }
        this.m_selectionHistoryIndex = this.m_selectionHistory.size();
        this.m_selectionHistory.add(stringArray);
        this.updateSelectionHistoryButtons();
    }

    private void updateSelectionHistoryButtons() {
        this.m_navigateBackAction.setEnabled(!this.m_sceneMgr.isReadOnly() && this.m_selectionHistoryIndex > 0);
        this.m_navigateForwardAction.setEnabled(!this.m_sceneMgr.isReadOnly() && this.m_selectionHistoryIndex < this.m_selectionHistory.size() - 1);
    }
}

