/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.export;

public final class ShrinkPalette {
    private static final int MAX_RGB = 255;
    private static final int MAX_NODES = 266817;
    private static final int MAX_TREE_DEPTH = 8;
    private static final int[] SQUARES;
    private static final int[] SHIFT;

    public static int[] quantizeImage(int[][] nArray, int n) {
        ColorCube colorCube = new ColorCube(nArray, n);
        colorCube.clasify();
        colorCube.reduce();
        colorCube.assign();
        return colorCube.getColorMap();
    }

    static {
        int n;
        SQUARES = new int[511];
        for (n = -255; n <= 255; ++n) {
            ShrinkPalette.SQUARES[n + 255] = n * n;
        }
        SHIFT = new int[9];
        for (n = 0; n < 9; ++n) {
            ShrinkPalette.SHIFT[n] = 1 << 15 - n;
        }
    }

    private static class ColorCube {
        private final Node m_root;
        private final int[][] m_pixels;
        private final int m_max_colors;
        private int[] m_colormap;
        private int m_depth;
        private int m_colors;
        private int m_nodes;

        ColorCube(int[][] nArray, int n) {
            this.m_pixels = nArray;
            this.m_max_colors = n;
            this.m_colors = 1;
            int n2 = n;
            this.m_depth = 1;
            while (n2 != 0) {
                n2 /= 4;
                ++this.m_depth;
            }
            if (this.m_depth > 1) {
                --this.m_depth;
            }
            if (this.m_depth > 8) {
                this.m_depth = 8;
            } else if (this.m_depth < 2) {
                this.m_depth = 2;
            }
            this.m_root = new Node(this);
        }

        void clasify() {
            int[][] nArray = this.m_pixels;
            int n = nArray.length;
            int n2 = nArray[0].length;
            int n3 = n;
            while (n3-- > 0) {
                int n4 = n2;
                while (n4-- > 0) {
                    int n5 = nArray[n3][n4];
                    int n6 = n5 >> 24 & 0xFF;
                    int n7 = n5 >> 16 & 0xFF;
                    int n8 = n5 >> 8 & 0xFF;
                    int n9 = n5 >> 0 & 0xFF;
                    if (n6 <= 0) continue;
                    if (this.m_nodes > 266817) {
                        this.m_root.removeLevel();
                        --this.m_depth;
                    }
                    Node node = this.m_root;
                    for (int i = 1; i <= this.m_depth; ++i) {
                        int n10 = (n7 > node.m_mid_red ? 1 : 0) << 0 | (n8 > node.m_mid_green ? 1 : 0) << 1 | (n9 > node.m_mid_blue ? 1 : 0) << 2;
                        if (node.m_child[n10] == null) {
                            new Node(node, n10, i);
                        }
                        node = node.m_child[n10];
                        node.m_number_pixels += SHIFT[i];
                    }
                    ++node.m_unique;
                    node.m_total_alpha += n6;
                    node.m_total_red += n7;
                    node.m_total_green += n8;
                    node.m_total_blue += n9;
                }
            }
        }

        void reduce() {
            int n = 1;
            while (this.m_colors > this.m_max_colors) {
                this.m_colors = 1;
                n = this.m_root.reduce(n, Integer.MAX_VALUE);
            }
        }

        void assign() {
            this.m_colormap = new int[this.m_colors];
            this.m_colormap[0] = 0x800000;
            this.m_colors = 1;
            this.m_root.fillColorMaps();
            int[][] nArray = this.m_pixels;
            int n = nArray.length;
            int n2 = nArray[0].length;
            Search search = new Search();
            int n3 = n;
            while (n3-- > 0) {
                int n4 = n2;
                while (n4-- > 0) {
                    int n5 = nArray[n3][n4];
                    int n6 = n5 >> 24 & 0xFF;
                    int n7 = n5 >> 16 & 0xFF;
                    int n8 = n5 >> 8 & 0xFF;
                    int n9 = n5 >> 0 & 0xFF;
                    if (n6 > 0) {
                        Node node = this.m_root;
                        while (true) {
                            int n10 = (n7 > node.m_mid_red ? 1 : 0) << 0 | (n8 > node.m_mid_green ? 1 : 0) << 1 | (n9 > node.m_mid_blue ? 1 : 0) << 2;
                            if (node.m_child[n10] == null) break;
                            node = node.m_child[n10];
                        }
                        search.distance = Integer.MAX_VALUE;
                        node.m_parent.findNearestColor(n7, n8, n9, search);
                        nArray[n3][n4] = search.color_number;
                        continue;
                    }
                    nArray[n3][n4] = 0;
                }
            }
        }

        public int[] getColorMap() {
            return this.m_colormap;
        }
    }

    private static class Node {
        private ColorCube m_cube;
        private Node m_parent;
        private Node[] m_child;
        private int m_nchild;
        private int m_id;
        private int m_level;
        private int m_mid_red;
        private int m_mid_green;
        private int m_mid_blue;
        private int m_number_pixels;
        private int m_unique;
        private int m_total_alpha;
        private int m_total_red;
        private int m_total_green;
        private int m_total_blue;
        private int m_color_number;

        Node(ColorCube colorCube) {
            this.m_cube = colorCube;
            this.m_parent = this;
            this.m_child = new Node[8];
            this.m_id = 0;
            this.m_level = 0;
            this.m_number_pixels = Integer.MAX_VALUE;
            this.m_mid_red = 128;
            this.m_mid_green = 128;
            this.m_mid_blue = 128;
        }

        Node(Node node, int n, int n2) {
            this.m_cube = node.m_cube;
            this.m_parent = node;
            this.m_child = new Node[8];
            this.m_id = n;
            this.m_level = n2;
            ++this.m_cube.m_nodes;
            if (n2 == this.m_cube.m_depth) {
                ++this.m_cube.m_colors;
            }
            ++node.m_nchild;
            node.m_child[n] = this;
            int n3 = 1 << 8 - n2 >> 1;
            this.m_mid_red = node.m_mid_red + ((n & 1) > 0 ? n3 : -n3);
            this.m_mid_green = node.m_mid_green + ((n & 2) > 0 ? n3 : -n3);
            this.m_mid_blue = node.m_mid_blue + ((n & 4) > 0 ? n3 : -n3);
        }

        void removeChild() {
            --this.m_parent.m_nchild;
            this.m_parent.m_unique += this.m_unique;
            this.m_parent.m_total_alpha += this.m_total_alpha;
            this.m_parent.m_total_red += this.m_total_red;
            this.m_parent.m_total_green += this.m_total_green;
            this.m_parent.m_total_blue += this.m_total_blue;
            this.m_parent.m_child[this.m_id] = null;
            --this.m_cube.m_nodes;
            this.m_cube = null;
            this.m_parent = null;
        }

        void removeLevel() {
            if (this.m_nchild != 0) {
                for (int i = 0; i < 8; ++i) {
                    if (this.m_child[i] == null) continue;
                    this.m_child[i].removeLevel();
                }
            }
            if (this.m_level == this.m_cube.m_depth) {
                this.removeChild();
            }
        }

        int reduce(int n, int n2) {
            if (this.m_nchild != 0) {
                for (int i = 0; i < 8; ++i) {
                    if (this.m_child[i] == null) continue;
                    n2 = this.m_child[i].reduce(n, n2);
                }
            }
            if (this.m_number_pixels <= n) {
                this.removeChild();
            } else {
                if (this.m_unique != 0) {
                    this.m_cube.m_colors++;
                }
                if (this.m_number_pixels < n2) {
                    n2 = this.m_number_pixels;
                }
            }
            return n2;
        }

        void fillColorMaps() {
            int n;
            if (this.m_nchild != 0) {
                for (n = 0; n < 8; ++n) {
                    if (this.m_child[n] == null) continue;
                    this.m_child[n].fillColorMaps();
                }
            }
            if (this.m_unique != 0) {
                n = (this.m_total_alpha + (this.m_unique >> 1)) / this.m_unique;
                int n2 = (this.m_total_red + (this.m_unique >> 1)) / this.m_unique;
                int n3 = (this.m_total_green + (this.m_unique >> 1)) / this.m_unique;
                int n4 = (this.m_total_blue + (this.m_unique >> 1)) / this.m_unique;
                ((ColorCube)this.m_cube).m_colormap[((ColorCube)this.m_cube).m_colors] = (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 0;
                this.m_color_number = this.m_cube.m_colors++;
            }
        }

        void findNearestColor(int n, int n2, int n3, Search search) {
            int n4;
            int n5;
            if (this.m_nchild != 0) {
                for (n5 = 0; n5 < 8; ++n5) {
                    if (this.m_child[n5] == null) continue;
                    this.m_child[n5].findNearestColor(n, n2, n3, search);
                }
            }
            if (this.m_unique != 0 && (n4 = Node.getDistance(n5 = this.m_cube.m_colormap[this.m_color_number], n, n2, n3)) < search.distance) {
                search.distance = n4;
                search.color_number = this.m_color_number;
            }
        }

        static final int getDistance(int n, int n2, int n3, int n4) {
            return SQUARES[(n >> 16 & 0xFF) - n2 + 255] + SQUARES[(n >> 8 & 0xFF) - n3 + 255] + SQUARES[(n >> 0 & 0xFF) - n4 + 255];
        }
    }

    private static class Search {
        private int distance;
        private int color_number;

        private Search() {
        }
    }
}

