/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.CharSeq;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.EncodingInputStream;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElementMapping {
    private static final String ID_COUPLING_PREFIX = "_";
    private static final String ID_WRAPPER_PREFIX = "w_";
    private final SVGFileModel m_fileModel;
    private final Map<String, DocumentElement> m_ids = new HashMap<String, DocumentElement>();
    private boolean m_refreshNeeded = false;

    public ElementMapping(SVGFileModel sVGFileModel) {
        this.m_fileModel = sVGFileModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVGImage parseDocument(boolean bl) throws BadLocationException, IOException {
        StringBuilder stringBuilder;
        CharSeq charSeq;
        BaseDocument baseDocument;
        Object object;
        Object object2 = this.m_fileModel.getTransactionMonitor();
        synchronized (object2) {
            if (bl) {
                this.m_fileModel.updateModel();
            }
            object = this.m_fileModel.getModel();
            try {
                object.readLock();
                baseDocument = (BaseDocument)object.getDocument();
                charSeq = baseDocument.getText();
                int n = charSeq.length();
                stringBuilder = new StringBuilder(n);
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append(charSeq.charAt(i));
                }
                this.m_ids.clear();
                this.m_refreshNeeded = false;
                ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
                this.collectAnonymousElements(object.getRootElement(), arrayList);
                int n2 = 0;
                for (DocumentElement documentElement : arrayList) {
                    String string;
                    while (this.m_ids.containsKey(string = ID_COUPLING_PREFIX + n2++)) {
                    }
                    int n3 = documentElement.getStartOffset();
                    String string2 = " id=\"" + string + "\" ";
                    stringBuilder.insert(n3 += documentElement.getName().length() + 1, string2);
                    ElementMapping.checkRemovedElement(documentElement);
                    if (this.m_ids.put(string, documentElement) == null) continue;
                    SceneManager.log(Level.SEVERE, "Duplicated id: " + string);
                }
            }
            finally {
                object.readUnlock();
            }
        }
        object2 = this.m_fileModel.getDataObject().getEncodingHelper().getEncoding();
        object = new EncodingInputStream(stringBuilder, (String)object2);
        try {
            baseDocument = PerseusController.createImage((InputStream)object);
            charSeq = baseDocument;
            return charSeq;
        }
        finally {
            ((InputStream)object).close();
        }
    }

    public synchronized void add(DocumentElement documentElement) {
        String string = SVGFileModel.getIdAttribute(documentElement);
        if (SceneManager.isEnabled(Level.FINEST)) {
            SceneManager.log(Level.FINEST, "Adding mapping " + string + " <--> " + documentElement);
        }
        ElementMapping.checkRemovedElement(documentElement);
        if (string != null) {
            this.m_ids.put(string, documentElement);
        } else {
            this.m_refreshNeeded = true;
        }
    }

    public synchronized void remove(DocumentElement documentElement) {
        String string = SVGFileModel.getIdAttribute(documentElement);
        if (string == null) {
            Iterator<DocumentElement> iterator = this.m_ids.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != documentElement) continue;
                if (SceneManager.isEnabled(Level.FINEST)) {
                    SceneManager.log(Level.FINEST, "Removing mapping " + string + " <--> " + documentElement);
                }
                iterator.remove();
                return;
            }
        } else {
            this.m_ids.remove(string);
        }
    }

    private void refresh() {
        try {
            SceneManager.log(Level.INFO, "Refreshing mapping");
            SVGImage sVGImage = this.parseDocument(false);
            this.m_fileModel.getDataObject().getSceneManager().setImage(sVGImage);
        }
        catch (Exception exception) {
            SceneManager.error("Mapping refresh failed", exception);
        }
    }

    synchronized DocumentElement id2element(String string) {
        DocumentElement documentElement;
        if (SceneManager.isEnabled(Level.FINER)) {
            SceneManager.log(Level.FINER, "Looking for element with id: " + string);
        }
        if ((documentElement = this.m_ids.get(string)) == null) {
            SceneManager.log(Level.FINER, "No element found.");
            if (this.m_refreshNeeded) {
                this.refresh();
                documentElement = this.m_ids.get(string);
            }
        }
        ElementMapping.checkRemovedElement(documentElement);
        if (SceneManager.isEnabled(Level.FINE)) {
            SceneManager.log(Level.FINE, "Mapping found: " + string + " -> " + documentElement);
        }
        return documentElement;
    }

    public synchronized String element2id(DocumentElement documentElement) {
        String string = null;
        for (Map.Entry<String, DocumentElement> entry : this.m_ids.entrySet()) {
            if (entry.getValue() != documentElement) continue;
            string = entry.getKey();
            break;
        }
        if (SceneManager.isEnabled(Level.FINE)) {
            SceneManager.log(Level.FINE, "Mapping found: " + documentElement + " -> " + string);
        }
        return string;
    }

    synchronized String generateId(String string, boolean bl, Set<String> set) {
        String string2;
        int n = 0;
        if (bl) {
            string = ID_WRAPPER_PREFIX + string;
        }
        while (this.m_ids.containsKey(string2 = string + ID_COUPLING_PREFIX + n++) || set != null && set.contains(string2)) {
        }
        return string2;
    }

    static boolean isWrapperId(String string) {
        return string != null && string.startsWith(ID_WRAPPER_PREFIX);
    }

    protected static void checkRemovedElement(DocumentElement documentElement) {
        assert (documentElement == null || documentElement.getStartOffset() < documentElement.getEndOffset()) : "Deleted element found: " + documentElement;
    }

    synchronized void collectConflictingElements(DocumentElement documentElement, List<String> list, Set<String> set) {
        String string;
        assert (documentElement != null);
        List list2 = documentElement.getChildren();
        for (int i = list2.size() - 1; i >= 0; --i) {
            DocumentElement documentElement2 = (DocumentElement)list2.get(i);
            if (!SVGFileModel.isTagElement(documentElement2)) continue;
            this.collectConflictingElements(documentElement2, list, set);
        }
        if (!"ROOT_ELEMENT".equals(documentElement.getType()) && (string = SVGFileModel.getIdAttribute(documentElement)) != null) {
            if (this.m_ids.containsKey(string)) {
                list.add(string);
            } else {
                set.add(string);
            }
        }
    }

    protected void collectAnonymousElements(DocumentElement documentElement, List<DocumentElement> list) {
        assert (documentElement != null);
        assert (documentElement.getDocumentModel() == this.m_fileModel.getModel()) : "Element " + documentElement + " has incorrect model " + documentElement.getDocumentModel();
        List list2 = documentElement.getChildren();
        for (int i = list2.size() - 1; i >= 0; --i) {
            DocumentElement documentElement2 = (DocumentElement)list2.get(i);
            if (!SVGFileModel.isTagElement(documentElement2)) continue;
            if (documentElement2.getStartOffset() < documentElement2.getEndOffset()) {
                this.collectAnonymousElements(documentElement2, list);
                continue;
            }
            SceneManager.log(Level.SEVERE, "Deleted element found in the model: " + documentElement2);
        }
        if (!"ROOT_ELEMENT".equals(documentElement.getType())) {
            String string = SVGFileModel.getIdAttribute(documentElement);
            if (string != null) {
                ElementMapping.checkRemovedElement(documentElement);
                if (this.m_ids.put(string, documentElement) != null) {
                    SceneManager.log(Level.SEVERE, "Duplicated id: " + string);
                }
            } else {
                list.add(documentElement);
            }
        }
    }
}

