/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Image;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.microedition.m2g.SVGImage;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.export.AnimationRasterizer;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class SVGPaletteItemData {
    private static final String PROP_NAME = "name";
    private static final String PROP_DISPLAY_NAME = "displayName";
    private static final String PROP_FOLDER_NAME = "folderName";
    private static final String PROP_FILE = "file";
    private final Properties m_props = new Properties();
    private Image m_icon32 = null;
    private static final Map<String, SVGPaletteItemData> s_pool = new HashMap<String, SVGPaletteItemData>(10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SVGPaletteItemData get(FileObject fileObject) throws FileNotFoundException, IOException {
        String string = fileObject.getPath();
        SVGPaletteItemData sVGPaletteItemData = s_pool.get(string);
        if (sVGPaletteItemData == null) {
            InputStream inputStream = fileObject.getInputStream();
            try {
                sVGPaletteItemData = new SVGPaletteItemData(inputStream);
            }
            finally {
                inputStream.close();
            }
            s_pool.put(string, sVGPaletteItemData);
        }
        return sVGPaletteItemData;
    }

    public static synchronized void set(String string, SVGPaletteItemData sVGPaletteItemData) {
        s_pool.put(string, sVGPaletteItemData);
    }

    private SVGPaletteItemData(InputStream inputStream) throws IOException {
        this.m_props.loadFromXML(inputStream);
    }

    public SVGPaletteItemData(String string, String string2, String string3) {
        this.m_props.put(PROP_NAME, string);
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        this.m_props.put(PROP_DISPLAY_NAME, string);
        this.m_props.put(PROP_FILE, string3);
        this.m_props.put(PROP_FOLDER_NAME, string2);
    }

    public String getName() {
        return this.m_props.getProperty(PROP_NAME);
    }

    public String getDisplayName() {
        return this.m_props.getProperty(PROP_DISPLAY_NAME);
    }

    public String getFilePath() {
        return this.m_props.getProperty(PROP_FILE);
    }

    public String getFolderName() {
        return this.m_props.getProperty(PROP_FOLDER_NAME);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.m_props.storeToXML(outputStream, "");
    }

    public synchronized Image getIcon32() {
        if (this.m_icon32 == null) {
            SceneManager.log(Level.INFO, "Obtaining icon for " + this.getFilePath());
            try {
                FileObject fileObject;
                String string = this.getFolderName();
                FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("SVGPalette/ThumbnailImages");
                FileObject fileObject3 = fileObject2.getFileObject(string);
                if (fileObject3 != null) {
                    fileObject2 = fileObject3;
                    fileObject = fileObject2.getFileObject(this.getDisplayName(), "png");
                } else {
                    fileObject2 = fileObject2.createFolder(string);
                    fileObject = null;
                }
                if (fileObject == null) {
                    SceneManager.log(Level.INFO, "Constructing icon...");
                    File file = new File(this.getFilePath());
                    if (file.exists() && file.isFile()) {
                        FileObject fileObject4 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                        DataObject dataObject = DataObject.find((FileObject)fileObject4);
                        if (dataObject != null && dataObject instanceof SVGDataObject) {
                            fileObject = SVGPaletteItemData.createThumb((SVGDataObject)dataObject, fileObject2);
                            SceneManager.log(Level.INFO, "Icon constructed.");
                        } else {
                            SceneManager.log(Level.SEVERE, "File " + fileObject4.getPath() + " is not valid SVG file.");
                        }
                    } else {
                        SceneManager.log(Level.SEVERE, "File " + file.getPath() + " not found");
                    }
                }
                if (fileObject != null) {
                    this.m_icon32 = ImageIO.read(fileObject.getInputStream());
                }
            }
            catch (Exception exception) {
                SceneManager.error("Could not load icon", exception);
            }
        }
        return this.m_icon32;
    }

    private static FileObject createThumb(final SVGDataObject sVGDataObject, FileObject fileObject) throws IOException {
        FileObject fileObject2 = null;
        try {
            fileObject2 = AnimationRasterizer.export(sVGDataObject, new AnimationRasterizer.Params(){

                public SVGImage getSVGImage() throws IOException, BadLocationException {
                    return Util.createSVGImage(sVGDataObject.getPrimaryFile(), false);
                }

                public int getImageWidth() {
                    return 32;
                }

                public int getImageHeight() {
                    return 32;
                }

                public float getStartTime() {
                    return 0.0f;
                }

                public float getEndTime() {
                    return 0.0f;
                }

                public float getFramesPerSecond() {
                    return 0.0f;
                }

                public boolean isForAllConfigurations() {
                    return false;
                }

                public double getRatio() {
                    return 1.0;
                }

                public float getCompressionQuality() {
                    return 100.0f;
                }

                public boolean isProgressive() {
                    return false;
                }

                public boolean isInSingleImage() {
                    return true;
                }

                public boolean isTransparent() {
                    return true;
                }

                public AnimationRasterizer.ImageType getImageType() {
                    return AnimationRasterizer.ImageType.PNG24;
                }

                public void setImageWidth(int n) {
                }

                public void setImageHeight(int n) {
                }

                public int getNumberFrames() {
                    return 1;
                }

                public J2MEProject getProject() {
                    return null;
                }

                public String getElementId() {
                    return null;
                }

                public AnimationRasterizer.ColorReductionMethod getColorReductionMethod() {
                    return null;
                }
            }, fileObject);
            assert (fileObject2 != null) : "Null thumbnail image file";
        }
        catch (MissingResourceException missingResourceException) {
            Exceptions.printStackTrace((Throwable)missingResourceException);
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return fileObject2;
    }
}

