/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.EventListener;
import java.util.zip.GZIPInputStream;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableImage;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mobility.svgcore.options.SvgcoreSettings;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class Util {
    public static void launchExternalEditor(final FileObject fileObject) {
        assert (fileObject != null) : "File object is null";
        final InputOutput inputOutput = IOProvider.getDefault().getIO(NbBundle.getMessage(Util.class, (String)"LBL_EditedSvgFile", (Object)fileObject.getName()), false);
        ExecutionEngine.getDefault().execute(NbBundle.getMessage(Util.class, (String)"LBL_SvgEditor"), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                String string = SvgcoreSettings.getDefault().getExternalEditorPath();
                if (string == null || string.length() == 0 || !new File(string).exists()) {
                    if (string == null || string.length() == 0) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"ERR_SvgEditorNotSet", (Object)string), 0));
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"ERR_SvgEditor", (Object)string), 0));
                    }
                    inputOutput.closeInputOutput();
                    return;
                }
                inputOutput.getOut().println(NbBundle.getMessage(Util.class, (String)"LBL_LaunchingFile", (Object)FileUtil.toFile((FileObject)fileObject).toString()));
                NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(string, '\"' + FileUtil.toFile((FileObject)fileObject).getAbsoluteFile().toString() + '\"');
                try {
                    Process process = nbProcessDescriptor.exec();
                    process.waitFor();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(16, (Throwable)iOException);
                }
                catch (InterruptedException interruptedException) {
                    ErrorManager.getDefault().notify(1, (Throwable)interruptedException);
                }
                finally {
                    if (inputOutput != null) {
                        inputOutput.closeInputOutput();
                    }
                }
            }
        }, inputOutput);
    }

    public static SVGImage createSVGImage(FileObject fileObject, boolean bl) throws IOException {
        assert (fileObject != null) : "File object is null";
        if (!bl) {
            return Util.loadImage(fileObject.getURL().toString());
        }
        return Util.loadImageWithProgress(fileObject);
    }

    private static SVGImage loadImage(String string) throws IOException {
        return (SVGImage)ScalableImage.createImage((String)string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SVGImage loadImageWithProgress(FileObject fileObject) throws IOException {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Util.class, (String)"MSG_Loading", (Object)fileObject.getNameExt()));
        progressHandle.start(200);
        if ("svg".equals(fileObject.getExt().toLowerCase())) {
            ProgressInputStream progressInputStream = null;
            try {
                progressInputStream = new ProgressInputStream(fileObject.getInputStream(), fileObject.getSize(), progressHandle);
                SVGImage sVGImage = (SVGImage)ScalableImage.createImage((InputStream)progressInputStream, null);
                return sVGImage;
            }
            finally {
                progressHandle.finish();
                try {
                    if (progressInputStream != null) {
                        progressInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new ProgressInputStream(new GZIPInputStream(fileObject.getInputStream()), fileObject.getSize(), progressHandle);
            SVGImage sVGImage = (SVGImage)ScalableImage.createImage((InputStream)bufferedInputStream, null);
            return sVGImage;
        }
        finally {
            progressHandle.finish();
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getPropertyValue(String string, String string2) {
        int n;
        int n2;
        int n3;
        if (string != null && (n3 = string.indexOf(string2)) != -1 && (n2 = string.indexOf(34, n3 += string2.length())) != -1 && (n = string.indexOf(34, ++n2)) != -1) {
            return string.substring(n2, n);
        }
        return null;
    }

    private static class ProgressInputStream
    extends BufferedInputStream {
        private ProgressHandle handle;
        private long expectedSize;
        private long alreadyRead;

        public ProgressInputStream(InputStream inputStream, long l, ProgressHandle progressHandle) {
            super(inputStream);
            this.handle = progressHandle;
            this.expectedSize = l;
        }

        public synchronized int read() throws IOException {
            int n = super.read();
            this.alreadyRead += (long)n;
            this.updateProgress();
            return n;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = super.read(byArray, n, n2);
            this.alreadyRead += (long)n3;
            this.updateProgress();
            return n3;
        }

        private void updateProgress() throws IOException {
            double d = (double)this.alreadyRead / (double)this.expectedSize * 100.0;
            if (d > (double)this.expectedSize) {
                d = this.expectedSize;
            }
            this.handle.progress((int)d);
        }
    }

    public static interface SVGImageLoadedListener
    extends EventListener {
        public void svgImageLoaded(SVGImage var1, Exception var2);
    }
}

