/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.microedition.m2g.SVGImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.PerseusController;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.composer.ScreenManager;
import org.netbeans.modules.mobility.svgcore.export.SaveElementAsImage;
import org.netbeans.modules.mobility.svgcore.export.ScreenSizeHelper;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.navigator.SVGNavigatorContent;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemDataObject;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGToggleAction;
import org.netbeans.modules.mobility.svgcore.view.svg.AnimationCookie;
import org.netbeans.modules.mobility.svgcore.view.svg.ParsingTask;
import org.netbeans.modules.mobility.svgcore.view.svg.SelectionCookie;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGLocatableElement;
import org.xml.sax.SAXException;

public final class SVGViewTopComponent
extends TopComponent
implements SceneManager.SelectionListener {
    private static final long serialVersionUID = 5862679852552354L;
    private static final float ZOOM_STEP = 1.1f;
    private static final float SLIDER_DEFAULT_STEP = 0.1f;
    private static final String PREFERRED_ID = "SVGViewTopComponent";
    private static final String[] ZOOM_VALUES = new String[]{"400%", "300%", "200%", "100%", "75%", "50%", "25%"};
    private static final String DND_PALETTE_MIME = "x-java-openide-dataobjectdnd";
    private final transient SVGDataObject m_svgDataObject;
    private transient ParsingTask parsingTask;
    private transient Lookup lookup = null;
    private transient JPanel basePanel;
    private transient UpdateThread m_timeUpdater = null;
    private transient JToolBar m_toolbar;
    private transient JToolBar animationToolbar;
    private transient JSlider slider;
    private transient JSpinner currentTimeSpinner;
    private transient JComboBox zoomComboBox;
    private transient AbstractButton startAnimationButton;
    private transient AbstractButton pauseAnimationButton;
    private transient AbstractButton scaleToggleButton;
    private transient AbstractButton showViewBoxToggleButton;
    private transient ChangeListener changeListener;
    private transient boolean doScale = false;
    private transient ButtonMouseListener buttonListener;
    private transient PropertyChangeListener nameChangeL;
    private transient ToggleScaleAction scaleAction;
    private transient ZoomToFitAction zoomToFitAction;
    private transient ZoomInAction zoomInAction;
    private transient ZoomOutAction zoomOutAction;
    private transient ToggleShowViewBoxAction showViewBoxAction;
    private final transient AbstractSVGToggleAction allowEditAction = new AbstractSVGToggleAction("svg_allow_edit"){

        public void actionPerformed(ActionEvent actionEvent) {
            SceneManager sceneManager = SVGViewTopComponent.this.getSceneManager();
            if (sceneManager.isReadOnly()) {
                PerseusController perseusController = SVGViewTopComponent.this.getPerseusController();
                if (perseusController != null && perseusController.isAnimatorStarted()) {
                    SVGViewTopComponent.this.startAnimationAction.actionPerformed(actionEvent);
                }
                SVGViewTopComponent.this.insertGraphicsAction.setEnabled(true);
                sceneManager.setReadOnly(false);
            } else {
                SVGViewTopComponent.this.insertGraphicsAction.setEnabled(false);
                sceneManager.setReadOnly(true);
            }
            SVGViewTopComponent.this.updateAnimationActions();
            SVGViewTopComponent.this.updateDataTransferActions();
            sceneManager.updateActionState();
            this.setIsSelected(!sceneManager.isReadOnly());
        }
    };
    private final transient AbstractSVGToggleAction startAnimationAction = new AbstractSVGToggleAction("svg_anim_start"){

        public void actionPerformed(ActionEvent actionEvent) {
            PerseusController perseusController = SVGViewTopComponent.this.getPerseusController();
            if (perseusController != null) {
                if (!perseusController.isAnimatorStarted()) {
                    if (!SVGViewTopComponent.this.getSceneManager().isReadOnly()) {
                        SVGViewTopComponent.this.allowEditAction.actionPerformed(actionEvent);
                    }
                    perseusController.startAnimator();
                    if (SVGViewTopComponent.this.m_timeUpdater == null) {
                        SVGViewTopComponent.this.m_timeUpdater = new UpdateThread();
                        SVGViewTopComponent.this.m_timeUpdater.start();
                    }
                } else {
                    perseusController.stopAnimator();
                    SVGViewTopComponent.this.updateAnimationTime(perseusController.getAnimatorTime(), SVGViewTopComponent.this.getSceneManager().getAnimationDuration());
                    if (SVGViewTopComponent.this.m_timeUpdater != null) {
                        SVGViewTopComponent.this.m_timeUpdater.interrupt();
                        SVGViewTopComponent.this.m_timeUpdater = null;
                    }
                    SVGViewTopComponent.this.updateImage();
                }
                SVGViewTopComponent.this.updateAnimationActions();
            }
        }
    };
    private final transient AbstractSVGToggleAction pauseAnimationAction = new AbstractSVGToggleAction("svg_anim_pause", false){

        public void actionPerformed(ActionEvent actionEvent) {
            PerseusController perseusController = SVGViewTopComponent.this.getPerseusController();
            if (perseusController != null) {
                if (perseusController.getAnimatorState() == 2) {
                    perseusController.pauseAnimator();
                } else {
                    perseusController.startAnimator();
                }
                SVGViewTopComponent.this.updateAnimationActions();
            }
        }
    };
    private final transient AbstractSVGAction insertGraphicsAction = new AbstractSVGAction("svg_insert_graphics", false){

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showDialog(SwingUtilities.getWindowAncestor((Component)((Object)SVGViewTopComponent.this)), NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_CHOOSE_SVG_FILE"));
            if (n == 0) {
                final File file = jFileChooser.getSelectedFile();
                if (!file.isFile()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SVGViewTopComponent.class, (String)"ERROR_NotSVGFile", (Object)file), 2));
                    return;
                }
                Thread thread = new Thread("InsertGraphicsTask"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            SVGViewTopComponent.this.getSceneManager().setBusyState("operation", true);
                            SVGViewTopComponent.this.m_svgDataObject.getModel().mergeImage(file);
                        }
                        catch (Exception exception) {
                            SceneManager.error("Insert graphics failed.", exception);
                        }
                        finally {
                            SVGViewTopComponent.this.getSceneManager().setBusyState("operation", false);
                        }
                    }
                };
                thread.setPriority(1);
                thread.setDaemon(true);
                thread.start();
            }
        }
    };
    private final transient Action m_pasteAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard = SVGViewTopComponent.getClipboard();
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                try {
                    String string = (String)clipboard.getData(DataFlavor.stringFlavor);
                    String string2 = SVGViewTopComponent.this.m_svgDataObject.getModel().mergeImage(string, false);
                    SVGViewTopComponent.this.getSceneManager().setSelection(string2, true);
                }
                catch (Exception exception) {
                    SceneManager.error("Paste failed.", exception);
                }
                return;
            }
        }
    };
    private final transient Action m_copyAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            SVGViewTopComponent.this.putElementToClipboard(false);
        }
    };
    private final transient Action m_cutAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            SVGViewTopComponent.this.putElementToClipboard(true);
        }
    };

    public SVGViewTopComponent(SVGDataObject sVGDataObject) {
        this.m_svgDataObject = sVGDataObject;
        this.initialize();
    }

    private SceneManager getSceneManager() {
        return this.m_svgDataObject.getSceneManager();
    }

    private PerseusController getPerseusController() {
        return this.getSceneManager().getPerseusController();
    }

    private ScreenManager getScreenManager() {
        return this.getSceneManager().getScreenManager();
    }

    private Lookup createLookup() {
        Lookup lookup = this.getSceneManager().getLoookup();
        ActionMap actionMap = this.getActionMap();
        return Lookups.fixed((Object[])new Object[]{new FilterNode(this.m_svgDataObject.getNodeDelegate(), null, (Lookup)new ProxyLookup(new Lookup[]{new SVGElementNode(lookup).getLookup(), this.m_svgDataObject.getNodeDelegate().getLookup()})), new SVGCookie(), actionMap});
    }

    private void initialize() {
        this.lookup = this.createLookup();
        this.associateLookup(this.lookup);
        this.initComponents();
        this.nameChangeL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("cookie".equals(propertyChangeEvent.getPropertyName()) || "name".equals(propertyChangeEvent.getPropertyName())) {
                    SVGViewTopComponent.this.updateName();
                }
                if (SVGViewTopComponent.this.isVisible() && "external_change".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SceneManager.log(Level.INFO, "Document modified, refreshing image.");
                            SVGViewTopComponent.this.updateImage();
                        }
                    });
                }
            }
        };
        this.m_svgDataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.nameChangeL, (Object)((Object)this.m_svgDataObject)));
        this.m_toolbar = this.createToolBar();
        this.animationToolbar = this.createAnimationBar();
        this.changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == SVGViewTopComponent.this.slider) {
                    float f = (float)SVGViewTopComponent.this.slider.getValue() * 0.1f;
                    SVGViewTopComponent.this.getPerseusController().setAnimatorTime(f);
                    SVGViewTopComponent.this.updateAnimationTime(f, SVGViewTopComponent.this.getSceneManager().getAnimationDuration());
                } else if (changeEvent.getSource() == SVGViewTopComponent.this.currentTimeSpinner) {
                    float f = ((Float)SVGViewTopComponent.this.currentTimeSpinner.getValue()).floatValue();
                    SVGViewTopComponent.this.getPerseusController().setAnimatorTime(f);
                    SVGViewTopComponent.this.updateAnimationTime(f, SVGViewTopComponent.this.getSceneManager().getAnimationDuration());
                }
            }
        };
        this.slider.addChangeListener(this.changeListener);
        this.currentTimeSpinner.addChangeListener(this.changeListener);
        this.basePanel = new JPanel();
        this.basePanel.setBackground(Color.WHITE);
        this.add(this.basePanel, "Center");
        Box box = new Box(1);
        box.add(this.animationToolbar);
        box.add(this.getScreenManager().getStatusBar());
        this.add(box, "South");
        this.updateName();
    }

    private void updateAnimationTime(float f, float f2) {
        this.currentTimeSpinner.removeChangeListener(this.changeListener);
        this.slider.removeChangeListener(this.changeListener);
        if (f2 != -1.0f) {
            this.slider.setMaximum(Math.round(f2 / 0.1f));
        }
        this.slider.setValue(Math.round(f / 0.1f));
        f = (float)Math.round(f * 10.0f) / 10.0f;
        this.currentTimeSpinner.setValue(new Float(f));
        this.slider.addChangeListener(this.changeListener);
        this.currentTimeSpinner.addChangeListener(this.changeListener);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public JComponent getToolbar() {
        return this.m_toolbar;
    }

    JPanel getBasePanel() {
        return this.basePanel;
    }

    public int getPersistenceType() {
        return 1;
    }

    private void putElementToClipboard(final boolean bl) {
        final SVGObject[] sVGObjectArray = this.getSceneManager().getSelected();
        if (sVGObjectArray != null) {
            assert (sVGObjectArray.length > 0);
            assert (sVGObjectArray[0] != null);
            Thread thread = new Thread(){

                public void run() {
                    try {
                        String string = sVGObjectArray[0].getElementId();
                        String string2 = SVGViewTopComponent.this.getModel().getElementAsText(string);
                        StringSelection stringSelection = new StringSelection(string2);
                        Clipboard clipboard = SVGViewTopComponent.getClipboard();
                        clipboard.setContents(stringSelection, stringSelection);
                        if (bl) {
                            SVGViewTopComponent.this.getSceneManager().deleteObject(sVGObjectArray[0]);
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                }
            };
            thread.setPriority(1);
            thread.setName("PutElementToClipboardThread");
            thread.start();
        }
    }

    public void componentOpened() {
        this.getModel().setChanged(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGNavigatorContent.getDefault().navigate(SVGViewTopComponent.this.m_svgDataObject);
            }
        });
        this.addSvgPanel();
        this.getActionMap().put("paste-from-clipboard", this.m_pasteAction);
        this.getActionMap().put("copy-to-clipboard", this.m_copyAction);
        this.getActionMap().put("cut-to-clipboard", this.m_cutAction);
        this.getSceneManager().addSelectionListener(this);
    }

    public void componentClosed() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SVGNavigatorContent.getDefault().navigate(null);
            }
        });
        this.removeSvgPanel();
    }

    public boolean isFocusable() {
        return true;
    }

    public void componentActivated() {
        super.componentActivated();
        this.updateDataTransferActions();
    }

    public void componentDeactivated() {
        super.componentDeactivated();
    }

    private void addSvgPanel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        LoadPanel loadPanel = new LoadPanel();
        this.basePanel.add(loadPanel);
        this.basePanel.setLayout(new BorderLayout());
    }

    public void onShow() {
        if (this.getModel().isChanged()) {
            this.basePanel.removeAll();
            this.updateImage();
            this.getModel().setChanged(false);
        }
    }

    public void componentHidden() {
        PerseusController perseusController = this.getPerseusController();
        if (perseusController != null) {
            perseusController.stopAnimator();
        }
    }

    private void removeSvgPanel() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        this.getSceneManager().resetImage();
        this.basePanel.removeAll();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void updateName() {
        if (!this.m_svgDataObject.isValid()) {
            return;
        }
        String string = this.m_svgDataObject.getNodeDelegate().getDisplayName();
        this.setName(string);
        FileObject fileObject = this.m_svgDataObject.getPrimaryFile();
        this.setToolTipText(FileUtil.getFileDisplayName((FileObject)fileObject));
    }

    private void addButtonsForActions(JToolBar jToolBar, Action[] actionArray, GridBagConstraints gridBagConstraints) {
        for (Action action : actionArray) {
            if (action != null) {
                this.initButton(jToolBar, action, action instanceof AbstractSVGToggleAction);
                continue;
            }
            jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        }
    }

    private JToolBar createToolBar() {
        final SceneManager sceneManager = this.getSceneManager();
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setFloatable(false);
        jToolBar.setFocusable(true);
        Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        jToolBar.setBorder(border);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 2);
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        this.buttonListener = new ButtonMouseListener();
        this.addButtonsForActions(jToolBar, sceneManager.getToolbarActions("svg_prev_sel", "svg_next_sel", "svg_parent_sel"), gridBagConstraints);
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        this.zoomToFitAction = new ZoomToFitAction();
        this.initButton(jToolBar, this.zoomToFitAction, false);
        this.zoomComboBox = new JComboBox<String>(ZOOM_VALUES);
        this.initCombo(jToolBar, this.zoomComboBox);
        final ComboBoxEditor comboBoxEditor = this.zoomComboBox.getEditor();
        this.zoomComboBox.setEditor(new ComboBoxEditor(){
            private String m_lastValue = "";

            public Component getEditorComponent() {
                return comboBoxEditor.getEditorComponent();
            }

            public void setItem(Object object) {
                comboBoxEditor.setItem(object);
            }

            public Object getItem() {
                int n;
                String string;
                Object object = comboBoxEditor.getItem();
                if (object != null && (string = object.toString()) != null && (n = (string = string.trim()).length()) > 0) {
                    if (string.endsWith("%")) {
                        string = string.substring(0, n - 1);
                    }
                    try {
                        float f = Float.parseFloat(string);
                        this.m_lastValue = Math.round(f) + "%";
                        return this.m_lastValue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((JTextComponent)comboBoxEditor.getEditorComponent()).setText(m_lastValue);
                    }
                });
                return this.m_lastValue;
            }

            public void selectAll() {
                comboBoxEditor.selectAll();
            }

            public void addActionListener(ActionListener actionListener) {
                comboBoxEditor.addActionListener(actionListener);
            }

            public void removeActionListener(ActionListener actionListener) {
                comboBoxEditor.removeActionListener(actionListener);
            }
        });
        this.zoomComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                ScreenManager screenManager;
                if (sceneManager.isImageLoaded() && (screenManager = SVGViewTopComponent.this.getScreenManager()) != null && (string = (String)SVGViewTopComponent.this.zoomComboBox.getSelectedItem()) != null) {
                    if ((string = string.trim()).endsWith("%")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    try {
                        float f = Float.parseFloat(string) / 100.0f;
                        if (f > 0.0f && f < 100.0f) {
                            screenManager.setZoomRatio(f);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        numberFormatException.printStackTrace();
                    }
                }
            }
        });
        this.zoomInAction = new ZoomInAction();
        this.initButton(jToolBar, this.zoomInAction, false);
        this.zoomOutAction = new ZoomOutAction();
        this.initButton(jToolBar, this.zoomOutAction, false);
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        this.addButtonsForActions(jToolBar, sceneManager.getToolbarActions("svg_toggle_tooltip", "svg_toggle_highlight"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 2);
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        this.scaleAction = new ToggleScaleAction();
        this.scaleToggleButton = this.initButton(jToolBar, this.scaleAction, true);
        this.showViewBoxAction = new ToggleShowViewBoxAction();
        this.showViewBoxToggleButton = this.initButton(jToolBar, this.showViewBoxAction, true);
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        this.initButton(jToolBar, this.allowEditAction, true);
        this.allowEditAction.setIsSelected(!sceneManager.isReadOnly());
        this.allowEditAction.setEnabled(this.m_svgDataObject.getPrimaryFile().canWrite());
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        this.initButton(jToolBar, this.insertGraphicsAction, false);
        this.addButtonsForActions(jToolBar, sceneManager.getToolbarActions("svg_delete", null, "svg_move_to_top", "svg_move_to_bottom", "svg_move_forward", "svg_move_backward"), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jToolBar.add((Component)new JPanel(), gridBagConstraints);
        return jToolBar;
    }

    private JToolBar createAnimationBar() {
        Serializable serializable;
        JToolBar jToolBar = new JToolBar();
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setFloatable(false);
        jToolBar.setFocusable(true);
        Border border = (Border)UIManager.get("Nb.Editor.Toolbar.border");
        jToolBar.setBorder(border);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 2);
        jToolBar.add(Box.createHorizontalStrut(5));
        this.startAnimationButton = this.initButton(jToolBar, this.startAnimationAction, true);
        this.startAnimationAction.setIsSelected(false);
        this.pauseAnimationButton = this.initButton(jToolBar, this.pauseAnimationAction, true);
        this.pauseAnimationAction.setIsSelected(false);
        jToolBar.add((Component)SVGViewTopComponent.createToolBarSeparator(), gridBagConstraints);
        float f = 30.0f;
        this.slider = new JSlider(0, 0, (int)(f / 0.1f), 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 100.0;
        jToolBar.add((Component)this.slider, gridBagConstraints);
        jToolBar.add(Box.createHorizontalStrut(11));
        this.currentTimeSpinner = new JSpinner();
        this.currentTimeSpinner.setToolTipText(NbBundle.getMessage(SVGViewTopComponent.class, (String)"HINT_CurrentTime"));
        this.currentTimeSpinner.setModel(new SpinnerNumberModel(new Float(0.0f), new Float(0.0), new Float(2.1474836E9f), new Float(0.1)));
        JComponent jComponent = this.currentTimeSpinner.getEditor();
        if (jComponent instanceof JSpinner.NumberEditor) {
            serializable = ((JSpinner.NumberEditor)jComponent).getFormat();
            ((DecimalFormat)serializable).setMinimumFractionDigits(2);
            ((DecimalFormat)serializable).setMaximumFractionDigits(2);
            this.currentTimeSpinner.setValue(new Float(0.0f));
        }
        serializable = this.currentTimeSpinner.getFont();
        FontMetrics fontMetrics = this.currentTimeSpinner.getFontMetrics((Font)serializable);
        int n = fontMetrics.stringWidth("000.0");
        Dimension dimension = this.currentTimeSpinner.getPreferredSize();
        dimension.width = n + 20;
        this.currentTimeSpinner.setPreferredSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_CurrentTime"));
        jToolBar.add((Component)jLabel, gridBagConstraints);
        jToolBar.add(Box.createHorizontalStrut(4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jToolBar.add((Component)this.currentTimeSpinner, gridBagConstraints);
        jLabel.setLabelFor(this.currentTimeSpinner);
        jToolBar.add(Box.createHorizontalStrut(4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        JLabel jLabel2 = new JLabel(NbBundle.getMessage(SVGViewTopComponent.class, (String)"LBL_Seconds"));
        jToolBar.add((Component)jLabel2, gridBagConstraints);
        jToolBar.add(Box.createHorizontalStrut(10));
        return jToolBar;
    }

    private AbstractButton initButton(JComponent jComponent, Action action, boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        Border border = UIManager.getBorder("nb.tabbutton.border");
        if (bl) {
            serializable2 = new JToggleButton(action);
            action.addPropertyChangeListener(new PropertyChangeListener((JToggleButton)serializable2){
                final /* synthetic */ JToggleButton val$tButton;
                {
                    this.val$tButton = jToggleButton;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("selected".equals(propertyChangeEvent.getPropertyName())) {
                        this.val$tButton.setSelected((Boolean)propertyChangeEvent.getNewValue());
                        this.val$tButton.repaint();
                    }
                }
            });
            Boolean bl2 = (Boolean)action.getValue("selected");
            if (bl2 != null) {
                ((AbstractButton)serializable2).setSelected(bl2);
            }
            serializable = serializable2;
        } else {
            serializable = new JButton(action);
        }
        if (border != null) {
            ((JComponent)serializable).setBorder(border);
        }
        serializable2 = new GridBagConstraints();
        ((GridBagConstraints)serializable2).anchor = 17;
        ((AbstractButton)serializable).setContentAreaFilled(true);
        ((AbstractButton)serializable).setBorderPainted(true);
        if (serializable instanceof JButton) {
            ((Component)serializable).addMouseListener((MouseListener)((Object)this.buttonListener));
        }
        ((Component)serializable).setFocusable(false);
        jComponent.add((Component)serializable, serializable2);
        return serializable;
    }

    private void initCombo(JComponent jComponent, JComboBox jComboBox) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        jComboBox.setFocusable(false);
        Dimension dimension = jComboBox.getPreferredSize();
        jComboBox.setPreferredSize(dimension);
        jComboBox.setSize(dimension);
        jComboBox.setMinimumSize(dimension);
        jComboBox.setMaximumSize(dimension);
        jComboBox.setEditable(true);
        jComponent.add((Component)jComboBox, gridBagConstraints);
    }

    private void updateDataTransferActions() {
        boolean bl = this.getSceneManager().isReadOnly();
        boolean bl2 = this.getSceneManager().getSelected() != null;
        this.m_pasteAction.setEnabled(!bl);
        this.m_cutAction.setEnabled(!bl && bl2);
        this.m_copyAction.setEnabled(bl2);
    }

    private void updateAnimationActions() {
        PerseusController perseusController = this.getPerseusController();
        if (perseusController != null) {
            int n = perseusController.getAnimatorState();
            boolean bl = this.getSceneManager().isReadOnly();
            SVGViewTopComponent.enableComponentsInToolbar(this.animationToolbar, bl && n != 0, this.startAnimationButton, this.pauseAnimationButton);
            this.startAnimationAction.setEnabled(n != 0);
            boolean bl2 = bl && perseusController.isAnimatorStarted();
            this.startAnimationAction.setIsSelected(bl2);
            this.pauseAnimationAction.setEnabled(bl2);
            this.pauseAnimationAction.setIsSelected(n == 3);
        }
    }

    private static JSeparator createToolBarSeparator() {
        JSeparator jSeparator = new JSeparator(1);
        Dimension dimension = new Dimension(2, 22);
        jSeparator.setPreferredSize(dimension);
        jSeparator.setSize(dimension);
        jSeparator.setMinimumSize(dimension);
        return jSeparator;
    }

    protected void updateZoomCombo() {
        this.zoomComboBox.getEditor().setItem(Integer.toString((int)((double)(this.getScreenManager().getZoomRatio() * 100.0f) + 0.5)) + "%");
    }

    protected synchronized void updateImage() {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        this.getSceneManager().saveSelection();
        if (this.parsingTask != null) {
            this.parsingTask.cancel();
        }
        try {
            this.parsingTask = new ParsingTask(this.m_svgDataObject, this);
            this.parsingTask.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void showImage(SVGImage sVGImage) {
        assert (SwingUtilities.isEventDispatchThread()) : "Not in AWT event dispach thread";
        SceneManager sceneManager = this.getSceneManager();
        this.basePanel.removeAll();
        sceneManager.setImage(sVGImage);
        sceneManager.restoreSelection();
        JComponent jComponent = sceneManager.getComposerGUI();
        jComponent.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getWheelRotation() < 0) {
                    SVGViewTopComponent.this.zoomOutAction.actionPerformed(null);
                } else {
                    SVGViewTopComponent.this.zoomInAction.actionPerformed(null);
                }
            }
        });
        this.basePanel.add((Component)jComponent, "Center");
        jComponent.setDropTarget(new DropTarget(jComponent, new DropTargetListener(){

            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                SVGViewTopComponent.this.doDrag(dropTargetDragEvent);
            }

            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
                SVGViewTopComponent.this.doDrag(dropTargetDragEvent);
            }

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                SVGViewTopComponent.this.doDrop(dropTargetDropEvent);
            }

            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }
        }));
        sceneManager.registerPopupActions(new Action[]{this.insertGraphicsAction, this.zoomToFitAction, this.zoomInAction, this.zoomOutAction, this.scaleAction, this.showViewBoxAction, this.startAnimationAction, this.pauseAnimationAction, this.allowEditAction}, this, this.lookup);
        this.updateZoomCombo();
        this.updateAnimationActions();
        sceneManager.processEvent(SceneManager.createEvent(this, 2535));
        SVGLocatableElement sVGLocatableElement = this.getPerseusController().getViewBoxMarker();
        ScreenManager screenManager = this.getScreenManager();
        if (sVGLocatableElement == null) {
            this.showViewBoxAction.setEnabled(false);
            screenManager.setShowAllArea(true);
        } else {
            this.showViewBoxAction.setEnabled(true);
        }
        this.showViewBoxToggleButton.setSelected(screenManager.getShowAllArea());
        jComponent.requestFocus();
        this.repaintAll();
    }

    private void doDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getDroppedDataObject(dropTargetDragEvent) != null) {
            dropTargetDragEvent.acceptDrag(3);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private void doDrop(DropTargetDropEvent dropTargetDropEvent) {
        DataObject dataObject = this.getDroppedDataObject(dropTargetDropEvent);
        if (dataObject != null) {
            dropTargetDropEvent.acceptDrop(3);
            try {
                if (this.dropDataObject(dataObject)) {
                    dropTargetDropEvent.dropComplete(true);
                }
            }
            catch (Exception exception) {
                SceneManager.error("Could not obtain dropped data.", exception);
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public boolean dropDataObject(DataObject dataObject) throws IOException, SAXException, DocumentModelException, BadLocationException {
        if (dataObject instanceof XMLDataObject) {
            Document document = ((XMLDataObject)dataObject).getDocument();
            NodeList nodeList = document.getElementsByTagName("body");
            if (nodeList.getLength() > 0) {
                String string = nodeList.item(0).getTextContent();
                SceneManager.log(Level.INFO, "Dropping text: \"" + string + "\"");
                String string2 = this.m_svgDataObject.getModel().mergeImage(string, false);
                this.getSceneManager().setSelection(string2, true);
            } else {
                SceneManager.log(Level.SEVERE, "Nothing to drop, empty body!");
            }
            return true;
        }
        if (dataObject instanceof SVGPaletteItemDataObject) {
            this.dropFile(((SVGPaletteItemDataObject)dataObject).getReferencedFile());
            return true;
        }
        if (dataObject instanceof SVGDataObject) {
            this.dropFile(FileUtil.toFile((FileObject)dataObject.getPrimaryFile()));
            return true;
        }
        return false;
    }

    private void dropFile(File file) throws FileNotFoundException, IOException, DocumentModelException, BadLocationException {
        if (file != null && file.exists() && file.isFile()) {
            SceneManager.log(Level.INFO, "Dropping file " + file.getPath());
            String string = this.m_svgDataObject.getModel().mergeImage(file);
            this.getSceneManager().setSelection(string, true);
        } else {
            SceneManager.log(Level.SEVERE, "Nothing to drop, file " + file + " not found");
        }
    }

    private DataObject getDroppedDataObject(DropTargetEvent dropTargetEvent) {
        if (!this.getSceneManager().isReadOnly()) {
            DataFlavor[] dataFlavorArray;
            for (DataFlavor dataFlavor : dataFlavorArray = dropTargetEvent instanceof DropTargetDragEvent ? ((DropTargetDragEvent)dropTargetEvent).getCurrentDataFlavors() : ((DropTargetDropEvent)dropTargetEvent).getCurrentDataFlavors()) {
                if (!DND_PALETTE_MIME.equals(dataFlavor.getSubType())) continue;
                try {
                    Transferable transferable = dropTargetEvent instanceof DropTargetDragEvent ? ((DropTargetDragEvent)dropTargetEvent).getTransferable() : ((DropTargetDropEvent)dropTargetEvent).getTransferable();
                    DataObject dataObject = (DataObject)transferable.getTransferData(dataFlavor);
                    if (dataObject instanceof XMLDataObject || dataObject instanceof SVGPaletteItemDataObject || dataObject instanceof SVGDataObject) {
                        return dataObject;
                    }
                }
                catch (Exception exception) {
                    SceneManager.error("Failed to get dropped data object", exception);
                }
            }
        }
        return null;
    }

    public void selectionChanged(SVGObject[] sVGObjectArray, SVGObject[] sVGObjectArray2, boolean bl) {
        this.updateDataTransferActions();
    }

    private void repaintAll() {
        this.getScreenManager().getAnimatorView().invalidate();
        this.basePanel.validate();
        this.basePanel.repaint();
    }

    private SVGFileModel getModel() {
        return this.m_svgDataObject.getModel();
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    private static void enableComponentsInToolbar(Container container, boolean bl, Component ... componentArray) {
        block0: for (Component component : container.getComponents()) {
            if (componentArray != null) {
                for (Component component2 : componentArray) {
                    if (component2 == component) continue block0;
                }
            }
            component.setEnabled(bl);
            SVGViewTopComponent.enableComponentsInToolbar((Container)component, bl, new Component[0]);
        }
    }

    private class SVGCookie
    implements SelectionCookie,
    AnimationCookie {
        private SVGCookie() {
        }

        public void startAnimation(SVGDataObject sVGDataObject, final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SVGViewTopComponent.this.startAnimationAction.actionPerformed(null);
                    SVGViewTopComponent.this.getPerseusController().startAnimation(string);
                }
            });
        }

        public void stopAnimation(SVGDataObject sVGDataObject, final String string) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SVGViewTopComponent.this.getPerseusController().stopAnimation(string);
                }
            });
        }

        public void updateSelection(SVGDataObject sVGDataObject, final String string, int n, boolean bl) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SVGViewTopComponent.this.getSceneManager().setSelection(string, false);
                }
            });
        }
    }

    private class ZoomOutAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;

        ZoomOutAction() {
            super("svg_zoom_out");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScreenManager screenManager = SVGViewTopComponent.this.getScreenManager();
            screenManager.setZoomRatio(screenManager.getZoomRatio() / 1.1f);
            SVGViewTopComponent.this.updateZoomCombo();
        }
    }

    private class ZoomInAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;

        ZoomInAction() {
            super("svg_zoom_in");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScreenManager screenManager = SVGViewTopComponent.this.getScreenManager();
            screenManager.setZoomRatio(screenManager.getZoomRatio() * 1.1f);
            SVGViewTopComponent.this.updateZoomCombo();
        }
    }

    private class ZoomToFitAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;

        ZoomToFitAction() {
            super("svg_zoom_fit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScreenManager screenManager = SVGViewTopComponent.this.getScreenManager();
            Rectangle rectangle = screenManager.getImageBounds();
            Rectangle rectangle2 = screenManager.getComponent().getBounds();
            float f = Math.min((float)(rectangle2.width - 20) / (float)rectangle.width, (float)(rectangle2.height - 20) / (float)rectangle.height);
            screenManager.setZoomRatio(f * screenManager.getZoomRatio());
            SVGViewTopComponent.this.updateZoomCombo();
        }
    }

    private class ToggleShowViewBoxAction
    extends AbstractSVGAction
    implements Presenter.Popup {
        private static final long serialVersionUID = 5862679852552354L;

        ToggleShowViewBoxAction() {
            super("svg_toggle_view");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScreenManager screenManager = SVGViewTopComponent.this.getScreenManager();
            boolean bl = !screenManager.getShowAllArea();
            screenManager.setShowAllArea(bl);
            SVGViewTopComponent.this.showViewBoxToggleButton.setSelected(bl);
            SVGViewTopComponent.this.repaint();
        }
    }

    private class ToggleScaleAction
    extends AbstractSVGAction {
        private static final long serialVersionUID = 5862679852552354L;
        private float m_previousZoomRatio;

        ToggleScaleAction() {
            super("svg_toggle_scale");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ScreenManager screenManager = SVGViewTopComponent.this.getScreenManager();
            SVGViewTopComponent.this.doScale = !SVGViewTopComponent.this.doScale;
            if (SVGViewTopComponent.this.doScale) {
                Dimension dimension;
                this.m_previousZoomRatio = screenManager.getZoomRatio();
                String string = null;
                FileObject fileObject = SVGViewTopComponent.this.m_svgDataObject.getPrimaryFile();
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null && project instanceof J2MEProject) {
                    dimension = (J2MEProject)project;
                    string = dimension.getConfigurationHelper().getActiveConfiguration().getDisplayName();
                }
                dimension = ScreenSizeHelper.getCurrentDeviceScreenSize(fileObject, string);
                Rectangle rectangle = screenManager.getImageBounds();
                float f = (float)(dimension.getHeight() / rectangle.getHeight());
                screenManager.setZoomRatio(f * this.m_previousZoomRatio);
            } else {
                screenManager.setZoomRatio(this.m_previousZoomRatio);
            }
            SVGViewTopComponent.this.scaleToggleButton.setSelected(SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomInAction.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomOutAction.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomToFitAction.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.zoomComboBox.setEnabled(!SVGViewTopComponent.this.doScale);
            SVGViewTopComponent.this.repaint();
        }
    }

    private class ButtonMouseListener
    extends MouseUtils.PopupMouseAdapter {
        private ButtonMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JButton jButton;
            if (mouseEvent.getSource() instanceof JButton && (jButton = (JButton)mouseEvent.getSource()).isEnabled()) {
                jButton.setContentAreaFilled(true);
                jButton.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            JButton jButton;
            if (mouseEvent.getSource() instanceof JButton && (jButton = (JButton)mouseEvent.getSource()).isEnabled()) {
                jButton.setContentAreaFilled(false);
                jButton.setBorderPainted(false);
            }
        }

        protected void showPopup(MouseEvent mouseEvent) {
        }
    }

    private class SVGElementNode
    extends AbstractNode {
        SVGElementNode(Lookup lookup) {
            super(Children.LEAF, lookup);
        }

        protected Class[] cookieClasses() {
            return new Class[]{SVGObject.class};
        }

        public Action[] getActions(boolean bl) {
            return new SystemAction[]{SystemAction.get(SaveElementAsImage.class)};
        }
    }

    private static class LoadPanel
    extends JPanel {
        private static final long serialVersionUID = 5862679852552354L;

        LoadPanel() {
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
            JLabel jLabel = new JLabel(NbBundle.getMessage(SVGViewTopComponent.class, (String)"MSG_Loading"));
            jLabel.setBackground(Color.WHITE);
            Font font = jLabel.getFont();
            jLabel.setFont(font.deriveFont(20.0f));
            this.add((Component)jLabel, "Center");
        }
    }

    private final class UpdateThread
    extends Thread {
        public UpdateThread() {
            super("AnimatorTimeUpdater");
            this.setDaemon(true);
            this.setPriority(1);
        }

        public void run() {
            try {
                PerseusController perseusController;
                while ((perseusController = SVGViewTopComponent.this.getPerseusController()) != null && !this.isInterrupted()) {
                    if (perseusController.getAnimatorState() == 2) {
                        final float f = perseusController.getAnimatorTime();
                        final float f2 = SVGViewTopComponent.this.getSceneManager().getAnimationDuration();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SVGViewTopComponent.this.updateAnimationTime(f, f2);
                            }
                        });
                    }
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

