/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.api.variables;

import org.netbeans.modules.bpel.debugger.api.variables.Value;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public interface XmlElementValue
extends Value {
    public static final String VALUE_OBJECT_KEY = "ValueObject";
    public static final String XPATH_KEY = "Xpath";

    public Element getElement();

    public static final class Helper {
        private Helper() {
        }

        public static XmlElementValue find(Node node) {
            Node node2 = node.getNodeType() == 9 ? node : node.getOwnerDocument();
            Object object = node2.getUserData(XmlElementValue.VALUE_OBJECT_KEY);
            if (object instanceof XmlElementValue) {
                return (XmlElementValue)object;
            }
            return null;
        }

        public static void bind(Document document, XmlElementValue xmlElementValue) {
            document.setUserData(XmlElementValue.VALUE_OBJECT_KEY, xmlElementValue, null);
        }

        public static String xpath(Node node) {
            StringBuffer stringBuffer = new StringBuffer(255);
            if (node.getNodeType() == 1) {
                Helper.appendElementXpath(node, stringBuffer);
            } else {
                Object object = node.getUserData(XmlElementValue.XPATH_KEY);
                if (object != null) {
                    return (String)object;
                }
                if (node.getNodeType() == 2) {
                    Helper.appendElementXpath(((Attr)node).getOwnerElement(), stringBuffer);
                    stringBuffer.append("/@").append(node.getNodeName());
                } else if (node.getNodeType() == 3) {
                    Helper.appendElementXpath(node.getParentNode(), stringBuffer);
                    stringBuffer.append("/text()");
                } else {
                    Helper.appendElementXpath(node.getParentNode(), stringBuffer);
                }
                node.setUserData(XmlElementValue.XPATH_KEY, stringBuffer.toString(), null);
            }
            return stringBuffer.toString();
        }

        private static void appendElementXpath(Node node, StringBuffer stringBuffer) {
            assert (node.getNodeType() == 1);
            Object object = node.getUserData(XmlElementValue.XPATH_KEY);
            if (object != null) {
                stringBuffer.append((String)object);
                return;
            }
            Node node2 = node.getParentNode();
            if (node2.getNodeType() == 9) {
                return;
            }
            Helper.appendElementXpath(node2, stringBuffer);
            int n = 1;
            for (Node node3 = node.getPreviousSibling(); node3 != null; node3 = node3.getPreviousSibling()) {
                if (node3.getNodeType() != 1) continue;
                ++n;
            }
            stringBuffer.append("/node()[").append(n).append(']');
            node.setUserData(XmlElementValue.XPATH_KEY, stringBuffer.toString(), null);
        }
    }
}

