/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.Settings;
import org.netbeans.modules.javascript.editing.CodeStyle;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FmtOptions {
    public static final String expandTabToSpaces = "expandTabToSpaces";
    public static final String tabSize = "tabSize";
    public static final String indentSize = "indentSize";
    public static final String continuationIndentSize = "continuationIndentSize";
    public static final String reformatComments = "reformatComments";
    public static final String indentHtml = "indentHtml";
    public static final String rightMargin = "rightMargin";
    public static CodeStyleProducer codeStyleProducer;
    public static Preferences lastValues;
    private static Class<? extends EditorKit> kitClass;
    private static final String DEFAULT_PROFILE = "default";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static Map<String, String> defaults;

    private FmtOptions() {
    }

    public static int getDefaultAsInt(String string) {
        return Integer.parseInt(defaults.get(string));
    }

    public static boolean getDefaultAsBoolean(String string) {
        return Boolean.parseBoolean(defaults.get(string));
    }

    public static String getDefaultAsString(String string) {
        return defaults.get(string);
    }

    public static Preferences getPreferences(String string) {
        return NbPreferences.forModule(CodeStyle.class).node("CodeStyle").node(string);
    }

    public static boolean getGlobalExpandTabToSpaces() {
        Formatter formatter = (Formatter)Settings.getValue(FmtOptions.getKitClass(), (String)"formatter");
        if (formatter != null) {
            return formatter.expandTabs();
        }
        return FmtOptions.getDefaultAsBoolean(expandTabToSpaces);
    }

    public static int getGlobalTabSize() {
        Integer n = (Integer)Settings.getValue(FmtOptions.getKitClass(), (String)"tab-size");
        return n != null ? n : FmtOptions.getDefaultAsInt(tabSize);
    }

    public static int getGlobalRightMargin() {
        Integer n = (Integer)Settings.getValue(FmtOptions.getKitClass(), (String)"text-limit-width");
        return n != null ? n : FmtOptions.getDefaultAsInt(rightMargin);
    }

    public static Class<? extends EditorKit> getKitClass() {
        if (kitClass == null) {
            EditorKit editorKit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/javascript")).lookup(EditorKit.class);
            kitClass = editorKit != null ? editorKit.getClass() : EditorKit.class;
        }
        return kitClass;
    }

    public static void flush() {
        try {
            FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()).flush();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    public static String getCurrentProfileId() {
        return DEFAULT_PROFILE;
    }

    public static CodeStyle createCodeStyle(Preferences preferences) {
        CodeStyle.getDefault(null);
        return codeStyleProducer.create(preferences);
    }

    public static boolean isInteger(String string) {
        String string2 = defaults.get(string);
        try {
            Integer.parseInt(string2);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getLastValue(String string) {
        Preferences preferences = lastValues == null ? FmtOptions.getPreferences(FmtOptions.getCurrentProfileId()) : lastValues;
        return preferences.get(string, FmtOptions.getDefaultAsString(string));
    }

    private static void createDefaults() {
        String[][] stringArrayArray = new String[][]{{expandTabToSpaces, TRUE}, {tabSize, "8"}, {indentSize, "4"}, {continuationIndentSize, "4"}, {reformatComments, FALSE}, {indentHtml, TRUE}, {rightMargin, "80"}};
        defaults = new HashMap<String, String>();
        for (String[] stringArray : stringArrayArray) {
            defaults.put(stringArray[0], stringArray[1]);
        }
    }

    static {
        FmtOptions.createDefaults();
    }

    public static interface CodeStyleProducer {
        public CodeStyle create(Preferences var1);
    }
}

