/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.BracketCompletion;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.EditorOptions;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.NbUtilities;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsBracketCompleter
implements BracketCompletion {
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("js.cont.comment");
    private static final TokenId[] STRING_TOKENS = new TokenId[]{JsTokenId.STRING_LITERAL, JsTokenId.STRING_END};
    private static final TokenId[] REGEXP_TOKENS = new TokenId[]{JsTokenId.REGEXP_LITERAL, JsTokenId.REGEXP_END};
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument baseDocument) {
        EditorOptions editorOptions = EditorOptions.get((String)"text/javascript");
        if (editorOptions != null) {
            return editorOptions.getMatchBrackets();
        }
        return true;
    }

    public int beforeBreak(Document document, int n, JTextComponent jTextComponent) throws BadLocationException {
        boolean bl;
        int n2;
        int n3;
        String string;
        boolean bl2;
        int n4;
        String string2;
        boolean bl3;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        boolean bl4 = this.isInsertMatchingEnabled(baseDocument);
        int n5 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n5 == n && n6 == n) {
            return -1;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        int[] nArray = new int[1];
        boolean bl5 = bl3 = bl4 && JsBracketCompleter.isEndMissing(baseDocument, n, false, blArray, blArray2, null, nArray);
        if (bl3) {
            boolean bl6 = blArray[0];
            boolean bl7 = blArray2[0];
            int n7 = nArray[0];
            int n8 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
            StringBuilder stringBuilder = new StringBuilder();
            if (n > n8) {
                stringBuilder.append("\n");
                LexUtilities.indent(stringBuilder, n7);
            } else {
                String string3 = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n8) - n);
                stringBuilder.append(string3);
                stringBuilder.append("\n");
                LexUtilities.indent(stringBuilder, n7);
                baseDocument.remove(n, string3.length());
            }
            if (bl6) {
                stringBuilder.append("end");
            } else {
                assert (bl7);
                stringBuilder.append("}");
            }
            int n9 = n;
            baseDocument.insertString(n9, stringBuilder.toString(), null);
            caret.setDot(n9);
            return -1;
        }
        if (tokenId == JsTokenId.ERROR && (string2 = ((Object)token.text()).toString()).startsWith("/*") && tokenSequence.offset() == Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) {
            int n10 = LexUtilities.getLineIndent(baseDocument, n);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(LexUtilities.getIndentString(n10));
            stringBuilder.append(" * ");
            int n11 = stringBuilder.length() + 1;
            stringBuilder.append("\n");
            stringBuilder.append(LexUtilities.getIndentString(n10));
            stringBuilder.append(" */");
            baseDocument.insertString(n, stringBuilder.toString(), null);
            caret.setDot(n);
            return n + n11;
        }
        if (tokenId == JsTokenId.STRING_LITERAL || tokenId == JsTokenId.STRING_END && n < tokenSequence.offset() + tokenSequence.token().length()) {
            string2 = tokenId != JsTokenId.STRING_LITERAL || n > tokenSequence.offset() ? "\\n\\" : "\\";
            baseDocument.insertString(n, string2, null);
            caret.setDot(n + string2.length());
            return n + 1 + string2.length();
        }
        if (tokenId == JsTokenId.REGEXP_LITERAL || tokenId == JsTokenId.REGEXP_END && n < tokenSequence.offset() + tokenSequence.token().length()) {
            string2 = tokenId != JsTokenId.REGEXP_LITERAL || n > tokenSequence.offset() ? "\\n\\" : "\\";
            baseDocument.insertString(n, string2, null);
            caret.setDot(n + string2.length());
            return n + 1 + string2.length();
        }
        if ((tokenId == JsTokenId.RBRACE || tokenId == JsTokenId.RBRACKET) && Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n) == n) {
            int n12 = LexUtilities.getLineIndent(baseDocument, n);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n");
            LexUtilities.indent(stringBuilder, n12);
            int n13 = n;
            baseDocument.insertString(n13, stringBuilder.toString(), null);
            caret.setDot(n13);
        }
        if (tokenId == JsTokenId.WHITESPACE && (n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) != -1 && n < n4) {
            tokenSequence.move(n4);
            if (tokenSequence.moveNext() && (tokenId = tokenSequence.token().id()) == JsTokenId.LINE_COMMENT) {
                n = n4;
            }
        }
        if (tokenId == JsTokenId.BLOCK_COMMENT && n > tokenSequence.offset() && ((bl2 = (string = baseDocument.getText(n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n), (n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1) - n3)).startsWith("/*")) || string.startsWith("*"))) {
            int n14;
            int n15;
            int n16 = LexUtilities.getLineIndent(baseDocument, n);
            StringBuilder stringBuilder = new StringBuilder();
            if (bl2) {
                ++n16;
            }
            LexUtilities.indent(stringBuilder, n16);
            stringBuilder.append("*");
            int n17 = bl2 ? n3 + 2 : n3 + 1;
            string = baseDocument.getText(n17, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n17) - n17);
            for (n15 = 0; n15 < string.length() && ((n14 = string.charAt(n15)) == 32 || n14 == 9); ++n15) {
                stringBuilder.append((char)n14);
            }
            n15 = n;
            if (n == n3 && n15 > 0) {
                n15 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                n14 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + stringBuilder.length();
                baseDocument.insertString(n15, stringBuilder.toString(), null);
                caret.setDot(n14);
                return n14;
            }
            baseDocument.insertString(n15, stringBuilder.toString(), null);
            caret.setDot(n15);
            return n15 + stringBuilder.length() + 1;
        }
        boolean bl8 = bl = tokenId == JsTokenId.LINE_COMMENT;
        if (tokenId == JsTokenId.EOL && tokenSequence.movePrevious() && tokenSequence.token().id() == JsTokenId.LINE_COMMENT) {
            bl = true;
        }
        if (bl) {
            Token<? extends JsTokenId> token2;
            int n18;
            Token<? extends JsTokenId> token3;
            int n19;
            boolean bl9 = false;
            int n20 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            bl2 = false;
            boolean bl10 = false;
            int n21 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (n21 > 0 && (n19 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n21 - 1))) != -1 && (token3 = LexUtilities.getToken(baseDocument, n19)) != null && token3.id() == JsTokenId.LINE_COMMENT) {
                bl2 = true;
            }
            if ((n19 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n)) < baseDocument.getLength() && (n18 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)(n19 + 1))) != -1 && (token2 = LexUtilities.getToken(baseDocument, n18)) != null && token2.id() == JsTokenId.LINE_COMMENT) {
                bl10 = true;
            }
            if (bl2 || bl10 || n > tokenSequence.offset() && n < tokenSequence.offset() + tokenSequence.token().length()) {
                Token<? extends JsTokenId> token4;
                int n22;
                int n23;
                Token<? extends JsTokenId> token5;
                if (tokenSequence.offset() + token.length() > n + 1) {
                    String string4 = baseDocument.getText(n, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) - n);
                    if (string4.trim().length() != 0) {
                        bl9 = true;
                    }
                } else if (CONTINUE_COMMENTS && (token5 = LexUtilities.getToken(baseDocument, n20)).id() == JsTokenId.LINE_COMMENT) {
                    bl9 = true;
                }
                if (!bl9 && (n23 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1) < baseDocument.getLength() && (n22 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n23)) != -1 && (token4 = LexUtilities.getToken(baseDocument, n22)) != null && token4.id() == JsTokenId.LINE_COMMENT) {
                    bl9 = true;
                }
            }
            if (bl9) {
                int n24;
                int n25;
                int n26 = LexUtilities.getLineIndent(baseDocument, n);
                StringBuilder stringBuilder = new StringBuilder();
                LexUtilities.indent(stringBuilder, n26);
                stringBuilder.append("//");
                int n27 = n20 + 2;
                String string5 = baseDocument.getText(n27, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n27) - n27);
                for (n25 = 0; n25 < string5.length() && ((n24 = string5.charAt(n25)) == 32 || n24 == 9); ++n25) {
                    stringBuilder.append((char)n24);
                }
                n25 = n;
                if (n == n20 && n25 > 0) {
                    n25 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                    n24 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n) + stringBuilder.length();
                    baseDocument.insertString(n25, stringBuilder.toString(), null);
                    caret.setDot(n24);
                    return n24;
                }
                baseDocument.insertString(n25, stringBuilder.toString(), null);
                caret.setDot(n25);
                return n25 + stringBuilder.length() + 1;
            }
        }
        return -1;
    }

    static boolean isEndMissing(BaseDocument baseDocument, int n, boolean bl, boolean[] blArray, boolean[] blArray2, int[] nArray, int[] nArray2) throws BadLocationException {
        int n2 = baseDocument.getLength();
        if (nArray != null) {
            nArray[0] = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        }
        int n3 = LexUtilities.getBeginEndLineBalance(baseDocument, n, true);
        int n4 = LexUtilities.getLineBalance(baseDocument, n, JsTokenId.LBRACE, JsTokenId.RBRACE);
        if (n3 == 1 || n4 == 1) {
            int n5 = LexUtilities.getLineIndent(baseDocument, n);
            boolean bl2 = n3 > 0;
            boolean bl3 = n4 > 0;
            int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n) + 1;
            while (n6 < n2) {
                if (!(Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n6) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n6) || LexUtilities.isCommentOnlyLine(baseDocument, n6))) {
                    int n7 = LexUtilities.getLineIndent(baseDocument, n6);
                    if (n7 > n5) {
                        bl2 = false;
                        bl3 = false;
                        break;
                    }
                    if (n7 != n5) break;
                    if (bl2) {
                        if (LexUtilities.getBeginEndLineBalance(baseDocument, n6, false) < 0) {
                            bl2 = false;
                            break;
                        }
                        int n8 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n6);
                        Token<? extends JsTokenId> token = LexUtilities.getToken(baseDocument, n8);
                        if (token == null || !LexUtilities.isIndentToken(token.id()) || LexUtilities.isBeginToken(token.id(), baseDocument, n8)) break;
                        bl2 = false;
                        break;
                    }
                    if (!bl3 || LexUtilities.getLineBalance(baseDocument, n6, JsTokenId.LBRACE, JsTokenId.RBRACE) >= 0) break;
                    bl3 = false;
                    break;
                }
                n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n6) + 1;
            }
            if (blArray != null) {
                blArray[0] = bl2;
            }
            if (blArray2 != null) {
                blArray2[0] = bl3;
            }
            if (nArray2 != null) {
                nArray2[0] = n5;
            }
            return bl2 || bl3;
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence<? extends JsTokenId> tokenSequence;
        TokenSequence<? extends JsTokenId> tokenSequence2;
        this.isAfter = false;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(baseDocument)) {
            return false;
        }
        if (jTextComponent.getSelectionStart() != -1) {
            String string;
            char c2;
            if (NbUtilities.isCodeTemplateEditing((Document)baseDocument)) {
                int n2 = jTextComponent.getSelectionStart();
                if (n2 < (c2 = jTextComponent.getSelectionEnd())) {
                    jTextComponent.setSelectionStart(n2);
                    jTextComponent.setSelectionEnd(n2);
                    n = n2;
                    caret.setDot(n);
                    baseDocument.remove(n2, c2 - n2);
                }
            } else if ((c == '\"' || c == '\'' || c == '(' || c == '{' || c == '[' || c == '/') && (string = jTextComponent.getSelectedText()) != null && string.length() > 0 && (c2 = (char)string.charAt(0)) != c) {
                int n3 = jTextComponent.getSelectionStart();
                int n4 = jTextComponent.getSelectionEnd();
                tokenSequence2 = LexUtilities.getPositionedSequence(baseDocument, n3);
                if (tokenSequence2 != null && tokenSequence2.token().id() != JsTokenId.STRING_LITERAL) {
                    char c3 = string.charAt(string.length() - 1);
                    if (string.length() > 1 && (c2 == '\"' || c2 == '\'' || c2 == '(' || c2 == '{' || c2 == '[' || c2 == '/') && c3 == this.matching(c2)) {
                        baseDocument.remove(n4 - 1, 1);
                        baseDocument.insertString(n4 - 1, "" + this.matching(c), null);
                        baseDocument.remove(n3, 1);
                        baseDocument.insertString(n3, "" + c, null);
                        jTextComponent.getCaret().setDot(n4);
                    } else {
                        baseDocument.remove(n3, n4 - n3);
                        baseDocument.insertString(n3, c + string + this.matching(c), null);
                        jTextComponent.getCaret().setDot(n3 + string.length() + 2);
                    }
                    return true;
                }
            }
        }
        if ((tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n)) == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        TokenId[] tokenIdArray = null;
        tokenSequence2 = null;
        if (c == '\"' || c == '\'') {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = JsTokenId.STRING_BEGIN;
        } else if (tokenId == JsTokenId.ERROR) {
            tokenSequence.movePrevious();
            TokenSequence<? extends JsTokenId> tokenSequence3 = tokenSequence.token().id();
            if (tokenSequence3 == JsTokenId.STRING_BEGIN) {
                tokenIdArray = STRING_TOKENS;
                tokenSequence2 = tokenSequence3;
            } else if (tokenSequence3 == JsTokenId.REGEXP_BEGIN) {
                tokenIdArray = REGEXP_TOKENS;
                tokenSequence2 = JsTokenId.REGEXP_BEGIN;
            }
        } else if (tokenId == JsTokenId.STRING_BEGIN && n == tokenSequence.offset() + 1) {
            if (!Character.isLetter(c)) {
                tokenIdArray = STRING_TOKENS;
                tokenSequence2 = tokenId;
            }
        } else if (tokenId == JsTokenId.STRING_BEGIN && n == tokenSequence.offset() + 2 || tokenId == JsTokenId.STRING_END) {
            tokenIdArray = STRING_TOKENS;
            tokenSequence2 = JsTokenId.STRING_BEGIN;
        } else if (tokenId == JsTokenId.REGEXP_BEGIN && n == tokenSequence.offset() + 2 || tokenId == JsTokenId.REGEXP_END) {
            tokenIdArray = REGEXP_TOKENS;
            tokenSequence2 = JsTokenId.REGEXP_BEGIN;
        }
        if (tokenIdArray != null) {
            boolean bl = this.completeQuote(baseDocument, n, caret, c, tokenIdArray, (TokenId)tokenSequence2);
            if (bl) {
                caret.setDot(n + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        TokenSequence<? extends JsTokenId> tokenSequence;
        this.isAfter = true;
        Caret caret = jTextComponent.getCaret();
        BaseDocument baseDocument = (BaseDocument)document;
        if (this.previousAdjustmentOffset != -1) {
            if (n == this.previousAdjustmentOffset && (tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n)) != null) {
                tokenSequence.move(n);
                if (tokenSequence.moveNext() && tokenSequence.offset() < n) {
                    LexUtilities.setLineIndentation(baseDocument, n, this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (c) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                tokenSequence = LexUtilities.getToken(baseDocument, n);
                if (tokenSequence == null) {
                    return true;
                }
                TokenId tokenId = tokenSequence.id();
                if (tokenId == JsTokenId.ANY_OPERATOR) {
                    int n2 = tokenSequence.length();
                    String string = ((Object)tokenSequence.text()).toString();
                    if (n2 == 2 && "[]".equals(string) || "[]=".equals(string)) {
                        this.skipClosingBracket(baseDocument, caret, c, JsTokenId.RBRACKET);
                        return true;
                    }
                }
                if (tokenId == JsTokenId.IDENTIFIER && tokenSequence.length() == 1 || tokenId == JsTokenId.LBRACKET || tokenId == JsTokenId.RBRACKET || tokenId == JsTokenId.LBRACE || tokenId == JsTokenId.RBRACE || tokenId == JsTokenId.LPAREN || tokenId == JsTokenId.RPAREN) {
                    if (c == ']') {
                        this.skipClosingBracket(baseDocument, caret, c, JsTokenId.RBRACKET);
                    } else if (c == ')') {
                        this.skipClosingBracket(baseDocument, caret, c, JsTokenId.RPAREN);
                    } else if (c == '}') {
                        this.skipClosingBracket(baseDocument, caret, c, JsTokenId.RBRACE);
                    } else if (c == '[' || c == '(' || c == '{') {
                        this.completeOpeningBracket(baseDocument, n, caret, c);
                    }
                }
                if (c == '}') {
                    this.reindent(baseDocument, n, JsTokenId.RBRACE, caret);
                    break;
                }
                if (c != ']') break;
                this.reindent(baseDocument, n, JsTokenId.RBRACKET, caret);
                break;
            }
            case '/': {
                if (!this.isInsertMatchingEnabled(baseDocument)) {
                    return false;
                }
                tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
                if (tokenSequence == null) break;
                Token token = tokenSequence.token();
                TokenId tokenId = token.id();
                if (tokenId == JsTokenId.LINE_COMMENT && n == tokenSequence.offset() + 1 && n + 1 < baseDocument.getLength() && baseDocument.getText(n + 1, 1).charAt(0) == '/') {
                    baseDocument.remove(n, 1);
                    caret.setDot(n + 1);
                    return true;
                }
                if (tokenId != JsTokenId.REGEXP_BEGIN && tokenId != JsTokenId.REGEXP_END) break;
                TokenId[] tokenIdArray = REGEXP_TOKENS;
                JsTokenId jsTokenId = JsTokenId.REGEXP_BEGIN;
                boolean bl = this.completeQuote(baseDocument, n, caret, c, tokenIdArray, jsTokenId);
                if (bl) {
                    caret.setDot(n + 1);
                }
                return bl;
            }
        }
        return true;
    }

    private void reindent(BaseDocument baseDocument, int n, TokenId tokenId, Caret caret) throws BadLocationException {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return;
            }
            Token token = tokenSequence.token();
            if (token.id() == tokenId) {
                int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
                if (tokenSequence.offset() > n2) {
                    return;
                }
                OffsetRange offsetRange = tokenId == JsTokenId.RBRACE ? LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LBRACE, JsTokenId.RBRACE) : (tokenId == JsTokenId.RBRACKET ? LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LBRACKET, JsTokenId.RBRACKET) : LexUtilities.findBegin(baseDocument, tokenSequence));
                if (offsetRange != OffsetRange.NONE) {
                    int n3 = offsetRange.getStart();
                    int n4 = LexUtilities.getLineIndent(baseDocument, n3);
                    this.previousAdjustmentIndent = LexUtilities.getLineIndent(baseDocument, n);
                    LexUtilities.setLineIndentation(baseDocument, n, n4);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) {
                return OffsetRange.NONE;
            }
            Token token = tokenSequence.token();
            if (token == null) {
                return OffsetRange.NONE;
            }
            TokenId tokenId = token.id();
            if (tokenId == JsTokenId.WHITESPACE) {
                tokenSequence.move(++n);
                if (tokenSequence.moveNext() && tokenSequence.offset() <= n) {
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
            }
            if (tokenId == JsTokenId.STRING_BEGIN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END);
            }
            if (tokenId == JsTokenId.STRING_END) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.STRING_BEGIN, JsTokenId.STRING_END);
            }
            if (tokenId == JsTokenId.REGEXP_BEGIN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, JsTokenId.REGEXP_BEGIN, JsTokenId.REGEXP_END);
            }
            if (tokenId == JsTokenId.REGEXP_END) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.REGEXP_BEGIN, JsTokenId.REGEXP_END);
            }
            if (tokenId == JsTokenId.LPAREN) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, JsTokenId.LPAREN, JsTokenId.RPAREN);
            }
            if (tokenId == JsTokenId.RPAREN) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LPAREN, JsTokenId.RPAREN);
            }
            if (tokenId == JsTokenId.LBRACE) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, JsTokenId.LBRACE, JsTokenId.RBRACE);
            }
            if (tokenId == JsTokenId.RBRACE) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LBRACE, JsTokenId.RBRACE);
            }
            if (tokenId == JsTokenId.LBRACKET) {
                return LexUtilities.findFwd(baseDocument, tokenSequence, JsTokenId.LBRACKET, JsTokenId.RBRACKET);
            }
            if (tokenId == JsTokenId.RBRACKET) {
                return LexUtilities.findBwd(baseDocument, tokenSequence, JsTokenId.LBRACKET, JsTokenId.RBRACKET);
            }
        }
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int n, JTextComponent jTextComponent, char c) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)document;
        switch (c) {
            case ' ': {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
                if (tokenSequence == null || tokenSequence.token().id() != JsTokenId.LINE_COMMENT || tokenSequence.offset() != n - 2) break;
                baseDocument.remove(n - 2, 2);
                jTextComponent.getCaret().setDot(n - 2);
                return true;
            }
            case '(': 
            case '[': 
            case '{': {
                char c2 = LexUtilities.getTokenChar(baseDocument, n);
                if (!(c2 == ']' && LexUtilities.getTokenBalance(baseDocument, JsTokenId.LBRACKET, JsTokenId.RBRACKET, n) != 0 || c2 == ')' && LexUtilities.getTokenBalance(baseDocument, JsTokenId.LPAREN, JsTokenId.RPAREN, n) != 0) && (c2 != '}' || LexUtilities.getTokenBalance(baseDocument, JsTokenId.LBRACE, JsTokenId.RBRACE, n) == 0)) break;
                baseDocument.remove(n, 1);
                break;
            }
            case '/': {
                Object object = LexUtilities.getPositionedSequence(baseDocument, n);
                if (object != null && object.token().id() == JsTokenId.REGEXP_BEGIN && object.offset() == n - 1) {
                    baseDocument.remove(n - 1, 1);
                    jTextComponent.getCaret().setDot(n - 1);
                    return true;
                }
            }
            case '\"': 
            case '\'': 
            case '|': {
                Object object = baseDocument.getChars(n, 1);
                if (object == null || object[0] != c) break;
                baseDocument.remove(n, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c, TokenId tokenId) throws BadLocationException {
        int n = caret.getDot();
        if (this.isSkipClosingBracket(baseDocument, n, tokenId)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument baseDocument, int n, TokenId tokenId) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return false;
        }
        Token token = tokenSequence.token();
        if (token != null && token.id() == tokenId) {
            int n2 = tokenId.ordinal();
            int n3 = n2 == JsTokenId.RPAREN.ordinal() ? JsTokenId.LPAREN.ordinal() : JsTokenId.LBRACKET.ordinal();
            tokenSequence.moveNext();
            Token token2 = tokenSequence.token();
            while (token2 != null && token2.id() == tokenId) {
                token = token2;
                if (!tokenSequence.moveNext()) break;
                token2 = tokenSequence.token();
            }
            int n4 = 0;
            int n5 = -1;
            Token token3 = token;
            tokenSequence.movePrevious();
            token = tokenSequence.token();
            boolean bl2 = false;
            while (!bl2 && token != null) {
                int n6 = ((JsTokenId)token.id()).ordinal();
                if (token.id() == JsTokenId.LPAREN || token.id() == JsTokenId.LBRACKET) {
                    if (n6 == n2 && ++n5 == 0) {
                        if (n4 != 0) {
                            n5 = 1;
                        }
                        bl2 = true;
                    }
                } else if (token.id() == JsTokenId.RPAREN || token.id() == JsTokenId.RBRACKET) {
                    if (n6 == n2) {
                        --n5;
                    }
                } else if (token.id() == JsTokenId.LBRACE) {
                    if (++n4 > 0) {
                        bl2 = true;
                    }
                } else if (token.id() == JsTokenId.RBRACE) {
                    --n4;
                }
                if (!tokenSequence.movePrevious()) break;
                token = tokenSequence.token();
            }
            if (n5 != 0) {
                bl = true;
            } else {
                n4 = 0;
                n5 = 1;
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n7 = token3.offset(tokenHierarchy);
                tokenSequence.move(n7);
                tokenSequence.moveNext();
                token = tokenSequence.token();
                bl2 = false;
                while (!bl2 && token != null) {
                    if (token.id() == JsTokenId.LPAREN || token.id() == JsTokenId.LBRACKET) {
                        if (((JsTokenId)token.id()).ordinal() == n3) {
                            ++n5;
                        }
                    } else if (token.id() == JsTokenId.RPAREN || token.id() == JsTokenId.RBRACKET) {
                        if (((JsTokenId)token.id()).ordinal() == n2 && --n5 == 0) {
                            if (n4 != 0) {
                                n5 = -1;
                            }
                            bl2 = true;
                        }
                    } else if (token.id() == JsTokenId.LBRACE) {
                        ++n4;
                    } else if (token.id() == JsTokenId.RBRACE && --n4 < 0) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) break;
                    token = tokenSequence.token();
                }
                bl = n5 == 0;
            }
        }
        return bl;
    }

    private void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (this.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + this.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private boolean completeQuote(BaseDocument baseDocument, int n, Caret caret, char c, TokenId[] tokenIdArray, TokenId tokenId) throws BadLocationException {
        int n2;
        boolean bl;
        if (this.isEscapeSequence(baseDocument, n)) {
            return false;
        }
        if (baseDocument.getLength() < n) {
            return false;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return false;
        }
        Token<? extends JsTokenId> token = tokenSequence.token();
        Token token2 = null;
        if (tokenSequence.movePrevious()) {
            token2 = tokenSequence.token();
        }
        boolean bl2 = bl = (n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) < n;
        if (token.id() == JsTokenId.BLOCK_COMMENT || token.id() == JsTokenId.LINE_COMMENT) {
            return false;
        }
        if (token.id() == JsTokenId.WHITESPACE && bl && n - 1 > 0 && (token = LexUtilities.getToken(baseDocument, n - 1)).id() == JsTokenId.LINE_COMMENT) {
            return false;
        }
        boolean bl3 = this.isQuoteCompletablePosition(baseDocument, n);
        boolean bl4 = false;
        TokenId tokenId2 = token.id();
        for (TokenId tokenId3 : tokenIdArray) {
            if (tokenId2 != tokenId3) continue;
            bl4 = true;
            break;
        }
        if (tokenId2 == JsTokenId.ERROR && token2 != null && token2.id() == tokenId) {
            bl4 = true;
        }
        if (tokenId2 == JsTokenId.EOL && token2 != null) {
            if (token2.id() == tokenId) {
                bl4 = true;
            } else if (token2.id() == JsTokenId.ERROR && tokenSequence.movePrevious() && tokenSequence.token().id() == tokenId) {
                bl4 = true;
            }
        }
        if (!bl4 && token.id() == JsTokenId.WHITESPACE && bl && n - 1 > 0) {
            token = LexUtilities.getToken(baseDocument, n - 1);
            boolean bl5 = bl4 = token.id() == JsTokenId.STRING_LITERAL;
        }
        if (bl4) {
            if (bl) {
                return false;
            }
            char c2 = baseDocument.getChars(n, 1)[0];
            if (c2 == c) {
                if (!this.isAfter) {
                    baseDocument.insertString(n, "" + c, null);
                } else if (n >= baseDocument.getLength() - 1 || baseDocument.getText(n + 1, 1).charAt(0) != c) {
                    return true;
                }
                baseDocument.remove(n, 1);
                return true;
            }
        }
        if (bl3 && !bl4 || bl) {
            baseDocument.insertString(n, "" + c + (this.isAfter ? "" : Character.valueOf(this.matching(c))), null);
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private boolean isQuoteCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        if (n == n2 || n2 == -1) {
            return false;
        }
        int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n, (int)n2);
        if (n3 == -1) {
            return false;
        }
        char c = baseDocument.getChars(n3, 1)[0];
        return c == ')' || c == ',' || c == '+' || c == '}' || c == ';' || c == ']' || c == '/';
    }

    private char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return c;
    }

    public List<OffsetRange> findLogicalRanges(CompilationInfo compilationInfo, int n) {
        Token token;
        OffsetRange offsetRange;
        int n2;
        Object object;
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return Collections.emptyList();
        }
        int n3 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n3 == -1) {
            return Collections.emptyList();
        }
        AstPath astPath = new AstPath(node, n3);
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        try {
            object = (BaseDocument)compilationInfo.getDocument();
            n2 = object.getLength();
            offsetRange = LexUtilities.getPositionedSequence((BaseDocument)object, n);
            if (offsetRange != null) {
                int n6;
                int n7;
                token = offsetRange.token();
                if (token != null && token.id() == JsTokenId.BLOCK_COMMENT) {
                    n7 = offsetRange.offset();
                    n6 = n7 + token.length();
                    arrayList.add(new OffsetRange(n7, n6));
                } else if (token != null && token.id() == JsTokenId.LINE_COMMENT) {
                    int n8;
                    n7 = Utilities.getRowStart((BaseDocument)object, (int)n);
                    n6 = Utilities.getRowEnd((BaseDocument)object, (int)n);
                    if (LexUtilities.isCommentOnlyLine((BaseDocument)object, n)) {
                        int n9;
                        arrayList.add(new OffsetRange(Utilities.getRowFirstNonWhite((BaseDocument)object, (int)n7), Utilities.getRowLastNonWhite((BaseDocument)object, (int)n6) + 1));
                        int n10 = n7;
                        n8 = n6;
                        while (n7 > 0) {
                            n9 = Utilities.getRowStart((BaseDocument)object, (int)(n7 - 1));
                            if (n9 < 0 || !LexUtilities.isCommentOnlyLine((BaseDocument)object, n9)) {
                                n7 = Utilities.getRowFirstNonWhite((BaseDocument)object, (int)n7);
                                break;
                            }
                            n7 = n9;
                        }
                        while (true) {
                            if ((n9 = Utilities.getRowEnd((BaseDocument)object, (int)(n6 + 1))) >= n2 || !LexUtilities.isCommentOnlyLine((BaseDocument)object, n9)) break;
                            n6 = n9;
                        }
                        n6 = Utilities.getRowLastNonWhite((BaseDocument)object, (int)n6) + 1;
                        if (n10 > n7 || n8 < n6) {
                            arrayList.add(new OffsetRange(n7, n6));
                        }
                    } else {
                        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)object);
                        n8 = token.offset(tokenHierarchy);
                        arrayList.add(new OffsetRange(n8, n8 + token.length()));
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return arrayList;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return arrayList;
        }
        object = astPath.leafToRoot();
        offsetRange = OffsetRange.NONE;
        while (object.hasNext()) {
            token = (Node)object.next();
            OffsetRange offsetRange2 = AstUtilities.getRange((Node)token);
            if (!offsetRange2.containsInclusive(n3) || offsetRange2.equals((Object)offsetRange) || (offsetRange2 = LexUtilities.getLexerOffsets(compilationInfo, offsetRange2)) == OffsetRange.NONE) continue;
            if (offsetRange2.getStart() < n4) {
                arrayList.add(new OffsetRange(n4, n5));
                arrayList.add(new OffsetRange(0, n2));
                break;
            }
            arrayList.add(offsetRange2);
            offsetRange = offsetRange2;
        }
        return arrayList;
    }

    public int getNextWordOffset(Document document, int n, boolean bl) {
        BaseDocument baseDocument = (BaseDocument)document;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return -1;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return -1;
        }
        if (bl && tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
            return -1;
        }
        Token token = tokenSequence.token();
        TokenId tokenId = token.id();
        if (tokenId == JsTokenId.WHITESPACE) {
            int n2;
            if (bl && tokenSequence.offset() < n || !bl && tokenSequence.offset() > n) {
                return tokenSequence.offset();
            }
            while (tokenId == JsTokenId.WHITESPACE) {
                if (bl && !tokenSequence.movePrevious()) {
                    return -1;
                }
                if (!bl && !tokenSequence.moveNext()) {
                    return -1;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (bl ? (n2 = tokenSequence.offset() + token.length()) < n : (n2 = tokenSequence.offset()) > n) {
                return n2;
            }
        }
        if (tokenId == JsTokenId.IDENTIFIER || tokenId == JsTokenId.CONSTANT || tokenId == JsTokenId.GLOBAL_VAR) {
            char c;
            int n3;
            String string = ((Object)token.text()).toString();
            int n4 = string.length();
            int n5 = n - tokenSequence.offset();
            if (bl) {
                int n6 = n - 1 - tokenSequence.offset();
                if (n6 < 0) {
                    return -1;
                }
                if (n6 < n4 && Character.isUpperCase(string.charAt(n6))) {
                    for (int i = n6 - 1; i >= 0; --i) {
                        char c2 = string.charAt(i);
                        if (c2 == '_') {
                            return tokenSequence.offset() + i + 1;
                        }
                        if (Character.isUpperCase(c2)) continue;
                        return tokenSequence.offset() + i + 1;
                    }
                    return tokenSequence.offset();
                }
                for (int i = n6 - 1; i >= 0; --i) {
                    char c3 = string.charAt(i);
                    if (c3 == '_') {
                        return tokenSequence.offset() + i + 1;
                    }
                    if (!Character.isUpperCase(c3)) continue;
                    for (int j = i; j >= 0; --j) {
                        char c4 = string.charAt(j);
                        if (c4 == '_') {
                            return tokenSequence.offset() + j + 1;
                        }
                        if (Character.isUpperCase(c4)) continue;
                        return tokenSequence.offset() + j + 1;
                    }
                    return tokenSequence.offset();
                }
                return tokenSequence.offset();
            }
            int n7 = n5 + 1;
            if (n5 < 0 || n5 >= string.length()) {
                return -1;
            }
            if (Character.isUpperCase(string.charAt(n5))) {
                for (n3 = n7; n3 < n4 && Character.isUpperCase(c = string.charAt(n3)); ++n3) {
                    if (string.charAt(n3) == '_') {
                        return tokenSequence.offset() + n3;
                    }
                    ++n7;
                }
            }
            for (n3 = n7; n3 < n4; ++n3) {
                c = string.charAt(n3);
                if (c != '_' && !Character.isUpperCase(c)) continue;
                return tokenSequence.offset() + n3;
            }
        }
        return -1;
    }
}

