/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.mozilla.javascript.Node;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.ClassCache;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.FunctionCache;
import org.netbeans.modules.javascript.editing.IndexedElement;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsIndex;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.NbUtilities;
import org.netbeans.modules.javascript.editing.lexer.JsCommentLexer;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsIndexer
implements Indexer {
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    static final String FIELD_FQN = "fqn";
    static final String FIELD_BASE = "base";
    static final String FIELD_EXTEND = "extend";
    static final String FIELD_CLASS = "clz";
    private FileObject cachedFo;
    private boolean cachedIndexable;
    private static FileObject preindexedDb;

    public String getIndexVersion() {
        return "6.113";
    }

    public String getIndexerName() {
        return "javascript";
    }

    public boolean isIndexable(ParserFile parserFile) {
        String string = parserFile.getExtension();
        if (string.equals("json")) {
            return false;
        }
        if (string.equals("html")) {
            return !parserFile.getNameExt().equals("DataTable.js.html");
        }
        if (string.equals("rhtml") || string.equals("jsp")) {
            return true;
        }
        if (string.equals("js")) {
            String string2;
            String string3 = parserFile.getNameExt();
            if (string3.equals("utilities.js") && (string2 = parserFile.getRelativePath()) != null && string2.indexOf("yui") != -1) {
                return false;
            }
            if (string3.endsWith("min.js") && string3.length() > 6 && !Character.isLetter(string3.charAt(string3.length() - 7))) {
                string3 = string3.substring(0, string3.length() - 7);
                if (parserFile.getFileObject().getParent().getFileObject(string3, "js") != null) {
                    return false;
                }
            } else {
                String string4;
                string2 = parserFile.getFileObject();
                if (string2 == null) {
                    return true;
                }
                FileObject fileObject = string2.getParent();
                if (fileObject == null) {
                    return true;
                }
                if (!string3.endsWith(".uncompressed.js") && fileObject.getFileObject((string4 = string3.substring(0, string3.length() - 3)) + ".uncompressed", "js") != null) {
                    return false;
                }
                if (!string3.endsWith("-debug.js") && fileObject.getFileObject((string4 = string3.substring(0, string3.length() - 3)) + "-debug", "js") != null) {
                    return false;
                }
                if (fileObject == this.cachedFo) {
                    return this.cachedIndexable;
                }
                this.cachedFo = fileObject;
                if (fileObject.getFileObject("everything", "sdoc") != null) {
                    this.cachedIndexable = false;
                    return false;
                }
                for (int i = 0; i <= 3 && fileObject != null; ++i, fileObject = fileObject.getParent()) {
                    if (!fileObject.getName().equals("javascript")) continue;
                    FileObject fileObject2 = fileObject.getParent();
                    if (fileObject2 == null || fileObject2.getFileObject("javascript_uncompressed") == null) break;
                    this.cachedIndexable = false;
                    return false;
                }
                this.cachedIndexable = true;
            }
            return true;
        }
        return string.equals("sdoc");
    }

    public boolean acceptQueryPath(String string) {
        return string.indexOf("/ruby2/") == -1 && string.indexOf("/gems/") == -1 && string.indexOf("lib/ruby/") == -1;
    }

    public String getPersistentUrl(File file) {
        try {
            String string = file.toURI().toURL().toExternalForm();
            return JsIndex.getPreindexUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return file.getPath();
        }
    }

    public List<IndexDocument> index(ParserResult parserResult, IndexDocumentFactory indexDocumentFactory) throws IOException {
        JsParseResult jsParseResult = (JsParseResult)parserResult;
        Node node = jsParseResult.getRootNode();
        if (node == null && !parserResult.getFile().getExtension().equals("sdoc")) {
            return null;
        }
        TreeAnalyzer treeAnalyzer = new TreeAnalyzer(jsParseResult, indexDocumentFactory);
        treeAnalyzer.analyze();
        return treeAnalyzer.getDocuments();
    }

    public File getPreindexedData() {
        return null;
    }

    public static void setPreindexedDb(FileObject fileObject) {
        preindexedDb = fileObject;
    }

    public FileObject getPreindexedDb() {
        if (preindexedDb == null) {
            File file = InstalledFileLocator.getDefault().locate("preindexed-javascript", "org.netbeans.modules.javascript.editing", false);
            if (file == null || !file.isDirectory()) {
                throw new RuntimeException("Can't locate preindexed directory. Installation might be damaged");
            }
            preindexedDb = FileUtil.toFileObject((File)file);
        }
        return preindexedDb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeAnalyzer {
        private final ParserFile file;
        private String url;
        private final JsParseResult result;
        private BaseDocument doc;
        private IndexDocumentFactory factory;
        private List<IndexDocument> documents = new ArrayList<IndexDocument>();
        private static FileObject sdocsRoot;
        private static String sdocsRootUrl;

        private TreeAnalyzer(JsParseResult jsParseResult, IndexDocumentFactory indexDocumentFactory) {
            this.result = jsParseResult;
            this.file = jsParseResult.getFile();
            this.factory = indexDocumentFactory;
        }

        List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void analyze() throws IOException {
            String string;
            String string2;
            boolean bl;
            FileObject fileObject = this.file.getFileObject();
            if (this.result.getInfo() != null) {
                this.doc = LexUtilities.getDocument(this.result.getInfo(), true);
            } else {
                if (fileObject.getSize() > 0x100000L) {
                    return;
                }
                this.doc = NbUtilities.getBaseDocument(fileObject, true);
            }
            try {
                this.url = fileObject.getURL().toExternalForm();
                this.url = JsIndex.getPreindexUrl(this.url);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            if (this.file.getExtension().equals("sdoc")) {
                this.indexScriptDoc(this.doc, null);
                return;
            }
            JsAnalyzer.AnalysisResult analysisResult = this.result.getStructure();
            List<? extends AstElement> list = analysisResult.getElements();
            if (list == null || list.size() == 0) {
                return;
            }
            if (this.url.endsWith(".js") && (bl = this.indexRelatedScriptDocs())) {
                return;
            }
            IndexDocument indexDocument = this.factory.createDocument(40);
            this.documents.add(indexDocument);
            for (AstElement object : list) {
                ElementKind elementKind = object.getKind();
                if (elementKind == ElementKind.CONSTRUCTOR || elementKind == ElementKind.METHOD) {
                    string2 = this.computeSignature(object);
                    this.indexFuncOrProperty(object, indexDocument, string2);
                    string = object.getName();
                    if (Character.isUpperCase(string.charAt(0))) {
                        this.indexClass(object, indexDocument, string2);
                    }
                } else if (elementKind == ElementKind.GLOBAL || elementKind == ElementKind.PROPERTY || elementKind == ElementKind.CLASS) {
                    this.indexFuncOrProperty(object, indexDocument, this.computeSignature(object));
                } else assert (false) : elementKind;
                assert (object.getChildren().size() == 0);
            }
            Map<String, String> map = analysisResult.getExtendsMap();
            if (map != null && map.size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    string2 = (String)entry.getKey();
                    string = (String)entry.getValue();
                    indexDocument.addPair(JsIndexer.FIELD_EXTEND, string2.toLowerCase() + ";" + string2 + ";" + string, true);
                }
                ClassCache.INSTANCE.refresh();
            }
        }

        private void indexClass(AstElement astElement, IndexDocument indexDocument, String string) {
            String string2 = astElement.getName();
            indexDocument.addPair(JsIndexer.FIELD_CLASS, string2 + ";" + string, true);
        }

        private String computeSignature(AstElement astElement) {
            Object object;
            int n;
            OffsetRange offsetRange = this.getDocumentationOffset(astElement);
            int n2 = -1;
            if (offsetRange != OffsetRange.NONE) {
                n2 = offsetRange.getStart();
            }
            Map<String, String> map = astElement.getDocProps();
            int n3 = 3;
            String string = "";
            if (this.file.getNameExt().startsWith("stub_")) {
                int n4;
                n = n4 = astElement.getNode().getSourceStart();
                object = this.result.getTranslatedSource();
                if (object != null) {
                    n = object.getLexicalOffset(n4);
                }
                try {
                    String string2 = this.doc.getText(n, Utilities.getRowEnd((BaseDocument)this.doc, (int)n) - n);
                    int n5 = string2.indexOf("COMPAT=");
                    if (n5 != -1) {
                        EnumSet<BrowserVersion> object2 = BrowserVersion.fromFlags(string2.substring(n5 += "COMPAT=".length()));
                        string = BrowserVersion.toCompactFlags(object2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            assert (n3 == 3);
            StringBuilder stringBuilder = new StringBuilder();
            n = IndexedElement.getFlags(astElement);
            if (map != null && map.get("@ignore") != null) {
                n |= 0x20;
            }
            if (n2 != -1) {
                n |= 1;
            }
            stringBuilder.append(IndexedElement.encode(n));
            stringBuilder.append(';');
            assert (++n3 == 4);
            if (astElement instanceof FunctionAstElement) {
                object = (FunctionAstElement)astElement;
                int n6 = 0;
                for (String string2 : ((FunctionAstElement)object).getParameters()) {
                    String string3;
                    if (n6 == 0 && "$super".equals(string2)) {
                        ++n6;
                        continue;
                    }
                    if (n6 > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(string2);
                    if (map != null && (string3 = map.get(string2)) != null) {
                        stringBuilder.append(':');
                        stringBuilder.append(string3);
                    }
                    ++n6;
                }
            }
            stringBuilder.append(';');
            assert (++n3 == 5);
            stringBuilder.append('0');
            stringBuilder.append(';');
            assert (++n3 == 6);
            if (n2 != -1) {
                stringBuilder.append(IndexedElement.encode(n2));
            }
            stringBuilder.append(';');
            assert (++n3 == 7);
            stringBuilder.append(string);
            stringBuilder.append(';');
            assert (++n3 == 8);
            object = astElement.getType();
            if (object == Node.UNKNOWN_TYPE) {
                object = null;
            }
            if (object == null) {
                Object object2 = object = map != null ? map.get("@return") : null;
            }
            if (object != null) {
                stringBuilder.append((String)object);
            }
            stringBuilder.append(';');
            String string4 = stringBuilder.toString();
            return string4;
        }

        private void indexFuncOrProperty(AstElement astElement, IndexDocument indexDocument, String string) {
            String string2 = astElement.getIn();
            String string3 = astElement.getName();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3.toLowerCase());
            stringBuilder.append(';');
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(';');
            stringBuilder.append(string3);
            stringBuilder.append(';');
            stringBuilder.append(string);
            indexDocument.addPair(JsIndexer.FIELD_BASE, stringBuilder.toString(), true);
            StringBuilder stringBuilder2 = new StringBuilder();
            if (string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2.toLowerCase());
                stringBuilder2.append('.');
            }
            stringBuilder2.append(string3.toLowerCase());
            stringBuilder2.append(';');
            stringBuilder2.append(';');
            if (string2 != null && string2.length() > 0) {
                stringBuilder2.append(string2);
                stringBuilder2.append('.');
            }
            stringBuilder2.append(string3);
            stringBuilder2.append(';');
            stringBuilder2.append(string);
            indexDocument.addPair(JsIndexer.FIELD_FQN, stringBuilder2.toString(), true);
            FunctionCache functionCache = FunctionCache.INSTANCE;
            if (!functionCache.isEmpty()) {
                functionCache.wipe(string2 != null && string2.length() > 0 ? string2 + "." + string3 : string3);
            }
        }

        private OffsetRange getDocumentationOffset(AstElement astElement) {
            int n;
            int n2 = n = astElement.getNode().getSourceStart();
            try {
                if (n2 > this.doc.getLength()) {
                    return OffsetRange.NONE;
                }
                n2 = Utilities.getRowStart((BaseDocument)this.doc, (int)n2);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            OffsetRange offsetRange = LexUtilities.getCommentBlock(this.doc, n2, true);
            if (offsetRange != OffsetRange.NONE) {
                return offsetRange;
            }
            return OffsetRange.NONE;
        }

        private void indexScriptDoc(BaseDocument baseDocument, String string) {
            assert (string == null || string.endsWith(".sdoc")) : string;
            IndexDocument indexDocument = this.factory.createDocument(40, string);
            this.documents.add(indexDocument);
            if (baseDocument == null) {
                return;
            }
            TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, 0);
            if (tokenSequence == null) {
                return;
            }
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                CharSequence charSequence;
                String string2;
                CharSequence charSequence2;
                Object object;
                JsTokenId jsTokenId = (JsTokenId)tokenSequence.token().id();
                if (jsTokenId != JsTokenId.BLOCK_COMMENT) continue;
                int n = tokenSequence.offset();
                TokenSequence tokenSequence2 = tokenSequence.embedded(JsCommentTokenId.language());
                if (tokenSequence2 == null) continue;
                int n2 = 521;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                StringBuilder stringBuilder = new StringBuilder();
                tokenSequence2.moveStart();
                while (tokenSequence2.moveNext()) {
                    object = tokenSequence2.token();
                    TokenId tokenId = object.id();
                    if (tokenId != JsCommentTokenId.TAG) continue;
                    charSequence2 = object.text();
                    if (TokenUtilities.textEquals((CharSequence)"@id", (CharSequence)charSequence2)) {
                        string3 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@name", (CharSequence)charSequence2)) {
                        string9 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@param", (CharSequence)charSequence2)) {
                        int n3 = tokenSequence2.index();
                        string2 = JsCommentLexer.nextType((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        charSequence = JsCommentLexer.nextIdent((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        if (charSequence != null) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append(',');
                            }
                            stringBuilder.append((String)charSequence);
                            if (string4 == null) continue;
                            stringBuilder.append(':');
                            stringBuilder.append(string2);
                            continue;
                        }
                        tokenSequence2.moveIndex(n3);
                        tokenSequence2.moveNext();
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@return", (CharSequence)charSequence2)) {
                        String string10 = JsCommentLexer.nextType((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        if (string10 == null) continue;
                        string4 = string10;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@constructor", (CharSequence)charSequence2)) {
                        n2 |= 0x80;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@static", (CharSequence)charSequence2)) {
                        n2 |= 0x10;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@deprecated", (CharSequence)charSequence2)) {
                        n2 |= 0x100;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@final", (CharSequence)charSequence2)) {
                        n2 |= 0x400;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@type", (CharSequence)charSequence2)) {
                        string4 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@private", (CharSequence)charSequence2) || TokenUtilities.textEquals((CharSequence)"@protected", (CharSequence)charSequence2)) {
                        n2 |= 4;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@namespace", (CharSequence)charSequence2)) {
                        string8 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@class", (CharSequence)charSequence2)) {
                        string5 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@memberOf", (CharSequence)charSequence2)) {
                        string5 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@method", (CharSequence)charSequence2)) {
                        n2 |= 8;
                        string6 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@function", (CharSequence)charSequence2)) {
                        n2 |= 8;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@global", (CharSequence)charSequence2)) {
                        n2 &= 0xFFFFFFF7;
                        n2 |= 0x40;
                        continue;
                    }
                    if (TokenUtilities.textEquals((CharSequence)"@property", (CharSequence)charSequence2) || TokenUtilities.textEquals((CharSequence)"@attribute", (CharSequence)charSequence2)) {
                        n2 &= 0xFFFFFFF7;
                        string6 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                        continue;
                    }
                    if (!TokenUtilities.textEquals((CharSequence)"@extends", (CharSequence)charSequence2)) continue;
                    string7 = JsCommentLexer.nextIdentGroup((TokenSequence<? extends JsCommentTokenId>)tokenSequence2);
                }
                if (string9 != null && string3 == null) {
                    string3 = string9;
                    string5 = null;
                }
                if (string3 == null && string5 != null && string6 == null) {
                    string3 = string8 != null ? string8 + "." + string5 + "." + string6 : string5 + "." + string6;
                }
                if (string7 != null && string5 != null) {
                    if (string5.indexOf(46) == -1) {
                        if (string8 != null) {
                            object = string8 + "." + string5;
                        } else if (string3 != null && string3.indexOf(46) != -1) {
                            int n4 = string3.lastIndexOf(46);
                            object = string3.substring(0, n4 + 1) + string5;
                        } else {
                            object = string5;
                        }
                    } else {
                        object = string5;
                    }
                    if (string7.indexOf(46) == -1 && string8 != null) {
                        string7 = string8 + "." + string7;
                    }
                    indexDocument.addPair(JsIndexer.FIELD_EXTEND, ((String)object).toLowerCase() + ";" + (String)object + ";" + string7, true);
                }
                if (string3 == null) continue;
                if (string5 == null || string6 == null) {
                    int n5 = string3.lastIndexOf(46);
                    if (n5 != -1) {
                        string5 = string3.substring(0, n5);
                        string6 = string3.substring(n5 + 1);
                    } else {
                        string5 = null;
                        string6 = string3;
                    }
                }
                int n6 = 3;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(IndexedElement.encode(n2));
                stringBuilder2.append(';');
                assert (++n6 == 4);
                if (stringBuilder.length() > 0) {
                    stringBuilder2.append((CharSequence)stringBuilder);
                }
                stringBuilder2.append(';');
                assert (++n6 == 5);
                stringBuilder2.append('0');
                stringBuilder2.append(';');
                assert (++n6 == 6);
                if (n != -1) {
                    stringBuilder2.append(IndexedElement.encode(n));
                }
                stringBuilder2.append(';');
                assert (++n6 == 7);
                charSequence2 = "";
                stringBuilder2.append((String)charSequence2);
                stringBuilder2.append(';');
                assert (++n6 == 8);
                if (string4 != null) {
                    stringBuilder2.append(string4);
                }
                stringBuilder2.append(';');
                String string11 = stringBuilder2.toString();
                string2 = string5;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string6.toLowerCase());
                ((StringBuilder)charSequence).append(';');
                if (string2 != null) {
                    ((StringBuilder)charSequence).append(string2);
                }
                ((StringBuilder)charSequence).append(';');
                ((StringBuilder)charSequence).append(string6);
                ((StringBuilder)charSequence).append(';');
                ((StringBuilder)charSequence).append(string11);
                indexDocument.addPair(JsIndexer.FIELD_BASE, ((StringBuilder)charSequence).toString(), true);
                StringBuilder stringBuilder3 = new StringBuilder();
                if (string2 != null && string2.length() > 0) {
                    stringBuilder3.append(string2.toLowerCase());
                    stringBuilder3.append('.');
                }
                stringBuilder3.append(string6.toLowerCase());
                stringBuilder3.append(';');
                stringBuilder3.append(';');
                if (string2 != null && string2.length() > 0) {
                    stringBuilder3.append(string2);
                    stringBuilder3.append('.');
                }
                stringBuilder3.append(string6);
                stringBuilder3.append(';');
                stringBuilder3.append(string11);
                indexDocument.addPair(JsIndexer.FIELD_FQN, stringBuilder3.toString(), true);
            }
        }

        private boolean indexRelatedScriptDocs() {
            int n = this.url.lastIndexOf(47);
            if (this.url.startsWith("jquery-", n + 1)) {
                this.indexScriptDoc("jquery.sdoc", false);
                return true;
            }
            if (this.url.startsWith("dojo.js", n + 1)) {
                this.indexScriptDoc("dojo.sdoc", false);
                return true;
            }
            if (this.url.startsWith("yahoo.js", n + 1) || this.url.startsWith("yahoo-debug.js", n + 1) || this.url.startsWith("yahoo-min.js", n + 1)) {
                int n2 = n - "yahoo".length();
                if (this.url.startsWith("yahoo/yahoo", n2)) {
                    this.indexScriptDoc("yui/" + this.url.substring(n2), false);
                } else {
                    this.indexScriptDoc("yui", true);
                }
                return true;
            }
            int n3 = this.url.indexOf("/yui/build/");
            if (n3 != -1) {
                this.indexScriptDoc("yui/" + this.url.substring(n3 + "/yui/build/".length()), false);
                return true;
            }
            return false;
        }

        private void indexScriptDocRecursively(FileObject fileObject, String string) {
            if (fileObject.isFolder()) {
                for (FileObject fileObject2 : fileObject.getChildren()) {
                    this.indexScriptDocRecursively(fileObject2, string + "/" + fileObject2.getNameExt());
                }
                return;
            }
            if (fileObject.getExt().equals("sdoc")) {
                BaseDocument baseDocument = NbUtilities.getBaseDocument(fileObject, true);
                this.indexScriptDoc(baseDocument, string);
            }
        }

        private void indexScriptDoc(String string, boolean bl) {
            if (string != null) {
                URL uRL;
                String string2;
                File file;
                if (sdocsRootUrl == null) {
                    file = InstalledFileLocator.getDefault().locate("jsstubs/sdocs.zip", "org-netbeans-modules-javascript-editing.jar", false);
                    if (file == null) {
                        sdocsRootUrl = "";
                    } else if (file.exists()) {
                        try {
                            string2 = file.toURI().toURL().toExternalForm() + "!/sdocs";
                            uRL = new URL("jar:" + string2);
                            sdocsRoot = URLMapper.findFileObject((URL)uRL);
                            sdocsRootUrl = uRL.toExternalForm();
                        }
                        catch (MalformedURLException malformedURLException) {
                            Exceptions.printStackTrace((Throwable)malformedURLException);
                        }
                    }
                    if (sdocsRoot == null) {
                        sdocsRootUrl = "";
                        return;
                    }
                }
                if (sdocsRootUrl.length() > 0) {
                    if (string.endsWith("-debug.js")) {
                        string = string.substring(0, string.length() - "-debug.js".length()) + ".sdoc";
                    } else if (string.endsWith("-min.js")) {
                        string = string.substring(0, string.length() - "-min.js".length()) + ".sdoc";
                    } else if (string.endsWith(".js")) {
                        string = string.substring(0, string.length() - 2) + "sdoc";
                    }
                    assert (sdocsRoot != null);
                    file = sdocsRoot.getFileObject(string);
                    if (file != null) {
                        string2 = sdocsRootUrl + "/" + string;
                        if (bl) {
                            this.indexScriptDocRecursively((FileObject)file, string2);
                        } else {
                            uRL = NbUtilities.getBaseDocument((FileObject)file, true);
                            this.indexScriptDoc((BaseDocument)uRL, string2);
                        }
                    }
                }
            }
        }
    }
}

