/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.javascript.Node;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsRenameHandler
implements InstantRenamer {
    public boolean isRenameAllowed(CompilationInfo compilationInfo, int n, String[] stringArray) {
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            stringArray[0] = NbBundle.getMessage(JsRenameHandler.class, (String)"NoRenameWithErrors");
            return false;
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return false;
        }
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        switch (node2.getType()) {
            case 38: 
            case 48: 
            case 155: 
            case 156: {
                return true;
            }
            case 157: {
                return AstUtilities.isLabelledFunction(node2);
            }
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(CompilationInfo compilationInfo, int n) {
        JsParseResult jsParseResult = AstUtilities.getParseResult(compilationInfo);
        if (jsParseResult == null) {
            return Collections.emptySet();
        }
        Node node = jsParseResult.getRootNode();
        if (node == null) {
            return Collections.emptySet();
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return Collections.emptySet();
        }
        VariableVisitor variableVisitor = jsParseResult.getVariableVisitor();
        AstPath astPath = new AstPath(node, n2);
        Node node2 = astPath.leaf();
        if (!(node2 instanceof Node.StringNode)) {
            return Collections.emptySet();
        }
        Map<String, List<Node>> map = variableVisitor.getLocalVars(node2);
        String string = node2.getString();
        List<Node> list = map.get(string);
        Object object = new HashSet<OffsetRange>();
        if (list != null) {
            for (Node object2 : list) {
                object.add((OffsetRange)AstUtilities.getNameRange(object2));
            }
        }
        if (object.size() > 0 && jsParseResult.getTranslatedSource() != null) {
            HashSet hashSet = new HashSet(2 * object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                OffsetRange offsetRange = (OffsetRange)iterator.next();
                OffsetRange offsetRange2 = LexUtilities.getLexerOffsets(compilationInfo, offsetRange);
                if (offsetRange2 == OffsetRange.NONE) continue;
                hashSet.add(offsetRange2);
            }
            object = hashSet;
        }
        return object;
    }
}

