/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.embedding;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.NbUtilities;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsModel {
    private static final Logger LOGGER = Logger.getLogger(JsModel.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    private final String HTML_MIME_TYPE = "text/html";
    private final String JSP_MIME_TYPE = "text/x-jsp";
    private final String PHP_MIME_TYPE = "text/x-php5";
    private final Document doc;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();
    private String rubyCode;
    private boolean documentDirty = true;
    private int prevAstOffset;
    private int prevLexOffset;
    protected static final String JS = "in_javascript";
    protected static final String JS_INLINED = "in_inlined_javascript";

    public static JsModel get(Document document) {
        JsModel jsModel = (JsModel)document.getProperty(JsModel.class);
        if (jsModel == null) {
            jsModel = new JsModel(document);
            document.putProperty(JsModel.class, jsModel);
        }
        return jsModel;
    }

    JsModel(Document document) {
        this.doc = document;
        if (document != null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            tokenHierarchy.addTokenHierarchyListener(new TokenHierarchyListener(){

                public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
                    JsModel.this.documentDirty = true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
                String string = (String)this.doc.getProperty("mimeType");
                if ("application/x-httpd-eruby".equals(string)) {
                    this.extractJavaScriptFromRhtml((TokenSequence<? extends TokenId>)tokenSequence, stringBuilder);
                } else if ("text/html".equals(string)) {
                    TokenSequence tokenSequence2 = tokenSequence;
                    this.extractJavaScriptFromHtml((TokenSequence<? extends HTMLTokenId>)tokenSequence2, stringBuilder, new JsAnalyzerState());
                } else if ("text/x-jsp".equals(string)) {
                    this.extractJavaScriptFromJsp((TokenSequence<? extends TokenId>)tokenSequence, stringBuilder);
                } else if ("text/x-php5".equals(string)) {
                    this.extractJavaScriptFromPHP((TokenSequence<? extends TokenId>)tokenSequence, stringBuilder);
                }
            }
            finally {
                baseDocument.readUnlock();
            }
            this.rubyCode = stringBuilder.toString();
        }
        if (LOG) {
            LOGGER.log(Level.FINE, "===== VIRTUAL JavaScript SOURCE =====");
            LOGGER.log(Level.FINE, this.rubyCode);
            LOGGER.log(Level.FINE, "=====================================");
        }
        return this.rubyCode;
    }

    void extractJavaScriptFromJsp(TokenSequence<? extends TokenId> tokenSequence, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder;
        JsAnalyzerState jsAnalyzerState = new JsAnalyzerState();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id().primaryCategory().equals("text")) {
                TokenSequence tokenSequence2 = tokenSequence.embedded(HTMLTokenId.language());
                if (tokenSequence2 == null) continue;
                this.extractJavaScriptFromHtml((TokenSequence<? extends HTMLTokenId>)tokenSequence2, stringBuilder2, jsAnalyzerState);
                continue;
            }
            if (!token.id().primaryCategory().equals("expression-language") && !token.id().primaryCategory().equals("scriptlet") && (!token.id().primaryCategory().equals("symbol") || !"/>".equals(((Object)token.text()).toString())) || !jsAnalyzerState.in_inlined_javascript && !jsAnalyzerState.in_javascript) continue;
            int n = tokenSequence.offset();
            String string = " __UNKNOWN__ ";
            int n2 = n + token.length();
            int n3 = stringBuilder2.length();
            stringBuilder2.append(string);
            int n4 = stringBuilder2.length();
            CodeBlockData codeBlockData = new CodeBlockData(n, n2, n3, n4);
            this.codeBlocks.add(codeBlockData);
        }
    }

    void extractJavaScriptFromPHP(TokenSequence<? extends TokenId> tokenSequence, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = stringBuilder;
        JsAnalyzerState jsAnalyzerState = new JsAnalyzerState();
        block0: while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id().name().equals("T_INLINE_HTML")) {
                TokenSequence tokenSequence2 = tokenSequence.embedded(HTMLTokenId.language());
                if (tokenSequence2 == null) continue;
                this.extractJavaScriptFromHtml((TokenSequence<? extends HTMLTokenId>)tokenSequence2, stringBuilder2, jsAnalyzerState);
            }
            if (!jsAnalyzerState.in_inlined_javascript && !jsAnalyzerState.in_javascript) continue;
            int n = tokenSequence.offset();
            while (tokenSequence.moveNext()) {
                token = tokenSequence.token();
                if (!token.id().name().equals("T_INLINE_HTML")) continue;
                tokenSequence.movePrevious();
                String string = " __PHP_CODE__ ";
                int n2 = n + token.length();
                int n3 = stringBuilder2.length();
                stringBuilder2.append(string);
                int n4 = stringBuilder2.length();
                CodeBlockData codeBlockData = new CodeBlockData(n, n2, n3, n4);
                this.codeBlocks.add(codeBlockData);
                continue block0;
            }
        }
    }

    void extractJavaScriptFromRhtml(TokenSequence<? extends TokenId> tokenSequence, StringBuilder stringBuilder) {
        int n;
        FileObject fileObject;
        StringBuilder stringBuilder2;
        Object object;
        StringBuilder stringBuilder3 = stringBuilder;
        FileObject fileObject2 = NbUtilities.findFileObject(this.doc);
        if (fileObject2 != null && (object = FileOwnerQuery.getOwner((FileObject)fileObject2)) != null) {
            stringBuilder2 = new StringBuilder();
            fileObject = object.getProjectDirectory().getFileObject("public/javascripts");
            if (fileObject != null) {
                this.addJavaScriptFiles(fileObject, stringBuilder2);
                if (stringBuilder2.length() > 0) {
                    int n2 = 0;
                    String string = stringBuilder2.toString();
                    String string2 = "__netbeans_import__(" + string + ");\n";
                    n = n2;
                    int n3 = stringBuilder3.length();
                    stringBuilder3.append(string2);
                    int n4 = stringBuilder3.length();
                    CodeBlockData codeBlockData = new CodeBlockData(n2, n, n3, n4);
                    this.codeBlocks.add(codeBlockData);
                }
            }
        }
        object = new JsAnalyzerState();
        while (tokenSequence.moveNext()) {
            stringBuilder2 = tokenSequence.token();
            if (stringBuilder2.id().primaryCategory().equals("html")) {
                fileObject = tokenSequence.embedded(HTMLTokenId.language());
                if (fileObject == null) continue;
                this.extractJavaScriptFromHtml((TokenSequence<? extends HTMLTokenId>)fileObject, stringBuilder3, (JsAnalyzerState)object);
                continue;
            }
            if (!stringBuilder2.id().primaryCategory().equals("ruby") || !object.in_inlined_javascript && !object.in_javascript) continue;
            int n5 = tokenSequence.offset();
            String string = " __UNKNOWN__ ";
            int n6 = n5 + stringBuilder2.length();
            int n7 = stringBuilder3.length();
            stringBuilder3.append(string);
            n = stringBuilder3.length();
            CodeBlockData codeBlockData = new CodeBlockData(n5, n6, n7, n);
            this.codeBlocks.add(codeBlockData);
        }
    }

    void extractJavaScriptFromHtml(TokenSequence<? extends HTMLTokenId> tokenSequence, StringBuilder stringBuilder, JsAnalyzerState jsAnalyzerState) {
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            Object object;
            Object object2;
            int n;
            int n2;
            int n3;
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId == HTMLTokenId.SCRIPT) {
                int n4;
                jsAnalyzerState.in_javascript = true;
                int n5 = tokenSequence.offset();
                String string = ((Object)token.text()).toString();
                for (n3 = 0; n3 < string.length() && Character.isWhitespace((char)(n4 = string.charAt(n3))); ++n3) {
                }
                if (n3 < string.length() && string.startsWith("<!--", n3) && (n4 = string.indexOf(10, n3)) != -1) {
                    string = string.substring(n4 + 1);
                }
                n4 = n5 + string.length();
                n2 = stringBuilder.length();
                stringBuilder.append(string);
                n = stringBuilder.length();
                object2 = new CodeBlockData(n5, n4, n2, n);
                this.codeBlocks.add((CodeBlockData)object2);
                continue;
            }
            if (tokenId == HTMLTokenId.TAG_OPEN) {
                String string = ((Object)token.text()).toString();
                if (!"script".equals(string)) continue;
                TokenSequence tokenSequence2 = tokenSequence.subSequence(tokenSequence.offset());
                tokenSequence2.moveStart();
                n3 = 0;
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                while (tokenSequence2.moveNext() && (object = (object2 = tokenSequence2.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    if (n3 != 0 || bl) {
                        if (object == HTMLTokenId.ARGUMENT) break;
                        if (object != HTMLTokenId.VALUE) continue;
                        if (n3 != 0) {
                            string3 = object2.toString();
                        } else {
                            assert (bl);
                            string2 = object2.toString();
                        }
                        n3 = 0;
                        bl = false;
                        continue;
                    }
                    if (object != HTMLTokenId.ARGUMENT) continue;
                    String string4 = object2.toString();
                    if ("src".equals(string4)) {
                        n3 = 1;
                        continue;
                    }
                    if (!"type".equals(string4)) continue;
                    bl = true;
                }
                if (string3 == null || string2 != null && string2.toLowerCase().indexOf("javascript") == -1) continue;
                if (string3.length() > 2 && string3.startsWith("\"") && string3.endsWith("\"")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                if (string3.length() > 2 && string3.startsWith("'") && string3.endsWith("'")) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                int n6 = tokenSequence.offset();
                object = "__netbeans_import__('" + string3 + "');\n";
                int n7 = n6;
                int n8 = stringBuilder.length();
                stringBuilder.append((String)object);
                int n9 = stringBuilder.length();
                CodeBlockData codeBlockData = new CodeBlockData(n6, n7, n8, n9);
                this.codeBlocks.add(codeBlockData);
                continue;
            }
            if (jsAnalyzerState.in_javascript && tokenId == HTMLTokenId.TEXT) {
                int n10 = tokenSequence.offset();
                String string = ((Object)token.text()).toString();
                n3 = n10 + string.length();
                int n11 = stringBuilder.length();
                stringBuilder.append(string);
                n2 = stringBuilder.length();
                CodeBlockData codeBlockData = new CodeBlockData(n10, n3, n11, n2);
                this.codeBlocks.add(codeBlockData);
                continue;
            }
            if (tokenId == HTMLTokenId.VALUE_JAVASCRIPT) {
                int n12;
                char c;
                String string = token.toString();
                if (!(string.length() < 1 || (c = string.charAt(0)) != '\'' && c != '\"' || jsAnalyzerState.in_inlined_javascript)) {
                    jsAnalyzerState.opening_quotation_stripped = true;
                    string = string.substring(1);
                }
                if ((n12 = string.indexOf(38)) != -1) {
                    string = string.replace("&lt;", "<");
                    string = string.replace("&apos;", "'");
                    string = string.replace("&quot;", "\"");
                    string = string.replace("&amp;", "&");
                }
                n3 = tokenSequence.offset();
                String string5 = string;
                n2 = n3 + token.length();
                if (!jsAnalyzerState.in_inlined_javascript) {
                    n = stringBuilder.length();
                    stringBuilder.append(";function(){\n");
                    int n13 = stringBuilder.length();
                    this.codeBlocks.add(new CodeBlockData(n3, n3, n, n13));
                }
                jsAnalyzerState.in_inlined_javascript = true;
                n = stringBuilder.length();
                stringBuilder.append(string5);
                int n14 = stringBuilder.length();
                object = new CodeBlockData(n3, n2, n, n14);
                this.codeBlocks.add((CodeBlockData)object);
                jsAnalyzerState.lastCodeBlock = object;
                continue;
            }
            if (jsAnalyzerState.in_inlined_javascript && tokenId != HTMLTokenId.VALUE_JAVASCRIPT) {
                if (jsAnalyzerState.opening_quotation_stripped) {
                    CodeBlockData codeBlockData = jsAnalyzerState.lastCodeBlock;
                    char c = stringBuilder.charAt(stringBuilder.length() - 1);
                    if (c == '\'' || c == '\"') {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                        codeBlockData.generatedEnd--;
                    }
                }
                jsAnalyzerState.in_inlined_javascript = false;
                jsAnalyzerState.opening_quotation_stripped = false;
                jsAnalyzerState.lastCodeBlock = null;
                int n15 = tokenSequence.offset();
                int n16 = stringBuilder.length();
                stringBuilder.append("\n}\n");
                n3 = stringBuilder.length();
                this.codeBlocks.add(new CodeBlockData(n15, n15, n16, n3));
                continue;
            }
            if (tokenId == HTMLTokenId.TAG_CLOSE && "script".equals(token.toString())) {
                stringBuilder.append("\n");
                continue;
            }
            jsAnalyzerState.in_javascript = false;
        }
    }

    public int sourceToGeneratedPos(int n) {
        if (this.prevLexOffset == n) {
            return this.prevAstOffset;
        }
        this.prevLexOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtSourceOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.sourceStart;
        int n3 = codeBlockData.generatedStart + n2;
        this.prevAstOffset = n3 <= codeBlockData.generatedEnd ? n3 : codeBlockData.generatedEnd;
        return this.prevAstOffset;
    }

    public int generatedToSourcePos(int n) {
        if (this.prevAstOffset == n) {
            return this.prevLexOffset;
        }
        this.prevAstOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtGeneratedOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.generatedStart;
        int n3 = codeBlockData.sourceStart + n2;
        this.prevLexOffset = n3 <= codeBlockData.sourceEnd ? n3 : codeBlockData.sourceEnd;
        return this.prevLexOffset;
    }

    private void addJavaScriptFiles(FileObject fileObject, StringBuilder stringBuilder) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                this.addJavaScriptFiles(fileObject2, stringBuilder);
            }
        } else if (JsUtils.isJsFile(fileObject)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            String string = fileObject.getNameExt();
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.sourceStart > n || codeBlockData.sourceEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.generatedStart > n || codeBlockData.generatedEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;

        public CodeBlockData(int n, int n2, int n3, int n4) {
            this.sourceStart = n;
            this.generatedStart = n3;
            this.sourceEnd = n2;
            this.generatedEnd = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CodeBlockData[");
            stringBuilder.append("\n  SOURCE(" + this.sourceStart + "," + this.sourceEnd + ")");
            stringBuilder.append(",\n  JAVASCRIPT(" + this.generatedStart + "," + this.generatedEnd + ")");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    private class JsAnalyzerState {
        boolean in_javascript = false;
        boolean in_inlined_javascript = false;
        boolean opening_quotation_stripped = false;
        CodeBlockData lastCodeBlock = null;

        private JsAnalyzerState() {
        }
    }
}

