/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import java.io.IOException;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.TokenStream;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsLexer
implements Lexer<JsTokenId> {
    private static final boolean DEBUG_TOKENS = false;
    private static final boolean REUSE_LEXERS = false;
    private static JsLexer cached;
    private LexerInput input;
    private TokenFactory<JsTokenId> tokenFactory;
    private Parser parser;
    private TokenStream tokenStream;

    private JsLexer(LexerRestartInfo<JsTokenId> lexerRestartInfo) {
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        ErrorReporter errorReporter = new ErrorReporter(){

            public void warning(String string, String string2, int n, String string3, int n2, String string4, Object object) {
            }

            public void error(String string, String string2, int n, String string3, int n2, String string4, Object object) {
            }

            public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
                return null;
            }
        };
        Context context = new Context();
        compilerEnvirons.initFromContext(context);
        compilerEnvirons.setErrorReporter(errorReporter);
        compilerEnvirons.setGeneratingSource(false);
        compilerEnvirons.setGenerateDebugInfo(false);
        int n = SupportedBrowsers.getInstance().getLanguageVersion();
        compilerEnvirons.setLanguageVersion(n);
        if (n >= 170) {
            compilerEnvirons.setXmlAvailable(true);
        }
        this.parser = new Parser(compilerEnvirons, errorReporter);
        this.tokenStream = new TokenStream(this.parser, null, null, "", 0);
    }

    public static synchronized JsLexer create(LexerRestartInfo<JsTokenId> lexerRestartInfo) {
        JsLexer jsLexer = cached;
        if (jsLexer == null) {
            jsLexer = new JsLexer(lexerRestartInfo);
        }
        jsLexer.restart(lexerRestartInfo);
        return jsLexer;
    }

    void restart(LexerRestartInfo<JsTokenId> lexerRestartInfo) {
        this.input = lexerRestartInfo.input();
        this.tokenFactory = lexerRestartInfo.tokenFactory();
        this.tokenStream.setInput(lexerRestartInfo.input());
        Object object = lexerRestartInfo.state();
        this.tokenStream.fromState(object);
        this.parser.setTokenStream(this.tokenStream);
    }

    public void release() {
    }

    public Object state() {
        return this.tokenStream.toState();
    }

    private Token<JsTokenId> token(JsTokenId jsTokenId, int n) {
        String string = jsTokenId.fixedText();
        return string != null ? this.tokenFactory.getFlyweightToken((TokenId)jsTokenId, string) : this.tokenFactory.createToken((TokenId)jsTokenId, n);
    }

    public Token<JsTokenId> nextToken() {
        int n;
        try {
            n = this.tokenStream.getToken() & 0xFFFF;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            n = -1;
        }
        JsTokenId jsTokenId = this.getTokenId(n);
        int n2 = this.input.readLength();
        if (n2 < 1 && n == 0) {
            return null;
        }
        return this.token(jsTokenId, n2);
    }

    private JsTokenId getTokenId(int n) {
        switch (n) {
            case -1: 
            case 65535: {
                return JsTokenId.ERROR;
            }
            case 152: {
                return JsTokenId.LINE_COMMENT;
            }
            case 153: {
                return JsTokenId.BLOCK_COMMENT;
            }
            case 30: {
                return JsTokenId.NEW;
            }
            case 104: {
                return JsTokenId.DOT;
            }
            case 0: 
            case 154: {
                return JsTokenId.WHITESPACE;
            }
            case 1: {
                return JsTokenId.EOL;
            }
            case 105: {
                return JsTokenId.FUNCTION;
            }
            case 42: {
                return JsTokenId.THIS;
            }
            case 115: {
                return JsTokenId.FOR;
            }
            case 108: {
                return JsTokenId.IF;
            }
            case 113: {
                return JsTokenId.WHILE;
            }
            case 109: {
                return JsTokenId.ELSE;
            }
            case 111: {
                return JsTokenId.CASE;
            }
            case 112: {
                return JsTokenId.DEFAULT;
            }
            case 116: {
                return JsTokenId.BREAK;
            }
            case 110: {
                return JsTokenId.SWITCH;
            }
            case 4: 
            case 5: 
            case 31: 
            case 32: 
            case 41: 
            case 43: 
            case 44: 
            case 49: 
            case 51: 
            case 52: 
            case 77: 
            case 106: 
            case 107: 
            case 114: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 149: 
            case 165: {
                return JsTokenId.ANY_KEYWORD;
            }
            case 39: {
                return JsTokenId.FLOAT_LITERAL;
            }
            case 158: {
                return JsTokenId.STRING_BEGIN;
            }
            case 40: {
                return JsTokenId.STRING_LITERAL;
            }
            case 159: {
                return JsTokenId.STRING_END;
            }
            case 24: {
                return JsTokenId.NONUNARY_OP;
            }
            case 96: {
                return JsTokenId.ANY_OPERATOR;
            }
            case 161: {
                return JsTokenId.REGEXP_BEGIN;
            }
            case 47: {
                return JsTokenId.REGEXP_LITERAL;
            }
            case 162: {
                return JsTokenId.REGEXP_END;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 45: 
            case 46: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 101: {
                return JsTokenId.NONUNARY_OP;
            }
            case 99: {
                return JsTokenId.COLON;
            }
            case 85: {
                return JsTokenId.ANY_OPERATOR;
            }
            case 38: {
                return JsTokenId.IDENTIFIER;
            }
            case 29: 
            case 102: 
            case 103: {
                return JsTokenId.ANY_OPERATOR;
            }
            case 63: 
            case 64: {
                return JsTokenId.IDENTIFIER;
            }
            case 78: {
                return JsTokenId.SEMI;
            }
            case 79: {
                return JsTokenId.LBRACKET;
            }
            case 80: {
                return JsTokenId.RBRACKET;
            }
            case 81: {
                return JsTokenId.LBRACE;
            }
            case 82: {
                return JsTokenId.RBRACE;
            }
            case 83: {
                return JsTokenId.LPAREN;
            }
            case 84: {
                return JsTokenId.RPAREN;
            }
        }
        return JsTokenId.IDENTIFIER;
    }
}

