/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EnumSet;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.SupportedBrowsers;
import org.netbeans.modules.javascript.editing.options.JsOptionsController;
import org.openide.util.NbBundle;

public class BrowserPanel
extends JPanel {
    private final String[] VERSION_LABELS = new String[]{NbBundle.getMessage(BrowserPanel.class, (String)"LanguageDefault"), "1.0", "1.1", "1.2", "1.3", "1.4", "1.5", "1.6", "1.7", "1.8"};
    private final int[] VERSION_VALUES = new int[]{0, 100, 110, 120, 130, 140, 150, 160, 170, 180};
    private final JsOptionsController controller;
    private JLabel browserLabel;
    private JRadioButton ff1Rb;
    private JRadioButton ff2Rb;
    private JRadioButton ff3Rb;
    private JCheckBox ffCb;
    private ButtonGroup firefoxGroup;
    private JRadioButton ie5Rb;
    private JRadioButton ie6Rb;
    private JRadioButton ie7Rb;
    private JCheckBox ieCb;
    private ButtonGroup ieGroup;
    private JComboBox languageCombo;
    private JLabel languageLabel;
    private JCheckBox limitCb;
    private JCheckBox operaCb;
    private JCheckBox safariCb;
    private ButtonGroup safariGroup;
    private JRadioButton sf2Rb;
    private JRadioButton sf3Rb;
    private JCheckBox unsupportedCb;

    public BrowserPanel(JsOptionsController jsOptionsController) {
        this.controller = jsOptionsController;
        this.initComponents();
    }

    public void load() {
        SupportedBrowsers supportedBrowsers = SupportedBrowsers.getInstance();
        if (supportedBrowsers.isSupported(BrowserVersion.FF1)) {
            this.ff1Rb.setSelected(true);
            this.ffCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.FF2)) {
            this.ff2Rb.setSelected(true);
            this.ffCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.FF3)) {
            this.ff3Rb.setSelected(true);
            this.ffCb.setSelected(true);
        } else {
            this.ffCb.setSelected(false);
        }
        if (supportedBrowsers.isSupported(BrowserVersion.IE55)) {
            this.ie5Rb.setSelected(true);
            this.ieCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.IE6)) {
            this.ie6Rb.setSelected(true);
            this.ieCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.IE7)) {
            this.ie7Rb.setSelected(true);
            this.ieCb.setSelected(true);
        } else {
            this.ieCb.setSelected(false);
        }
        if (supportedBrowsers.isSupported(BrowserVersion.SAFARI2)) {
            this.sf2Rb.setSelected(true);
            this.safariCb.setSelected(true);
        } else if (supportedBrowsers.isSupported(BrowserVersion.SAFARI3)) {
            this.sf3Rb.setSelected(true);
            this.safariCb.setSelected(true);
        } else {
            this.safariCb.setSelected(false);
        }
        this.operaCb.setSelected(supportedBrowsers.isSupported(BrowserVersion.OPERA));
        int n = supportedBrowsers.getLanguageVersion();
        int n2 = this.VERSION_VALUES.length;
        for (int i = 0; i < n2; ++i) {
            if (this.VERSION_VALUES[i] != n) continue;
            this.languageCombo.setSelectedIndex(i);
            break;
        }
    }

    public void store() {
        EnumSet<BrowserVersion> enumSet = EnumSet.noneOf(BrowserVersion.class);
        if (this.ieCb.isSelected()) {
            if (this.ie5Rb.isSelected()) {
                enumSet.add(BrowserVersion.IE55);
                enumSet.add(BrowserVersion.IE6);
                enumSet.add(BrowserVersion.IE7);
            } else if (this.ie6Rb.isSelected()) {
                enumSet.add(BrowserVersion.IE6);
                enumSet.add(BrowserVersion.IE7);
            } else if (this.ie7Rb.isSelected()) {
                enumSet.add(BrowserVersion.IE7);
            }
        }
        if (this.ffCb.isSelected()) {
            if (this.ff1Rb.isSelected()) {
                enumSet.add(BrowserVersion.FF1);
                enumSet.add(BrowserVersion.FF2);
                enumSet.add(BrowserVersion.FF3);
            } else if (this.ff2Rb.isSelected()) {
                enumSet.add(BrowserVersion.FF2);
                enumSet.add(BrowserVersion.FF3);
            } else if (this.ff3Rb.isSelected()) {
                enumSet.add(BrowserVersion.FF3);
            }
        }
        if (this.safariCb.isSelected()) {
            if (this.sf2Rb.isSelected()) {
                enumSet.add(BrowserVersion.SAFARI2);
                enumSet.add(BrowserVersion.SAFARI3);
            } else if (this.sf3Rb.isSelected()) {
                enumSet.add(BrowserVersion.SAFARI3);
            }
        }
        if (this.operaCb.isSelected()) {
            enumSet.add(BrowserVersion.OPERA);
        }
        SupportedBrowsers supportedBrowsers = SupportedBrowsers.getInstance();
        JsOptionsController.Accessor.DEFAULT.setSupported(supportedBrowsers, enumSet);
        JsOptionsController.Accessor.DEFAULT.setLanguageVersion(supportedBrowsers, this.VERSION_VALUES[this.languageCombo.getSelectedIndex()]);
    }

    private ComboBoxModel getVersionModel() {
        return new DefaultComboBoxModel<String>(this.VERSION_LABELS);
    }

    private void initComponents() {
        this.firefoxGroup = new ButtonGroup();
        this.ieGroup = new ButtonGroup();
        this.safariGroup = new ButtonGroup();
        this.browserLabel = new JLabel();
        this.ffCb = new JCheckBox();
        this.ieCb = new JCheckBox();
        this.safariCb = new JCheckBox();
        this.operaCb = new JCheckBox();
        this.ff1Rb = new JRadioButton();
        this.ff2Rb = new JRadioButton();
        this.ff3Rb = new JRadioButton();
        this.ie5Rb = new JRadioButton();
        this.ie6Rb = new JRadioButton();
        this.ie7Rb = new JRadioButton();
        this.sf2Rb = new JRadioButton();
        this.sf3Rb = new JRadioButton();
        this.unsupportedCb = new JCheckBox();
        this.limitCb = new JCheckBox();
        this.languageLabel = new JLabel();
        this.languageCombo = new JComboBox();
        this.browserLabel.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.browserLabel.text"));
        this.ffCb.setSelected(true);
        this.ffCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ffCb.text"));
        this.ffCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.ieCb.setSelected(true);
        this.ieCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ieCb.text"));
        this.ieCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.safariCb.setSelected(true);
        this.safariCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.safariCb.text"));
        this.safariCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.operaCb.setSelected(true);
        this.operaCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.operaCb.text"));
        this.operaCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.firefoxGroup.add(this.ff1Rb);
        this.ff1Rb.setSelected(true);
        this.ff1Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ff1Rb.text"));
        this.ff1Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.firefoxGroup.add(this.ff2Rb);
        this.ff2Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ff2Rb.text"));
        this.ff2Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.firefoxGroup.add(this.ff3Rb);
        this.ff3Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ff3Rb.text"));
        this.ff3Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.ieGroup.add(this.ie5Rb);
        this.ie5Rb.setSelected(true);
        this.ie5Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ie5Rb.text"));
        this.ie5Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.ieGroup.add(this.ie6Rb);
        this.ie6Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ie6Rb.text"));
        this.ie6Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.ieGroup.add(this.ie7Rb);
        this.ie7Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.ie7Rb.text"));
        this.ie7Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.safariGroup.add(this.sf2Rb);
        this.sf2Rb.setSelected(true);
        this.sf2Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.sf2Rb.text"));
        this.sf2Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.safariGroup.add(this.sf3Rb);
        this.sf3Rb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.sf3Rb.text"));
        this.sf3Rb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.actionCheckChange(actionEvent);
            }
        });
        this.unsupportedCb.setSelected(true);
        this.unsupportedCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.unsupportedCb.text"));
        this.unsupportedCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.limitCb.setSelected(true);
        this.limitCb.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.limitCb.text"));
        this.limitCb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        this.languageLabel.setText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.languageLabel.text"));
        this.languageCombo.setModel(this.getVersionModel());
        this.languageCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BrowserPanel.this.itemCheckChange(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.browserLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.ffCb).add(18, 18, 18).add((Component)this.ff1Rb).addPreferredGap(0).add((Component)this.ff2Rb).addPreferredGap(0).add((Component)this.ff3Rb)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.ieCb).add(18, 18, 18).add((Component)this.ie5Rb).addPreferredGap(0).add((Component)this.ie6Rb).addPreferredGap(0).add((Component)this.ie7Rb)).add((Component)this.unsupportedCb).add((Component)this.limitCb).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.safariCb).add(20, 20, 20).add((Component)this.sf2Rb).addPreferredGap(0).add((Component)this.sf3Rb)).add((Component)this.operaCb).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.languageLabel).addPreferredGap(0).add((Component)this.languageCombo, -2, -1, -2))).addContainerGap(93, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.browserLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ffCb).add((Component)this.ff1Rb).add((Component)this.ff2Rb).add((Component)this.ff3Rb)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.ieCb).add((Component)this.ie5Rb).add((Component)this.ie6Rb).add((Component)this.ie7Rb)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.safariCb).add((Component)this.sf2Rb).add((Component)this.sf3Rb)).addPreferredGap(0).add((Component)this.operaCb).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.languageLabel).add((Component)this.languageCombo, -2, -1, -2)).addPreferredGap(0, 60, Short.MAX_VALUE).add((Component)this.limitCb).addPreferredGap(0).add((Component)this.unsupportedCb).addContainerGap()));
    }

    private void actionCheckChange(ActionEvent actionEvent) {
        this.controller.changed();
    }

    private void itemCheckChange(ItemEvent itemEvent) {
        this.controller.changed();
    }
}

