/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.Utilities;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorUtils {
    private static final ErrorManager ERR = ErrorManager.getDefault().getInstance(GeneratorUtils.class.getName());
    private static final String ERROR = "<error>";
    public static final int GETTERS_ONLY = 1;
    public static final int SETTERS_ONLY = 2;
    private static final Set<String> SUPPORTS_OVERRIDE_SOURCE_LEVELS = new HashSet<String>();
    private static final Set<Modifier> NOT_OVERRIDABLE;

    private GeneratorUtils() {
    }

    public static ClassTree insertClassMember(WorkingCopy workingCopy, TreePath treePath, Tree tree) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TreeUtilities treeUtilities = workingCopy.getTreeUtilities();
        int n = 0;
        for (Tree tree2 : ((ClassTree)treePath.getLeaf()).getMembers()) {
            if (!treeUtilities.isSynthetic(new TreePath(treePath, tree2)) && ClassMemberComparator.compare(tree, tree2) < 0) break;
            ++n;
        }
        return workingCopy.getTreeMaker().insertClassMember((ClassTree)treePath.getLeaf(), n, tree);
    }

    public static List<? extends ExecutableElement> findUndefs(CompilationInfo compilationInfo, TypeElement typeElement) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "findUndefs(" + compilationInfo + ", " + typeElement + ")");
        }
        List list = compilationInfo.getElementUtilities().findUnimplementedMethods(typeElement);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "undef=" + list);
        }
        return list;
    }

    public static List<? extends ExecutableElement> findOverridable(CompilationInfo compilationInfo, TypeElement typeElement) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        List<TypeElement> list = GeneratorUtils.getAllClasses(typeElement);
        if (ERR.isLoggable(1)) {
            ERR.log(1, "classes=" + list);
        }
        for (TypeElement typeElement2 : list.subList(1, list.size())) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                EnumSet<Modifier> enumSet = EnumSet.copyOf(NOT_OVERRIDABLE);
                enumSet.removeAll(executableElement.getModifiers());
                if (enumSet.size() != NOT_OVERRIDABLE.size() || executableElement.getModifiers().contains((Object)Modifier.PRIVATE) || GeneratorUtils.overridesPackagePrivateOutsidePackage(executableElement, typeElement)) continue;
                int n = list.indexOf(typeElement2);
                if (ERR.isLoggable(1)) {
                    ERR.log(1, "ee=" + executableElement);
                    ERR.log(1, "thisElement = " + n);
                    ERR.log(1, "classes.subList(0, thisElement + 1)=" + list.subList(0, n + 1));
                    ERR.log(1, "isOverriden(info, ee, classes.subList(0, thisElement + 1))=" + GeneratorUtils.isOverriden(compilationInfo, executableElement, list.subList(0, n + 1)));
                }
                if (GeneratorUtils.isOverriden(compilationInfo, executableElement, list.subList(0, n + 1))) continue;
                arrayList.add(executableElement);
            }
        }
        return arrayList;
    }

    public static Map<? extends TypeElement, ? extends List<? extends VariableElement>> findAllAccessibleFields(CompilationInfo compilationInfo, TypeElement typeElement) {
        HashMap<TypeElement, List<? extends VariableElement>> hashMap = new HashMap<TypeElement, List<? extends VariableElement>>();
        hashMap.put(typeElement, GeneratorUtils.findAllAccessibleFields(compilationInfo, typeElement, typeElement));
        for (TypeElement typeElement2 : GeneratorUtils.getAllParents(typeElement)) {
            hashMap.put(typeElement2, GeneratorUtils.findAllAccessibleFields(compilationInfo, typeElement, typeElement2));
        }
        return hashMap;
    }

    public static void scanForFieldsAndConstructors(CompilationInfo compilationInfo, TreePath treePath, final Set<VariableElement> set, final Set<VariableElement> set2, final List<ExecutableElement> list) {
        final Trees trees = compilationInfo.getTrees();
        new TreePathScanner<Void, Boolean>(){

            @Override
            public Void visitVariable(VariableTree variableTree, Boolean bl) {
                if (GeneratorUtils.ERROR.contentEquals(variableTree.getName())) {
                    return null;
                }
                Element element = trees.getElement(this.getCurrentPath());
                if (element != null && element.getKind() == ElementKind.FIELD && !element.getModifiers().contains((Object)Modifier.STATIC) && variableTree.getInitializer() == null && !set.remove(element)) {
                    set2.add((VariableElement)element);
                }
                return null;
            }

            @Override
            public Void visitAssignment(AssignmentTree assignmentTree, Boolean bl) {
                Element element = trees.getElement(new TreePath(this.getCurrentPath(), assignmentTree.getVariable()));
                if (element != null && element.getKind() == ElementKind.FIELD && !set2.remove(element)) {
                    set.add((VariableElement)element);
                }
                return null;
            }

            @Override
            public Void visitClass(ClassTree classTree, Boolean bl) {
                return bl != false ? (Void)super.visitClass(classTree, false) : null;
            }

            @Override
            public Void visitMethod(MethodTree methodTree, Boolean bl) {
                Element element = trees.getElement(this.getCurrentPath());
                if (element != null && element.getKind() == ElementKind.CONSTRUCTOR) {
                    list.add((ExecutableElement)element);
                }
                return null;
            }
        }.scan(treePath, Boolean.TRUE);
    }

    public static void generateAllAbstractMethodImplementations(WorkingCopy workingCopy, TreePath treePath) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            ElementUtilities elementUtilities = workingCopy.getElementUtilities();
            for (ExecutableElement executableElement : elementUtilities.findUnimplementedMethods(typeElement)) {
                arrayList.add(generatorUtilities.createAbstractMethodImplementation(typeElement, executableElement));
            }
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static void generateAbstractMethodImplementations(WorkingCopy workingCopy, TreePath treePath, List<? extends ExecutableElement> list, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            arrayList.addAll(n, generatorUtilities.createAbstractMethodImplementations(typeElement, list));
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static void generateAbstractMethodImplementation(WorkingCopy workingCopy, TreePath treePath, ExecutableElement executableElement, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            ClassTree classTree = workingCopy.getTreeMaker().insertClassMember((ClassTree)treePath.getLeaf(), n, (Tree)generatorUtilities.createAbstractMethodImplementation(typeElement, executableElement));
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    public static void generateMethodOverrides(WorkingCopy workingCopy, TreePath treePath, List<? extends ExecutableElement> list, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            arrayList.addAll(n, generatorUtilities.createOverridingMethods(typeElement, list));
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static void generateMethodOverride(WorkingCopy workingCopy, TreePath treePath, ExecutableElement executableElement, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            ClassTree classTree = workingCopy.getTreeMaker().insertClassMember((ClassTree)treePath.getLeaf(), n, (Tree)generatorUtilities.createOverridingMethod(typeElement, executableElement));
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    public static void generateConstructor(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, ExecutableElement executableElement, int n) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
        ClassTree classTree2 = treeMaker.insertClassMember(classTree, n, (Tree)generatorUtilities.createConstructor(typeElement, iterable, executableElement));
        workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree2);
    }

    public static void generateConstructors(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, List<? extends ExecutableElement> list, int n) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
        ClassTree classTree2 = classTree;
        for (ExecutableElement executableElement : list) {
            classTree2 = treeMaker.insertClassMember(classTree2, n, (Tree)generatorUtilities.createConstructor(typeElement, iterable, executableElement));
        }
        workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
    }

    public static void generateGettersAndSetters(WorkingCopy workingCopy, TreePath treePath, Iterable<? extends VariableElement> iterable, int n, int n2) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            GeneratorUtilities generatorUtilities = GeneratorUtilities.get((WorkingCopy)workingCopy);
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            ArrayList<? extends Tree> arrayList = new ArrayList<Tree>(classTree.getMembers());
            ArrayList<MethodTree> arrayList2 = new ArrayList<MethodTree>();
            for (VariableElement variableElement : iterable) {
                if (n != 2) {
                    arrayList2.add(generatorUtilities.createGetter(typeElement, variableElement));
                }
                if (n == 1) continue;
                arrayList2.add(generatorUtilities.createSetter(typeElement, variableElement));
            }
            arrayList.addAll(n2, arrayList2);
            ClassTree classTree2 = treeMaker.Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
            workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
        }
    }

    public static boolean hasGetter(CompilationInfo compilationInfo, VariableElement variableElement, Map<String, List<ExecutableElement>> map) {
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        TypeMirror typeMirror = variableElement.asType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(typeMirror.getKind() == TypeKind.BOOLEAN ? "is" : "get").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        Types types = compilationInfo.getTypes();
        List<ExecutableElement> list = map.get(stringBuilder.toString());
        if (list != null) {
            for (ExecutableElement executableElement : list) {
                if (!executableElement.getParameters().isEmpty() || !types.isSameType(executableElement.getReturnType(), typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasSetter(CompilationInfo compilationInfo, VariableElement variableElement, Map<String, List<ExecutableElement>> map) {
        Name name = variableElement.getSimpleName();
        assert (name.length() > 0);
        TypeMirror typeMirror = variableElement.asType();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("set").append(Character.toUpperCase(name.charAt(0))).append(name.subSequence(1, name.length()));
        Types types = compilationInfo.getTypes();
        List<ExecutableElement> list = map.get(stringBuilder.toString());
        if (list != null) {
            for (ExecutableElement executableElement : list) {
                if (executableElement.getReturnType().getKind() != TypeKind.VOID || executableElement.getParameters().size() != 1 || !types.isSameType(executableElement.getParameters().get(0).asType(), typeMirror)) continue;
                return true;
            }
        }
        return false;
    }

    public static int findClassMemberIndex(WorkingCopy workingCopy, ClassTree classTree, int n) {
        Object object;
        int n2 = 0;
        SourcePositions sourcePositions = workingCopy.getTrees().getSourcePositions();
        GuardedDocument guardedDocument = null;
        try {
            object = workingCopy.getDocument();
            if (object != null && object instanceof GuardedDocument) {
                guardedDocument = (GuardedDocument)object;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = null;
        for (Tree tree : classTree.getMembers()) {
            if ((long)n <= sourcePositions.getStartPosition(workingCopy.getCompilationUnit(), tree)) {
                if (guardedDocument == null) break;
                int n3 = (int)(object != null ? sourcePositions.getEndPosition(workingCopy.getCompilationUnit(), (Tree)object) : sourcePositions.getStartPosition(workingCopy.getCompilationUnit(), classTree));
                n3 = guardedDocument.getGuardedBlockChain().adjustToBlockEnd(n3);
                if ((long)n3 <= sourcePositions.getStartPosition(workingCopy.getCompilationUnit(), tree)) break;
            }
            ++n2;
            object = tree;
        }
        return n2;
    }

    private static List<? extends VariableElement> findAllAccessibleFields(CompilationInfo compilationInfo, TypeElement typeElement, TypeElement typeElement2) {
        ArrayList<VariableElement> arrayList = new ArrayList<VariableElement>();
        for (VariableElement variableElement : ElementFilter.fieldsIn(typeElement2.getEnclosedElements())) {
            if (variableElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                arrayList.add(variableElement);
                continue;
            }
            if (variableElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
                if (typeElement != typeElement2) continue;
                arrayList.add(variableElement);
                continue;
            }
            if (!variableElement.getModifiers().contains((Object)Modifier.PROTECTED) || !GeneratorUtils.getAllParents(typeElement).contains(typeElement2)) continue;
            arrayList.add(variableElement);
        }
        return arrayList;
    }

    public static Collection<TypeElement> getAllParents(TypeElement typeElement) {
        TypeElement typeElement2;
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            TypeElement typeElement3 = (TypeElement)((DeclaredType)typeMirror2).asElement();
            if (typeElement3 != null) {
                hashSet.add(typeElement3);
                hashSet.addAll(GeneratorUtils.getAllParents(typeElement3));
                continue;
            }
            if (!ERR.isLoggable(1)) continue;
            ERR.log(1, "te=null, t=" + typeMirror2);
        }
        TypeMirror typeMirror3 = typeElement.getSuperclass();
        TypeElement typeElement4 = typeElement2 = typeMirror3.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)typeMirror3).asElement() : null;
        if (typeElement2 != null) {
            hashSet.add(typeElement2);
            hashSet.addAll(GeneratorUtils.getAllParents(typeElement2));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + typeElement);
        }
        return hashSet;
    }

    public static boolean supportsOverride(FileObject fileObject) {
        return SUPPORTS_OVERRIDE_SOURCE_LEVELS.contains(SourceLevelQuery.getSourceLevel((FileObject)fileObject));
    }

    private static List<TypeElement> getAllClasses(TypeElement typeElement) {
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>();
        TypeMirror typeMirror = typeElement.getSuperclass();
        TypeElement typeElement2 = typeMirror.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)typeMirror).asElement() : null;
        arrayList.add(typeElement);
        if (typeElement2 != null) {
            arrayList.addAll(GeneratorUtils.getAllClasses(typeElement2));
        } else if (ERR.isLoggable(1)) {
            ERR.log(1, "te=null, t=" + typeElement);
        }
        return arrayList;
    }

    private static boolean isOverriden(CompilationInfo compilationInfo, ExecutableElement executableElement, List<TypeElement> list) {
        if (ERR.isLoggable(1)) {
            ERR.log(1, "isOverriden(" + compilationInfo + ", " + executableElement + ", " + list + ")");
        }
        for (TypeElement typeElement : list) {
            for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (ERR.isLoggable(1) && compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement)) {
                    ERR.log(1, "overrides:");
                    ERR.log(1, "impl=" + typeElement);
                    ERR.log(1, "methodImpl=" + executableElement2);
                }
                if (!compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement)) continue;
                return true;
            }
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "no overriding methods overrides:");
        }
        return false;
    }

    public static boolean isAccessible(TypeElement typeElement, Element element) {
        TypeElement typeElement2;
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return true;
        }
        TypeElement typeElement3 = SourceUtils.getOutermostEnclosingTypeElement((Element)typeElement);
        if (typeElement3.equals(typeElement2 = SourceUtils.getOutermostEnclosingTypeElement((Element)element))) {
            return true;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (element.getModifiers().contains((Object)Modifier.PROTECTED) && GeneratorUtils.getAllClasses(typeElement3).contains(SourceUtils.getEnclosingTypeElement((Element)element))) {
            return true;
        }
        return ((PackageElement)typeElement3.getEnclosingElement()).getQualifiedName().toString().contentEquals(((PackageElement)typeElement2.getEnclosingElement()).getQualifiedName());
    }

    static DialogDescriptor createDialogDescriptor(JComponent jComponent, String string) {
        Object[] objectArray = new JButton[2];
        objectArray[0] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_generate_button"));
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GeneratorUtils.class, (String)"A11Y_Generate"));
        objectArray[1] = new JButton(NbBundle.getMessage(GeneratorUtils.class, (String)"LBL_cancel_button"));
        return new DialogDescriptor((Object)jComponent, string, true, objectArray, (Object)objectArray[0], 0, null, null);
    }

    private static boolean overridesPackagePrivateOutsidePackage(ExecutableElement executableElement, TypeElement typeElement) {
        String string = executableElement.getEnclosingElement().getEnclosingElement().getSimpleName().toString();
        String string2 = typeElement.getEnclosingElement().getSimpleName().toString();
        return !executableElement.getModifiers().contains((Object)Modifier.PRIVATE) && !executableElement.getModifiers().contains((Object)Modifier.PUBLIC) && !executableElement.getModifiers().contains((Object)Modifier.PROTECTED) && !string2.equals(string);
    }

    public static void guardedCommit(JTextComponent jTextComponent, ModificationResult modificationResult) throws IOException {
        block2: {
            try {
                modificationResult.commit();
            }
            catch (IOException iOException) {
                if (!(iOException.getCause() instanceof GuardedException)) break block2;
                String string = NbBundle.getMessage(GeneratorUtils.class, (String)"ERR_CannotApplyGuarded");
                Utilities.setStatusBoldText((JTextComponent)jTextComponent, (String)string);
                Logger.getLogger(GeneratorUtils.class.getName()).log(Level.FINE, null, iOException);
            }
        }
    }

    static {
        SUPPORTS_OVERRIDE_SOURCE_LEVELS.add("1.5");
        SUPPORTS_OVERRIDE_SOURCE_LEVELS.add("1.6");
        NOT_OVERRIDABLE = EnumSet.of(Modifier.ABSTRACT, Modifier.STATIC, Modifier.FINAL);
    }

    private static class ClassMemberComparator {
        private ClassMemberComparator() {
        }

        public static int compare(Tree tree, Tree tree2) {
            if (tree == tree2) {
                return 0;
            }
            int n = ClassMemberComparator.getSortPriority(tree) - ClassMemberComparator.getSortPriority(tree2);
            if (n != 0) {
                return n;
            }
            int n2 = ClassMemberComparator.getSortText(tree).compareTo(ClassMemberComparator.getSortText(tree2));
            if (n2 != 0) {
                return n2;
            }
            return -1;
        }

        private static int getSortPriority(Tree tree) {
            int n = 0;
            ModifiersTree modifiersTree = null;
            switch (tree.getKind()) {
                case CLASS: {
                    n = 400;
                    modifiersTree = ((ClassTree)tree).getModifiers();
                    break;
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    n = methodTree.getName().contentEquals("<init>") ? 200 : 300;
                    modifiersTree = methodTree.getModifiers();
                    break;
                }
                case VARIABLE: {
                    n = 100;
                    modifiersTree = ((VariableTree)tree).getModifiers();
                }
            }
            if (modifiersTree != null) {
                if (!modifiersTree.getFlags().contains((Object)Modifier.STATIC)) {
                    n += 1000;
                }
                n = modifiersTree.getFlags().contains((Object)Modifier.PUBLIC) ? (n += 10) : (modifiersTree.getFlags().contains((Object)Modifier.PROTECTED) ? (n += 20) : (modifiersTree.getFlags().contains((Object)Modifier.PRIVATE) ? (n += 40) : (n += 30)));
            }
            return n;
        }

        private static String getSortText(Tree tree) {
            switch (tree.getKind()) {
                case CLASS: {
                    return ((ClassTree)tree).getSimpleName().toString();
                }
                case METHOD: {
                    MethodTree methodTree = (MethodTree)tree;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('(');
                    int n = 0;
                    Iterator<? extends VariableTree> iterator = methodTree.getParameters().iterator();
                    while (iterator.hasNext()) {
                        VariableTree variableTree = iterator.next();
                        if (variableTree.getType().getKind() == Tree.Kind.IDENTIFIER) {
                            stringBuilder.append(((IdentifierTree)variableTree.getType()).getName().toString());
                        } else if (variableTree.getType().getKind() == Tree.Kind.MEMBER_SELECT) {
                            stringBuilder.append(((MemberSelectTree)variableTree.getType()).getIdentifier().toString());
                        }
                        if (iterator.hasNext()) {
                            stringBuilder.append(',');
                        }
                        ++n;
                    }
                    stringBuilder.append(')');
                    return methodTree.getName().toString() + "#" + (n < 10 ? "0" : "") + n + "#" + stringBuilder.toString();
                }
                case VARIABLE: {
                    return ((VariableTree)tree).getName().toString();
                }
            }
            return "";
        }
    }
}

