/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.swing.JPanel;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.editor.codegen.ui.CheckTreeView;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementSelectorPanel
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager = new ExplorerManager();
    private CheckTreeView elementView;

    public ElementSelectorPanel(ElementNode.Description description, boolean bl) {
        this.setLayout(new BorderLayout());
        this.elementView = new CheckTreeView();
        this.elementView.setRootVisible(false);
        this.add((Component)((Object)this.elementView), "Center");
        this.setRootElement(description, bl);
        Node node = this.manager.getRootContext();
        Node[] nodeArray = node.getChildren().getNodes();
        if (null != nodeArray && nodeArray.length > 0) {
            try {
                this.manager.setSelectedNodes(new Node[]{nodeArray[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public List<ElementHandle<? extends Element>> getTreeSelectedElements() {
        ArrayList<ElementHandle<? extends Element>> arrayList = new ArrayList<ElementHandle<? extends Element>>();
        for (Node node : this.manager.getSelectedNodes()) {
            if (!(node instanceof ElementNode)) continue;
            ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
            arrayList.add(description.getElementHandle());
        }
        return arrayList;
    }

    public List<ElementHandle<? extends Element>> getSelectedElements() {
        ArrayList<ElementHandle<? extends Element>> arrayList = new ArrayList<ElementHandle<? extends Element>>();
        Node node = this.manager.getRootContext();
        ElementNode.Description description = (ElementNode.Description)node.getLookup().lookup(ElementNode.Description.class);
        this.getSelectedHandles(description, arrayList);
        return arrayList;
    }

    public void setRootElement(ElementNode.Description description, boolean bl) {
        Object object;
        if (description != null) {
            ElementNode elementNode = new ElementNode(description);
            elementNode.setSingleSelection(bl);
            object = elementNode;
        } else {
            object = Node.EMPTY;
        }
        this.manager.setRootContext(object);
    }

    public void doInitialExpansion(int n) {
        Node node = this.getExplorerManager().getRootContext();
        Node[] nodeArray = node.getChildren().getNodes(true);
        if (nodeArray == null) {
            return;
        }
        Node node2 = null;
        int n2 = 0;
        boolean bl = this.elementView.getScrollsOnExpand();
        this.elementView.setScrollsOnExpand(false);
        for (int i = 0; nodeArray != null && i < (n == -1 || n > nodeArray.length ? nodeArray.length : n); ++i) {
            this.elementView.expandRow(++n2);
            Node[] nodeArray2 = nodeArray[i].getChildren().getNodes(true);
            n2 += nodeArray2.length;
            if (node2 != null || nodeArray2.length <= 0) continue;
            node2 = nodeArray2[0];
        }
        this.elementView.setScrollsOnExpand(bl);
        try {
            if (node2 != null) {
                this.getExplorerManager().setSelectedNodes(new Node[]{node2});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void getSelectedHandles(ElementNode.Description description, ArrayList<ElementHandle<? extends Element>> arrayList) {
        List<ElementNode.Description> list = description.getSubs();
        if (list == null) {
            return;
        }
        for (ElementNode.Description description2 : list) {
            if (description2.isSelectable() && description2.isSelected()) {
                arrayList.add(description2.getElementHandle());
                continue;
            }
            this.getSelectedHandles(description2, arrayList);
        }
    }
}

