/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotation;
import org.netbeans.modules.java.editor.overridden.IsOverriddenAnnotationHandler;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsHolder
implements PropertyChangeListener {
    private static final Map<FileObject, AnnotationsHolder> file2Annotations = new HashMap<FileObject, AnnotationsHolder>();
    private final FileObject file;
    private final EditorCookie.Observable ec;
    private final List<IsOverriddenAnnotation> annotations;

    public static synchronized AnnotationsHolder get(FileObject fileObject) {
        AnnotationsHolder annotationsHolder = file2Annotations.get(fileObject);
        if (annotationsHolder != null) {
            return annotationsHolder;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie.Observable observable = (EditorCookie.Observable)dataObject.getCookie(EditorCookie.Observable.class);
            if (observable == null) {
                return null;
            }
            annotationsHolder = new AnnotationsHolder(fileObject, observable);
            file2Annotations.put(fileObject, annotationsHolder);
            return annotationsHolder;
        }
        catch (IOException iOException) {
            IsOverriddenAnnotationHandler.LOG.log(Level.INFO, null, iOException);
            return null;
        }
    }

    private AnnotationsHolder(FileObject fileObject, EditorCookie.Observable observable) {
        this.file = fileObject;
        this.ec = observable;
        this.annotations = new ArrayList<IsOverriddenAnnotation>();
        observable.addPropertyChangeListener((PropertyChangeListener)this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AnnotationsHolder.this.checkForReset();
            }
        });
        Logger.getLogger("TIMER").log(Level.FINE, "Overridden AnnotationsHolder", new Object[]{fileObject, this});
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("openedPanes".endsWith(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getPropertyName() == null) {
            this.checkForReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkForReset() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.ec.getOpenedPanes() != null) return;
        Class<AnnotationsHolder> clazz = AnnotationsHolder.class;
        synchronized (AnnotationsHolder.class) {
            file2Annotations.remove(this.file);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setNewAnnotations(Collections.<IsOverriddenAnnotation>emptyList());
            this.ec.removePropertyChangeListener((PropertyChangeListener)this);
            return;
        }
    }

    public synchronized void setNewAnnotations(List<IsOverriddenAnnotation> list) {
        final ArrayList<IsOverriddenAnnotation> arrayList = new ArrayList<IsOverriddenAnnotation>(this.annotations);
        final ArrayList<IsOverriddenAnnotation> arrayList2 = new ArrayList<IsOverriddenAnnotation>(list);
        this.annotations.clear();
        this.annotations.addAll(list);
        Runnable runnable = new Runnable(){

            public void run() {
                for (IsOverriddenAnnotation isOverriddenAnnotation : arrayList) {
                    isOverriddenAnnotation.detachImpl();
                }
                for (IsOverriddenAnnotation isOverriddenAnnotation : arrayList2) {
                    isOverriddenAnnotation.attach();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public synchronized List<IsOverriddenAnnotation> getAnnotations() {
        return new ArrayList<IsOverriddenAnnotation>(this.annotations);
    }
}

