/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.semantic;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.errorstripe.privatespi.Mark;
import org.netbeans.modules.java.editor.javadoc.JavadocImports;
import org.netbeans.modules.java.editor.options.MarkOccurencesSettings;
import org.netbeans.modules.java.editor.semantic.ColoringAttributes;
import org.netbeans.modules.java.editor.semantic.ColoringManager;
import org.netbeans.modules.java.editor.semantic.FindLocalUsagesQuery;
import org.netbeans.modules.java.editor.semantic.MarkOccurrencesHighlighterFactory;
import org.netbeans.modules.java.editor.semantic.MethodExitDetector;
import org.netbeans.modules.java.editor.semantic.OccurrencesMarkProvider;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesHighlighter
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    public static final Color ES_COLOR = new Color(175, 172, 102);
    private static final Set<Tree.Kind> TYPE_PATH_ELEMENT = EnumSet.of(Tree.Kind.IDENTIFIER, Tree.Kind.PRIMITIVE_TYPE, Tree.Kind.PARAMETERIZED_TYPE, Tree.Kind.MEMBER_SELECT, Tree.Kind.ARRAY_TYPE);
    private boolean canceled;
    private MethodExitDetector exitDetector;
    private FindLocalUsagesQuery localUsages;
    static ColoringAttributes.Coloring MO = ColoringAttributes.add(ColoringAttributes.empty(), ColoringAttributes.MARK_OCCURRENCES);

    MarkOccurrencesHighlighter(FileObject fileObject) {
        this.file = fileObject;
    }

    public void run(CompilationInfo compilationInfo) throws IOException {
        Object object;
        this.resume();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            Logger.getLogger(MarkOccurrencesHighlighter.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        Preferences preferences = MarkOccurencesSettings.getCurrentNode();
        if (!preferences.getBoolean(MarkOccurencesSettings.ON_OFF, true)) {
            MarkOccurrencesHighlighter.getHighlightsBag(document).clear();
            OccurrencesMarkProvider.get(document).setOccurrences(Collections.<Mark>emptySet());
            return;
        }
        long l = System.currentTimeMillis();
        int n = MarkOccurrencesHighlighterFactory.getLastPosition((FileObject)this.file);
        if (this.isCancelled()) {
            return;
        }
        n = compilationInfo.getPositionConverter().getJavaSourcePosition(n);
        List<int[]> list = this.processImpl(compilationInfo, preferences, document, n);
        if (this.isCancelled()) {
            return;
        }
        Logger.getLogger("TIMER").log(Level.FINE, "Occurrences", new Object[]{((DataObject)document.getProperty("stream")).getPrimaryFile(), System.currentTimeMillis() - l});
        if (list == null) {
            if (preferences.getBoolean(MarkOccurencesSettings.KEEP_MARKS, true)) {
                return;
            }
            list = new ArrayList<int[]>();
        }
        Collections.sort(list, new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                return nArray[0] - nArray2[0];
            }
        });
        Iterator<int[]> iterator = list.iterator();
        int[] nArray = iterator.hasNext() ? iterator.next() : null;
        ArrayList<int[]> arrayList = new ArrayList<int[]>(list.size());
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object[0] < nArray[1]) {
                nArray[1] = Math.max(object[1], nArray[1]);
                continue;
            }
            arrayList.add(nArray);
            nArray = object;
        }
        if (nArray != null) {
            arrayList.add(nArray);
        }
        object = new OffsetsBag(document);
        object.clear();
        AttributeSet attributeSet = ColoringManager.getColoringImpl(MO);
        for (int[] nArray2 : arrayList) {
            int n2 = compilationInfo.getPositionConverter().getOriginalPosition(nArray2[0]);
            int n3 = compilationInfo.getPositionConverter().getOriginalPosition(nArray2[1]);
            if (n2 == -1 || n3 == -1) continue;
            object.addHighlight(n2, n3, attributeSet);
        }
        MarkOccurrencesHighlighter.getHighlightsBag(document).setHighlights((OffsetsBag)object);
        OccurrencesMarkProvider.get(document).setOccurrences(OccurrencesMarkProvider.createMarks(document, list, ES_COLOR, NbBundle.getMessage(MarkOccurrencesHighlighter.class, (String)"LBL_ES_TOOLTIP")));
    }

    private boolean isIn(CompilationUnitTree compilationUnitTree, SourcePositions sourcePositions, Tree tree, int n) {
        return sourcePositions.getStartPosition(compilationUnitTree, tree) <= (long)n && (long)n <= sourcePositions.getEndPosition(compilationUnitTree, tree);
    }

    private boolean isIn(int n, Token token) {
        if (token == null) {
            return false;
        }
        return token.offset(null) <= n && n <= token.offset(null) + token.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<int[]> processImpl(CompilationInfo compilationInfo, Preferences preferences, Document document, int n) {
        boolean bl;
        Object object;
        Object object3;
        Tree tree;
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n);
        TreePath treePath2 = MarkOccurrencesHighlighter.findTypePath(treePath);
        if (this.isCancelled()) {
            return null;
        }
        if (treePath2 != null && treePath2.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD) {
            tree = (MethodTree)treePath2.getParentPath().getLeaf();
            object3 = tree.getReturnType();
            if (preferences.getBoolean(MarkOccurencesSettings.EXIT, true) && this.isIn(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), (Tree)object3, n)) {
                MethodExitDetector methodExitDetector = new MethodExitDetector();
                this.setExitDetector(methodExitDetector);
                try {
                    List<int[]> list = methodExitDetector.process(compilationInfo, document, (MethodTree)tree, null);
                    return list;
                }
                finally {
                    this.setExitDetector(null);
                }
            }
            for (ExpressionTree expressionTree : tree.getThrows()) {
                if (!preferences.getBoolean(MarkOccurencesSettings.EXCEPTIONS, true) || !this.isIn(compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), expressionTree, n)) continue;
                MethodExitDetector object2 = new MethodExitDetector();
                this.setExitDetector(object2);
                try {
                    List<int[]> object22 = object2.process(compilationInfo, document, (MethodTree)tree, Collections.singletonList(expressionTree));
                    return object22;
                }
                finally {
                    this.setExitDetector(null);
                }
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        if (preferences.getBoolean(MarkOccurencesSettings.IMPLEMENTS, true)) {
            int n2;
            if (treePath2 != null && treePath2.getParentPath().getLeaf().getKind() == Tree.Kind.CLASS) {
                boolean element;
                tree = (ClassTree)treePath2.getParentPath().getLeaf();
                int n3 = Utilities.findBodyStart(tree, compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document);
                boolean bl2 = tree.getExtendsClause() == treePath2.getLeaf();
                boolean bl3 = false;
                for (Tree tree2 : tree.getImplementsClause()) {
                    if (tree2 != treePath2.getLeaf()) continue;
                    element = true;
                    break;
                }
                if (bl2 && preferences.getBoolean(MarkOccurencesSettings.OVERRIDES, true) || element && preferences.getBoolean(MarkOccurencesSettings.IMPLEMENTS, true)) {
                    object = compilationInfo.getTrees().getElement(treePath2);
                    Element element2 = compilationInfo.getTrees().getElement(treePath2.getParentPath());
                    if (MarkOccurrencesHighlighter.isClass((Element)object) && MarkOccurrencesHighlighter.isClass(element2)) {
                        return this.detectMethodsForClass(compilationInfo, document, treePath2.getParentPath(), (TypeElement)object, (TypeElement)element2);
                    }
                }
            }
            if (this.isCancelled()) {
                return null;
            }
            tree = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            if (tree != null && treePath.getLeaf().getKind() == Tree.Kind.CLASS && n < (n2 = Utilities.findBodyStart(treePath.getLeaf(), compilationUnitTree, compilationInfo.getTrees().getSourcePositions(), document))) {
                tree.move(n);
                if (tree.moveNext()) {
                    List<? extends Tree> list;
                    Tree tree2;
                    if (preferences.getBoolean(MarkOccurencesSettings.OVERRIDES, true) && tree.token().id() == JavaTokenId.EXTENDS && (tree2 = ((ClassTree)treePath.getLeaf()).getExtendsClause()) != null) {
                        Element arrayList = compilationInfo.getTrees().getElement(new TreePath(treePath, tree2));
                        object = compilationInfo.getTrees().getElement(treePath);
                        if (MarkOccurrencesHighlighter.isClass(arrayList) && MarkOccurrencesHighlighter.isClass((Element)object)) {
                            return this.detectMethodsForClass(compilationInfo, document, treePath, (TypeElement)arrayList, (TypeElement)object);
                        }
                    }
                    if (preferences.getBoolean(MarkOccurencesSettings.IMPLEMENTS, true) && tree.token().id() == JavaTokenId.IMPLEMENTS && (list = ((ClassTree)treePath.getLeaf()).getImplementsClause()) != null) {
                        ArrayList<TypeElement> findLocalUsagesQuery = new ArrayList<TypeElement>();
                        for (Tree tree3 : list) {
                            Object object4;
                            if (tree3 == null || !MarkOccurrencesHighlighter.isClass((Element)(object4 = compilationInfo.getTrees().getElement(new TreePath(treePath, tree3))))) continue;
                            findLocalUsagesQuery.add((TypeElement)object4);
                        }
                        object = compilationInfo.getTrees().getElement(treePath);
                        if (!findLocalUsagesQuery.isEmpty() && MarkOccurrencesHighlighter.isClass((Element)object)) {
                            return this.detectMethodsForClass(compilationInfo, document, treePath, findLocalUsagesQuery, (TypeElement)object);
                        }
                    }
                }
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        tree = treePath.getLeaf();
        if (preferences.getBoolean(MarkOccurencesSettings.BREAK_CONTINUE, true) && (tree.getKind() == Tree.Kind.BREAK || tree.getKind() == Tree.Kind.CONTINUE)) {
            return this.detectBreakOrContinueTarget(compilationInfo, document, treePath);
        }
        object3 = JavadocImports.findReferencedElement(compilationInfo, n);
        boolean bl2 = bl = object3 != null;
        if (this.isCancelled()) {
            return null;
        }
        if (!bl) {
            object3 = compilationInfo.getTrees().getElement(treePath);
        }
        if (object3 != null && (tree.getKind() != Tree.Kind.CLASS || this.isIn(n, Utilities.findIdentifierSpan(compilationInfo, document, treePath))) && !Utilities.isKeyword(tree) && (tree.getKind() != Tree.Kind.METHOD || this.isIn(n, Utilities.findIdentifierSpan(compilationInfo, document, treePath))) && MarkOccurrencesHighlighter.isEnabled(preferences, (Element)object3) || bl && MarkOccurrencesHighlighter.isEnabled(preferences, (Element)object3)) {
            FindLocalUsagesQuery findLocalUsagesQuery = new FindLocalUsagesQuery();
            this.setLocalUsages(findLocalUsagesQuery);
            try {
                object = new ArrayList();
                for (Object object4 : findLocalUsagesQuery.findUsages((Element)object3, compilationInfo, document)) {
                    object.add((int[])new int[]{object4.offset(null), object4.offset(null) + object4.length()});
                }
                Iterator<? extends Tree> iterator = object;
                return iterator;
            }
            finally {
                this.setLocalUsages(null);
            }
        }
        return null;
    }

    private static TreePath findTypePath(TreePath treePath) {
        if (!TYPE_PATH_ELEMENT.contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        while (TYPE_PATH_ELEMENT.contains((Object)treePath.getParentPath().getLeaf().getKind())) {
            treePath = treePath.getParentPath();
        }
        return treePath;
    }

    private static boolean isClass(Element element) {
        return element != null && (element.getKind().isClass() || element.getKind().isInterface());
    }

    private static boolean isEnabled(Preferences preferences, Element element) {
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: 
            case TYPE_PARAMETER: {
                return preferences.getBoolean(MarkOccurencesSettings.TYPES, true);
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return preferences.getBoolean(MarkOccurencesSettings.METHODS, true);
            }
            case ENUM_CONSTANT: {
                return preferences.getBoolean(MarkOccurencesSettings.CONSTANTS, true);
            }
            case FIELD: {
                if (element.getModifiers().containsAll(EnumSet.of(Modifier.STATIC, Modifier.FINAL))) {
                    return preferences.getBoolean(MarkOccurencesSettings.CONSTANTS, true);
                }
                return preferences.getBoolean(MarkOccurencesSettings.FIELDS, true);
            }
            case LOCAL_VARIABLE: 
            case PARAMETER: 
            case EXCEPTION_PARAMETER: {
                return preferences.getBoolean(MarkOccurencesSettings.LOCAL_VARIABLES, true);
            }
            case PACKAGE: {
                return false;
            }
        }
        Logger.getLogger(MarkOccurrencesHighlighter.class.getName()).log(Level.INFO, "Unknow element type: {0}.", (Object)element.getKind());
        return true;
    }

    private final synchronized void setExitDetector(MethodExitDetector methodExitDetector) {
        this.exitDetector = methodExitDetector;
    }

    private final synchronized void setLocalUsages(FindLocalUsagesQuery findLocalUsagesQuery) {
        this.localUsages = findLocalUsagesQuery;
    }

    public final synchronized void cancel() {
        this.canceled = true;
        if (this.exitDetector != null) {
            this.exitDetector.cancel();
        }
        if (this.localUsages != null) {
            this.localUsages.cancel();
        }
    }

    protected final synchronized boolean isCancelled() {
        return this.canceled;
    }

    protected final synchronized void resume() {
        this.canceled = false;
    }

    private List<int[]> detectMethodsForClass(CompilationInfo compilationInfo, Document document, TreePath treePath, TypeElement typeElement, TypeElement typeElement2) {
        return this.detectMethodsForClass(compilationInfo, document, treePath, Collections.singletonList(typeElement), typeElement2);
    }

    private List<int[]> detectMethodsForClass(CompilationInfo compilationInfo, Document document, TreePath treePath, List<TypeElement> list, TypeElement typeElement) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        TypeElement typeElement2 = compilationInfo.getElements().getTypeElement("java.lang.Object");
        block0: for (Tree tree : classTree.getMembers()) {
            if (this.isCancelled()) {
                return null;
            }
            if (tree.getKind() != Tree.Kind.METHOD) continue;
            TreePath treePath2 = new TreePath(treePath, tree);
            Element element = compilationInfo.getTrees().getElement(treePath2);
            if (element.getKind() != ElementKind.METHOD) continue;
            for (TypeElement typeElement3 : list) {
                for (ExecutableElement executableElement : ElementFilter.methodsIn(compilationInfo.getElements().getAllMembers(typeElement3))) {
                    if (!compilationInfo.getElements().overrides((ExecutableElement)element, executableElement, typeElement) || !typeElement3.getKind().isClass() && ((Object)executableElement.getEnclosingElement()).equals(typeElement2)) continue;
                    Token<JavaTokenId> token = Utilities.getToken(compilationInfo, document, treePath2);
                    if (token == null) continue block0;
                    arrayList.add(new int[]{token.offset(null), token.offset(null) + token.length()});
                    continue block0;
                }
            }
        }
        return arrayList;
    }

    private List<int[]> detectBreakOrContinueTarget(CompilationInfo compilationInfo, Document document, TreePath treePath) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        StatementTree statementTree = compilationInfo.getTreeUtilities().getBreakContinueTarget(treePath);
        if (statementTree == null) {
            return null;
        }
        TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        tokenSequence.move((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), statementTree));
        if (tokenSequence.moveNext()) {
            arrayList.add(new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()});
        }
        StatementTree statementTree2 = statementTree.getKind() == Tree.Kind.LABELED_STATEMENT ? ((LabeledStatementTree)statementTree).getStatement() : statementTree;
        StatementTree statementTree3 = null;
        switch (statementTree2.getKind()) {
            case SWITCH: {
                statementTree3 = statementTree2;
                break;
            }
            case WHILE_LOOP: {
                if (((WhileLoopTree)statementTree2).getStatement().getKind() != Tree.Kind.BLOCK) break;
                statementTree3 = ((WhileLoopTree)statementTree2).getStatement();
                break;
            }
            case FOR_LOOP: {
                if (((ForLoopTree)statementTree2).getStatement().getKind() != Tree.Kind.BLOCK) break;
                statementTree3 = ((ForLoopTree)statementTree2).getStatement();
                break;
            }
            case DO_WHILE_LOOP: {
                if (((DoWhileLoopTree)statementTree2).getStatement().getKind() != Tree.Kind.BLOCK) break;
                statementTree3 = ((DoWhileLoopTree)statementTree2).getStatement();
            }
        }
        if (statementTree3 != null) {
            tokenSequence.move((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), statementTree3));
            if (tokenSequence.movePrevious() && tokenSequence.token().id() == JavaTokenId.RBRACE) {
                arrayList.add(new int[]{tokenSequence.offset(), tokenSequence.offset() + tokenSequence.token().length()});
            }
        }
        return arrayList;
    }

    static OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(MarkOccurrencesHighlighter.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, false);
            document.putProperty(MarkOccurrencesHighlighter.class, offsetsBag);
            Object object = document.getProperty("stream");
            final OffsetsBag offsetsBag2 = offsetsBag;
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    offsetsBag2.removeHighlights(documentEvent.getOffset(), documentEvent.getOffset(), false);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
            document.addDocumentListener(documentListener);
            if (object instanceof DataObject) {
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag", new Object[]{((DataObject)object).getPrimaryFile(), offsetsBag});
                Logger.getLogger("TIMER").log(Level.FINE, "MarkOccurrences Highlights Bag Listener", new Object[]{((DataObject)object).getPrimaryFile(), documentListener});
            }
        }
        return offsetsBag;
    }
}

