/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.ComponentView;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DrawEngineDocView;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.modules.editor.lib2.EditorApiPackageAccessor;

public class BaseTextUI
extends BasicTextUI
implements PropertyChangeListener,
DocumentListener,
SettingsChangeListener {
    static final String PROP_DEFAULT_CARET_BLINK_RATE = "nbeditor-default-swing-caret-blink-rate";
    private EditorUI editorUI;
    private boolean foldingEnabled;
    private boolean needsRefresh = false;
    int componentID = -1;
    private AbstractDocument lastDocument;
    private static final GetFocusedComponentAction gfcAction = new GetFocusedComponentAction();

    protected String getPropertyPrefix() {
        return "EditorPane";
    }

    public static JTextComponent getFocusedComponent() {
        return gfcAction.getFocusedComponent2();
    }

    protected boolean isRootViewReplaceNecessary() {
        boolean bl = false;
        Document document = this.getComponent().getDocument();
        if (document != this.lastDocument) {
            bl = true;
        }
        return bl;
    }

    protected void rootViewReplaceNotify() {
        this.lastDocument = (AbstractDocument)this.getComponent().getDocument();
    }

    protected void modelChanged() {
        JTextComponent jTextComponent = this.getComponent();
        Document document = jTextComponent.getDocument();
        if (document != null && !(document instanceof AbstractDocument)) {
            return;
        }
        AbstractDocument abstractDocument = (AbstractDocument)document;
        if (document != null) {
            Settings.KitAndValue[] kitAndValueArray;
            ViewFactory viewFactory = this.getRootView(jTextComponent).getViewFactory();
            BaseKit baseKit = (BaseKit)this.getEditorKit(jTextComponent);
            jTextComponent.removeAll();
            if (this.isRootViewReplaceNecessary()) {
                this.rootViewReplaceNotify();
                kitAndValueArray = document.getDefaultRootElement();
                View view = viewFactory.create((Element)kitAndValueArray);
                this.setView(view);
            }
            jTextComponent.revalidate();
            kitAndValueArray = Settings.getValueHierarchy(baseKit.getClass(), "doc-install-action-name-list");
            for (int i = kitAndValueArray.length - 1; i >= 0; --i) {
                List list = (List)kitAndValueArray[i].value;
                if ((list = baseKit.translateActionNameList(list)) == null) continue;
                for (Action action : list) {
                    action.actionPerformed(new ActionEvent(jTextComponent, 1001, ""));
                }
            }
        }
    }

    protected void installKeyboardActions() {
        String string = this.getPropertyPrefix() + ".actionMap";
        UIManager.getLookAndFeelDefaults().put(string, (Object)null);
        UIManager.getDefaults().put(string, (Object)null);
        super.installKeyboardActions();
    }

    public void installUI(JComponent jComponent) {
        Object object;
        super.installUI(jComponent);
        if (!(jComponent instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = this.getComponent();
        Object object2 = Settings.getValue(Utilities.getKitClass(jTextComponent), "margin");
        Insets insets = object2 instanceof Insets ? (Insets)object2 : null;
        jTextComponent.setMargin(insets);
        this.getEditorUI().installUI(jTextComponent);
        Object object3 = Settings.getValue(Utilities.getKitClass(jTextComponent), "code-folding-enable");
        this.foldingEnabled = object3 instanceof Boolean ? (Boolean)object3 : false;
        jTextComponent.putClientProperty("code-folding-enable", object3);
        Settings.addSettingsChangeListener(this);
        if (jTextComponent.getClientProperty(UIWatcher.class) == null) {
            object = new UIWatcher(this.getClass());
            jTextComponent.addPropertyChangeListener((PropertyChangeListener)object);
            jTextComponent.putClientProperty(UIWatcher.class, object);
        }
        object = (BaseKit)this.getEditorKit(jTextComponent);
        ViewFactory viewFactory = ((BaseKit)object).getViewFactory();
        Caret caret = jTextComponent.getCaret();
        Caret caret2 = ((BaseKit)object).createCaret();
        jTextComponent.setCaretColor(Color.black);
        jTextComponent.setCaret(caret2);
        jTextComponent.putClientProperty(PROP_DEFAULT_CARET_BLINK_RATE, caret.getBlinkRate());
        int n = SettingsUtil.getInteger(Utilities.getKitClass(jTextComponent), "caret-blink-rate", (int)SettingsDefaults.defaultCaretBlinkRate);
        if (n == -1) {
            n = caret.getBlinkRate();
        }
        caret2.setBlinkRate(n);
        SwingUtilities.replaceUIInputMap(jComponent, 0, null);
        Registry.addComponent(jTextComponent);
        Registry.activate(jTextComponent);
        EditorApiPackageAccessor.get().register(jTextComponent);
        jTextComponent.setCursor(Cursor.getPredefinedCursor(2));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        Settings.removeSettingsChangeListener(this);
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
            if (baseDocument != null) {
                baseDocument.removeDocumentListener(this);
            }
            jTextComponent.setKeymap(null);
            jTextComponent.setCaret(null);
            this.getEditorUI().uninstallUI(jTextComponent);
            Registry.removeComponent(jTextComponent);
        }
        this.editorUI = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getYFromPos(int n) throws BadLocationException {
        Object object;
        JTextComponent jTextComponent;
        block11: {
            jTextComponent = this.getComponent();
            if (jTextComponent != null) {
                object = jTextComponent.getDocument();
                if (object instanceof AbstractDocument) {
                    ((AbstractDocument)object).readLock();
                }
                try {
                    View view;
                    View view2 = this.getRootView(jTextComponent);
                    if (view2.getViewCount() <= 0 || !((view = view2.getView(0)) instanceof LockView)) break block11;
                    LockView lockView = (LockView)view;
                    lockView.lock();
                    try {
                        DrawEngineDocView drawEngineDocView = (DrawEngineDocView)view.getView(0);
                        Rectangle rectangle = this.getVisibleEditorRect();
                        if (rectangle != null) {
                            view2.setSize(rectangle.width, rectangle.height);
                            int n2 = drawEngineDocView.getYFromPos(n, rectangle);
                            return n2;
                        }
                    }
                    finally {
                        lockView.unlock();
                    }
                }
                finally {
                    if (object instanceof AbstractDocument) {
                        ((AbstractDocument)object).readUnlock();
                    }
                }
            }
        }
        return (object = this.modelToView(jTextComponent, n)) == null ? 0 : ((Rectangle)object).y;
    }

    public int getPosFromY(int n) throws BadLocationException {
        return this.viewToModel(this.getComponent(), 0, n);
    }

    public int getBaseX(int n) {
        return this.getEditorUI().getTextMargin().left;
    }

    public int viewToModel(JTextComponent jTextComponent, int n, int n2) {
        return this.viewToModel(jTextComponent, new Point(n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damageRange(JTextComponent jTextComponent, int n, int n2, Position.Bias bias, Position.Bias bias2) {
        View view;
        View view2 = this.getRootView(this.getComponent());
        boolean bl = true;
        if (view2.getViewCount() > 0 && (view = view2.getView(0)) instanceof LockView) {
            LockView lockView = (LockView)view;
            lockView.lock();
            try {
                DrawEngineDocView drawEngineDocView = (DrawEngineDocView)view.getView(0);
                bl = drawEngineDocView.checkDamageRange(n, n2, bias, bias2);
            }
            finally {
                lockView.unlock();
            }
        }
        if (bl) {
            super.damageRange(jTextComponent, n, n2, bias, bias2);
        }
    }

    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
        if (biasArray == null) {
            biasArray = new Position.Bias[]{Position.Bias.Forward};
        }
        return super.getNextVisualPositionFrom(jTextComponent, n, bias, n2, biasArray);
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        JEditorPane jEditorPane = (JEditorPane)this.getComponent();
        return jEditorPane == null ? null : jEditorPane.getEditorKit();
    }

    public EditorUI getEditorUI() {
        JTextComponent jTextComponent;
        BaseKit baseKit;
        if (this.editorUI == null && (baseKit = (BaseKit)this.getEditorKit(jTextComponent = this.getComponent())) != null) {
            this.editorUI = baseKit.createEditorUI();
            this.editorUI.initLineHeight(jTextComponent);
        }
        return this.editorUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        JTextComponent jTextComponent;
        String string = propertyChangeEvent.getPropertyName();
        if ("document".equals(string)) {
            BaseDocument baseDocument;
            BaseDocument baseDocument2;
            BaseDocument baseDocument3 = baseDocument2 = propertyChangeEvent.getOldValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getOldValue() : null;
            if (baseDocument2 != null) {
                baseDocument2.removeDocumentListener(this);
            }
            BaseDocument baseDocument4 = baseDocument = propertyChangeEvent.getNewValue() instanceof BaseDocument ? (BaseDocument)propertyChangeEvent.getNewValue() : null;
            if (baseDocument != null) {
                baseDocument.addDocumentListener(this);
                Registry.activate(baseDocument);
            }
        } else if ("ancestor".equals(string) && (jTextComponent = (JTextComponent)propertyChangeEvent.getSource()).isDisplayable() && this.editorUI != null && this.editorUI.hasExtComponent() && !Boolean.TRUE.equals(jTextComponent.getClientProperty("ancestorOverride"))) {
            jTextComponent.putClientProperty("ancestorOverride", Boolean.TRUE);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        try {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            EditorUI editorUI = this.getEditorUI();
            int n = this.getYFromPos(documentEvent.getOffset());
            int n2 = editorUI.getLineHeight();
            int n3 = this.getYFromPos(baseDocumentEvent.getSyntaxUpdateOffset());
            if (baseDocumentEvent.getSyntaxUpdateOffset() == documentEvent.getDocument().getLength()) {
                n3 += n2;
            }
            if (this.getComponent().isShowing()) {
                editorUI.repaint(n, Math.max(n2, n3 - n));
            }
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        try {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            EditorUI editorUI = this.getEditorUI();
            int n = this.getYFromPos(documentEvent.getOffset());
            int n2 = editorUI.getLineHeight();
            int n3 = this.getYFromPos(baseDocumentEvent.getSyntaxUpdateOffset());
            if (baseDocumentEvent.getSyntaxUpdateOffset() == documentEvent.getDocument().getLength()) {
                n3 += n2;
            }
            if (this.getComponent().isShowing()) {
                editorUI.repaint(n, Math.max(n2, n3 - n));
            }
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent instanceof BaseDocumentEvent) {
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            BaseDocument baseDocument = (BaseDocument)baseDocumentEvent.getDocument();
            String string = baseDocumentEvent.getDrawLayerName();
            if (string != null) {
                this.getEditorUI().addLayer(baseDocument.findLayer(string), baseDocumentEvent.getDrawLayerVisibility());
            } else {
                try {
                    JTextComponent jTextComponent = this.getComponent();
                    if (jTextComponent != null && jTextComponent.isShowing()) {
                        this.getEditorUI().repaintBlock(documentEvent.getOffset(), documentEvent.getOffset() + documentEvent.getLength());
                    }
                }
                catch (BadLocationException badLocationException) {
                    Utilities.annotateLoggable(badLocationException);
                }
            }
        }
    }

    public View create(Element element) {
        String string = element.getName();
        if (string != null) {
            if (string.equals("content")) {
                return new LabelView(element);
            }
            if (string.equals("paragraph")) {
                return new DrawEngineLineView(element);
            }
            if (string.equals("section")) {
                return new LockView(new DrawEngineDocView(element));
            }
            if (string.equals("component")) {
                return new ComponentView(element);
            }
            if (string.equals("icon")) {
                return new IconView(element);
            }
        }
        return new DrawEngineLineView(element);
    }

    public View create(Element element, int n, int n2) {
        return null;
    }

    public void preferenceChanged(boolean bl, boolean bl2) {
        this.modelChanged();
    }

    public void invalidateStartY() {
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        if (settingsChangeEvent == null || Utilities.getKitClass(jTextComponent) != settingsChangeEvent.getKitClass()) {
            return;
        }
        if ("code-folding-enable".equals(settingsChangeEvent.getSettingName())) {
            Boolean bl = (Boolean)Settings.getValue(settingsChangeEvent.getKitClass(), "code-folding-enable");
            this.foldingEnabled = bl;
            jTextComponent.putClientProperty("code-folding-enable", bl);
            this.needsRefresh = true;
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    BaseTextUI.this.refresh();
                }
            });
        }
    }

    boolean isFoldingEnabled() {
        return this.foldingEnabled;
    }

    protected void refresh() {
        if (this.getComponent().isShowing() && this.needsRefresh) {
            this.modelChanged();
            this.needsRefresh = false;
        }
    }

    static void uninstallUIWatcher(JTextComponent jTextComponent) {
        UIWatcher uIWatcher = (UIWatcher)jTextComponent.getClientProperty(UIWatcher.class);
        if (uIWatcher != null) {
            jTextComponent.removePropertyChangeListener(uIWatcher);
            jTextComponent.putClientProperty(UIWatcher.class, null);
        }
    }

    static class UIWatcher
    implements PropertyChangeListener {
        private Class uiClass;

        UIWatcher(Class clazz) {
            this.uiClass = clazz;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JTextComponent jTextComponent;
            EditorKit editorKit;
            Object object = propertyChangeEvent.getNewValue();
            if ("UI".equals(propertyChangeEvent.getPropertyName()) && object != null && !(object instanceof BaseTextUI) && (editorKit = ((TextUI)object).getEditorKit(jTextComponent = (JTextComponent)propertyChangeEvent.getSource())) instanceof BaseKit) {
                try {
                    jTextComponent.setUI((BaseTextUI)this.uiClass.newInstance());
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static class GetFocusedComponentAction
    extends TextAction {
        private GetFocusedComponentAction() {
            super("get-focused-component");
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        JTextComponent getFocusedComponent2() {
            return super.getFocusedComponent();
        }
    }
}

