/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.netbeans.editor.AnnotationDesc;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawEngine;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.FindSupport;
import org.netbeans.editor.Mark;
import org.netbeans.editor.MarkChain;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.MarkVector;
import org.netbeans.editor.MultiMark;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.StringMap;
import org.netbeans.editor.TokenCategory;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;

public class DrawLayerFactory {
    private static final Logger LOG = Logger.getLogger(DrawLayerFactory.class.getName());
    public static final String SYNTAX_LAYER_NAME = "syntax-layer";
    public static final int SYNTAX_LAYER_VISIBILITY = 1000;
    public static final String ANNOTATION_LAYER_NAME = "annotation-layer";
    public static final int ANNOTATION_LAYER_VISIBILITY = 2100;
    public static final String HIGHLIGHT_SEARCH_LAYER_NAME = "highlight-search-layer";
    public static final int HIGHLIGHT_SEARCH_LAYER_VISIBILITY = 9000;
    public static final String INC_SEARCH_LAYER_NAME = "inc-search-layer";
    public static final int INC_SEARCH_LAYER_VISIBILITY = 9500;
    public static final String BLOCK_SEARCH_LAYER_NAME = "block-search-layer";
    public static final int BLOCK_SEARCH_LAYER_VISIBILITY = 8500;
    public static final String CARET_LAYER_NAME = "caret-layer";
    public static final int CARET_LAYER_VISIBILITY = 10000;
    public static final String GUARDED_LAYER_NAME = "guarded-layer";
    public static final int GUARDED_LAYER_VISIBILITY = 1400;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MarkFactory.DrawMark getFoldedMark(DrawEngineLineView drawEngineLineView, String string) {
        MarkVector markVector;
        BaseDocument baseDocument = (BaseDocument)drawEngineLineView.getDocument();
        int n = drawEngineLineView.getStartOffset();
        int n2 = drawEngineLineView.getEndOffset() - 1;
        MarkVector markVector2 = markVector = baseDocument.marksStorage;
        synchronized (markVector2) {
            int n3 = 0;
            int n4 = markVector.getMarkCount() - 1;
            while (n3 < n4) {
                int n5 = n3 + n4 >> 1;
                int n6 = markVector.getMarkOffsetInternal(n5) - n2;
                if (n6 < 0) {
                    n3 = n5 + 1;
                    continue;
                }
                if (n6 > 0) {
                    n4 = n5 - 1;
                    continue;
                }
                while (++n5 <= n4 && markVector.getMarkOffsetInternal(n5) == n2) {
                }
                n3 = n4 = n5 - 1;
            }
            while (n3 >= 0 && n3 < markVector.getMarkCount()) {
                MultiMark multiMark;
                if (!(multiMark = markVector.getMark(n3--)).isValid() || multiMark.getOffset() > n2) continue;
                if (multiMark.getOffset() < n) break;
                Mark mark = baseDocument.marks.get(multiMark);
                if (!(mark instanceof MarkFactory.DrawMark) || !string.equals(((MarkFactory.DrawMark)mark).layerName)) continue;
                return (MarkFactory.DrawMark)mark;
            }
        }
        return null;
    }

    public static class AnnotationLayer
    extends DrawLayer.AbstractLayer {
        private Coloring coloring = null;
        private MarkChain markChain;

        public AnnotationLayer(BaseDocument baseDocument) {
            super(DrawLayerFactory.ANNOTATION_LAYER_NAME);
            this.markChain = new MarkChain(baseDocument, DrawLayerFactory.ANNOTATION_LAYER_NAME);
        }

        public final MarkChain getMarkChain() {
            return this.markChain;
        }

        public boolean extendsEOL() {
            return true;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n;
            Object object;
            this.coloring = null;
            if (drawMark == null) {
                Object object2 = object = drawContext instanceof DrawEngine.DrawInfo ? ((DrawEngine.DrawInfo)drawContext).view : null;
                if (object instanceof DrawEngineLineView) {
                    drawMark = DrawLayerFactory.getFoldedMark((DrawEngineLineView)object, this.getName());
                }
            }
            if (drawMark == null) {
                return false;
            }
            if (drawContext.getEditorUI().getComponent() == null || !drawMark.activateLayer) {
                return false;
            }
            object = drawContext.getEditorUI().getDocument();
            AnnotationDesc annotationDesc = ((BaseDocument)object).getAnnotations().getActiveAnnotation(drawMark);
            if (annotationDesc == null) {
                AnnotationDesc annotationDesc2 = ((BaseDocument)object).getAnnotations().getLineActiveAnnotation(drawMark);
                if (annotationDesc2 == null) {
                    return false;
                }
                if (drawContext.getFragmentOffset() >= annotationDesc2.getOffset() && (drawContext.getFragmentOffset() < annotationDesc2.getOffset() + annotationDesc2.getLength() || annotationDesc2.isWholeLine())) {
                    this.coloring = annotationDesc2.getColoring();
                    return true;
                }
                return false;
            }
            if (annotationDesc.isWholeLine()) {
                try {
                    n = Utilities.getRowEnd((BaseDocument)object, drawContext.getFragmentOffset());
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.FINE, null, badLocationException);
                    return false;
                }
            } else {
                n = annotationDesc.getOffset() + annotationDesc.getLength();
            }
            this.setNextActivityChangeOffset(n);
            this.coloring = annotationDesc.getColoring();
            return true;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }
    }

    public static class WordColoringLayer
    extends DrawLayer.AbstractLayer {
        protected StringMap stringMap = new StringMap();

        public WordColoringLayer(String string) {
            super(string);
        }

        public void put(String string, Coloring coloring) {
            this.stringMap.put(string, coloring);
        }

        public void put(String[] stringArray, Coloring coloring) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.put(stringArray[i], coloring);
            }
        }

        public void put(List list, Coloring coloring) {
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            this.put(stringArray, coloring);
        }

        public void init(DrawContext drawContext) {
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            return true;
        }

        public void updateContext(DrawContext drawContext) {
            Coloring coloring = (Coloring)this.stringMap.get(drawContext.getBuffer(), drawContext.getTokenOffset(), drawContext.getTokenLength());
            if (coloring != null) {
                coloring.apply(drawContext);
            }
        }
    }

    public static class StyleLayer
    extends DrawLayer.AbstractLayer {
        protected Style style;
        protected MarkChain markChain;
        protected Color backColor;
        protected Color foreColor;

        public StyleLayer(String string, BaseDocument baseDocument, Style style) {
            super(string);
            this.style = style;
            this.markChain = new MarkChain(baseDocument, string);
        }

        public boolean extendsEOL() {
            return true;
        }

        public final MarkChain getMarkChain() {
            return this.markChain;
        }

        public void init(DrawContext drawContext) {
            this.foreColor = StyleConstants.getForeground(this.style);
            this.backColor = StyleConstants.getBackground(this.style);
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = false;
            if (drawMark != null) {
                boolean bl2 = bl = drawContext.getEditorUI().getComponent() != null && drawMark.activateLayer;
                if (bl) {
                    try {
                        BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                        int n = Utilities.getRowStart(baseDocument, drawContext.getFragmentOffset(), 1);
                        if (n < 0) {
                            n = Integer.MAX_VALUE;
                        }
                        this.setNextActivityChangeOffset(n);
                    }
                    catch (BadLocationException badLocationException) {
                        bl = false;
                    }
                }
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.foreColor != null) {
                drawContext.setForeColor(this.foreColor);
            }
            if (this.backColor != null) {
                drawContext.setBackColor(this.backColor);
            }
        }

        public String toString() {
            return super.toString() + (this.markChain != null ? ", " + this.markChain : "");
        }
    }

    public static class BlockSearchLayer
    extends DrawLayer.AbstractLayer
    implements SettingsChangeListener {
        Coloring coloring;
        int pos;
        int len;
        boolean enabled;

        public BlockSearchLayer() {
            super(DrawLayerFactory.BLOCK_SEARCH_LAYER_NAME);
            Settings.addSettingsChangeListener(this);
        }

        public boolean extendsEmptyLine() {
            return true;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        void setArea(int n, int n2) {
            this.pos = n;
            this.len = n2;
        }

        int getOffset() {
            return this.pos;
        }

        int getLength() {
            return this.len;
        }

        public void init(DrawContext drawContext) {
            this.setNextActivityChangeOffset(this.enabled ? this.pos : Integer.MAX_VALUE);
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            int n;
            boolean bl = false;
            if (this.enabled && (n = drawContext.getFragmentOffset()) >= this.pos && n < this.pos + this.len) {
                bl = true;
                try {
                    BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                    int n2 = Utilities.getRowStart(baseDocument, n, 1);
                    if (n2 < 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                    this.setNextActivityChangeOffset(Math.min(n2, this.pos + this.len));
                }
                catch (BadLocationException badLocationException) {
                    bl = false;
                }
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring == null) {
                this.coloring = drawContext.getEditorUI().getColoring("block-search");
            }
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }

        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            String string;
            if (settingsChangeEvent != null && (string = "block-search-coloring").equals(settingsChangeEvent.getSettingName())) {
                this.coloring = null;
            }
        }
    }

    public static class IncSearchLayer
    extends DrawLayer.AbstractLayer
    implements SettingsChangeListener {
        Coloring coloring;
        Coloring invertedColoring;
        int pos;
        int len;
        boolean enabled;
        boolean invert;

        public IncSearchLayer() {
            super(DrawLayerFactory.INC_SEARCH_LAYER_NAME);
            Settings.addSettingsChangeListener(this);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        void setArea(int n, int n2) {
            this.pos = n;
            this.len = n2;
        }

        public int getOffset() {
            return this.pos;
        }

        public int getLength() {
            return this.len;
        }

        public void init(DrawContext drawContext) {
            this.setNextActivityChangeOffset(this.enabled ? this.pos : Integer.MAX_VALUE);
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = false;
            if (this.enabled && drawContext.getFragmentOffset() == this.pos) {
                bl = true;
                this.setNextActivityChangeOffset(this.pos + this.len);
            }
            return bl;
        }

        void setInversion(boolean bl) {
            this.invert = bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (!this.invert) {
                if (this.coloring == null) {
                    this.coloring = drawContext.getEditorUI().getColoring("inc-search");
                }
                if (this.coloring != null) {
                    this.coloring.apply(drawContext);
                }
            } else {
                if (this.invertedColoring == null) {
                    this.invertedColoring = drawContext.getEditorUI().getColoring("selection");
                }
                if (this.invertedColoring != null) {
                    this.invertedColoring.apply(drawContext);
                }
            }
        }

        public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
            String string;
            if (settingsChangeEvent != null && (string = "inc-search-coloring").equals(settingsChangeEvent.getSettingName())) {
                this.coloring = null;
            }
        }
    }

    public static class HighlightSearchLayer
    extends DrawLayer.AbstractLayer {
        int[] blocks = new int[]{-1, -1};
        Coloring coloring;
        int curInd;
        boolean enabled;

        public HighlightSearchLayer() {
            super(DrawLayerFactory.HIGHLIGHT_SEARCH_LAYER_NAME);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void init(DrawContext drawContext) {
            if (this.enabled) {
                try {
                    BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
                    this.blocks = FindSupport.getFindSupport().getBlocks(this.blocks, baseDocument, drawContext.getStartOffset(), drawContext.getEndOffset());
                }
                catch (BadLocationException badLocationException) {
                    this.blocks = new int[]{-1, -1};
                }
                this.coloring = null;
                this.curInd = 0;
            }
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl;
            if (this.enabled) {
                int n = drawContext.getFragmentOffset();
                if (n == this.blocks[this.curInd]) {
                    bl = true;
                    this.setNextActivityChangeOffset(this.blocks[this.curInd + 1]);
                } else if (n == this.blocks[this.curInd + 1]) {
                    bl = false;
                    this.curInd += 2;
                    this.setNextActivityChangeOffset(this.blocks[this.curInd]);
                    if (n == this.blocks[this.curInd]) {
                        this.setNextActivityChangeOffset(this.blocks[this.curInd + 1]);
                        bl = true;
                    }
                } else {
                    this.setNextActivityChangeOffset(this.blocks[this.curInd]);
                    bl = false;
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            int n = drawContext.getFragmentOffset();
            if (n >= this.blocks[this.curInd] && n < this.blocks[this.curInd + 1]) {
                if (this.coloring == null) {
                    this.coloring = drawContext.getEditorUI().getColoring("highlight-search");
                }
                if (this.coloring != null) {
                    this.coloring.apply(drawContext);
                }
            }
        }
    }

    public static class CaretLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;

        public CaretLayer() {
            super(DrawLayerFactory.CARET_LAYER_NAME);
        }

        public boolean extendsEmptyLine() {
            return true;
        }

        public void init(DrawContext drawContext) {
            this.coloring = null;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            JTextComponent jTextComponent;
            boolean bl = drawMark != null ? drawMark.activateLayer : (jTextComponent = drawContext.getEditorUI().getComponent()) != null && Utilities.isSelectionShowing(jTextComponent) && drawContext.getFragmentOffset() >= jTextComponent.getSelectionStart() && drawContext.getFragmentOffset() < jTextComponent.getSelectionEnd();
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring == null) {
                this.coloring = drawContext.getEditorUI().getColoring("selection");
            }
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }
    }

    public static abstract class ColorLineLayer
    extends DrawLayer.AbstractLayer {
        Coloring coloring;

        public ColorLineLayer(String string) {
            super(string);
        }

        public boolean extendsEOL() {
            return true;
        }

        public void init(DrawContext drawContext) {
            this.coloring = null;
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl;
            Object object;
            if (drawMark == null) {
                DrawEngineLineView drawEngineLineView;
                Object object2 = object = drawContext instanceof DrawEngine.DrawInfo ? ((DrawEngine.DrawInfo)drawContext).view.getParent() : null;
                if (object instanceof DrawEngineLineView && (drawMark = DrawLayerFactory.getFoldedMark(drawEngineLineView = (DrawEngineLineView)object, this.getName())) == null && (object = drawEngineLineView.getView(drawEngineLineView.getViewCount() - 1)) instanceof DrawEngineLineView) {
                    drawEngineLineView = (DrawEngineLineView)object;
                    drawMark = DrawLayerFactory.getFoldedMark(drawEngineLineView, this.getName());
                }
            }
            if (drawMark != null) {
                boolean bl2 = bl = drawContext.getEditorUI().getComponent() != null && drawMark.activateLayer;
                if (bl) {
                    try {
                        object = drawContext.getEditorUI().getDocument();
                        int n = Utilities.getRowStart((BaseDocument)object, drawContext.getFragmentOffset(), 1);
                        if (n < 0) {
                            n = Integer.MAX_VALUE;
                        }
                        this.setNextActivityChangeOffset(n);
                    }
                    catch (BadLocationException badLocationException) {
                        bl = false;
                    }
                }
            } else {
                bl = false;
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (this.coloring == null) {
                this.coloring = this.getColoring(drawContext);
            }
            if (this.coloring != null) {
                this.coloring.apply(drawContext);
            }
        }

        protected abstract Coloring getColoring(DrawContext var1);
    }

    public static class SyntaxLayer
    extends DrawLayer.AbstractLayer {
        public SyntaxLayer() {
            super(DrawLayerFactory.SYNTAX_LAYER_NAME);
        }

        public void init(DrawContext drawContext) {
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            return true;
        }

        public void updateContext(DrawContext drawContext) {
            TokenID tokenID = drawContext.getTokenID();
            TokenContextPath tokenContextPath = drawContext.getTokenContextPath();
            if (tokenID != null && tokenContextPath != null) {
                String string = tokenContextPath.getFullTokenName(tokenID);
                Coloring coloring = drawContext.getEditorUI().getColoring(string);
                if (coloring != null) {
                    coloring.apply(drawContext);
                } else {
                    TokenCategory tokenCategory = tokenID.getCategory();
                    if (tokenCategory != null) {
                        string = tokenContextPath.getFullTokenName(tokenCategory);
                        coloring = drawContext.getEditorUI().getColoring(string);
                        if (coloring != null) {
                            coloring.apply(drawContext);
                        }
                    }
                }
            }
        }
    }
}

