/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorDebug;
import org.netbeans.editor.HighlightingDrawLayer;

class DrawLayerList {
    private static final Logger LOG = Logger.getLogger(DrawLayerList.class.getName());
    private static final DrawLayer[] EMPTY = new DrawLayer[0];
    private DrawLayer[] layers = EMPTY;
    private static final Set<String> ISSUED_WARNINGS = Collections.synchronizedSet(new HashSet());
    private final ArrayList visibilityList = new ArrayList();

    DrawLayerList() {
    }

    synchronized boolean add(DrawLayer drawLayer, int n) {
        String string;
        if (this.indexOf(drawLayer.getName()) >= 0) {
            return false;
        }
        if (!(drawLayer instanceof HighlightingDrawLayer) && !ISSUED_WARNINGS.contains(string = drawLayer.getClass().getName() + drawLayer.getName())) {
            ISSUED_WARNINGS.add(string);
            LOG.log(Level.WARNING, "Using deprecated DrawLayer: " + drawLayer.getName() + " z-order: " + n + " class: " + drawLayer.getClass().getName() + " " + drawLayer);
        }
        int n2 = this.layers.length;
        for (int i = 0; i < this.layers.length; ++i) {
            if ((Integer)this.visibilityList.get(i) <= n) continue;
            n2 = i;
            break;
        }
        ArrayList<DrawLayer> arrayList = new ArrayList<DrawLayer>(Arrays.asList(this.layers));
        arrayList.add(n2, drawLayer);
        this.layers = new DrawLayer[this.layers.length + 1];
        arrayList.toArray(this.layers);
        this.visibilityList.add(n2, new Integer(n));
        return true;
    }

    synchronized void add(DrawLayerList drawLayerList) {
        DrawLayer[] drawLayerArray = drawLayerList.layers;
        for (int i = 0; i < drawLayerArray.length; ++i) {
            this.add(drawLayerArray[i], (Integer)drawLayerList.visibilityList.get(i));
        }
    }

    synchronized DrawLayer remove(String string) {
        int n = this.indexOf(string);
        DrawLayer drawLayer = null;
        if (n >= 0) {
            drawLayer = this.layers[n];
            ArrayList<DrawLayer> arrayList = new ArrayList<DrawLayer>(Arrays.asList(this.layers));
            arrayList.remove(n);
            this.layers = new DrawLayer[this.layers.length - 1];
            arrayList.toArray(this.layers);
            this.visibilityList.remove(n);
        }
        return drawLayer;
    }

    synchronized void remove(DrawLayerList drawLayerList) {
        DrawLayer[] drawLayerArray = drawLayerList.layers;
        for (int i = 0; i < drawLayerArray.length; ++i) {
            this.remove(drawLayerArray[i].getName());
        }
    }

    synchronized DrawLayer findLayer(String string) {
        int n = this.indexOf(string);
        return n >= 0 ? this.layers[n] : null;
    }

    synchronized DrawLayer[] currentLayers() {
        return (DrawLayer[])this.layers.clone();
    }

    private int indexOf(String string) {
        for (int i = 0; i < this.layers.length; ++i) {
            if (!string.equals(this.layers[i].getName())) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        switch (this.layers.length) {
            case 0: {
                return "No layers";
            }
            case 1: {
                return "Standalone " + this.layers[0];
            }
        }
        return "Layers:\n" + EditorDebug.debugArray(this.layers);
    }
}

