/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.EditorState;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.GotoDialogPanel;
import org.netbeans.editor.ext.KeyEventBlocker;
import org.openide.util.NbBundle;

public class GotoDialogSupport
implements ActionListener {
    private static final String BOUNDS_KEY = "GotoDialogSupport.bounds-goto-line";
    private JButton[] gotoButtons;
    private GotoDialogPanel gotoPanel;
    private static Dialog gotoDialog;

    public GotoDialogSupport() {
        ResourceBundle resourceBundle = NbBundle.getBundle(BaseKit.class);
        JButton jButton = new JButton(resourceBundle.getString("goto-button-goto"));
        JButton jButton2 = new JButton(resourceBundle.getString("goto-button-cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_goto-button-goto"));
        jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_goto-button-cancel"));
        this.gotoButtons = new JButton[]{jButton, jButton2};
        this.gotoPanel = new GotoDialogPanel();
        this.gotoPanel.getGotoCombo().getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    GotoDialogSupport.this.actionPerformed(new ActionEvent(GotoDialogSupport.this.gotoButtons[0], 0, null));
                }
                if (!Character.isDigit(keyEvent.getKeyChar()) && !Character.isISOControl(keyEvent.getKeyChar())) {
                    keyEvent.consume();
                    Component component = keyEvent.getComponent();
                    if (component != null) {
                        component.getToolkit().beep();
                    }
                }
            }
        });
    }

    protected synchronized Dialog createGotoDialog() {
        if (gotoDialog == null) {
            gotoDialog = DialogSupport.createDialog(NbBundle.getBundle(BaseKit.class).getString("goto-title"), this.gotoPanel, false, this.gotoButtons, false, 0, 1, this);
            gotoDialog.pack();
            Rectangle rectangle = (Rectangle)EditorState.get(BOUNDS_KEY);
            if (rectangle != null) {
                gotoDialog.setBounds(rectangle);
            } else {
                Dimension dimension = gotoDialog.getPreferredSize();
                Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
                int n = Math.max(0, (dimension2.width - dimension.width) / 2);
                int n2 = Math.max(0, (dimension2.height - dimension.height) / 2);
                gotoDialog.setLocation(n, n2);
            }
            return gotoDialog;
        }
        gotoDialog.setVisible(true);
        gotoDialog.toFront();
        return null;
    }

    protected synchronized void disposeGotoDialog() {
        if (gotoDialog != null) {
            EditorState.put(BOUNDS_KEY, gotoDialog.getBounds());
            gotoDialog.dispose();
            Utilities.returnFocus();
        }
        gotoDialog = null;
    }

    public void showGotoDialog(final KeyEventBlocker keyEventBlocker) {
        Dialog dialog = this.createGotoDialog();
        if (dialog == null) {
            return;
        }
        dialog.setVisible(true);
        this.gotoPanel.popupNotify(keyEventBlocker);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GotoDialogSupport.this.disposeGotoDialog();
            }

            public void windowClosed(WindowEvent windowEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (keyEventBlocker != null) {
                            keyEventBlocker.stopBlocking(false);
                        }
                        Utilities.returnFocus();
                    }
                });
            }
        };
        dialog.addWindowListener(windowAdapter);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.gotoButtons[0] || object == this.gotoPanel) {
            if (this.performGoto()) {
                this.gotoPanel.updateHistory();
                this.disposeGotoDialog();
            }
        } else {
            this.disposeGotoDialog();
        }
    }

    protected boolean performGoto() {
        block6: {
            JTextComponent jTextComponent = Utilities.getLastActiveComponent();
            if (jTextComponent != null) {
                try {
                    Object object;
                    int n = Integer.parseInt(this.gotoPanel.getValue());
                    BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                    if (baseDocument == null) break block6;
                    int n2 = Utilities.getRowCount(baseDocument);
                    if (n > n2) {
                        n = n2;
                    }
                    int n3 = Utilities.getRowStartFromLineOffset(baseDocument, n - 1);
                    BaseKit baseKit = Utilities.getKit(jTextComponent);
                    if (baseKit != null && (object = baseKit.getActionByName("goto")) instanceof ExtKit.GotoAction) {
                        n3 = ((ExtKit.GotoAction)object).getOffsetFromLine(baseDocument, n - 1);
                    }
                    if (n3 != -1) {
                        object = jTextComponent.getCaret();
                        object.setDot(n3);
                        break block6;
                    }
                    jTextComponent.getToolkit().beep();
                    return false;
                }
                catch (NumberFormatException numberFormatException) {
                    jTextComponent.getToolkit().beep();
                    return false;
                }
            }
        }
        return true;
    }
}

