/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.CustomAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.SaasCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.model.CustomSaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomCodeGenerator
extends SaasCodeGenerator {
    private Constants.DropFileType dropFileType;
    private FileObject serviceFolder;
    private CustomAuthenticationGenerator authGen;

    public CustomCodeGenerator(JTextComponent jTextComponent, FileObject fileObject, CustomSaasMethod customSaasMethod) throws IOException {
        this(jTextComponent, fileObject, new CustomSaasBean(customSaasMethod));
    }

    public CustomCodeGenerator(JTextComponent jTextComponent, FileObject fileObject, CustomSaasBean customSaasBean) throws IOException {
        super(jTextComponent, fileObject, customSaasBean);
        this.authGen = new CustomAuthenticationGenerator(customSaasBean, this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
    }

    @Override
    public CustomSaasBean getBean() {
        return (CustomSaasBean)this.bean;
    }

    public CustomAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public Constants.DropFileType getDropFileType() {
        return this.dropFileType;
    }

    void setDropFileType(Constants.DropFileType dropFileType) {
        this.dropFileType = dropFileType;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            this.serviceFolder = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], this.getBean().getSaasServicePackageName(), true);
        }
        return this.serviceFolder;
    }

    @Override
    protected void preGenerate() throws IOException {
        CustomCodeGenerator.createRestConnectionFile(this.getProject());
        if (this.getBean().getMethod().getSaas().getLibraryJars().size() > 0) {
            Util.addClientJars(this.getBean(), this.getProject(), null);
        }
        this.getTargetFolder().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                Map<String, String> map = CustomCodeGenerator.this.getBean().getArtifactTemplates();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    Util.createDataObjectFromTemplate(string2, CustomCodeGenerator.this.getSaasServiceFolder(), string);
                }
            }
        });
    }

    @Override
    protected String getCustomMethodBody() throws IOException {
        String string = "";
        int n = 0;
        for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
            if (n++ > 0) {
                string = string + ", ";
            }
            string = string + this.getParameterName(parameterInfo, true, true);
        }
        return "return execute(" + string + ")";
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List<ParameterInfo> list = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            ParameterInfo parameterInfo = Util.findParameter(this.getBean().getInputParameters(), "Content-Type");
            Class clazz = InputStream.class;
            if (parameterInfo == null) {
                list.add(new ParameterInfo("Content-Type", String.class));
            } else if (!parameterInfo.isFixed() && !list.contains(parameterInfo)) {
                list.add(parameterInfo);
            } else {
                String string = Util.findParamValue(parameterInfo);
                if (string.equals("text/plain") || string.equals("application/xml") || string.equals("text/xml")) {
                    clazz = String.class;
                }
            }
            list.add(new ParameterInfo("content", clazz));
        }
        return list;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list, String string) {
        if (string == null) {
            string = " ";
        }
        String string2 = "";
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getVariableName(parameterInfo.getName());
            String string4 = Util.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                string2 = string2 + string + parameterInfo.getType().getName() + " " + string3 + " = " + string4 + ";\n";
                continue;
            }
            if (string4 != null) {
                string2 = string2 + string + "String " + string3 + " = \"" + string4 + "\";\n";
                continue;
            }
            string2 = string2 + string + "String " + string3 + " = null;\n";
        }
        return string2;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list) {
        String string = "                 ";
        return this.getHeaderOrParameterDeclaration(list, string);
    }

    public static List<ParameterInfo> getAuthenticatorMethodParametersForWeb() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.add(new ParameterInfo("request", Object.class, "HttpServletRequest"));
        arrayList.add(new ParameterInfo("response", Object.class, "HttpServletResponse"));
        return arrayList;
    }

    public static List<ParameterInfo> getServiceMethodParametersForWeb(CustomSaasBean customSaasBean) {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        arrayList.addAll(CustomCodeGenerator.getAuthenticatorMethodParametersForWeb());
        arrayList.addAll(customSaasBean.filterParametersByAuth(customSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED})));
        return arrayList;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }
}

