/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.CustomCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.CustomJavaClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.CustomJspCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.CustomServletCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class CustomCodeGeneratorFactory {
    public static CustomCodeGenerator create(JTextComponent jTextComponent, FileObject fileObject, CustomSaasMethod customSaasMethod) throws IOException {
        CustomJavaClientCodeGenerator customJavaClientCodeGenerator = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (Util.isRestJavaFile(dataObject) || Util.isServlet(dataObject)) {
                customJavaClientCodeGenerator = new CustomServletCodeGenerator(jTextComponent, fileObject, customSaasMethod);
                if (Util.isServlet(dataObject)) {
                    customJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.SERVLET);
                } else {
                    customJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.RESOURCE);
                }
            } else if (Util.isJsp(dataObject)) {
                customJavaClientCodeGenerator = new CustomJspCodeGenerator(jTextComponent, fileObject, customSaasMethod);
                customJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.JSP);
            } else {
                customJavaClientCodeGenerator = new CustomJavaClientCodeGenerator(jTextComponent, fileObject, customSaasMethod);
                customJavaClientCodeGenerator.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new IOException(dataObjectNotFoundException.getMessage());
        }
        return customJavaClientCodeGenerator;
    }
}

