/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.saas.codegen.java.CustomCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.CustomCodeGeneratorFactory;
import org.netbeans.modules.websvc.saas.codegen.java.CustomCodeSetupPanel;
import org.netbeans.modules.websvc.saas.codegen.java.ProgressDialog;
import org.netbeans.modules.websvc.saas.codegen.java.model.CustomSaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CustomEditorDrop
implements ActiveEditorDrop {
    private CustomSaasMethod method;
    private FileObject targetFO;
    private RequestProcessor.Task generatorTask;

    public CustomEditorDrop(CustomSaasMethod customSaasMethod) {
        this.method = customSaasMethod;
    }

    private boolean isAcceptTarget(JTextComponent jTextComponent) {
        Object object = jTextComponent.getDocument().getProperty("mimeType");
        return object != null && ("text/x-java".equals(object) || "text/x-jsp".equals(object));
    }

    public boolean handleTransfer(JTextComponent jTextComponent) {
        if (this.isAcceptTarget(jTextComponent)) {
            return this.doHandleTransfer(jTextComponent);
        }
        return false;
    }

    private boolean doHandleTransfer(final JTextComponent jTextComponent) {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)jTextComponent.getDocument());
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        final String string = this.method.getName();
        this.targetFO = CustomEditorDrop.getTargetFile(jTextComponent);
        if (this.targetFO == null) {
            return false;
        }
        final ArrayList arrayList = new ArrayList();
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(CustomEditorDrop.class, (String)"LBL_CodeGenProgress", (Object)string));
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CustomCodeGenerator customCodeGenerator = CustomCodeGeneratorFactory.create(jTextComponent, CustomEditorDrop.this.targetFO, CustomEditorDrop.this.method);
                    if (customCodeGenerator == null) {
                        Util.showUnsupportedDropMessage(new Object[]{CustomEditorDrop.this.targetFO.getNameExt(), "REST Resource"});
                        return;
                    }
                    CustomSaasBean customSaasBean = customCodeGenerator.getBean();
                    boolean bl = customCodeGenerator.canShowParam();
                    List<ParameterInfo> list = customSaasBean.filterParametersByAuth(customSaasBean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
                    if (customCodeGenerator.canShowResourceInfo() || bl && !list.isEmpty()) {
                        CustomCodeSetupPanel customCodeSetupPanel = new CustomCodeSetupPanel(customCodeGenerator.getSubresourceLocatorUriTemplate(), customSaasBean.getQualifiedClassName(), list, customCodeGenerator.canShowResourceInfo(), bl);
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customCodeSetupPanel, NbBundle.getMessage(CustomEditorDrop.class, (String)"LBL_CustomizeSaasService", (Object)string));
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                        if (object.equals(NotifyDescriptor.YES_OPTION)) {
                            customCodeGenerator.setSubresourceLocatorUriTemplate(customCodeSetupPanel.getUriTemplate());
                            customCodeGenerator.setSubresourceLocatorName(customCodeSetupPanel.getMethodName());
                        } else {
                            return;
                        }
                    }
                    try {
                        customCodeGenerator.generate(progressDialog.getProgressHandle());
                    }
                    catch (IOException iOException) {
                        if (!iOException.getMessage().equals("ScanningInProgress")) {
                            arrayList.add(iOException);
                        }
                    }
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
                finally {
                    progressDialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        progressDialog.open();
        if (arrayList.size() > 0) {
            Exceptions.printStackTrace((Throwable)((Throwable)arrayList.get(0)));
            return false;
        }
        return true;
    }

    public static FileObject getTargetFile(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)jTextComponent.getDocument());
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null || editorCookie.getOpenedPanes() == null) {
            return null;
        }
        return dataObject.getPrimaryFile();
    }
}

