/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.java.Constants;
import org.netbeans.modules.websvc.saas.codegen.java.JaxRsAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.SaasCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.java.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.model.WadlSaasBean;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.java.support.Util;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxRsCodeGenerator
extends SaasCodeGenerator {
    private FileObject saasServiceFile = SourceGroupSupport.findJavaSourceFile(this.getProject(), this.getBean().getSaasServiceName());
    private JavaSource saasServiceJS = null;
    private FileObject serviceFolder = null;
    private Constants.DropFileType dropFileType;
    private JaxRsAuthenticationGenerator authGen;

    public JaxRsCodeGenerator(JTextComponent jTextComponent, FileObject fileObject, WadlSaasMethod wadlSaasMethod) throws IOException {
        this(jTextComponent, fileObject, new WadlSaasBean(wadlSaasMethod));
    }

    public JaxRsCodeGenerator(JTextComponent jTextComponent, FileObject fileObject, WadlSaasBean wadlSaasBean) throws IOException {
        super(jTextComponent, fileObject, wadlSaasBean);
        if (this.saasServiceFile != null) {
            this.saasServiceJS = JavaSource.forFileObject((FileObject)this.saasServiceFile);
        }
        this.authGen = new JaxRsAuthenticationGenerator(wadlSaasBean, this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
    }

    @Override
    public WadlSaasBean getBean() {
        return (WadlSaasBean)this.bean;
    }

    public JaxRsAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    public JavaSource getSaasServiceSource() {
        return this.saasServiceJS;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            this.serviceFolder = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], this.getBean().getSaasServicePackageName(), true);
        }
        return this.serviceFolder;
    }

    public Constants.DropFileType getDropFileType() {
        return this.dropFileType;
    }

    void setDropFileType(Constants.DropFileType dropFileType) {
        this.dropFileType = dropFileType;
    }

    @Override
    protected void preGenerate() throws IOException {
        super.preGenerate();
        JaxRsCodeGenerator.createRestConnectionFile(this.getProject());
        if (this.getBean().getMethod().getSaas().getLibraryJars().size() > 0) {
            Util.addClientJars(this.getBean(), this.getProject(), null);
        }
    }

    @Override
    protected String getCustomMethodBody() throws IOException {
        return "";
    }

    protected String getServiceMethodBody() throws IOException {
        String string = this.getFixedParameterDeclaration();
        String string2 = "";
        if (this.getBean().getTemplateParameters() != null && this.getBean().getTemplateParameters().size() > 0) {
            string2 = this.getTemplateParameterDefinition(this.getBean().getTemplateParameters(), "pathParams", false);
        }
        String string3 = "";
        if (this.getBean().getQueryParameters() != null && this.getBean().getQueryParameters().size() > 0) {
            string3 = Util.getHeaderOrParameterDefinition(this.getBean().getQueryParameters(), "queryParams", false);
        }
        String string4 = "";
        string4 = string4 + "        " + string;
        string4 = string4 + "             " + this.getAuthenticationGenerator().getPreAuthenticationCode() + "\n";
        string4 = string4 + "        " + string2;
        string4 = string4 + "        " + string3;
        string4 = string4 + "             RestConnection conn = new RestConnection(\"" + this.getBean().getUrl() + "\"";
        if (!string2.trim().equals("")) {
            string4 = string4 + ", pathParams, " + (string3.trim().equals("") ? "null" : "queryParams");
        } else if (!string3.trim().equals("")) {
            string4 = string4 + ", queryParams";
        }
        string4 = string4 + ");\n";
        string4 = string4 + "             " + this.getAuthenticationGenerator().getPostAuthenticationCode() + "\n";
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        String string5 = "null";
        if (this.getBean().getHeaderParameters() != null && this.getBean().getHeaderParameters().size() > 0) {
            string5 = "headerParams";
            string4 = string4 + "        " + Util.getHeaderOrParameterDefinition(this.getBean().getHeaderParameters(), "headerParams", false, httpMethodType);
        }
        this.getBean();
        boolean bl = !WadlSaasBean.findInputRepresentations(this.getBean().getMethod()).isEmpty();
        String string6 = "return conn";
        if (httpMethodType == Constants.HttpMethodType.GET) {
            string4 = string4 + "             " + string6 + ".get(" + string5 + ");\n";
        } else if (httpMethodType == Constants.HttpMethodType.PUT) {
            string4 = bl ? string4 + "             " + string6 + ".put(" + string5 + ", " + "content" + ");\n" : string4 + "             " + string6 + ".put(" + string5 + ");\n";
        } else if (httpMethodType == Constants.HttpMethodType.POST) {
            string4 = !string3.trim().equals("") ? string4 + "             " + string6 + ".post(" + string5 + ", " + "queryParams" + ");\n" : string4 + "             " + string6 + ".post(" + string5 + ", " + "content" + ");\n";
        } else if (httpMethodType == Constants.HttpMethodType.DELETE) {
            string4 = string4 + "             " + string6 + ".delete(" + string5 + ");\n";
        }
        return string4;
    }

    protected String getFixedParameterDeclaration() {
        String string = "";
        List<ParameterInfo> list = this.getBean().getInputParameters();
        List<ParameterInfo> list2 = null;
        Constants.SaasAuthenticationType saasAuthenticationType = this.getBean().getAuthenticationType();
        if (saasAuthenticationType == Constants.SaasAuthenticationType.SESSION_KEY) {
            SaasBean.SessionKeyAuthentication sessionKeyAuthentication = (SaasBean.SessionKeyAuthentication)this.getBean().getAuthentication();
            list2 = sessionKeyAuthentication.getParameters();
        } else {
            list2 = Collections.emptyList();
        }
        for (ParameterInfo parameterInfo : this.getBean().getInputParameters()) {
            if (!parameterInfo.isFixed() || Util.isContains(parameterInfo, list2)) continue;
            string = string + "String " + this.getVariableName(parameterInfo.getName()) + " = \"" + this.findParamValue(parameterInfo) + "\";\n";
        }
        return string;
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List<ParameterInfo> list = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethodType = this.getBean().getHttpMethod();
        if (httpMethodType == Constants.HttpMethodType.PUT || httpMethodType == Constants.HttpMethodType.POST) {
            ParameterInfo parameterInfo = Util.findParameter(this.getBean().getInputParameters(), "Content-Type");
            Class clazz = InputStream.class;
            if (parameterInfo != null) {
                if (!parameterInfo.isFixed() && !list.contains(parameterInfo)) {
                    list.add(parameterInfo);
                } else {
                    String string = this.findParamValue(parameterInfo);
                    if (string.equals("text/plain") || string.equals("application/xml") || string.equals("text/xml")) {
                        clazz = String.class;
                    }
                }
            }
            this.getBean();
            if (!WadlSaasBean.findInputRepresentations(this.getBean().getMethod()).isEmpty()) {
                list.add(new ParameterInfo("content", clazz));
            }
        }
        return list;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getSaasServiceName());
        arrayList.add("org.netbeans.saas.RestResponse");
        Util.addImportsToSource(this.getTargetSource(), arrayList);
    }

    protected void addImportsToSaasService() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("org.netbeans.saas.RestConnection");
        arrayList.add("org.netbeans.saas.RestResponse");
        Util.addImportsToSource(this.saasServiceJS, arrayList);
    }

    protected void insertSaasServiceAccessCode(boolean bl) throws IOException {
        try {
            String string = "";
            if (bl) {
                string = this.getCustomMethodBody();
            } else {
                string = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                string = string + this.getCustomMethodBody() + "\n";
                string = string + "return result;\n";
                string = string + "}\n";
            }
            JaxRsCodeGenerator.insert(string, this.getTargetComponent(), true);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
    }

    public void createSaasServiceClass() throws IOException {
        if (this.saasServiceFile == null) {
            SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            String string = this.getBean().getSaasServicePackageName();
            FileObject fileObject = SourceGroupSupport.getFolderForPackage(sourceGroupArray[0], string, true);
            this.saasServiceJS = JavaSourceHelper.createJavaSource(this.getBean().getSaasServiceTemplate(), fileObject, string, this.getBean().getSaasServiceName());
            HashSet hashSet = new HashSet(this.saasServiceJS.getFileObjects());
            if (hashSet != null && hashSet.size() > 0) {
                this.saasServiceFile = (FileObject)hashSet.iterator().next();
            }
        }
    }

    protected void addSaasServiceMethod() throws IOException {
        List<ParameterInfo> list = this.getServiceMethodParameters();
        final String[] stringArray = this.getGetParamNames(list);
        final Object[] objectArray = this.getGetParamTypes(list);
        if (JavaSourceHelper.isContainsMethod(this.saasServiceJS, this.getBean().getSaasServiceMethodName(), stringArray, objectArray)) {
            return;
        }
        ModificationResult modificationResult = this.saasServiceJS.runModificationTask((Task)new AbstractTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                Modifier[] modifierArray = Constants.PUBLIC_STATIC;
                String string = "RestResponse";
                String string2 = "{ \n" + JaxRsCodeGenerator.this.getServiceMethodBody() + "\n }";
                String string3 = "Retrieves representation of an instance of " + JaxRsCodeGenerator.this.getBean().getQualifiedClassName() + "\n";
                for (String string4 : stringArray) {
                    string3 = string3 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", string4);
                }
                string3 = string3 + "@return an instance of " + string;
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)workingCopy);
                ClassTree classTree2 = JavaSourceHelper.addMethod(workingCopy, classTree, modifierArray, null, null, JaxRsCodeGenerator.this.getBean().getSaasServiceMethodName(), string, stringArray, objectArray, null, null, new String[]{"java.io.IOException"}, string2, string3);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        });
        modificationResult.commit();
    }

    public ParameterInfo findParameter(String string) {
        List<ParameterInfo> list = this.getBean().getInputParameters();
        if (list != null) {
            for (ParameterInfo parameterInfo : list) {
                if (!parameterInfo.getName().equals(string)) continue;
                return parameterInfo;
            }
        }
        return null;
    }

    @Override
    public String[] getUriParamTypes() {
        String string = String.class.getName();
        String[] stringArray = new String[this.getBean().getUriParams().length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = string;
        }
        return stringArray;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list, String string) {
        if (string == null) {
            string = " ";
        }
        String string2 = "";
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getVariableName(parameterInfo.getName());
            String string4 = this.findParamValue(parameterInfo);
            if (parameterInfo.getType() != String.class) {
                string2 = string2 + string + parameterInfo.getType().getName() + " " + string3 + " = " + string4 + ";\n";
                continue;
            }
            if (string4 != null) {
                string2 = string2 + string + "String " + string3 + " = \"" + string4 + "\";\n";
                continue;
            }
            string2 = string2 + string + "String " + string3 + " = null;\n";
        }
        return string2;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> list) {
        String string = "                 ";
        return this.getHeaderOrParameterDeclaration(list, string);
    }

    private String getTemplateParameterDefinition(List<ParameterInfo> list, String string, boolean bl) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        for (ParameterInfo parameterInfo : list) {
            String string3 = this.getParameterName(parameterInfo);
            String string4 = null;
            if (bl) {
                string4 = this.findParamValue(parameterInfo);
                if (parameterInfo.getType() != String.class) {
                    stringBuffer.append("{\"" + string3 + "\", \"" + string4 + "\".toString()},\n");
                    continue;
                }
                if (string4 != null) {
                    stringBuffer.append("{\"{" + string3 + "}\", \"" + string4 + "\"},\n");
                    continue;
                }
                stringBuffer.append("{\"{" + string3 + "}\", null},\n");
                continue;
            }
            stringBuffer.append("{\"{" + string3 + "}\", " + string3 + "},\n");
        }
        string2 = stringBuffer.toString();
        if (list.size() > 0) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        Object object = "";
        object = (String)object + "             String[][] " + string + " = new String[][]{\n";
        object = (String)object + "                 " + string2 + "\n";
        object = (String)object + "             };\n";
        return object;
    }

    private String findParamValue(ParameterInfo parameterInfo) {
        return Util.findParamValue(parameterInfo);
    }
}

